/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines an Oracle data provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OracleDataProviderSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<OracleDataProviderSettings.Builder, OracleDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(OracleDataProviderSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(OracleDataProviderSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(OracleDataProviderSettings::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> SSL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslMode").getter(getter(OracleDataProviderSettings::sslModeAsString)).setter(setter(Builder::sslMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(OracleDataProviderSettings::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final SdkField<String> ASM_SERVER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AsmServer").getter(getter(OracleDataProviderSettings::asmServer)).setter(setter(Builder::asmServer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AsmServer").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerOracleAsmSecretId")
            .getter(getter(OracleDataProviderSettings::secretsManagerOracleAsmSecretId))
            .setter(setter(Builder::secretsManagerOracleAsmSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManagerOracleAsmSecretId")
                    .build()).build();

    private static final SdkField<String> SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerOracleAsmAccessRoleArn")
            .getter(getter(OracleDataProviderSettings::secretsManagerOracleAsmAccessRoleArn))
            .setter(setter(Builder::secretsManagerOracleAsmAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecretsManagerOracleAsmAccessRoleArn").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_SECRET_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerSecurityDbEncryptionSecretId")
            .getter(getter(OracleDataProviderSettings::secretsManagerSecurityDbEncryptionSecretId))
            .setter(setter(Builder::secretsManagerSecurityDbEncryptionSecretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecretsManagerSecurityDbEncryptionSecretId").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_ACCESS_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SecretsManagerSecurityDbEncryptionAccessRoleArn")
            .getter(getter(OracleDataProviderSettings::secretsManagerSecurityDbEncryptionAccessRoleArn))
            .setter(setter(Builder::secretsManagerSecurityDbEncryptionAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecretsManagerSecurityDbEncryptionAccessRoleArn").build()).build();

    private static final SdkField<String> S3_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Path")
            .getter(getter(OracleDataProviderSettings::s3Path)).setter(setter(Builder::s3Path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Path").build()).build();

    private static final SdkField<String> S3_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3AccessRoleArn").getter(getter(OracleDataProviderSettings::s3AccessRoleArn))
            .setter(setter(Builder::s3AccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3AccessRoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD,
            DATABASE_NAME_FIELD, SSL_MODE_FIELD, CERTIFICATE_ARN_FIELD, ASM_SERVER_FIELD,
            SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD, SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD,
            SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_SECRET_ID_FIELD, SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_ACCESS_ROLE_ARN_FIELD,
            S3_PATH_FIELD, S3_ACCESS_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serverName;

    private final Integer port;

    private final String databaseName;

    private final String sslMode;

    private final String certificateArn;

    private final String asmServer;

    private final String secretsManagerOracleAsmSecretId;

    private final String secretsManagerOracleAsmAccessRoleArn;

    private final String secretsManagerSecurityDbEncryptionSecretId;

    private final String secretsManagerSecurityDbEncryptionAccessRoleArn;

    private final String s3Path;

    private final String s3AccessRoleArn;

    private OracleDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.databaseName = builder.databaseName;
        this.sslMode = builder.sslMode;
        this.certificateArn = builder.certificateArn;
        this.asmServer = builder.asmServer;
        this.secretsManagerOracleAsmSecretId = builder.secretsManagerOracleAsmSecretId;
        this.secretsManagerOracleAsmAccessRoleArn = builder.secretsManagerOracleAsmAccessRoleArn;
        this.secretsManagerSecurityDbEncryptionSecretId = builder.secretsManagerSecurityDbEncryptionSecretId;
        this.secretsManagerSecurityDbEncryptionAccessRoleArn = builder.secretsManagerSecurityDbEncryptionAccessRoleArn;
        this.s3Path = builder.s3Path;
        this.s3AccessRoleArn = builder.s3AccessRoleArn;
    }

    /**
     * <p>
     * The name of the Oracle server.
     * </p>
     * 
     * @return The name of the Oracle server.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The port value for the Oracle data provider.
     * </p>
     * 
     * @return The port value for the Oracle data provider.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The database name on the Oracle data provider.
     * </p>
     * 
     * @return The database name on the Oracle data provider.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The SSL mode used to connect to the Oracle data provider. The default value is <code>none</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the Oracle data provider. The default value is <code>none</code>.
     * @see DmsSslModeValue
     */
    public final DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(sslMode);
    }

    /**
     * <p>
     * The SSL mode used to connect to the Oracle data provider. The default value is <code>none</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the Oracle data provider. The default value is <code>none</code>.
     * @see DmsSslModeValue
     */
    public final String sslModeAsString() {
        return sslMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The address of your Oracle Automatic Storage Management (ASM) server. You can set this value from the
     * <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute string
     * to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
     * >Configuration for change data capture (CDC) on an Oracle source database</a>.
     * </p>
     * 
     * @return The address of your Oracle Automatic Storage Management (ASM) server. You can set this value from the
     *         <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute
     *         string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
     *         >Configuration for change data capture (CDC) on an Oracle source database</a>.
     */
    public final String asmServer() {
        return asmServer;
    }

    /**
     * <p>
     * The identifier of the secret in Secrets Manager that contains the Oracle ASM connection details.
     * </p>
     * <p>
     * Required only if your data provider uses the Oracle ASM server.
     * </p>
     * 
     * @return The identifier of the secret in Secrets Manager that contains the Oracle ASM connection details.</p>
     *         <p>
     *         Required only if your data provider uses the Oracle ASM server.
     */
    public final String secretsManagerOracleAsmSecretId() {
        return secretsManagerOracleAsmSecretId;
    }

    /**
     * <p>
     * The ARN of the IAM role that provides access to the secret in Secrets Manager that contains the Oracle ASM
     * connection details.
     * </p>
     * 
     * @return The ARN of the IAM role that provides access to the secret in Secrets Manager that contains the Oracle
     *         ASM connection details.
     */
    public final String secretsManagerOracleAsmAccessRoleArn() {
        return secretsManagerOracleAsmAccessRoleArn;
    }

    /**
     * <p>
     * The identifier of the secret in Secrets Manager that contains the transparent data encryption (TDE) password. DMS
     * requires this password to access Oracle redo logs encrypted by TDE using Binary Reader.
     * </p>
     * 
     * @return The identifier of the secret in Secrets Manager that contains the transparent data encryption (TDE)
     *         password. DMS requires this password to access Oracle redo logs encrypted by TDE using Binary Reader.
     */
    public final String secretsManagerSecurityDbEncryptionSecretId() {
        return secretsManagerSecurityDbEncryptionSecretId;
    }

    /**
     * <p>
     * The ARN of the IAM role that provides access to the secret in Secrets Manager that contains the TDE password.
     * </p>
     * 
     * @return The ARN of the IAM role that provides access to the secret in Secrets Manager that contains the TDE
     *         password.
     */
    public final String secretsManagerSecurityDbEncryptionAccessRoleArn() {
        return secretsManagerSecurityDbEncryptionAccessRoleArn;
    }

    /**
     * <p>
     * The path for the Amazon S3 bucket that the application uses for accessing the user-defined schema.
     * </p>
     * 
     * @return The path for the Amazon S3 bucket that the application uses for accessing the user-defined schema.
     */
    public final String s3Path() {
        return s3Path;
    }

    /**
     * <p>
     * The ARN for the role the application uses to access its Amazon S3 bucket.
     * </p>
     * 
     * @return The ARN for the role the application uses to access its Amazon S3 bucket.
     */
    public final String s3AccessRoleArn() {
        return s3AccessRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(asmServer());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerOracleAsmSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerOracleAsmAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecurityDbEncryptionSecretId());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerSecurityDbEncryptionAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(s3Path());
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OracleDataProviderSettings)) {
            return false;
        }
        OracleDataProviderSettings other = (OracleDataProviderSettings) obj;
        return Objects.equals(serverName(), other.serverName())
                && Objects.equals(port(), other.port())
                && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(sslModeAsString(), other.sslModeAsString())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(asmServer(), other.asmServer())
                && Objects.equals(secretsManagerOracleAsmSecretId(), other.secretsManagerOracleAsmSecretId())
                && Objects.equals(secretsManagerOracleAsmAccessRoleArn(), other.secretsManagerOracleAsmAccessRoleArn())
                && Objects.equals(secretsManagerSecurityDbEncryptionSecretId(),
                        other.secretsManagerSecurityDbEncryptionSecretId())
                && Objects.equals(secretsManagerSecurityDbEncryptionAccessRoleArn(),
                        other.secretsManagerSecurityDbEncryptionAccessRoleArn()) && Objects.equals(s3Path(), other.s3Path())
                && Objects.equals(s3AccessRoleArn(), other.s3AccessRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OracleDataProviderSettings").add("ServerName", serverName()).add("Port", port())
                .add("DatabaseName", databaseName()).add("SslMode", sslModeAsString()).add("CertificateArn", certificateArn())
                .add("AsmServer", asmServer()).add("SecretsManagerOracleAsmSecretId", secretsManagerOracleAsmSecretId())
                .add("SecretsManagerOracleAsmAccessRoleArn", secretsManagerOracleAsmAccessRoleArn())
                .add("SecretsManagerSecurityDbEncryptionSecretId", secretsManagerSecurityDbEncryptionSecretId())
                .add("SecretsManagerSecurityDbEncryptionAccessRoleArn", secretsManagerSecurityDbEncryptionAccessRoleArn())
                .add("S3Path", s3Path()).add("S3AccessRoleArn", s3AccessRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "SslMode":
            return Optional.ofNullable(clazz.cast(sslModeAsString()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "AsmServer":
            return Optional.ofNullable(clazz.cast(asmServer()));
        case "SecretsManagerOracleAsmSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerOracleAsmSecretId()));
        case "SecretsManagerOracleAsmAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerOracleAsmAccessRoleArn()));
        case "SecretsManagerSecurityDbEncryptionSecretId":
            return Optional.ofNullable(clazz.cast(secretsManagerSecurityDbEncryptionSecretId()));
        case "SecretsManagerSecurityDbEncryptionAccessRoleArn":
            return Optional.ofNullable(clazz.cast(secretsManagerSecurityDbEncryptionAccessRoleArn()));
        case "S3Path":
            return Optional.ofNullable(clazz.cast(s3Path()));
        case "S3AccessRoleArn":
            return Optional.ofNullable(clazz.cast(s3AccessRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ServerName", SERVER_NAME_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("SslMode", SSL_MODE_FIELD);
        map.put("CertificateArn", CERTIFICATE_ARN_FIELD);
        map.put("AsmServer", ASM_SERVER_FIELD);
        map.put("SecretsManagerOracleAsmSecretId", SECRETS_MANAGER_ORACLE_ASM_SECRET_ID_FIELD);
        map.put("SecretsManagerOracleAsmAccessRoleArn", SECRETS_MANAGER_ORACLE_ASM_ACCESS_ROLE_ARN_FIELD);
        map.put("SecretsManagerSecurityDbEncryptionSecretId", SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_SECRET_ID_FIELD);
        map.put("SecretsManagerSecurityDbEncryptionAccessRoleArn", SECRETS_MANAGER_SECURITY_DB_ENCRYPTION_ACCESS_ROLE_ARN_FIELD);
        map.put("S3Path", S3_PATH_FIELD);
        map.put("S3AccessRoleArn", S3_ACCESS_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OracleDataProviderSettings, T> g) {
        return obj -> g.apply((OracleDataProviderSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OracleDataProviderSettings> {
        /**
         * <p>
         * The name of the Oracle server.
         * </p>
         * 
         * @param serverName
         *        The name of the Oracle server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The port value for the Oracle data provider.
         * </p>
         * 
         * @param port
         *        The port value for the Oracle data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The database name on the Oracle data provider.
         * </p>
         * 
         * @param databaseName
         *        The database name on the Oracle data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The SSL mode used to connect to the Oracle data provider. The default value is <code>none</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the Oracle data provider. The default value is <code>none</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(String sslMode);

        /**
         * <p>
         * The SSL mode used to connect to the Oracle data provider. The default value is <code>none</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the Oracle data provider. The default value is <code>none</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(DmsSslModeValue sslMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The address of your Oracle Automatic Storage Management (ASM) server. You can set this value from the
         * <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection attribute
         * string to access an Oracle server with Binary Reader that uses ASM. For more information, see <a href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
         * >Configuration for change data capture (CDC) on an Oracle source database</a>.
         * </p>
         * 
         * @param asmServer
         *        The address of your Oracle Automatic Storage Management (ASM) server. You can set this value from the
         *        <code>asm_server</code> value. You set <code>asm_server</code> as part of the extra connection
         *        attribute string to access an Oracle server with Binary Reader that uses ASM. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration"
         *        >Configuration for change data capture (CDC) on an Oracle source database</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder asmServer(String asmServer);

        /**
         * <p>
         * The identifier of the secret in Secrets Manager that contains the Oracle ASM connection details.
         * </p>
         * <p>
         * Required only if your data provider uses the Oracle ASM server.
         * </p>
         * 
         * @param secretsManagerOracleAsmSecretId
         *        The identifier of the secret in Secrets Manager that contains the Oracle ASM connection details.</p>
         *        <p>
         *        Required only if your data provider uses the Oracle ASM server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId);

        /**
         * <p>
         * The ARN of the IAM role that provides access to the secret in Secrets Manager that contains the Oracle ASM
         * connection details.
         * </p>
         * 
         * @param secretsManagerOracleAsmAccessRoleArn
         *        The ARN of the IAM role that provides access to the secret in Secrets Manager that contains the Oracle
         *        ASM connection details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn);

        /**
         * <p>
         * The identifier of the secret in Secrets Manager that contains the transparent data encryption (TDE) password.
         * DMS requires this password to access Oracle redo logs encrypted by TDE using Binary Reader.
         * </p>
         * 
         * @param secretsManagerSecurityDbEncryptionSecretId
         *        The identifier of the secret in Secrets Manager that contains the transparent data encryption (TDE)
         *        password. DMS requires this password to access Oracle redo logs encrypted by TDE using Binary Reader.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecurityDbEncryptionSecretId(String secretsManagerSecurityDbEncryptionSecretId);

        /**
         * <p>
         * The ARN of the IAM role that provides access to the secret in Secrets Manager that contains the TDE password.
         * </p>
         * 
         * @param secretsManagerSecurityDbEncryptionAccessRoleArn
         *        The ARN of the IAM role that provides access to the secret in Secrets Manager that contains the TDE
         *        password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerSecurityDbEncryptionAccessRoleArn(String secretsManagerSecurityDbEncryptionAccessRoleArn);

        /**
         * <p>
         * The path for the Amazon S3 bucket that the application uses for accessing the user-defined schema.
         * </p>
         * 
         * @param s3Path
         *        The path for the Amazon S3 bucket that the application uses for accessing the user-defined schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Path(String s3Path);

        /**
         * <p>
         * The ARN for the role the application uses to access its Amazon S3 bucket.
         * </p>
         * 
         * @param s3AccessRoleArn
         *        The ARN for the role the application uses to access its Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessRoleArn(String s3AccessRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String serverName;

        private Integer port;

        private String databaseName;

        private String sslMode;

        private String certificateArn;

        private String asmServer;

        private String secretsManagerOracleAsmSecretId;

        private String secretsManagerOracleAsmAccessRoleArn;

        private String secretsManagerSecurityDbEncryptionSecretId;

        private String secretsManagerSecurityDbEncryptionAccessRoleArn;

        private String s3Path;

        private String s3AccessRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OracleDataProviderSettings model) {
            serverName(model.serverName);
            port(model.port);
            databaseName(model.databaseName);
            sslMode(model.sslMode);
            certificateArn(model.certificateArn);
            asmServer(model.asmServer);
            secretsManagerOracleAsmSecretId(model.secretsManagerOracleAsmSecretId);
            secretsManagerOracleAsmAccessRoleArn(model.secretsManagerOracleAsmAccessRoleArn);
            secretsManagerSecurityDbEncryptionSecretId(model.secretsManagerSecurityDbEncryptionSecretId);
            secretsManagerSecurityDbEncryptionAccessRoleArn(model.secretsManagerSecurityDbEncryptionAccessRoleArn);
            s3Path(model.s3Path);
            s3AccessRoleArn(model.s3AccessRoleArn);
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getSslMode() {
            return sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getAsmServer() {
            return asmServer;
        }

        public final void setAsmServer(String asmServer) {
            this.asmServer = asmServer;
        }

        @Override
        public final Builder asmServer(String asmServer) {
            this.asmServer = asmServer;
            return this;
        }

        public final String getSecretsManagerOracleAsmSecretId() {
            return secretsManagerOracleAsmSecretId;
        }

        public final void setSecretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
            this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
        }

        @Override
        public final Builder secretsManagerOracleAsmSecretId(String secretsManagerOracleAsmSecretId) {
            this.secretsManagerOracleAsmSecretId = secretsManagerOracleAsmSecretId;
            return this;
        }

        public final String getSecretsManagerOracleAsmAccessRoleArn() {
            return secretsManagerOracleAsmAccessRoleArn;
        }

        public final void setSecretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
            this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerOracleAsmAccessRoleArn(String secretsManagerOracleAsmAccessRoleArn) {
            this.secretsManagerOracleAsmAccessRoleArn = secretsManagerOracleAsmAccessRoleArn;
            return this;
        }

        public final String getSecretsManagerSecurityDbEncryptionSecretId() {
            return secretsManagerSecurityDbEncryptionSecretId;
        }

        public final void setSecretsManagerSecurityDbEncryptionSecretId(String secretsManagerSecurityDbEncryptionSecretId) {
            this.secretsManagerSecurityDbEncryptionSecretId = secretsManagerSecurityDbEncryptionSecretId;
        }

        @Override
        public final Builder secretsManagerSecurityDbEncryptionSecretId(String secretsManagerSecurityDbEncryptionSecretId) {
            this.secretsManagerSecurityDbEncryptionSecretId = secretsManagerSecurityDbEncryptionSecretId;
            return this;
        }

        public final String getSecretsManagerSecurityDbEncryptionAccessRoleArn() {
            return secretsManagerSecurityDbEncryptionAccessRoleArn;
        }

        public final void setSecretsManagerSecurityDbEncryptionAccessRoleArn(
                String secretsManagerSecurityDbEncryptionAccessRoleArn) {
            this.secretsManagerSecurityDbEncryptionAccessRoleArn = secretsManagerSecurityDbEncryptionAccessRoleArn;
        }

        @Override
        public final Builder secretsManagerSecurityDbEncryptionAccessRoleArn(
                String secretsManagerSecurityDbEncryptionAccessRoleArn) {
            this.secretsManagerSecurityDbEncryptionAccessRoleArn = secretsManagerSecurityDbEncryptionAccessRoleArn;
            return this;
        }

        public final String getS3Path() {
            return s3Path;
        }

        public final void setS3Path(String s3Path) {
            this.s3Path = s3Path;
        }

        @Override
        public final Builder s3Path(String s3Path) {
            this.s3Path = s3Path;
            return this;
        }

        public final String getS3AccessRoleArn() {
            return s3AccessRoleArn;
        }

        public final void setS3AccessRoleArn(String s3AccessRoleArn) {
            this.s3AccessRoleArn = s3AccessRoleArn;
        }

        @Override
        public final Builder s3AccessRoleArn(String s3AccessRoleArn) {
            this.s3AccessRoleArn = s3AccessRoleArn;
            return this;
        }

        @Override
        public OracleDataProviderSettings build() {
            return new OracleDataProviderSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
