/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDataMigrationRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<ModifyDataMigrationRequest.Builder, ModifyDataMigrationRequest> {
    private static final SdkField<String> DATA_MIGRATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataMigrationIdentifier").getter(getter(ModifyDataMigrationRequest::dataMigrationIdentifier))
            .setter(setter(Builder::dataMigrationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationIdentifier").build())
            .build();

    private static final SdkField<String> DATA_MIGRATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataMigrationName").getter(getter(ModifyDataMigrationRequest::dataMigrationName))
            .setter(setter(Builder::dataMigrationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationName").build()).build();

    private static final SdkField<Boolean> ENABLE_CLOUDWATCH_LOGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCloudwatchLogs").getter(getter(ModifyDataMigrationRequest::enableCloudwatchLogs))
            .setter(setter(Builder::enableCloudwatchLogs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogs").build())
            .build();

    private static final SdkField<String> SERVICE_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceAccessRoleArn").getter(getter(ModifyDataMigrationRequest::serviceAccessRoleArn))
            .setter(setter(Builder::serviceAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccessRoleArn").build())
            .build();

    private static final SdkField<String> DATA_MIGRATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataMigrationType").getter(getter(ModifyDataMigrationRequest::dataMigrationTypeAsString))
            .setter(setter(Builder::dataMigrationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataMigrationType").build()).build();

    private static final SdkField<List<SourceDataSetting>> SOURCE_DATA_SETTINGS_FIELD = SdkField
            .<List<SourceDataSetting>> builder(MarshallingType.LIST)
            .memberName("SourceDataSettings")
            .getter(getter(ModifyDataMigrationRequest::sourceDataSettings))
            .setter(setter(Builder::sourceDataSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDataSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceDataSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceDataSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetDataSetting>> TARGET_DATA_SETTINGS_FIELD = SdkField
            .<List<TargetDataSetting>> builder(MarshallingType.LIST)
            .memberName("TargetDataSettings")
            .getter(getter(ModifyDataMigrationRequest::targetDataSettings))
            .setter(setter(Builder::targetDataSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDataSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetDataSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetDataSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NUMBER_OF_JOBS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfJobs").getter(getter(ModifyDataMigrationRequest::numberOfJobs))
            .setter(setter(Builder::numberOfJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfJobs").build()).build();

    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionRules").getter(getter(ModifyDataMigrationRequest::selectionRules))
            .setter(setter(Builder::selectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATA_MIGRATION_IDENTIFIER_FIELD, DATA_MIGRATION_NAME_FIELD, ENABLE_CLOUDWATCH_LOGS_FIELD,
            SERVICE_ACCESS_ROLE_ARN_FIELD, DATA_MIGRATION_TYPE_FIELD, SOURCE_DATA_SETTINGS_FIELD, TARGET_DATA_SETTINGS_FIELD,
            NUMBER_OF_JOBS_FIELD, SELECTION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataMigrationIdentifier;

    private final String dataMigrationName;

    private final Boolean enableCloudwatchLogs;

    private final String serviceAccessRoleArn;

    private final String dataMigrationType;

    private final List<SourceDataSetting> sourceDataSettings;

    private final List<TargetDataSetting> targetDataSettings;

    private final Integer numberOfJobs;

    private final String selectionRules;

    private ModifyDataMigrationRequest(BuilderImpl builder) {
        super(builder);
        this.dataMigrationIdentifier = builder.dataMigrationIdentifier;
        this.dataMigrationName = builder.dataMigrationName;
        this.enableCloudwatchLogs = builder.enableCloudwatchLogs;
        this.serviceAccessRoleArn = builder.serviceAccessRoleArn;
        this.dataMigrationType = builder.dataMigrationType;
        this.sourceDataSettings = builder.sourceDataSettings;
        this.targetDataSettings = builder.targetDataSettings;
        this.numberOfJobs = builder.numberOfJobs;
        this.selectionRules = builder.selectionRules;
    }

    /**
     * <p>
     * The identifier (name or ARN) of the data migration to modify.
     * </p>
     * 
     * @return The identifier (name or ARN) of the data migration to modify.
     */
    public final String dataMigrationIdentifier() {
        return dataMigrationIdentifier;
    }

    /**
     * <p>
     * The new name for the data migration.
     * </p>
     * 
     * @return The new name for the data migration.
     */
    public final String dataMigrationName() {
        return dataMigrationName;
    }

    /**
     * <p>
     * Whether to enable Cloudwatch logs for the data migration.
     * </p>
     * 
     * @return Whether to enable Cloudwatch logs for the data migration.
     */
    public final Boolean enableCloudwatchLogs() {
        return enableCloudwatchLogs;
    }

    /**
     * <p>
     * The new service access role ARN for the data migration.
     * </p>
     * 
     * @return The new service access role ARN for the data migration.
     */
    public final String serviceAccessRoleArn() {
        return serviceAccessRoleArn;
    }

    /**
     * <p>
     * The new migration type for the data migration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataMigrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataMigrationTypeAsString}.
     * </p>
     * 
     * @return The new migration type for the data migration.
     * @see MigrationTypeValue
     */
    public final MigrationTypeValue dataMigrationType() {
        return MigrationTypeValue.fromValue(dataMigrationType);
    }

    /**
     * <p>
     * The new migration type for the data migration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataMigrationType}
     * will return {@link MigrationTypeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataMigrationTypeAsString}.
     * </p>
     * 
     * @return The new migration type for the data migration.
     * @see MigrationTypeValue
     */
    public final String dataMigrationTypeAsString() {
        return dataMigrationType;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceDataSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceDataSettings() {
        return sourceDataSettings != null && !(sourceDataSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new information about the source data provider for the data migration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceDataSettings} method.
     * </p>
     * 
     * @return The new information about the source data provider for the data migration.
     */
    public final List<SourceDataSetting> sourceDataSettings() {
        return sourceDataSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetDataSettings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetDataSettings() {
        return targetDataSettings != null && !(targetDataSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new information about the target data provider for the data migration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetDataSettings} method.
     * </p>
     * 
     * @return The new information about the target data provider for the data migration.
     */
    public final List<TargetDataSetting> targetDataSettings() {
        return targetDataSettings;
    }

    /**
     * <p>
     * The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load
     * them to the target.
     * </p>
     * 
     * @return The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then
     *         load them to the target.
     */
    public final Integer numberOfJobs() {
        return numberOfJobs;
    }

    /**
     * <p>
     * A JSON-formatted string that defines what objects to include and exclude from the migration.
     * </p>
     * 
     * @return A JSON-formatted string that defines what objects to include and exclude from the migration.
     */
    public final String selectionRules() {
        return selectionRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataMigrationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dataMigrationName());
        hashCode = 31 * hashCode + Objects.hashCode(enableCloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataMigrationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceDataSettings() ? sourceDataSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetDataSettings() ? targetDataSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(selectionRules());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDataMigrationRequest)) {
            return false;
        }
        ModifyDataMigrationRequest other = (ModifyDataMigrationRequest) obj;
        return Objects.equals(dataMigrationIdentifier(), other.dataMigrationIdentifier())
                && Objects.equals(dataMigrationName(), other.dataMigrationName())
                && Objects.equals(enableCloudwatchLogs(), other.enableCloudwatchLogs())
                && Objects.equals(serviceAccessRoleArn(), other.serviceAccessRoleArn())
                && Objects.equals(dataMigrationTypeAsString(), other.dataMigrationTypeAsString())
                && hasSourceDataSettings() == other.hasSourceDataSettings()
                && Objects.equals(sourceDataSettings(), other.sourceDataSettings())
                && hasTargetDataSettings() == other.hasTargetDataSettings()
                && Objects.equals(targetDataSettings(), other.targetDataSettings())
                && Objects.equals(numberOfJobs(), other.numberOfJobs())
                && Objects.equals(selectionRules(), other.selectionRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDataMigrationRequest").add("DataMigrationIdentifier", dataMigrationIdentifier())
                .add("DataMigrationName", dataMigrationName()).add("EnableCloudwatchLogs", enableCloudwatchLogs())
                .add("ServiceAccessRoleArn", serviceAccessRoleArn()).add("DataMigrationType", dataMigrationTypeAsString())
                .add("SourceDataSettings", hasSourceDataSettings() ? sourceDataSettings() : null)
                .add("TargetDataSettings", hasTargetDataSettings() ? targetDataSettings() : null)
                .add("NumberOfJobs", numberOfJobs())
                .add("SelectionRules", selectionRules() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataMigrationIdentifier":
            return Optional.ofNullable(clazz.cast(dataMigrationIdentifier()));
        case "DataMigrationName":
            return Optional.ofNullable(clazz.cast(dataMigrationName()));
        case "EnableCloudwatchLogs":
            return Optional.ofNullable(clazz.cast(enableCloudwatchLogs()));
        case "ServiceAccessRoleArn":
            return Optional.ofNullable(clazz.cast(serviceAccessRoleArn()));
        case "DataMigrationType":
            return Optional.ofNullable(clazz.cast(dataMigrationTypeAsString()));
        case "SourceDataSettings":
            return Optional.ofNullable(clazz.cast(sourceDataSettings()));
        case "TargetDataSettings":
            return Optional.ofNullable(clazz.cast(targetDataSettings()));
        case "NumberOfJobs":
            return Optional.ofNullable(clazz.cast(numberOfJobs()));
        case "SelectionRules":
            return Optional.ofNullable(clazz.cast(selectionRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataMigrationIdentifier", DATA_MIGRATION_IDENTIFIER_FIELD);
        map.put("DataMigrationName", DATA_MIGRATION_NAME_FIELD);
        map.put("EnableCloudwatchLogs", ENABLE_CLOUDWATCH_LOGS_FIELD);
        map.put("ServiceAccessRoleArn", SERVICE_ACCESS_ROLE_ARN_FIELD);
        map.put("DataMigrationType", DATA_MIGRATION_TYPE_FIELD);
        map.put("SourceDataSettings", SOURCE_DATA_SETTINGS_FIELD);
        map.put("TargetDataSettings", TARGET_DATA_SETTINGS_FIELD);
        map.put("NumberOfJobs", NUMBER_OF_JOBS_FIELD);
        map.put("SelectionRules", SELECTION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyDataMigrationRequest, T> g) {
        return obj -> g.apply((ModifyDataMigrationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyDataMigrationRequest> {
        /**
         * <p>
         * The identifier (name or ARN) of the data migration to modify.
         * </p>
         * 
         * @param dataMigrationIdentifier
         *        The identifier (name or ARN) of the data migration to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataMigrationIdentifier(String dataMigrationIdentifier);

        /**
         * <p>
         * The new name for the data migration.
         * </p>
         * 
         * @param dataMigrationName
         *        The new name for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataMigrationName(String dataMigrationName);

        /**
         * <p>
         * Whether to enable Cloudwatch logs for the data migration.
         * </p>
         * 
         * @param enableCloudwatchLogs
         *        Whether to enable Cloudwatch logs for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCloudwatchLogs(Boolean enableCloudwatchLogs);

        /**
         * <p>
         * The new service access role ARN for the data migration.
         * </p>
         * 
         * @param serviceAccessRoleArn
         *        The new service access role ARN for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccessRoleArn(String serviceAccessRoleArn);

        /**
         * <p>
         * The new migration type for the data migration.
         * </p>
         * 
         * @param dataMigrationType
         *        The new migration type for the data migration.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder dataMigrationType(String dataMigrationType);

        /**
         * <p>
         * The new migration type for the data migration.
         * </p>
         * 
         * @param dataMigrationType
         *        The new migration type for the data migration.
         * @see MigrationTypeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MigrationTypeValue
         */
        Builder dataMigrationType(MigrationTypeValue dataMigrationType);

        /**
         * <p>
         * The new information about the source data provider for the data migration.
         * </p>
         * 
         * @param sourceDataSettings
         *        The new information about the source data provider for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDataSettings(Collection<SourceDataSetting> sourceDataSettings);

        /**
         * <p>
         * The new information about the source data provider for the data migration.
         * </p>
         * 
         * @param sourceDataSettings
         *        The new information about the source data provider for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDataSettings(SourceDataSetting... sourceDataSettings);

        /**
         * <p>
         * The new information about the source data provider for the data migration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.SourceDataSetting.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.SourceDataSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.SourceDataSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceDataSettings(List<SourceDataSetting>)}.
         * 
         * @param sourceDataSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.SourceDataSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceDataSettings(java.util.Collection<SourceDataSetting>)
         */
        Builder sourceDataSettings(Consumer<SourceDataSetting.Builder>... sourceDataSettings);

        /**
         * <p>
         * The new information about the target data provider for the data migration.
         * </p>
         * 
         * @param targetDataSettings
         *        The new information about the target data provider for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDataSettings(Collection<TargetDataSetting> targetDataSettings);

        /**
         * <p>
         * The new information about the target data provider for the data migration.
         * </p>
         * 
         * @param targetDataSettings
         *        The new information about the target data provider for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDataSettings(TargetDataSetting... targetDataSettings);

        /**
         * <p>
         * The new information about the target data provider for the data migration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.TargetDataSetting.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.TargetDataSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.TargetDataSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #targetDataSettings(List<TargetDataSetting>)}.
         * 
         * @param targetDataSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.TargetDataSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetDataSettings(java.util.Collection<TargetDataSetting>)
         */
        Builder targetDataSettings(Consumer<TargetDataSetting.Builder>... targetDataSettings);

        /**
         * <p>
         * The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load
         * them to the target.
         * </p>
         * 
         * @param numberOfJobs
         *        The number of parallel jobs that trigger parallel threads to unload the tables from the source, and
         *        then load them to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfJobs(Integer numberOfJobs);

        /**
         * <p>
         * A JSON-formatted string that defines what objects to include and exclude from the migration.
         * </p>
         * 
         * @param selectionRules
         *        A JSON-formatted string that defines what objects to include and exclude from the migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionRules(String selectionRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private String dataMigrationIdentifier;

        private String dataMigrationName;

        private Boolean enableCloudwatchLogs;

        private String serviceAccessRoleArn;

        private String dataMigrationType;

        private List<SourceDataSetting> sourceDataSettings = DefaultSdkAutoConstructList.getInstance();

        private List<TargetDataSetting> targetDataSettings = DefaultSdkAutoConstructList.getInstance();

        private Integer numberOfJobs;

        private String selectionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDataMigrationRequest model) {
            super(model);
            dataMigrationIdentifier(model.dataMigrationIdentifier);
            dataMigrationName(model.dataMigrationName);
            enableCloudwatchLogs(model.enableCloudwatchLogs);
            serviceAccessRoleArn(model.serviceAccessRoleArn);
            dataMigrationType(model.dataMigrationType);
            sourceDataSettings(model.sourceDataSettings);
            targetDataSettings(model.targetDataSettings);
            numberOfJobs(model.numberOfJobs);
            selectionRules(model.selectionRules);
        }

        public final String getDataMigrationIdentifier() {
            return dataMigrationIdentifier;
        }

        public final void setDataMigrationIdentifier(String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
        }

        @Override
        public final Builder dataMigrationIdentifier(String dataMigrationIdentifier) {
            this.dataMigrationIdentifier = dataMigrationIdentifier;
            return this;
        }

        public final String getDataMigrationName() {
            return dataMigrationName;
        }

        public final void setDataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
        }

        @Override
        public final Builder dataMigrationName(String dataMigrationName) {
            this.dataMigrationName = dataMigrationName;
            return this;
        }

        public final Boolean getEnableCloudwatchLogs() {
            return enableCloudwatchLogs;
        }

        public final void setEnableCloudwatchLogs(Boolean enableCloudwatchLogs) {
            this.enableCloudwatchLogs = enableCloudwatchLogs;
        }

        @Override
        public final Builder enableCloudwatchLogs(Boolean enableCloudwatchLogs) {
            this.enableCloudwatchLogs = enableCloudwatchLogs;
            return this;
        }

        public final String getServiceAccessRoleArn() {
            return serviceAccessRoleArn;
        }

        public final void setServiceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
        }

        @Override
        public final Builder serviceAccessRoleArn(String serviceAccessRoleArn) {
            this.serviceAccessRoleArn = serviceAccessRoleArn;
            return this;
        }

        public final String getDataMigrationType() {
            return dataMigrationType;
        }

        public final void setDataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
        }

        @Override
        public final Builder dataMigrationType(String dataMigrationType) {
            this.dataMigrationType = dataMigrationType;
            return this;
        }

        @Override
        public final Builder dataMigrationType(MigrationTypeValue dataMigrationType) {
            this.dataMigrationType(dataMigrationType == null ? null : dataMigrationType.toString());
            return this;
        }

        public final List<SourceDataSetting.Builder> getSourceDataSettings() {
            List<SourceDataSetting.Builder> result = SourceDataSettingsCopier.copyToBuilder(this.sourceDataSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceDataSettings(Collection<SourceDataSetting.BuilderImpl> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copyFromBuilder(sourceDataSettings);
        }

        @Override
        public final Builder sourceDataSettings(Collection<SourceDataSetting> sourceDataSettings) {
            this.sourceDataSettings = SourceDataSettingsCopier.copy(sourceDataSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(SourceDataSetting... sourceDataSettings) {
            sourceDataSettings(Arrays.asList(sourceDataSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceDataSettings(Consumer<SourceDataSetting.Builder>... sourceDataSettings) {
            sourceDataSettings(Stream.of(sourceDataSettings).map(c -> SourceDataSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<TargetDataSetting.Builder> getTargetDataSettings() {
            List<TargetDataSetting.Builder> result = TargetDataSettingsCopier.copyToBuilder(this.targetDataSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetDataSettings(Collection<TargetDataSetting.BuilderImpl> targetDataSettings) {
            this.targetDataSettings = TargetDataSettingsCopier.copyFromBuilder(targetDataSettings);
        }

        @Override
        public final Builder targetDataSettings(Collection<TargetDataSetting> targetDataSettings) {
            this.targetDataSettings = TargetDataSettingsCopier.copy(targetDataSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataSettings(TargetDataSetting... targetDataSettings) {
            targetDataSettings(Arrays.asList(targetDataSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetDataSettings(Consumer<TargetDataSetting.Builder>... targetDataSettings) {
            targetDataSettings(Stream.of(targetDataSettings).map(c -> TargetDataSetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getNumberOfJobs() {
            return numberOfJobs;
        }

        public final void setNumberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
        }

        @Override
        public final Builder numberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
            return this;
        }

        public final String getSelectionRules() {
            return selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDataMigrationRequest build() {
            return new ModifyDataMigrationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
