/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFleetAdvisorSchemasRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<DescribeFleetAdvisorSchemasRequest.Builder, DescribeFleetAdvisorSchemasRequest> {
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeFleetAdvisorSchemasRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeFleetAdvisorSchemasRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeFleetAdvisorSchemasRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RECORDS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeFleetAdvisorSchemasRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you specify any of the following filters, the output includes information for only those schemas that meet the
     * filter criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>complexity</code> – The schema's complexity, for example <code>Simple</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database-id</code> – The ID of the schema's database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database-ip-address</code> – The IP address of the schema's database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database-name</code> – The name of the schema's database.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>database-engine</code> – The name of the schema database's engine.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>original-schema-name</code> – The name of the schema's database's main schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>schema-id</code> – The ID of the schema, for example <code>15</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>schema-name</code> – The name of the schema.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>server-ip-address</code> – The IP address of the schema database's server.
     * </p>
     * </li>
     * </ul>
     * <p>
     * An example is: <code>describe-fleet-advisor-schemas --filter Name="schema-id",Values="50"</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return If you specify any of the following filters, the output includes information for only those schemas that
     *         meet the filter criteria:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>complexity</code> – The schema's complexity, for example <code>Simple</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database-id</code> – The ID of the schema's database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database-ip-address</code> – The IP address of the schema's database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database-name</code> – The name of the schema's database.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>database-engine</code> – The name of the schema database's engine.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>original-schema-name</code> – The name of the schema's database's main schema.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>schema-id</code> – The ID of the schema, for example <code>15</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>schema-name</code> – The name of the schema.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>server-ip-address</code> – The IP address of the schema database's server.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         An example is: <code>describe-fleet-advisor-schemas --filter Name="schema-id",Values="50"</code>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * Sets the maximum number of records returned in the response.
     * </p>
     * 
     * @return Sets the maximum number of records returned in the response.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * If <code>NextToken</code> is returned by a previous response, there are more results available. The value of
     * <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned token
     * to retrieve the next page. Keep all other arguments unchanged.
     * </p>
     * 
     * @return If <code>NextToken</code> is returned by a previous response, there are more results available. The value
     *         of <code>NextToken</code> is a unique pagination token for each page. Make the call again using the
     *         returned token to retrieve the next page. Keep all other arguments unchanged.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetAdvisorSchemasRequest)) {
            return false;
        }
        DescribeFleetAdvisorSchemasRequest other = (DescribeFleetAdvisorSchemasRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFleetAdvisorSchemasRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxRecords", maxRecords()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetAdvisorSchemasRequest, T> g) {
        return obj -> g.apply((DescribeFleetAdvisorSchemasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeFleetAdvisorSchemasRequest> {
        /**
         * <p>
         * If you specify any of the following filters, the output includes information for only those schemas that meet
         * the filter criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>complexity</code> – The schema's complexity, for example <code>Simple</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-id</code> – The ID of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-ip-address</code> – The IP address of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-name</code> – The name of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-engine</code> – The name of the schema database's engine.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-schema-name</code> – The name of the schema's database's main schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>schema-id</code> – The ID of the schema, for example <code>15</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>schema-name</code> – The name of the schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>server-ip-address</code> – The IP address of the schema database's server.
         * </p>
         * </li>
         * </ul>
         * <p>
         * An example is: <code>describe-fleet-advisor-schemas --filter Name="schema-id",Values="50"</code>
         * </p>
         * 
         * @param filters
         *        If you specify any of the following filters, the output includes information for only those schemas
         *        that meet the filter criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>complexity</code> – The schema's complexity, for example <code>Simple</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database-id</code> – The ID of the schema's database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database-ip-address</code> – The IP address of the schema's database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database-name</code> – The name of the schema's database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database-engine</code> – The name of the schema database's engine.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>original-schema-name</code> – The name of the schema's database's main schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>schema-id</code> – The ID of the schema, for example <code>15</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>schema-name</code> – The name of the schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>server-ip-address</code> – The IP address of the schema database's server.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        An example is: <code>describe-fleet-advisor-schemas --filter Name="schema-id",Values="50"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * If you specify any of the following filters, the output includes information for only those schemas that meet
         * the filter criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>complexity</code> – The schema's complexity, for example <code>Simple</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-id</code> – The ID of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-ip-address</code> – The IP address of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-name</code> – The name of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-engine</code> – The name of the schema database's engine.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-schema-name</code> – The name of the schema's database's main schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>schema-id</code> – The ID of the schema, for example <code>15</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>schema-name</code> – The name of the schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>server-ip-address</code> – The IP address of the schema database's server.
         * </p>
         * </li>
         * </ul>
         * <p>
         * An example is: <code>describe-fleet-advisor-schemas --filter Name="schema-id",Values="50"</code>
         * </p>
         * 
         * @param filters
         *        If you specify any of the following filters, the output includes information for only those schemas
         *        that meet the filter criteria:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>complexity</code> – The schema's complexity, for example <code>Simple</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database-id</code> – The ID of the schema's database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database-ip-address</code> – The IP address of the schema's database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database-name</code> – The name of the schema's database.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>database-engine</code> – The name of the schema database's engine.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>original-schema-name</code> – The name of the schema's database's main schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>schema-id</code> – The ID of the schema, for example <code>15</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>schema-name</code> – The name of the schema.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>server-ip-address</code> – The IP address of the schema database's server.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        An example is: <code>describe-fleet-advisor-schemas --filter Name="schema-id",Values="50"</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * If you specify any of the following filters, the output includes information for only those schemas that meet
         * the filter criteria:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>complexity</code> – The schema's complexity, for example <code>Simple</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-id</code> – The ID of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-ip-address</code> – The IP address of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-name</code> – The name of the schema's database.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>database-engine</code> – The name of the schema database's engine.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>original-schema-name</code> – The name of the schema's database's main schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>schema-id</code> – The ID of the schema, for example <code>15</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>schema-name</code> – The name of the schema.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>server-ip-address</code> – The IP address of the schema database's server.
         * </p>
         * </li>
         * </ul>
         * <p>
         * An example is: <code>describe-fleet-advisor-schemas --filter Name="schema-id",Values="50"</code>
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.Filter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.databasemigration.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.Filter.Builder#build()} is called immediately
         * and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * Sets the maximum number of records returned in the response.
         * </p>
         * 
         * @param maxRecords
         *        Sets the maximum number of records returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * If <code>NextToken</code> is returned by a previous response, there are more results available. The value of
         * <code>NextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page. Keep all other arguments unchanged.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> is returned by a previous response, there are more results available. The
         *        value of <code>NextToken</code> is a unique pagination token for each page. Make the call again using
         *        the returned token to retrieve the next page. Keep all other arguments unchanged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetAdvisorSchemasRequest model) {
            super(model);
            filters(model.filters);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFleetAdvisorSchemasRequest build() {
            return new DescribeFleetAdvisorSchemasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
