/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for configuring a data migration, including whether to enable CloudWatch logs, and the selection rules to use
 * to include or exclude database objects from the migration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataMigrationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DataMigrationSettings.Builder, DataMigrationSettings> {
    private static final SdkField<Integer> NUMBER_OF_JOBS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfJobs").getter(getter(DataMigrationSettings::numberOfJobs)).setter(setter(Builder::numberOfJobs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfJobs").build()).build();

    private static final SdkField<Boolean> CLOUDWATCH_LOGS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CloudwatchLogsEnabled").getter(getter(DataMigrationSettings::cloudwatchLogsEnabled))
            .setter(setter(Builder::cloudwatchLogsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudwatchLogsEnabled").build())
            .build();

    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionRules").getter(getter(DataMigrationSettings::selectionRules))
            .setter(setter(Builder::selectionRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_JOBS_FIELD,
            CLOUDWATCH_LOGS_ENABLED_FIELD, SELECTION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer numberOfJobs;

    private final Boolean cloudwatchLogsEnabled;

    private final String selectionRules;

    private DataMigrationSettings(BuilderImpl builder) {
        this.numberOfJobs = builder.numberOfJobs;
        this.cloudwatchLogsEnabled = builder.cloudwatchLogsEnabled;
        this.selectionRules = builder.selectionRules;
    }

    /**
     * <p>
     * The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load
     * them to the target.
     * </p>
     * 
     * @return The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then
     *         load them to the target.
     */
    public final Integer numberOfJobs() {
        return numberOfJobs;
    }

    /**
     * <p>
     * Whether to enable CloudWatch logging for the data migration.
     * </p>
     * 
     * @return Whether to enable CloudWatch logging for the data migration.
     */
    public final Boolean cloudwatchLogsEnabled() {
        return cloudwatchLogsEnabled;
    }

    /**
     * <p>
     * A JSON-formatted string that defines what objects to include and exclude from the migration.
     * </p>
     * 
     * @return A JSON-formatted string that defines what objects to include and exclude from the migration.
     */
    public final String selectionRules() {
        return selectionRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfJobs());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(selectionRules());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataMigrationSettings)) {
            return false;
        }
        DataMigrationSettings other = (DataMigrationSettings) obj;
        return Objects.equals(numberOfJobs(), other.numberOfJobs())
                && Objects.equals(cloudwatchLogsEnabled(), other.cloudwatchLogsEnabled())
                && Objects.equals(selectionRules(), other.selectionRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataMigrationSettings").add("NumberOfJobs", numberOfJobs())
                .add("CloudwatchLogsEnabled", cloudwatchLogsEnabled())
                .add("SelectionRules", selectionRules() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfJobs":
            return Optional.ofNullable(clazz.cast(numberOfJobs()));
        case "CloudwatchLogsEnabled":
            return Optional.ofNullable(clazz.cast(cloudwatchLogsEnabled()));
        case "SelectionRules":
            return Optional.ofNullable(clazz.cast(selectionRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NumberOfJobs", NUMBER_OF_JOBS_FIELD);
        map.put("CloudwatchLogsEnabled", CLOUDWATCH_LOGS_ENABLED_FIELD);
        map.put("SelectionRules", SELECTION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataMigrationSettings, T> g) {
        return obj -> g.apply((DataMigrationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataMigrationSettings> {
        /**
         * <p>
         * The number of parallel jobs that trigger parallel threads to unload the tables from the source, and then load
         * them to the target.
         * </p>
         * 
         * @param numberOfJobs
         *        The number of parallel jobs that trigger parallel threads to unload the tables from the source, and
         *        then load them to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfJobs(Integer numberOfJobs);

        /**
         * <p>
         * Whether to enable CloudWatch logging for the data migration.
         * </p>
         * 
         * @param cloudwatchLogsEnabled
         *        Whether to enable CloudWatch logging for the data migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogsEnabled(Boolean cloudwatchLogsEnabled);

        /**
         * <p>
         * A JSON-formatted string that defines what objects to include and exclude from the migration.
         * </p>
         * 
         * @param selectionRules
         *        A JSON-formatted string that defines what objects to include and exclude from the migration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionRules(String selectionRules);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfJobs;

        private Boolean cloudwatchLogsEnabled;

        private String selectionRules;

        private BuilderImpl() {
        }

        private BuilderImpl(DataMigrationSettings model) {
            numberOfJobs(model.numberOfJobs);
            cloudwatchLogsEnabled(model.cloudwatchLogsEnabled);
            selectionRules(model.selectionRules);
        }

        public final Integer getNumberOfJobs() {
            return numberOfJobs;
        }

        public final void setNumberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
        }

        @Override
        public final Builder numberOfJobs(Integer numberOfJobs) {
            this.numberOfJobs = numberOfJobs;
            return this;
        }

        public final Boolean getCloudwatchLogsEnabled() {
            return cloudwatchLogsEnabled;
        }

        public final void setCloudwatchLogsEnabled(Boolean cloudwatchLogsEnabled) {
            this.cloudwatchLogsEnabled = cloudwatchLogsEnabled;
        }

        @Override
        public final Builder cloudwatchLogsEnabled(Boolean cloudwatchLogsEnabled) {
            this.cloudwatchLogsEnabled = cloudwatchLogsEnabled;
            return this;
        }

        public final String getSelectionRules() {
            return selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        @Override
        public DataMigrationSettings build() {
            return new DataMigrationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
