/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Savings Plans commitment details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlans implements SdkPojo, Serializable, ToCopyableBuilder<SavingsPlans.Builder, SavingsPlans> {
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PaymentOption").getter(getter(SavingsPlans::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<String> SAVINGS_PLANS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SavingsPlansType").getter(getter(SavingsPlans::savingsPlansTypeAsString))
            .setter(setter(Builder::savingsPlansType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansType").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(SavingsPlans::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceFamily").getter(getter(SavingsPlans::instanceFamily)).setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").build()).build();

    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TermInYears").getter(getter(SavingsPlans::termInYearsAsString)).setter(setter(Builder::termInYears))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()).build();

    private static final SdkField<Double> SAVINGS_PLANS_COMMITMENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("SavingsPlansCommitment").getter(getter(SavingsPlans::savingsPlansCommitment))
            .setter(setter(Builder::savingsPlansCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansCommitment").build())
            .build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OfferingId").getter(getter(SavingsPlans::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYMENT_OPTION_FIELD,
            SAVINGS_PLANS_TYPE_FIELD, REGION_FIELD, INSTANCE_FAMILY_FIELD, TERM_IN_YEARS_FIELD, SAVINGS_PLANS_COMMITMENT_FIELD,
            OFFERING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String paymentOption;

    private final String savingsPlansType;

    private final String region;

    private final String instanceFamily;

    private final String termInYears;

    private final Double savingsPlansCommitment;

    private final String offeringId;

    private SavingsPlans(BuilderImpl builder) {
        this.paymentOption = builder.paymentOption;
        this.savingsPlansType = builder.savingsPlansType;
        this.region = builder.region;
        this.instanceFamily = builder.instanceFamily;
        this.termInYears = builder.termInYears;
        this.savingsPlansCommitment = builder.savingsPlansCommitment;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * The payment option for the Savings Plans commitment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the Savings Plans commitment.
     * @see PaymentOption
     */
    public final PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option for the Savings Plans commitment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the Savings Plans commitment.
     * @see PaymentOption
     */
    public final String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The Savings Plans type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlansType}
     * will return {@link SupportedSavingsPlansType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #savingsPlansTypeAsString}.
     * </p>
     * 
     * @return The Savings Plans type.
     * @see SupportedSavingsPlansType
     */
    public final SupportedSavingsPlansType savingsPlansType() {
        return SupportedSavingsPlansType.fromValue(savingsPlansType);
    }

    /**
     * <p>
     * The Savings Plans type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlansType}
     * will return {@link SupportedSavingsPlansType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #savingsPlansTypeAsString}.
     * </p>
     * 
     * @return The Savings Plans type.
     * @see SupportedSavingsPlansType
     */
    public final String savingsPlansTypeAsString() {
        return savingsPlansType;
    }

    /**
     * <p>
     * The Region associated with the Savings Plans commitment.
     * </p>
     * 
     * @return The Region associated with the Savings Plans commitment.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The instance family of the Savings Plans commitment.
     * </p>
     * 
     * @return The instance family of the Savings Plans commitment.
     */
    public final String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The term that you want the Savings Plans commitment for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The term that you want the Savings Plans commitment for.
     * @see TermInYears
     */
    public final TermInYears termInYears() {
        return TermInYears.fromValue(termInYears);
    }

    /**
     * <p>
     * The term that you want the Savings Plans commitment for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The term that you want the Savings Plans commitment for.
     * @see TermInYears
     */
    public final String termInYearsAsString() {
        return termInYears;
    }

    /**
     * <p>
     * The Savings Plans commitment.
     * </p>
     * 
     * @return The Savings Plans commitment.
     */
    public final Double savingsPlansCommitment() {
        return savingsPlansCommitment;
    }

    /**
     * <p>
     * The unique ID that's used to distinguish Savings Plans commitments from one another.
     * </p>
     * 
     * @return The unique ID that's used to distinguish Savings Plans commitments from one another.
     */
    public final String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlans)) {
            return false;
        }
        SavingsPlans other = (SavingsPlans) obj;
        return Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(savingsPlansTypeAsString(), other.savingsPlansTypeAsString())
                && Objects.equals(region(), other.region()) && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(termInYearsAsString(), other.termInYearsAsString())
                && Objects.equals(savingsPlansCommitment(), other.savingsPlansCommitment())
                && Objects.equals(offeringId(), other.offeringId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlans").add("PaymentOption", paymentOptionAsString())
                .add("SavingsPlansType", savingsPlansTypeAsString()).add("Region", region())
                .add("InstanceFamily", instanceFamily()).add("TermInYears", termInYearsAsString())
                .add("SavingsPlansCommitment", savingsPlansCommitment()).add("OfferingId", offeringId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "SavingsPlansType":
            return Optional.ofNullable(clazz.cast(savingsPlansTypeAsString()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "TermInYears":
            return Optional.ofNullable(clazz.cast(termInYearsAsString()));
        case "SavingsPlansCommitment":
            return Optional.ofNullable(clazz.cast(savingsPlansCommitment()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PaymentOption", PAYMENT_OPTION_FIELD);
        map.put("SavingsPlansType", SAVINGS_PLANS_TYPE_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("InstanceFamily", INSTANCE_FAMILY_FIELD);
        map.put("TermInYears", TERM_IN_YEARS_FIELD);
        map.put("SavingsPlansCommitment", SAVINGS_PLANS_COMMITMENT_FIELD);
        map.put("OfferingId", OFFERING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlans, T> g) {
        return obj -> g.apply((SavingsPlans) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlans> {
        /**
         * <p>
         * The payment option for the Savings Plans commitment.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the Savings Plans commitment.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option for the Savings Plans commitment.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the Savings Plans commitment.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The Savings Plans type.
         * </p>
         * 
         * @param savingsPlansType
         *        The Savings Plans type.
         * @see SupportedSavingsPlansType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedSavingsPlansType
         */
        Builder savingsPlansType(String savingsPlansType);

        /**
         * <p>
         * The Savings Plans type.
         * </p>
         * 
         * @param savingsPlansType
         *        The Savings Plans type.
         * @see SupportedSavingsPlansType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedSavingsPlansType
         */
        Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType);

        /**
         * <p>
         * The Region associated with the Savings Plans commitment.
         * </p>
         * 
         * @param region
         *        The Region associated with the Savings Plans commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The instance family of the Savings Plans commitment.
         * </p>
         * 
         * @param instanceFamily
         *        The instance family of the Savings Plans commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The term that you want the Savings Plans commitment for.
         * </p>
         * 
         * @param termInYears
         *        The term that you want the Savings Plans commitment for.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(String termInYears);

        /**
         * <p>
         * The term that you want the Savings Plans commitment for.
         * </p>
         * 
         * @param termInYears
         *        The term that you want the Savings Plans commitment for.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(TermInYears termInYears);

        /**
         * <p>
         * The Savings Plans commitment.
         * </p>
         * 
         * @param savingsPlansCommitment
         *        The Savings Plans commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansCommitment(Double savingsPlansCommitment);

        /**
         * <p>
         * The unique ID that's used to distinguish Savings Plans commitments from one another.
         * </p>
         * 
         * @param offeringId
         *        The unique ID that's used to distinguish Savings Plans commitments from one another.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);
    }

    static final class BuilderImpl implements Builder {
        private String paymentOption;

        private String savingsPlansType;

        private String region;

        private String instanceFamily;

        private String termInYears;

        private Double savingsPlansCommitment;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlans model) {
            paymentOption(model.paymentOption);
            savingsPlansType(model.savingsPlansType);
            region(model.region);
            instanceFamily(model.instanceFamily);
            termInYears(model.termInYears);
            savingsPlansCommitment(model.savingsPlansCommitment);
            offeringId(model.offeringId);
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final String getSavingsPlansType() {
            return savingsPlansType;
        }

        public final void setSavingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
        }

        @Override
        public final Builder savingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
            return this;
        }

        @Override
        public final Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType) {
            this.savingsPlansType(savingsPlansType == null ? null : savingsPlansType.toString());
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final String getTermInYears() {
            return termInYears;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final Double getSavingsPlansCommitment() {
            return savingsPlansCommitment;
        }

        public final void setSavingsPlansCommitment(Double savingsPlansCommitment) {
            this.savingsPlansCommitment = savingsPlansCommitment;
        }

        @Override
        public final Builder savingsPlansCommitment(Double savingsPlansCommitment) {
            this.savingsPlansCommitment = savingsPlansCommitment;
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        @Override
        public SavingsPlans build() {
            return new SavingsPlans(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
