/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCostAllocationTagsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<ListCostAllocationTagsRequest.Builder, ListCostAllocationTagsRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListCostAllocationTagsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagKeys")
            .getter(getter(ListCostAllocationTagsRequest::tagKeys))
            .setter(setter(Builder::tagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ListCostAllocationTagsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCostAllocationTagsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListCostAllocationTagsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, TAG_KEYS_FIELD,
            TYPE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String status;

    private final List<String> tagKeys;

    private final String type;

    private final String nextToken;

    private final Integer maxResults;

    private ListCostAllocationTagsRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.tagKeys = builder.tagKeys;
        this.type = builder.type;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The status of cost allocation tag keys that are returned for this request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CostAllocationTagStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of cost allocation tag keys that are returned for this request.
     * @see CostAllocationTagStatus
     */
    public final CostAllocationTagStatus status() {
        return CostAllocationTagStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of cost allocation tag keys that are returned for this request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CostAllocationTagStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of cost allocation tag keys that are returned for this request.
     * @see CostAllocationTagStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagKeys() {
        return tagKeys != null && !(tagKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of cost allocation tag keys that are returned for this request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagKeys} method.
     * </p>
     * 
     * @return The list of cost allocation tag keys that are returned for this request.
     */
    public final List<String> tagKeys() {
        return tagKeys;
    }

    /**
     * <p>
     * The type of <code>CostAllocationTag</code> object that are returned for this request. The
     * <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support Amazon Web
     * Services resources for cost allocation purposes. The <code>UserDefined</code> type tags are tags that you define,
     * create, and apply to resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CostAllocationTagType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of <code>CostAllocationTag</code> object that are returned for this request. The
     *         <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support
     *         Amazon Web Services resources for cost allocation purposes. The <code>UserDefined</code> type tags are
     *         tags that you define, create, and apply to resources.
     * @see CostAllocationTagType
     */
    public final CostAllocationTagType type() {
        return CostAllocationTagType.fromValue(type);
    }

    /**
     * <p>
     * The type of <code>CostAllocationTag</code> object that are returned for this request. The
     * <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support Amazon Web
     * Services resources for cost allocation purposes. The <code>UserDefined</code> type tags are tags that you define,
     * create, and apply to resources.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CostAllocationTagType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of <code>CostAllocationTag</code> object that are returned for this request. The
     *         <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support
     *         Amazon Web Services resources for cost allocation purposes. The <code>UserDefined</code> type tags are
     *         tags that you define, create, and apply to resources.
     * @see CostAllocationTagType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of objects that are returned for this request. By default, the request returns 100 results.
     * </p>
     * 
     * @return The maximum number of objects that are returned for this request. By default, the request returns 100
     *         results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagKeys() ? tagKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCostAllocationTagsRequest)) {
            return false;
        }
        ListCostAllocationTagsRequest other = (ListCostAllocationTagsRequest) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && hasTagKeys() == other.hasTagKeys()
                && Objects.equals(tagKeys(), other.tagKeys()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCostAllocationTagsRequest").add("Status", statusAsString())
                .add("TagKeys", hasTagKeys() ? tagKeys() : null).add("Type", typeAsString()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TagKeys":
            return Optional.ofNullable(clazz.cast(tagKeys()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("TagKeys", TAG_KEYS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCostAllocationTagsRequest, T> g) {
        return obj -> g.apply((ListCostAllocationTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCostAllocationTagsRequest> {
        /**
         * <p>
         * The status of cost allocation tag keys that are returned for this request.
         * </p>
         * 
         * @param status
         *        The status of cost allocation tag keys that are returned for this request.
         * @see CostAllocationTagStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of cost allocation tag keys that are returned for this request.
         * </p>
         * 
         * @param status
         *        The status of cost allocation tag keys that are returned for this request.
         * @see CostAllocationTagStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagStatus
         */
        Builder status(CostAllocationTagStatus status);

        /**
         * <p>
         * The list of cost allocation tag keys that are returned for this request.
         * </p>
         * 
         * @param tagKeys
         *        The list of cost allocation tag keys that are returned for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * The list of cost allocation tag keys that are returned for this request.
         * </p>
         * 
         * @param tagKeys
         *        The list of cost allocation tag keys that are returned for this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);

        /**
         * <p>
         * The type of <code>CostAllocationTag</code> object that are returned for this request. The
         * <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support Amazon
         * Web Services resources for cost allocation purposes. The <code>UserDefined</code> type tags are tags that you
         * define, create, and apply to resources.
         * </p>
         * 
         * @param type
         *        The type of <code>CostAllocationTag</code> object that are returned for this request. The
         *        <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support
         *        Amazon Web Services resources for cost allocation purposes. The <code>UserDefined</code> type tags are
         *        tags that you define, create, and apply to resources.
         * @see CostAllocationTagType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of <code>CostAllocationTag</code> object that are returned for this request. The
         * <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support Amazon
         * Web Services resources for cost allocation purposes. The <code>UserDefined</code> type tags are tags that you
         * define, create, and apply to resources.
         * </p>
         * 
         * @param type
         *        The type of <code>CostAllocationTag</code> object that are returned for this request. The
         *        <code>AWSGenerated</code> type tags are tags that Amazon Web Services defines and applies to support
         *        Amazon Web Services resources for cost allocation purposes. The <code>UserDefined</code> type tags are
         *        tags that you define, create, and apply to resources.
         * @see CostAllocationTagType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostAllocationTagType
         */
        Builder type(CostAllocationTagType type);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of objects that are returned for this request. By default, the request returns 100
         * results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects that are returned for this request. By default, the request returns 100
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String status;

        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCostAllocationTagsRequest model) {
            super(model);
            status(model.status);
            tagKeys(model.tagKeys);
            type(model.type);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CostAllocationTagStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getTagKeys() {
            if (tagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return tagKeys;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = CostAllocationTagKeyListCopier.copy(tagKeys);
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = CostAllocationTagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CostAllocationTagType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCostAllocationTagsRequest build() {
            return new ListCostAllocationTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
