/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRightsizingRecommendationRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetRightsizingRecommendationRequest.Builder, GetRightsizingRecommendationRequest> {
    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetRightsizingRecommendationRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<RightsizingRecommendationConfiguration> CONFIGURATION_FIELD = SdkField
            .<RightsizingRecommendationConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(GetRightsizingRecommendationRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(RightsizingRecommendationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Service")
            .getter(getter(GetRightsizingRecommendationRequest::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(GetRightsizingRecommendationRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetRightsizingRecommendationRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            CONFIGURATION_FIELD, SERVICE_FIELD, PAGE_SIZE_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Expression filter;

    private final RightsizingRecommendationConfiguration configuration;

    private final String service;

    private final Integer pageSize;

    private final String nextPageToken;

    private GetRightsizingRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.filter = builder.filter;
        this.configuration = builder.configuration;
        this.service = builder.service;
        this.pageSize = builder.pageSize;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * <p>
     * You can use Configuration to customize recommendations across two attributes. You can choose to view
     * recommendations for instances within the same instance families or across different instance families. You can
     * also choose to view your estimated savings that are associated with recommendations with consideration of
     * existing Savings Plans or RI benefits, or neither.
     * </p>
     * 
     * @return You can use Configuration to customize recommendations across two attributes. You can choose to view
     *         recommendations for instances within the same instance families or across different instance families.
     *         You can also choose to view your estimated savings that are associated with recommendations with
     *         consideration of existing Savings Plans or RI benefits, or neither.
     */
    public final RightsizingRecommendationConfiguration configuration() {
        return configuration;
    }

    /**
     * <p>
     * The specific service that you want recommendations for. The only valid value for
     * <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".
     * </p>
     * 
     * @return The specific service that you want recommendations for. The only valid value for
     *         <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * The number of recommendations that you want returned in a single response object.
     * </p>
     * 
     * @return The number of recommendations that you want returned in a single response object.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results that you want to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results that you want to retrieve.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRightsizingRecommendationRequest)) {
            return false;
        }
        GetRightsizingRecommendationRequest other = (GetRightsizingRecommendationRequest) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(configuration(), other.configuration())
                && Objects.equals(service(), other.service()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRightsizingRecommendationRequest").add("Filter", filter())
                .add("Configuration", configuration()).add("Service", service()).add("PageSize", pageSize())
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Filter", FILTER_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Service", SERVICE_FIELD);
        map.put("PageSize", PAGE_SIZE_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRightsizingRecommendationRequest, T> g) {
        return obj -> g.apply((GetRightsizingRecommendationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRightsizingRecommendationRequest> {
        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * You can use Configuration to customize recommendations across two attributes. You can choose to view
         * recommendations for instances within the same instance families or across different instance families. You
         * can also choose to view your estimated savings that are associated with recommendations with consideration of
         * existing Savings Plans or RI benefits, or neither.
         * </p>
         * 
         * @param configuration
         *        You can use Configuration to customize recommendations across two attributes. You can choose to view
         *        recommendations for instances within the same instance families or across different instance families.
         *        You can also choose to view your estimated savings that are associated with recommendations with
         *        consideration of existing Savings Plans or RI benefits, or neither.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RightsizingRecommendationConfiguration configuration);

        /**
         * <p>
         * You can use Configuration to customize recommendations across two attributes. You can choose to view
         * recommendations for instances within the same instance families or across different instance families. You
         * can also choose to view your estimated savings that are associated with recommendations with consideration of
         * existing Savings Plans or RI benefits, or neither.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RightsizingRecommendationConfiguration.Builder} avoiding the need to create one manually via
         * {@link RightsizingRecommendationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RightsizingRecommendationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(RightsizingRecommendationConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RightsizingRecommendationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RightsizingRecommendationConfiguration)
         */
        default Builder configuration(Consumer<RightsizingRecommendationConfiguration.Builder> configuration) {
            return configuration(RightsizingRecommendationConfiguration.builder().applyMutation(configuration).build());
        }

        /**
         * <p>
         * The specific service that you want recommendations for. The only valid value for
         * <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".
         * </p>
         * 
         * @param service
         *        The specific service that you want recommendations for. The only valid value for
         *        <code>GetRightsizingRecommendation</code> is "<code>AmazonEC2</code>".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * The number of recommendations that you want returned in a single response object.
         * </p>
         * 
         * @param pageSize
         *        The number of recommendations that you want returned in a single response object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The pagination token that indicates the next set of results that you want to retrieve.
         * </p>
         * 
         * @param nextPageToken
         *        The pagination token that indicates the next set of results that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private Expression filter;

        private RightsizingRecommendationConfiguration configuration;

        private String service;

        private Integer pageSize;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRightsizingRecommendationRequest model) {
            super(model);
            filter(model.filter);
            configuration(model.configuration);
            service(model.service);
            pageSize(model.pageSize);
            nextPageToken(model.nextPageToken);
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final RightsizingRecommendationConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(RightsizingRecommendationConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RightsizingRecommendationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRightsizingRecommendationRequest build() {
            return new GetRightsizingRecommendationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
