/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You can use the following request parameters to query for how much of your instance usage a reservation covered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReservationCoverageRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetReservationCoverageRequest.Builder, GetReservationCoverageRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(GetReservationCoverageRequest::timePeriod))
            .setter(setter(Builder::timePeriod)).constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<List<GroupDefinition>> GROUP_BY_FIELD = SdkField
            .<List<GroupDefinition>> builder(MarshallingType.LIST)
            .memberName("GroupBy")
            .getter(getter(GetReservationCoverageRequest::groupBy))
            .setter(setter(Builder::groupBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GRANULARITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Granularity").getter(getter(GetReservationCoverageRequest::granularityAsString))
            .setter(setter(Builder::granularity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetReservationCoverageRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<List<String>> METRICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Metrics")
            .getter(getter(GetReservationCoverageRequest::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetReservationCoverageRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<SortDefinition> SORT_BY_FIELD = SdkField.<SortDefinition> builder(MarshallingType.SDK_POJO)
            .memberName("SortBy").getter(getter(GetReservationCoverageRequest::sortBy)).setter(setter(Builder::sortBy))
            .constructor(SortDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetReservationCoverageRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD,
            GROUP_BY_FIELD, GRANULARITY_FIELD, FILTER_FIELD, METRICS_FIELD, NEXT_PAGE_TOKEN_FIELD, SORT_BY_FIELD,
            MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DateInterval timePeriod;

    private final List<GroupDefinition> groupBy;

    private final String granularity;

    private final Expression filter;

    private final List<String> metrics;

    private final String nextPageToken;

    private final SortDefinition sortBy;

    private final Integer maxResults;

    private GetReservationCoverageRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.groupBy = builder.groupBy;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
        this.metrics = builder.metrics;
        this.nextPageToken = builder.nextPageToken;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The start and end dates of the period that you want to retrieve data about reservation coverage for. You can
     * retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is inclusive,
     * but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code>
     * is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     * </p>
     * 
     * @return The start and end dates of the period that you want to retrieve data about reservation coverage for. You
     *         can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is
     *         inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code>
     *         and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from
     *         <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including
     *         <code>2017-05-01</code>.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * You can group the data by the following attributes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE
     * </p>
     * </li>
     * <li>
     * <p>
     * INVOICING_ENTITY
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return You can group the data by the following attributes:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DATABASE_ENGINE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INVOICING_ENTITY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATING_SYSTEM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY
     *         </p>
     *         </li>
     */
    public final List<GroupDefinition> groupBy() {
        return groupBy;
    }

    /**
     * <p>
     * The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code>
     * and <code>DAILY</code>.
     * </p>
     * <p>
     * If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the
     * response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.
     * </p>
     * <p>
     * The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity of the Amazon Web Services cost data for the reservation. Valid values are
     *         <code>MONTHLY</code> and <code>DAILY</code>.</p>
     *         <p>
     *         If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't
     *         set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or
     *         <code>DAILY</code>.
     *         </p>
     *         <p>
     *         The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and
     *         <code>MONTHLY</code> granularities.
     * @see Granularity
     */
    public final Granularity granularity() {
        return Granularity.fromValue(granularity);
    }

    /**
     * <p>
     * The granularity of the Amazon Web Services cost data for the reservation. Valid values are <code>MONTHLY</code>
     * and <code>DAILY</code>.
     * </p>
     * <p>
     * If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set, the
     * response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or <code>DAILY</code>.
     * </p>
     * <p>
     * The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
     * granularities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granularity} will
     * return {@link Granularity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granularityAsString}.
     * </p>
     * 
     * @return The granularity of the Amazon Web Services cost data for the reservation. Valid values are
     *         <code>MONTHLY</code> and <code>DAILY</code>.</p>
     *         <p>
     *         If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't
     *         set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or
     *         <code>DAILY</code>.
     *         </p>
     *         <p>
     *         The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and
     *         <code>MONTHLY</code> granularities.
     * @see Granularity
     */
    public final String granularityAsString() {
        return granularity;
    }

    /**
     * <p>
     * Filters utilization data by dimensions. You can filter by the following dimensions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>GetReservationCoverage</code> uses the same <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
     * object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest only
     * one level deep. If there are multiple values for a dimension, they are OR'd together.
     * </p>
     * <p>
     * If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.
     * </p>
     * <p>
     * Cost category is also supported.
     * </p>
     * 
     * @return Filters utilization data by dimensions. You can filter by the following dimensions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DATABASE_ENGINE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATING_SYSTEM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TAG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <code>GetReservationCoverage</code> uses the same <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
     *         >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
     *         dimension. You can nest only one level deep. If there are multiple values for a dimension, they are OR'd
     *         together.
     *         </p>
     *         <p>
     *         If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.
     *         </p>
     *         <p>
     *         Cost category is also supported.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The measurement that you want your reservation coverage reported in.
     * </p>
     * <p>
     * Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in a
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return The measurement that you want your reservation coverage reported in.</p>
     *         <p>
     *         Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values
     *         in a request.
     */
    public final List<String> metrics() {
        return metrics;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The value by which you want to sort the data.
     * </p>
     * <p>
     * The following values are supported for <code>Key</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>OnDemandCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CoverageHoursPercentage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OnDemandHours</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReservedHours</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalRunningHours</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CoverageNormalizedUnitsPercentage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OnDemandNormalizedUnits</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReservedNormalizedUnits</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TotalRunningNormalizedUnits</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Time</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     * </p>
     * 
     * @return The value by which you want to sort the data.</p>
     *         <p>
     *         The following values are supported for <code>Key</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>OnDemandCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CoverageHoursPercentage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OnDemandHours</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReservedHours</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TotalRunningHours</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CoverageNormalizedUnitsPercentage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OnDemandNormalizedUnits</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReservedNormalizedUnits</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TotalRunningNormalizedUnits</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Time</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     */
    public final SortDefinition sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * The maximum number of objects that you returned for this request. If more objects are available, in the response,
     * Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the next batch of
     * objects.
     * </p>
     * 
     * @return The maximum number of objects that you returned for this request. If more objects are available, in the
     *         response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get
     *         the next batch of objects.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationCoverageRequest)) {
            return false;
        }
        GetReservationCoverageRequest other = (GetReservationCoverageRequest) obj;
        return Objects.equals(timePeriod(), other.timePeriod()) && hasGroupBy() == other.hasGroupBy()
                && Objects.equals(groupBy(), other.groupBy())
                && Objects.equals(granularityAsString(), other.granularityAsString()) && Objects.equals(filter(), other.filter())
                && hasMetrics() == other.hasMetrics() && Objects.equals(metrics(), other.metrics())
                && Objects.equals(nextPageToken(), other.nextPageToken()) && Objects.equals(sortBy(), other.sortBy())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReservationCoverageRequest").add("TimePeriod", timePeriod())
                .add("GroupBy", hasGroupBy() ? groupBy() : null).add("Granularity", granularityAsString())
                .add("Filter", filter()).add("Metrics", hasMetrics() ? metrics() : null).add("NextPageToken", nextPageToken())
                .add("SortBy", sortBy()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "GroupBy":
            return Optional.ofNullable(clazz.cast(groupBy()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularityAsString()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReservationCoverageRequest, T> g) {
        return obj -> g.apply((GetReservationCoverageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetReservationCoverageRequest> {
        /**
         * <p>
         * The start and end dates of the period that you want to retrieve data about reservation coverage for. You can
         * retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is
         * inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and
         * <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from
         * <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>
         * .
         * </p>
         * 
         * @param timePeriod
         *        The start and end dates of the period that you want to retrieve data about reservation coverage for.
         *        You can retrieve data for a maximum of 13 months: the last 12 months and the current month. The start
         *        date is inclusive, but the end date is exclusive. For example, if <code>start</code> is
         *        <code>2017-01-01</code> and <code>end</code> is <code>2017-05-01</code>, then the cost and usage data
         *        is retrieved from <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not
         *        including <code>2017-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The start and end dates of the period that you want to retrieve data about reservation coverage for. You can
         * retrieve data for a maximum of 13 months: the last 12 months and the current month. The start date is
         * inclusive, but the end date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and
         * <code>end</code> is <code>2017-05-01</code>, then the cost and usage data is retrieved from
         * <code>2017-01-01</code> up to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>
         * .
         * </p>
         * This is a convenience method that creates an instance of the {@link DateInterval.Builder} avoiding the need
         * to create one manually via {@link DateInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * You can group the data by the following attributes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE
         * </p>
         * </li>
         * <li>
         * <p>
         * INVOICING_ENTITY
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupBy
         *        You can group the data by the following attributes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVOICING_ENTITY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<GroupDefinition> groupBy);

        /**
         * <p>
         * You can group the data by the following attributes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE
         * </p>
         * </li>
         * <li>
         * <p>
         * INVOICING_ENTITY
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY
         * </p>
         * </li>
         * </ul>
         * 
         * @param groupBy
         *        You can group the data by the following attributes:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INVOICING_ENTITY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(GroupDefinition... groupBy);

        /**
         * <p>
         * You can group the data by the following attributes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE
         * </p>
         * </li>
         * <li>
         * <p>
         * INVOICING_ENTITY
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #groupBy(List<GroupDefinition>)}.
         * 
         * @param groupBy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.GroupDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupBy(java.util.Collection<GroupDefinition>)
         */
        Builder groupBy(Consumer<GroupDefinition.Builder>... groupBy);

        /**
         * <p>
         * The granularity of the Amazon Web Services cost data for the reservation. Valid values are
         * <code>MONTHLY</code> and <code>DAILY</code>.
         * </p>
         * <p>
         * If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set,
         * the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or
         * <code>DAILY</code>.
         * </p>
         * <p>
         * The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
         * granularities.
         * </p>
         * 
         * @param granularity
         *        The granularity of the Amazon Web Services cost data for the reservation. Valid values are
         *        <code>MONTHLY</code> and <code>DAILY</code>.</p>
         *        <p>
         *        If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code>
         *        isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code>
         *        or <code>DAILY</code>.
         *        </p>
         *        <p>
         *        The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and
         *        <code>MONTHLY</code> granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(String granularity);

        /**
         * <p>
         * The granularity of the Amazon Web Services cost data for the reservation. Valid values are
         * <code>MONTHLY</code> and <code>DAILY</code>.
         * </p>
         * <p>
         * If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code> isn't set,
         * the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code> or
         * <code>DAILY</code>.
         * </p>
         * <p>
         * The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and <code>MONTHLY</code>
         * granularities.
         * </p>
         * 
         * @param granularity
         *        The granularity of the Amazon Web Services cost data for the reservation. Valid values are
         *        <code>MONTHLY</code> and <code>DAILY</code>.</p>
         *        <p>
         *        If <code>GroupBy</code> is set, <code>Granularity</code> can't be set. If <code>Granularity</code>
         *        isn't set, the response object doesn't include <code>Granularity</code>, either <code>MONTHLY</code>
         *        or <code>DAILY</code>.
         *        </p>
         *        <p>
         *        The <code>GetReservationCoverage</code> operation supports only <code>DAILY</code> and
         *        <code>MONTHLY</code> granularities.
         * @see Granularity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Granularity
         */
        Builder granularity(Granularity granularity);

        /**
         * <p>
         * Filters utilization data by dimensions. You can filter by the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetReservationCoverage</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest
         * only one level deep. If there are multiple values for a dimension, they are OR'd together.
         * </p>
         * <p>
         * If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.
         * </p>
         * <p>
         * Cost category is also supported.
         * </p>
         * 
         * @param filter
         *        Filters utilization data by dimensions. You can filter by the following dimensions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TAG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <code>GetReservationCoverage</code> uses the same <a
         *        href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html"
         *        >Expression</a> object as the other operations, but only <code>AND</code> is supported among each
         *        dimension. You can nest only one level deep. If there are multiple values for a dimension, they are
         *        OR'd together.
         *        </p>
         *        <p>
         *        If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.
         *        </p>
         *        <p>
         *        Cost category is also supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * <p>
         * Filters utilization data by dimensions. You can filter by the following dimensions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY
         * </p>
         * </li>
         * </ul>
         * <p>
         * <code>GetReservationCoverage</code> uses the same <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html">Expression</a>
         * object as the other operations, but only <code>AND</code> is supported among each dimension. You can nest
         * only one level deep. If there are multiple values for a dimension, they are OR'd together.
         * </p>
         * <p>
         * If you don't provide a <code>SERVICE</code> filter, Cost Explorer defaults to EC2.
         * </p>
         * <p>
         * Cost category is also supported.
         * </p>
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The measurement that you want your reservation coverage reported in.
         * </p>
         * <p>
         * Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in
         * a request.
         * </p>
         * 
         * @param metrics
         *        The measurement that you want your reservation coverage reported in.</p>
         *        <p>
         *        Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple
         *        values in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Collection<String> metrics);

        /**
         * <p>
         * The measurement that you want your reservation coverage reported in.
         * </p>
         * <p>
         * Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple values in
         * a request.
         * </p>
         * 
         * @param metrics
         *        The measurement that you want your reservation coverage reported in.</p>
         *        <p>
         *        Valid values are <code>Hour</code>, <code>Unit</code>, and <code>Cost</code>. You can use multiple
         *        values in a request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(String... metrics);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The following values are supported for <code>Key</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OnDemandCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CoverageHoursPercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OnDemandHours</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReservedHours</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalRunningHours</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CoverageNormalizedUnitsPercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OnDemandNormalizedUnits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReservedNormalizedUnits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalRunningNormalizedUnits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Time</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * 
         * @param sortBy
         *        The value by which you want to sort the data.</p>
         *        <p>
         *        The following values are supported for <code>Key</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>OnDemandCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CoverageHoursPercentage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OnDemandHours</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReservedHours</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TotalRunningHours</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CoverageNormalizedUnitsPercentage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OnDemandNormalizedUnits</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReservedNormalizedUnits</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TotalRunningNormalizedUnits</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Time</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SortDefinition sortBy);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The following values are supported for <code>Key</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>OnDemandCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CoverageHoursPercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OnDemandHours</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReservedHours</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalRunningHours</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CoverageNormalizedUnitsPercentage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OnDemandNormalizedUnits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReservedNormalizedUnits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TotalRunningNormalizedUnits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Time</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortDefinition.Builder} avoiding the need
         * to create one manually via {@link SortDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #sortBy(SortDefinition)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link SortDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(SortDefinition)
         */
        default Builder sortBy(Consumer<SortDefinition.Builder> sortBy) {
            return sortBy(SortDefinition.builder().applyMutation(sortBy).build());
        }

        /**
         * <p>
         * The maximum number of objects that you returned for this request. If more objects are available, in the
         * response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call to get the
         * next batch of objects.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects that you returned for this request. If more objects are available, in
         *        the response, Amazon Web Services provides a NextPageToken value that you can use in a subsequent call
         *        to get the next batch of objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private DateInterval timePeriod;

        private List<GroupDefinition> groupBy = DefaultSdkAutoConstructList.getInstance();

        private String granularity;

        private Expression filter;

        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private SortDefinition sortBy;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationCoverageRequest model) {
            super(model);
            timePeriod(model.timePeriod);
            groupBy(model.groupBy);
            granularity(model.granularity);
            filter(model.filter);
            metrics(model.metrics);
            nextPageToken(model.nextPageToken);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final List<GroupDefinition.Builder> getGroupBy() {
            List<GroupDefinition.Builder> result = GroupDefinitionsCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<GroupDefinition.BuilderImpl> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<GroupDefinition> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupDefinition... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<GroupDefinition.Builder>... groupBy) {
            groupBy(Stream.of(groupBy).map(c -> GroupDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGranularity() {
            return granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getMetrics() {
            if (metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricNamesCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = MetricNamesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String... metrics) {
            metrics(Arrays.asList(metrics));
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final SortDefinition.Builder getSortBy() {
            return sortBy != null ? sortBy.toBuilder() : null;
        }

        public final void setSortBy(SortDefinition.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(SortDefinition sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReservationCoverageRequest build() {
            return new GetReservationCoverageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
