/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDimensionValuesResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetDimensionValuesResponse.Builder, GetDimensionValuesResponse> {
    private static final SdkField<List<DimensionValuesWithAttributes>> DIMENSION_VALUES_FIELD = SdkField
            .<List<DimensionValuesWithAttributes>> builder(MarshallingType.LIST)
            .memberName("DimensionValues")
            .getter(getter(GetDimensionValuesResponse::dimensionValues))
            .setter(setter(Builder::dimensionValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionValuesWithAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionValuesWithAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> RETURN_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReturnSize").getter(getter(GetDimensionValuesResponse::returnSize)).setter(setter(Builder::returnSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnSize").build()).build();

    private static final SdkField<Integer> TOTAL_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalSize").getter(getter(GetDimensionValuesResponse::totalSize)).setter(setter(Builder::totalSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSize").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetDimensionValuesResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_VALUES_FIELD,
            RETURN_SIZE_FIELD, TOTAL_SIZE_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DimensionValuesWithAttributes> dimensionValues;

    private final Integer returnSize;

    private final Integer totalSize;

    private final String nextPageToken;

    private GetDimensionValuesResponse(BuilderImpl builder) {
        super(builder);
        this.dimensionValues = builder.dimensionValues;
        this.returnSize = builder.returnSize;
        this.totalSize = builder.totalSize;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionValues() {
        return dimensionValues != null && !(dimensionValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filters that you used to filter your request. Some dimensions are available only for a specific context.
     * </p>
     * <p>
     * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon Web
     * Services.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand
     * Instances and Standard Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     * response for this operation includes a unit attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14
     * days for EC2-Compute Service. You can opt-in by enabling <code>Hourly</code> and <code>Resource Level Data</code>
     * in Cost Management Console preferences.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     * <code>SingleAZ</code> and <code>MultiAZ</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability
     * Zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     * </p>
     * </li>
     * <li>
     * <p>
     * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the Amazon Web Services ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionValues} method.
     * </p>
     * 
     * @return The filters that you used to filter your request. Some dimensions are available only for a specific
     *         context.</p>
     *         <p>
     *         If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
     *         searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as
     *         Amazon Web Services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
     *         On-Demand Instances and Standard Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     *         <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     *         response for this operation includes a unit attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for
     *         last 14 days for EC2-Compute Service. You can opt-in by enabling <code>Hourly</code> and
     *         <code>Resource Level Data</code> in Cost Management Console preferences.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     *         <code>SingleAZ</code> and <code>MultiAZ</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
     *         Availability Zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The Amazon Web Services Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the Amazon Web Services ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
     *         </p>
     *         </li>
     */
    public final List<DimensionValuesWithAttributes> dimensionValues() {
        return dimensionValues;
    }

    /**
     * <p>
     * The number of results that Amazon Web Services returned at one time.
     * </p>
     * 
     * @return The number of results that Amazon Web Services returned at one time.
     */
    public final Integer returnSize() {
        return returnSize;
    }

    /**
     * <p>
     * The total number of search results.
     * </p>
     * 
     * @return The total number of search results.
     */
    public final Integer totalSize() {
        return totalSize;
    }

    /**
     * <p>
     * The token for the next set of retrievable results. Amazon Web Services provides the token when the response from
     * a previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token for the next set of retrievable results. Amazon Web Services provides the token when the
     *         response from a previous call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionValues() ? dimensionValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(returnSize());
        hashCode = 31 * hashCode + Objects.hashCode(totalSize());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionValuesResponse)) {
            return false;
        }
        GetDimensionValuesResponse other = (GetDimensionValuesResponse) obj;
        return hasDimensionValues() == other.hasDimensionValues() && Objects.equals(dimensionValues(), other.dimensionValues())
                && Objects.equals(returnSize(), other.returnSize()) && Objects.equals(totalSize(), other.totalSize())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDimensionValuesResponse")
                .add("DimensionValues", hasDimensionValues() ? dimensionValues() : null).add("ReturnSize", returnSize())
                .add("TotalSize", totalSize()).add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionValues":
            return Optional.ofNullable(clazz.cast(dimensionValues()));
        case "ReturnSize":
            return Optional.ofNullable(clazz.cast(returnSize()));
        case "TotalSize":
            return Optional.ofNullable(clazz.cast(totalSize()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DimensionValues", DIMENSION_VALUES_FIELD);
        map.put("ReturnSize", RETURN_SIZE_FIELD);
        map.put("TotalSize", TOTAL_SIZE_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDimensionValuesResponse, T> g) {
        return obj -> g.apply((GetDimensionValuesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDimensionValuesResponse> {
        /**
         * <p>
         * The filters that you used to filter your request. Some dimensions are available only for a specific context.
         * </p>
         * <p>
         * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon
         * Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         * On-Demand Instances and Standard Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
         * response for this operation includes a unit attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last
         * 14 days for EC2-Compute Service. You can opt-in by enabling <code>Hourly</code> and
         * <code>Resource Level Data</code> in Cost Management Console preferences.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         * Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * </p>
         * </li>
         * <li>
         * <p>
         * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         * </p>
         * </li>
         * </ul>
         * 
         * @param dimensionValues
         *        The filters that you used to filter your request. Some dimensions are available only for a specific
         *        context.</p>
         *        <p>
         *        If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as
         *        Amazon Web Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATION - The action performed. Examples include <code>RunInstance</code> and
         *        <code>CreateBucket</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         *        On-Demand Instances and Standard Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         *        <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms.
         *        The response for this operation includes a unit attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available
         *        for last 14 days for EC2-Compute Service. You can opt-in by enabling <code>Hourly</code> and
         *        <code>Resource Level Data</code> in Cost Management Console preferences.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         *        <code>SingleAZ</code> and <code>MultiAZ</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         *        Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValues(Collection<DimensionValuesWithAttributes> dimensionValues);

        /**
         * <p>
         * The filters that you used to filter your request. Some dimensions are available only for a specific context.
         * </p>
         * <p>
         * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon
         * Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         * On-Demand Instances and Standard Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
         * response for this operation includes a unit attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last
         * 14 days for EC2-Compute Service. You can opt-in by enabling <code>Hourly</code> and
         * <code>Resource Level Data</code> in Cost Management Console preferences.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         * Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * </p>
         * </li>
         * <li>
         * <p>
         * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         * </p>
         * </li>
         * </ul>
         * 
         * @param dimensionValues
         *        The filters that you used to filter your request. Some dimensions are available only for a specific
         *        context.</p>
         *        <p>
         *        If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as
         *        Amazon Web Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATION - The action performed. Examples include <code>RunInstance</code> and
         *        <code>CreateBucket</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         *        On-Demand Instances and Standard Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         *        <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms.
         *        The response for this operation includes a unit attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available
         *        for last 14 days for EC2-Compute Service. You can opt-in by enabling <code>Hourly</code> and
         *        <code>Resource Level Data</code> in Cost Management Console preferences.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         *        <code>SingleAZ</code> and <code>MultiAZ</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         *        Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The Amazon Web Services Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the Amazon Web Services ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValues(DimensionValuesWithAttributes... dimensionValues);

        /**
         * <p>
         * The filters that you used to filter your request. Some dimensions are available only for a specific context.
         * </p>
         * <p>
         * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LEGAL_ENTITY_NAME - The name of the organization that sells you Amazon Web Services services, such as Amazon
         * Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         * On-Demand Instances and Standard Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE - The Amazon Web Services service such as Amazon DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
         * response for this operation includes a unit attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last
         * 14 days for EC2-Compute Service. You can opt-in by enabling <code>Hourly</code> and
         * <code>Resource Level Data</code> in Cost Management Console preferences.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         * Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * </p>
         * </li>
         * <li>
         * <p>
         * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The Amazon Web Services Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the Amazon Web Services ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes.Builder#build()} is
         * called immediately and its result is passed to {@link #dimensionValues(List<DimensionValuesWithAttributes>)}.
         * 
         * @param dimensionValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionValues(java.util.Collection<DimensionValuesWithAttributes>)
         */
        Builder dimensionValues(Consumer<DimensionValuesWithAttributes.Builder>... dimensionValues);

        /**
         * <p>
         * The number of results that Amazon Web Services returned at one time.
         * </p>
         * 
         * @param returnSize
         *        The number of results that Amazon Web Services returned at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnSize(Integer returnSize);

        /**
         * <p>
         * The total number of search results.
         * </p>
         * 
         * @param totalSize
         *        The total number of search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSize(Integer totalSize);

        /**
         * <p>
         * The token for the next set of retrievable results. Amazon Web Services provides the token when the response
         * from a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token for the next set of retrievable results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<DimensionValuesWithAttributes> dimensionValues = DefaultSdkAutoConstructList.getInstance();

        private Integer returnSize;

        private Integer totalSize;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionValuesResponse model) {
            super(model);
            dimensionValues(model.dimensionValues);
            returnSize(model.returnSize);
            totalSize(model.totalSize);
            nextPageToken(model.nextPageToken);
        }

        public final List<DimensionValuesWithAttributes.Builder> getDimensionValues() {
            List<DimensionValuesWithAttributes.Builder> result = DimensionValuesWithAttributesListCopier
                    .copyToBuilder(this.dimensionValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionValues(Collection<DimensionValuesWithAttributes.BuilderImpl> dimensionValues) {
            this.dimensionValues = DimensionValuesWithAttributesListCopier.copyFromBuilder(dimensionValues);
        }

        @Override
        public final Builder dimensionValues(Collection<DimensionValuesWithAttributes> dimensionValues) {
            this.dimensionValues = DimensionValuesWithAttributesListCopier.copy(dimensionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValues(DimensionValuesWithAttributes... dimensionValues) {
            dimensionValues(Arrays.asList(dimensionValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValues(Consumer<DimensionValuesWithAttributes.Builder>... dimensionValues) {
            dimensionValues(Stream.of(dimensionValues).map(c -> DimensionValuesWithAttributes.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getReturnSize() {
            return returnSize;
        }

        public final void setReturnSize(Integer returnSize) {
            this.returnSize = returnSize;
        }

        @Override
        public final Builder returnSize(Integer returnSize) {
            this.returnSize = returnSize;
            return this;
        }

        public final Integer getTotalSize() {
            return totalSize;
        }

        public final void setTotalSize(Integer totalSize) {
            this.totalSize = totalSize;
        }

        @Override
        public final Builder totalSize(Integer totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetDimensionValuesResponse build() {
            return new GetDimensionValuesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
