/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a collection of cost drivers and their associated metrics for cost comparison analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostComparisonDriver implements SdkPojo, Serializable,
        ToCopyableBuilder<CostComparisonDriver.Builder, CostComparisonDriver> {
    private static final SdkField<Expression> COST_SELECTOR_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("CostSelector").getter(getter(CostComparisonDriver::costSelector)).setter(setter(Builder::costSelector))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostSelector").build()).build();

    private static final SdkField<Map<String, ComparisonMetricValue>> METRICS_FIELD = SdkField
            .<Map<String, ComparisonMetricValue>> builder(MarshallingType.MAP)
            .memberName("Metrics")
            .getter(getter(CostComparisonDriver::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComparisonMetricValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComparisonMetricValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<CostDriver>> COST_DRIVERS_FIELD = SdkField
            .<List<CostDriver>> builder(MarshallingType.LIST)
            .memberName("CostDrivers")
            .getter(getter(CostComparisonDriver::costDrivers))
            .setter(setter(Builder::costDrivers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostDrivers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostDriver> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostDriver::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_SELECTOR_FIELD,
            METRICS_FIELD, COST_DRIVERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Expression costSelector;

    private final Map<String, ComparisonMetricValue> metrics;

    private final List<CostDriver> costDrivers;

    private CostComparisonDriver(BuilderImpl builder) {
        this.costSelector = builder.costSelector;
        this.metrics = builder.metrics;
        this.costDrivers = builder.costDrivers;
    }

    /**
     * Returns the value of the CostSelector property for this object.
     * 
     * @return The value of the CostSelector property for this object.
     */
    public final Expression costSelector() {
        return costSelector;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of metric names to their comparison values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return A mapping of metric names to their comparison values.
     */
    public final Map<String, ComparisonMetricValue> metrics() {
        return metrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the CostDrivers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCostDrivers() {
        return costDrivers != null && !(costDrivers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of cost drivers, each representing a cost difference between the baseline and comparison time periods.
     * Each entry also includes a metric delta (for example, usage change) that contributed to the cost variance, along
     * with the identifier and type of change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCostDrivers} method.
     * </p>
     * 
     * @return An array of cost drivers, each representing a cost difference between the baseline and comparison time
     *         periods. Each entry also includes a metric delta (for example, usage change) that contributed to the cost
     *         variance, along with the identifier and type of change.
     */
    public final List<CostDriver> costDrivers() {
        return costDrivers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costSelector());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCostDrivers() ? costDrivers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostComparisonDriver)) {
            return false;
        }
        CostComparisonDriver other = (CostComparisonDriver) obj;
        return Objects.equals(costSelector(), other.costSelector()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics()) && hasCostDrivers() == other.hasCostDrivers()
                && Objects.equals(costDrivers(), other.costDrivers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostComparisonDriver").add("CostSelector", costSelector())
                .add("Metrics", hasMetrics() ? metrics() : null).add("CostDrivers", hasCostDrivers() ? costDrivers() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostSelector":
            return Optional.ofNullable(clazz.cast(costSelector()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "CostDrivers":
            return Optional.ofNullable(clazz.cast(costDrivers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CostSelector", COST_SELECTOR_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("CostDrivers", COST_DRIVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostComparisonDriver, T> g) {
        return obj -> g.apply((CostComparisonDriver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostComparisonDriver> {
        /**
         * Sets the value of the CostSelector property for this object.
         *
         * @param costSelector
         *        The new value for the CostSelector property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costSelector(Expression costSelector);

        /**
         * Sets the value of the CostSelector property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #costSelector(Expression)}.
         * 
         * @param costSelector
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costSelector(Expression)
         */
        default Builder costSelector(Consumer<Expression.Builder> costSelector) {
            return costSelector(Expression.builder().applyMutation(costSelector).build());
        }

        /**
         * <p>
         * A mapping of metric names to their comparison values.
         * </p>
         * 
         * @param metrics
         *        A mapping of metric names to their comparison values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, ComparisonMetricValue> metrics);

        /**
         * <p>
         * An array of cost drivers, each representing a cost difference between the baseline and comparison time
         * periods. Each entry also includes a metric delta (for example, usage change) that contributed to the cost
         * variance, along with the identifier and type of change.
         * </p>
         * 
         * @param costDrivers
         *        An array of cost drivers, each representing a cost difference between the baseline and comparison time
         *        periods. Each entry also includes a metric delta (for example, usage change) that contributed to the
         *        cost variance, along with the identifier and type of change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costDrivers(Collection<CostDriver> costDrivers);

        /**
         * <p>
         * An array of cost drivers, each representing a cost difference between the baseline and comparison time
         * periods. Each entry also includes a metric delta (for example, usage change) that contributed to the cost
         * variance, along with the identifier and type of change.
         * </p>
         * 
         * @param costDrivers
         *        An array of cost drivers, each representing a cost difference between the baseline and comparison time
         *        periods. Each entry also includes a metric delta (for example, usage change) that contributed to the
         *        cost variance, along with the identifier and type of change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costDrivers(CostDriver... costDrivers);

        /**
         * <p>
         * An array of cost drivers, each representing a cost difference between the baseline and comparison time
         * periods. Each entry also includes a metric delta (for example, usage change) that contributed to the cost
         * variance, along with the identifier and type of change.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.CostDriver.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.costexplorer.model.CostDriver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.CostDriver.Builder#build()} is called immediately
         * and its result is passed to {@link #costDrivers(List<CostDriver>)}.
         * 
         * @param costDrivers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.CostDriver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costDrivers(java.util.Collection<CostDriver>)
         */
        Builder costDrivers(Consumer<CostDriver.Builder>... costDrivers);
    }

    static final class BuilderImpl implements Builder {
        private Expression costSelector;

        private Map<String, ComparisonMetricValue> metrics = DefaultSdkAutoConstructMap.getInstance();

        private List<CostDriver> costDrivers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostComparisonDriver model) {
            costSelector(model.costSelector);
            metrics(model.metrics);
            costDrivers(model.costDrivers);
        }

        public final Expression.Builder getCostSelector() {
            return costSelector != null ? costSelector.toBuilder() : null;
        }

        public final void setCostSelector(Expression.BuilderImpl costSelector) {
            this.costSelector = costSelector != null ? costSelector.build() : null;
        }

        @Override
        public final Builder costSelector(Expression costSelector) {
            this.costSelector = costSelector;
            return this;
        }

        public final Map<String, ComparisonMetricValue.Builder> getMetrics() {
            Map<String, ComparisonMetricValue.Builder> result = ComparisonMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Map<String, ComparisonMetricValue.BuilderImpl> metrics) {
            this.metrics = ComparisonMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Map<String, ComparisonMetricValue> metrics) {
            this.metrics = ComparisonMetricsCopier.copy(metrics);
            return this;
        }

        public final List<CostDriver.Builder> getCostDrivers() {
            List<CostDriver.Builder> result = CostDriversCopier.copyToBuilder(this.costDrivers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostDrivers(Collection<CostDriver.BuilderImpl> costDrivers) {
            this.costDrivers = CostDriversCopier.copyFromBuilder(costDrivers);
        }

        @Override
        public final Builder costDrivers(Collection<CostDriver> costDrivers) {
            this.costDrivers = CostDriversCopier.copy(costDrivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costDrivers(CostDriver... costDrivers) {
            costDrivers(Arrays.asList(costDrivers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costDrivers(Consumer<CostDriver.Builder>... costDrivers) {
            costDrivers(Stream.of(costDrivers).map(c -> CostDriver.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CostComparisonDriver build() {
            return new CostComparisonDriver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
