/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of processing statuses for Cost Management products for a specific cost category.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostCategoryProcessingStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<CostCategoryProcessingStatus.Builder, CostCategoryProcessingStatus> {
    private static final SdkField<String> COMPONENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Component").getter(getter(CostCategoryProcessingStatus::componentAsString))
            .setter(setter(Builder::component))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Component").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CostCategoryProcessingStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(COMPONENT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String component;

    private final String status;

    private CostCategoryProcessingStatus(BuilderImpl builder) {
        this.component = builder.component;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Cost Management product name of the applied status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #component} will
     * return {@link CostCategoryStatusComponent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #componentAsString}.
     * </p>
     * 
     * @return The Cost Management product name of the applied status.
     * @see CostCategoryStatusComponent
     */
    public final CostCategoryStatusComponent component() {
        return CostCategoryStatusComponent.fromValue(component);
    }

    /**
     * <p>
     * The Cost Management product name of the applied status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #component} will
     * return {@link CostCategoryStatusComponent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #componentAsString}.
     * </p>
     * 
     * @return The Cost Management product name of the applied status.
     * @see CostCategoryStatusComponent
     */
    public final String componentAsString() {
        return component;
    }

    /**
     * <p>
     * The process status for a specific cost category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CostCategoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The process status for a specific cost category.
     * @see CostCategoryStatus
     */
    public final CostCategoryStatus status() {
        return CostCategoryStatus.fromValue(status);
    }

    /**
     * <p>
     * The process status for a specific cost category.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CostCategoryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The process status for a specific cost category.
     * @see CostCategoryStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(componentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryProcessingStatus)) {
            return false;
        }
        CostCategoryProcessingStatus other = (CostCategoryProcessingStatus) obj;
        return Objects.equals(componentAsString(), other.componentAsString())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostCategoryProcessingStatus").add("Component", componentAsString())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Component":
            return Optional.ofNullable(clazz.cast(componentAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Component", COMPONENT_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryProcessingStatus, T> g) {
        return obj -> g.apply((CostCategoryProcessingStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostCategoryProcessingStatus> {
        /**
         * <p>
         * The Cost Management product name of the applied status.
         * </p>
         * 
         * @param component
         *        The Cost Management product name of the applied status.
         * @see CostCategoryStatusComponent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryStatusComponent
         */
        Builder component(String component);

        /**
         * <p>
         * The Cost Management product name of the applied status.
         * </p>
         * 
         * @param component
         *        The Cost Management product name of the applied status.
         * @see CostCategoryStatusComponent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryStatusComponent
         */
        Builder component(CostCategoryStatusComponent component);

        /**
         * <p>
         * The process status for a specific cost category.
         * </p>
         * 
         * @param status
         *        The process status for a specific cost category.
         * @see CostCategoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The process status for a specific cost category.
         * </p>
         * 
         * @param status
         *        The process status for a specific cost category.
         * @see CostCategoryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryStatus
         */
        Builder status(CostCategoryStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String component;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryProcessingStatus model) {
            component(model.component);
            status(model.status);
        }

        public final String getComponent() {
            return component;
        }

        public final void setComponent(String component) {
            this.component = component;
        }

        @Override
        public final Builder component(String component) {
            this.component = component;
            return this;
        }

        @Override
        public final Builder component(CostCategoryStatusComponent component) {
            this.component(component == null ? null : component.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CostCategoryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public CostCategoryProcessingStatus build() {
            return new CostCategoryProcessingStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
