/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the template attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<TemplateAttributes.Builder, TemplateAttributes> {
    private static final SdkField<Map<String, String>> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomAttributes")
            .getter(getter(TemplateAttributes::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_PROFILE_ATTRIBUTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomerProfileAttributes").getter(getter(TemplateAttributes::customerProfileAttributes))
            .setter(setter(Builder::customerProfileAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerProfileAttributes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ATTRIBUTES_FIELD,
            CUSTOMER_PROFILE_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> customAttributes;

    private final String customerProfileAttributes;

    private TemplateAttributes(BuilderImpl builder) {
        this.customAttributes = builder.customAttributes;
        this.customerProfileAttributes = builder.customerProfileAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAttributes() {
        return customAttributes != null && !(customAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that specifies the custom attributes values to use for variables in the message template. This object
     * contains different categories of key-value pairs. Each key defines a variable or placeholder in the message
     * template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAttributes} method.
     * </p>
     * 
     * @return An object that specifies the custom attributes values to use for variables in the message template. This
     *         object contains different categories of key-value pairs. Each key defines a variable or placeholder in
     *         the message template.
     */
    public final Map<String, String> customAttributes() {
        return customAttributes;
    }

    /**
     * <p>
     * An object that specifies the customer profile attributes values to use for variables in the message template.
     * This object contains different categories of key-value pairs. Each key defines a variable or placeholder in the
     * message template.
     * </p>
     * 
     * @return An object that specifies the customer profile attributes values to use for variables in the message
     *         template. This object contains different categories of key-value pairs. Each key defines a variable or
     *         placeholder in the message template.
     */
    public final String customerProfileAttributes() {
        return customerProfileAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAttributes() ? customAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(customerProfileAttributes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateAttributes)) {
            return false;
        }
        TemplateAttributes other = (TemplateAttributes) obj;
        return hasCustomAttributes() == other.hasCustomAttributes()
                && Objects.equals(customAttributes(), other.customAttributes())
                && Objects.equals(customerProfileAttributes(), other.customerProfileAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateAttributes").add("CustomAttributes", hasCustomAttributes() ? customAttributes() : null)
                .add("CustomerProfileAttributes", customerProfileAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CustomAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        case "CustomerProfileAttributes":
            return Optional.ofNullable(clazz.cast(customerProfileAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CustomAttributes", CUSTOM_ATTRIBUTES_FIELD);
        map.put("CustomerProfileAttributes", CUSTOMER_PROFILE_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemplateAttributes, T> g) {
        return obj -> g.apply((TemplateAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateAttributes> {
        /**
         * <p>
         * An object that specifies the custom attributes values to use for variables in the message template. This
         * object contains different categories of key-value pairs. Each key defines a variable or placeholder in the
         * message template.
         * </p>
         * 
         * @param customAttributes
         *        An object that specifies the custom attributes values to use for variables in the message template.
         *        This object contains different categories of key-value pairs. Each key defines a variable or
         *        placeholder in the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(Map<String, String> customAttributes);

        /**
         * <p>
         * An object that specifies the customer profile attributes values to use for variables in the message template.
         * This object contains different categories of key-value pairs. Each key defines a variable or placeholder in
         * the message template.
         * </p>
         * 
         * @param customerProfileAttributes
         *        An object that specifies the customer profile attributes values to use for variables in the message
         *        template. This object contains different categories of key-value pairs. Each key defines a variable or
         *        placeholder in the message template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerProfileAttributes(String customerProfileAttributes);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> customAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String customerProfileAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateAttributes model) {
            customAttributes(model.customAttributes);
            customerProfileAttributes(model.customerProfileAttributes);
        }

        public final Map<String, String> getCustomAttributes() {
            if (customAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return customAttributes;
        }

        public final void setCustomAttributes(Map<String, String> customAttributes) {
            this.customAttributes = AttributesCopier.copy(customAttributes);
        }

        @Override
        public final Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = AttributesCopier.copy(customAttributes);
            return this;
        }

        public final String getCustomerProfileAttributes() {
            return customerProfileAttributes;
        }

        public final void setCustomerProfileAttributes(String customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes;
        }

        @Override
        public final Builder customerProfileAttributes(String customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes;
            return this;
        }

        @Override
        public TemplateAttributes build() {
            return new TemplateAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
