/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the state transition of a supervisor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StateTransition implements SdkPojo, Serializable, ToCopyableBuilder<StateTransition.Builder, StateTransition> {
    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(StateTransition::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> STATE_START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StateStartTimestamp").getter(getter(StateTransition::stateStartTimestamp))
            .setter(setter(Builder::stateStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateStartTimestamp").build())
            .build();

    private static final SdkField<Instant> STATE_END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StateEndTimestamp").getter(getter(StateTransition::stateEndTimestamp))
            .setter(setter(Builder::stateEndTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateEndTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            STATE_START_TIMESTAMP_FIELD, STATE_END_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String state;

    private final Instant stateStartTimestamp;

    private final Instant stateEndTimestamp;

    private StateTransition(BuilderImpl builder) {
        this.state = builder.state;
        this.stateStartTimestamp = builder.stateStartTimestamp;
        this.stateEndTimestamp = builder.stateEndTimestamp;
    }

    /**
     * <p>
     * The state of the transition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transition.
     * @see ParticipantState
     */
    public final ParticipantState state() {
        return ParticipantState.fromValue(state);
    }

    /**
     * <p>
     * The state of the transition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ParticipantState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the transition.
     * @see ParticipantState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time when the state started in UTC time.
     * </p>
     * 
     * @return The date and time when the state started in UTC time.
     */
    public final Instant stateStartTimestamp() {
        return stateStartTimestamp;
    }

    /**
     * <p>
     * The date and time when the state ended in UTC time.
     * </p>
     * 
     * @return The date and time when the state ended in UTC time.
     */
    public final Instant stateEndTimestamp() {
        return stateEndTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(stateEndTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StateTransition)) {
            return false;
        }
        StateTransition other = (StateTransition) obj;
        return Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateStartTimestamp(), other.stateStartTimestamp())
                && Objects.equals(stateEndTimestamp(), other.stateEndTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StateTransition").add("State", stateAsString())
                .add("StateStartTimestamp", stateStartTimestamp()).add("StateEndTimestamp", stateEndTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateStartTimestamp":
            return Optional.ofNullable(clazz.cast(stateStartTimestamp()));
        case "StateEndTimestamp":
            return Optional.ofNullable(clazz.cast(stateEndTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("StateStartTimestamp", STATE_START_TIMESTAMP_FIELD);
        map.put("StateEndTimestamp", STATE_END_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StateTransition, T> g) {
        return obj -> g.apply((StateTransition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StateTransition> {
        /**
         * <p>
         * The state of the transition.
         * </p>
         * 
         * @param state
         *        The state of the transition.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the transition.
         * </p>
         * 
         * @param state
         *        The state of the transition.
         * @see ParticipantState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantState
         */
        Builder state(ParticipantState state);

        /**
         * <p>
         * The date and time when the state started in UTC time.
         * </p>
         * 
         * @param stateStartTimestamp
         *        The date and time when the state started in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateStartTimestamp(Instant stateStartTimestamp);

        /**
         * <p>
         * The date and time when the state ended in UTC time.
         * </p>
         * 
         * @param stateEndTimestamp
         *        The date and time when the state ended in UTC time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateEndTimestamp(Instant stateEndTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String state;

        private Instant stateStartTimestamp;

        private Instant stateEndTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StateTransition model) {
            state(model.state);
            stateStartTimestamp(model.stateStartTimestamp);
            stateEndTimestamp(model.stateEndTimestamp);
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ParticipantState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStateStartTimestamp() {
            return stateStartTimestamp;
        }

        public final void setStateStartTimestamp(Instant stateStartTimestamp) {
            this.stateStartTimestamp = stateStartTimestamp;
        }

        @Override
        public final Builder stateStartTimestamp(Instant stateStartTimestamp) {
            this.stateStartTimestamp = stateStartTimestamp;
            return this;
        }

        public final Instant getStateEndTimestamp() {
            return stateEndTimestamp;
        }

        public final void setStateEndTimestamp(Instant stateEndTimestamp) {
            this.stateEndTimestamp = stateEndTimestamp;
        }

        @Override
        public final Builder stateEndTimestamp(Instant stateEndTimestamp) {
            this.stateEndTimestamp = stateEndTimestamp;
            return this;
        }

        @Override
        public StateTransition build() {
            return new StateTransition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
