/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartEmailContactRequest extends ConnectRequest implements
        ToCopyableBuilder<StartEmailContactRequest.Builder, StartEmailContactRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(StartEmailContactRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<EmailAddressInfo> FROM_EMAIL_ADDRESS_FIELD = SdkField
            .<EmailAddressInfo> builder(MarshallingType.SDK_POJO).memberName("FromEmailAddress")
            .getter(getter(StartEmailContactRequest::fromEmailAddress)).setter(setter(Builder::fromEmailAddress))
            .constructor(EmailAddressInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromEmailAddress").build()).build();

    private static final SdkField<String> DESTINATION_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationEmailAddress").getter(getter(StartEmailContactRequest::destinationEmailAddress))
            .setter(setter(Builder::destinationEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationEmailAddress").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(StartEmailContactRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Map<String, Reference>> REFERENCES_FIELD = SdkField
            .<Map<String, Reference>> builder(MarshallingType.MAP)
            .memberName("References")
            .getter(getter(StartEmailContactRequest::references))
            .setter(setter(Builder::references))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Reference> builder(MarshallingType.SDK_POJO)
                                            .constructor(Reference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StartEmailContactRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<InboundEmailContent> EMAIL_MESSAGE_FIELD = SdkField
            .<InboundEmailContent> builder(MarshallingType.SDK_POJO).memberName("EmailMessage")
            .getter(getter(StartEmailContactRequest::emailMessage)).setter(setter(Builder::emailMessage))
            .constructor(InboundEmailContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailMessage").build()).build();

    private static final SdkField<InboundAdditionalRecipients> ADDITIONAL_RECIPIENTS_FIELD = SdkField
            .<InboundAdditionalRecipients> builder(MarshallingType.SDK_POJO).memberName("AdditionalRecipients")
            .getter(getter(StartEmailContactRequest::additionalRecipients)).setter(setter(Builder::additionalRecipients))
            .constructor(InboundAdditionalRecipients::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRecipients").build())
            .build();

    private static final SdkField<List<EmailAttachment>> ATTACHMENTS_FIELD = SdkField
            .<List<EmailAttachment>> builder(MarshallingType.LIST)
            .memberName("Attachments")
            .getter(getter(StartEmailContactRequest::attachments))
            .setter(setter(Builder::attachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailAttachment> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailAttachment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTACT_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowId").getter(getter(StartEmailContactRequest::contactFlowId))
            .setter(setter(Builder::contactFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactFlowId").build()).build();

    private static final SdkField<String> RELATED_CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelatedContactId").getter(getter(StartEmailContactRequest::relatedContactId))
            .setter(setter(Builder::relatedContactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedContactId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(StartEmailContactRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, SegmentAttributeValue>> SEGMENT_ATTRIBUTES_FIELD = SdkField
            .<Map<String, SegmentAttributeValue>> builder(MarshallingType.MAP)
            .memberName("SegmentAttributes")
            .getter(getter(StartEmailContactRequest::segmentAttributes))
            .setter(setter(Builder::segmentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SegmentAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartEmailContactRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            FROM_EMAIL_ADDRESS_FIELD, DESTINATION_EMAIL_ADDRESS_FIELD, DESCRIPTION_FIELD, REFERENCES_FIELD, NAME_FIELD,
            EMAIL_MESSAGE_FIELD, ADDITIONAL_RECIPIENTS_FIELD, ATTACHMENTS_FIELD, CONTACT_FLOW_ID_FIELD, RELATED_CONTACT_ID_FIELD,
            ATTRIBUTES_FIELD, SEGMENT_ATTRIBUTES_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceId;

    private final EmailAddressInfo fromEmailAddress;

    private final String destinationEmailAddress;

    private final String description;

    private final Map<String, Reference> references;

    private final String name;

    private final InboundEmailContent emailMessage;

    private final InboundAdditionalRecipients additionalRecipients;

    private final List<EmailAttachment> attachments;

    private final String contactFlowId;

    private final String relatedContactId;

    private final Map<String, String> attributes;

    private final Map<String, SegmentAttributeValue> segmentAttributes;

    private final String clientToken;

    private StartEmailContactRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.fromEmailAddress = builder.fromEmailAddress;
        this.destinationEmailAddress = builder.destinationEmailAddress;
        this.description = builder.description;
        this.references = builder.references;
        this.name = builder.name;
        this.emailMessage = builder.emailMessage;
        this.additionalRecipients = builder.additionalRecipients;
        this.attachments = builder.attachments;
        this.contactFlowId = builder.contactFlowId;
        this.relatedContactId = builder.relatedContactId;
        this.attributes = builder.attributes;
        this.segmentAttributes = builder.segmentAttributes;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The email address of the customer.
     * </p>
     * 
     * @return The email address of the customer.
     */
    public final EmailAddressInfo fromEmailAddress() {
        return fromEmailAddress;
    }

    /**
     * <p>
     * The email address associated with the Amazon Connect instance.
     * </p>
     * 
     * @return The email address associated with the Amazon Connect instance.
     */
    public final String destinationEmailAddress() {
        return destinationEmailAddress;
    }

    /**
     * <p>
     * A description of the email contact.
     * </p>
     * 
     * @return A description of the email contact.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the References property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReferences() {
        return references != null && !(references instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Emails can have the following
     * reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> |
     * <code>DATE</code>. <code>EMAIL</code> | <code>EMAIL_MESSAGE</code> |<code>ATTACHMENT</code> are not a supported
     * reference type during email creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferences} method.
     * </p>
     * 
     * @return A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Emails can have the
     *         following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> |
     *         <code>STRING</code> | <code>DATE</code>. <code>EMAIL</code> | <code>EMAIL_MESSAGE</code> |
     *         <code>ATTACHMENT</code> are not a supported reference type during email creation.
     */
    public final Map<String, Reference> references() {
        return references;
    }

    /**
     * <p>
     * The name of a email that is shown to an agent in the Contact Control Panel (CCP).
     * </p>
     * 
     * @return The name of a email that is shown to an agent in the Contact Control Panel (CCP).
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The email message body to be sent to the newly created email.
     * </p>
     * 
     * @return The email message body to be sent to the newly created email.
     */
    public final InboundEmailContent emailMessage() {
        return emailMessage;
    }

    /**
     * <p>
     * The additional recipients address of the email.
     * </p>
     * 
     * @return The additional recipients address of the email.
     */
    public final InboundAdditionalRecipients additionalRecipients() {
        return additionalRecipients;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttachments() {
        return attachments != null && !(attachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of S3 presigned URLs of email attachments and their file name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttachments} method.
     * </p>
     * 
     * @return List of S3 presigned URLs of email attachments and their file name.
     */
    public final List<EmailAttachment> attachments() {
        return attachments;
    }

    /**
     * <p>
     * The identifier of the flow for initiating the emails. To see the ContactFlowId in the Amazon Connect admin
     * website, on the navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow page, under the
     * name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN,
     * shown here in bold:
     * </p>
     * <p>
     * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     * </p>
     * 
     * @return The identifier of the flow for initiating the emails. To see the ContactFlowId in the Amazon Connect
     *         admin website, on the navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow
     *         page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is
     *         the last part of the ARN, shown here in bold: </p>
     *         <p>
     *         arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
     *         846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
     */
    public final String contactFlowId() {
        return contactFlowId;
    }

    /**
     * <p>
     * The contactId that is related to this contact. Linking emails together by using <code>RelatedContactID</code>
     * copies over contact attributes from the related email contact to the new email contact. All updates to
     * user-defined attributes in the new email contact are limited to the individual contact ID. There are no limits to
     * the number of contacts that can be linked by using <code>RelatedContactId</code>.
     * </p>
     * 
     * @return The contactId that is related to this contact. Linking emails together by using
     *         <code>RelatedContactID</code> copies over contact attributes from the related email contact to the new
     *         email contact. All updates to user-defined attributes in the new email contact are limited to the
     *         individual contact ID. There are no limits to the number of contacts that can be linked by using
     *         <code>RelatedContactId</code>.
     */
    public final String relatedContactId() {
        return relatedContactId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be
     * accessed in flows just like any other contact attributes.
     * </p>
     * <p>
     * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
     * alphanumeric, dash, and underscore characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
     *         and can be accessed in flows just like any other contact attributes.</p>
     *         <p>
     *         There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include
     *         only alphanumeric, dash, and underscore characters.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSegmentAttributes() {
        return segmentAttributes != null && !(segmentAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of system defined key-value pairs stored on individual contact segments using an attribute map. The
     * attributes are standard Amazon Connect attributes. They can be accessed in flows.
     * </p>
     * <p>
     * Attribute keys can include only alphanumeric, -, and _.
     * </p>
     * <p>
     * This field can be used to show channel subtype, such as <code>connect:Guide</code>.
     * </p>
     * <note>
     * <p>
     * To set contact expiry, a <code>ValueMap</code> must be specified containing the integer number of minutes the
     * contact will be active for before expiring, with <code>SegmentAttributes</code> like {
     * <code> "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger":135}}}}</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentAttributes} method.
     * </p>
     * 
     * @return A set of system defined key-value pairs stored on individual contact segments using an attribute map. The
     *         attributes are standard Amazon Connect attributes. They can be accessed in flows.</p>
     *         <p>
     *         Attribute keys can include only alphanumeric, -, and _.
     *         </p>
     *         <p>
     *         This field can be used to show channel subtype, such as <code>connect:Guide</code>.
     *         </p>
     *         <note>
     *         <p>
     *         To set contact expiry, a <code>ValueMap</code> must be specified containing the integer number of minutes
     *         the contact will be active for before expiring, with <code>SegmentAttributes</code> like {
     *         <code> "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger":135}}}}</code>.
     *         </p>
     */
    public final Map<String, SegmentAttributeValue> segmentAttributes() {
        return segmentAttributes;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(fromEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(destinationEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferences() ? references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(emailMessage());
        hashCode = 31 * hashCode + Objects.hashCode(additionalRecipients());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachments() ? attachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(relatedContactId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentAttributes() ? segmentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEmailContactRequest)) {
            return false;
        }
        StartEmailContactRequest other = (StartEmailContactRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(fromEmailAddress(), other.fromEmailAddress())
                && Objects.equals(destinationEmailAddress(), other.destinationEmailAddress())
                && Objects.equals(description(), other.description()) && hasReferences() == other.hasReferences()
                && Objects.equals(references(), other.references()) && Objects.equals(name(), other.name())
                && Objects.equals(emailMessage(), other.emailMessage())
                && Objects.equals(additionalRecipients(), other.additionalRecipients())
                && hasAttachments() == other.hasAttachments() && Objects.equals(attachments(), other.attachments())
                && Objects.equals(contactFlowId(), other.contactFlowId())
                && Objects.equals(relatedContactId(), other.relatedContactId()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && hasSegmentAttributes() == other.hasSegmentAttributes()
                && Objects.equals(segmentAttributes(), other.segmentAttributes())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartEmailContactRequest").add("InstanceId", instanceId())
                .add("FromEmailAddress", fromEmailAddress())
                .add("DestinationEmailAddress", destinationEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("References", hasReferences() ? references() : null)
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("EmailMessage", emailMessage())
                .add("AdditionalRecipients", additionalRecipients())
                .add("Attachments", attachments() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContactFlowId", contactFlowId()).add("RelatedContactId", relatedContactId())
                .add("Attributes", hasAttributes() ? attributes() : null)
                .add("SegmentAttributes", hasSegmentAttributes() ? segmentAttributes() : null).add("ClientToken", clientToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "FromEmailAddress":
            return Optional.ofNullable(clazz.cast(fromEmailAddress()));
        case "DestinationEmailAddress":
            return Optional.ofNullable(clazz.cast(destinationEmailAddress()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "References":
            return Optional.ofNullable(clazz.cast(references()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EmailMessage":
            return Optional.ofNullable(clazz.cast(emailMessage()));
        case "AdditionalRecipients":
            return Optional.ofNullable(clazz.cast(additionalRecipients()));
        case "Attachments":
            return Optional.ofNullable(clazz.cast(attachments()));
        case "ContactFlowId":
            return Optional.ofNullable(clazz.cast(contactFlowId()));
        case "RelatedContactId":
            return Optional.ofNullable(clazz.cast(relatedContactId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "SegmentAttributes":
            return Optional.ofNullable(clazz.cast(segmentAttributes()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("FromEmailAddress", FROM_EMAIL_ADDRESS_FIELD);
        map.put("DestinationEmailAddress", DESTINATION_EMAIL_ADDRESS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("References", REFERENCES_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EmailMessage", EMAIL_MESSAGE_FIELD);
        map.put("AdditionalRecipients", ADDITIONAL_RECIPIENTS_FIELD);
        map.put("Attachments", ATTACHMENTS_FIELD);
        map.put("ContactFlowId", CONTACT_FLOW_ID_FIELD);
        map.put("RelatedContactId", RELATED_CONTACT_ID_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("SegmentAttributes", SEGMENT_ATTRIBUTES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartEmailContactRequest, T> g) {
        return obj -> g.apply((StartEmailContactRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartEmailContactRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The email address of the customer.
         * </p>
         * 
         * @param fromEmailAddress
         *        The email address of the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromEmailAddress(EmailAddressInfo fromEmailAddress);

        /**
         * <p>
         * The email address of the customer.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmailAddressInfo.Builder} avoiding the
         * need to create one manually via {@link EmailAddressInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmailAddressInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #fromEmailAddress(EmailAddressInfo)}.
         * 
         * @param fromEmailAddress
         *        a consumer that will call methods on {@link EmailAddressInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fromEmailAddress(EmailAddressInfo)
         */
        default Builder fromEmailAddress(Consumer<EmailAddressInfo.Builder> fromEmailAddress) {
            return fromEmailAddress(EmailAddressInfo.builder().applyMutation(fromEmailAddress).build());
        }

        /**
         * <p>
         * The email address associated with the Amazon Connect instance.
         * </p>
         * 
         * @param destinationEmailAddress
         *        The email address associated with the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationEmailAddress(String destinationEmailAddress);

        /**
         * <p>
         * A description of the email contact.
         * </p>
         * 
         * @param description
         *        A description of the email contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Emails can have the following
         * reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> |
         * <code>DATE</code>. <code>EMAIL</code> | <code>EMAIL_MESSAGE</code> |<code>ATTACHMENT</code> are not a
         * supported reference type during email creation.
         * </p>
         * 
         * @param references
         *        A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Emails can have the
         *        following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> |
         *        <code>STRING</code> | <code>DATE</code>. <code>EMAIL</code> | <code>EMAIL_MESSAGE</code> |
         *        <code>ATTACHMENT</code> are not a supported reference type during email creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(Map<String, Reference> references);

        /**
         * <p>
         * The name of a email that is shown to an agent in the Contact Control Panel (CCP).
         * </p>
         * 
         * @param name
         *        The name of a email that is shown to an agent in the Contact Control Panel (CCP).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The email message body to be sent to the newly created email.
         * </p>
         * 
         * @param emailMessage
         *        The email message body to be sent to the newly created email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailMessage(InboundEmailContent emailMessage);

        /**
         * <p>
         * The email message body to be sent to the newly created email.
         * </p>
         * This is a convenience method that creates an instance of the {@link InboundEmailContent.Builder} avoiding the
         * need to create one manually via {@link InboundEmailContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InboundEmailContent.Builder#build()} is called immediately and
         * its result is passed to {@link #emailMessage(InboundEmailContent)}.
         * 
         * @param emailMessage
         *        a consumer that will call methods on {@link InboundEmailContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emailMessage(InboundEmailContent)
         */
        default Builder emailMessage(Consumer<InboundEmailContent.Builder> emailMessage) {
            return emailMessage(InboundEmailContent.builder().applyMutation(emailMessage).build());
        }

        /**
         * <p>
         * The additional recipients address of the email.
         * </p>
         * 
         * @param additionalRecipients
         *        The additional recipients address of the email.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalRecipients(InboundAdditionalRecipients additionalRecipients);

        /**
         * <p>
         * The additional recipients address of the email.
         * </p>
         * This is a convenience method that creates an instance of the {@link InboundAdditionalRecipients.Builder}
         * avoiding the need to create one manually via {@link InboundAdditionalRecipients#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InboundAdditionalRecipients.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalRecipients(InboundAdditionalRecipients)}.
         * 
         * @param additionalRecipients
         *        a consumer that will call methods on {@link InboundAdditionalRecipients.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalRecipients(InboundAdditionalRecipients)
         */
        default Builder additionalRecipients(Consumer<InboundAdditionalRecipients.Builder> additionalRecipients) {
            return additionalRecipients(InboundAdditionalRecipients.builder().applyMutation(additionalRecipients).build());
        }

        /**
         * <p>
         * List of S3 presigned URLs of email attachments and their file name.
         * </p>
         * 
         * @param attachments
         *        List of S3 presigned URLs of email attachments and their file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(Collection<EmailAttachment> attachments);

        /**
         * <p>
         * List of S3 presigned URLs of email attachments and their file name.
         * </p>
         * 
         * @param attachments
         *        List of S3 presigned URLs of email attachments and their file name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachments(EmailAttachment... attachments);

        /**
         * <p>
         * List of S3 presigned URLs of email attachments and their file name.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EmailAttachment.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.EmailAttachment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EmailAttachment.Builder#build()} is called immediately
         * and its result is passed to {@link #attachments(List<EmailAttachment>)}.
         * 
         * @param attachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EmailAttachment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachments(java.util.Collection<EmailAttachment>)
         */
        Builder attachments(Consumer<EmailAttachment.Builder>... attachments);

        /**
         * <p>
         * The identifier of the flow for initiating the emails. To see the ContactFlowId in the Amazon Connect admin
         * website, on the navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow page, under
         * the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of
         * the ARN, shown here in bold:
         * </p>
         * <p>
         * arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         * 846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * </p>
         * 
         * @param contactFlowId
         *        The identifier of the flow for initiating the emails. To see the ContactFlowId in the Amazon Connect
         *        admin website, on the navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow
         *        page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is
         *        the last part of the ARN, shown here in bold: </p>
         *        <p>
         *        arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>
         *        846ec553-a005-41c0-8341-xxxxxxxxxxxx</b>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowId(String contactFlowId);

        /**
         * <p>
         * The contactId that is related to this contact. Linking emails together by using <code>RelatedContactID</code>
         * copies over contact attributes from the related email contact to the new email contact. All updates to
         * user-defined attributes in the new email contact are limited to the individual contact ID. There are no
         * limits to the number of contacts that can be linked by using <code>RelatedContactId</code>.
         * </p>
         * 
         * @param relatedContactId
         *        The contactId that is related to this contact. Linking emails together by using
         *        <code>RelatedContactID</code> copies over contact attributes from the related email contact to the new
         *        email contact. All updates to user-defined attributes in the new email contact are limited to the
         *        individual contact ID. There are no limits to the number of contacts that can be linked by using
         *        <code>RelatedContactId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedContactId(String relatedContactId);

        /**
         * <p>
         * A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and
         * can be accessed in flows just like any other contact attributes.
         * </p>
         * <p>
         * There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only
         * alphanumeric, dash, and underscore characters.
         * </p>
         * 
         * @param attributes
         *        A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes,
         *        and can be accessed in flows just like any other contact attributes.</p>
         *        <p>
         *        There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can
         *        include only alphanumeric, dash, and underscore characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * A set of system defined key-value pairs stored on individual contact segments using an attribute map. The
         * attributes are standard Amazon Connect attributes. They can be accessed in flows.
         * </p>
         * <p>
         * Attribute keys can include only alphanumeric, -, and _.
         * </p>
         * <p>
         * This field can be used to show channel subtype, such as <code>connect:Guide</code>.
         * </p>
         * <note>
         * <p>
         * To set contact expiry, a <code>ValueMap</code> must be specified containing the integer number of minutes the
         * contact will be active for before expiring, with <code>SegmentAttributes</code> like {
         * <code> "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger":135}}}}</code>.
         * </p>
         * </note>
         * 
         * @param segmentAttributes
         *        A set of system defined key-value pairs stored on individual contact segments using an attribute map.
         *        The attributes are standard Amazon Connect attributes. They can be accessed in flows.</p>
         *        <p>
         *        Attribute keys can include only alphanumeric, -, and _.
         *        </p>
         *        <p>
         *        This field can be used to show channel subtype, such as <code>connect:Guide</code>.
         *        </p>
         *        <note>
         *        <p>
         *        To set contact expiry, a <code>ValueMap</code> must be specified containing the integer number of
         *        minutes the contact will be active for before expiring, with <code>SegmentAttributes</code> like {
         *        <code> "connect:ContactExpiry": {"ValueMap" : { "ExpiryDuration": { "ValueInteger":135}}}}</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private EmailAddressInfo fromEmailAddress;

        private String destinationEmailAddress;

        private String description;

        private Map<String, Reference> references = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private InboundEmailContent emailMessage;

        private InboundAdditionalRecipients additionalRecipients;

        private List<EmailAttachment> attachments = DefaultSdkAutoConstructList.getInstance();

        private String contactFlowId;

        private String relatedContactId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, SegmentAttributeValue> segmentAttributes = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEmailContactRequest model) {
            super(model);
            instanceId(model.instanceId);
            fromEmailAddress(model.fromEmailAddress);
            destinationEmailAddress(model.destinationEmailAddress);
            description(model.description);
            references(model.references);
            name(model.name);
            emailMessage(model.emailMessage);
            additionalRecipients(model.additionalRecipients);
            attachments(model.attachments);
            contactFlowId(model.contactFlowId);
            relatedContactId(model.relatedContactId);
            attributes(model.attributes);
            segmentAttributes(model.segmentAttributes);
            clientToken(model.clientToken);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final EmailAddressInfo.Builder getFromEmailAddress() {
            return fromEmailAddress != null ? fromEmailAddress.toBuilder() : null;
        }

        public final void setFromEmailAddress(EmailAddressInfo.BuilderImpl fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress != null ? fromEmailAddress.build() : null;
        }

        @Override
        public final Builder fromEmailAddress(EmailAddressInfo fromEmailAddress) {
            this.fromEmailAddress = fromEmailAddress;
            return this;
        }

        public final String getDestinationEmailAddress() {
            return destinationEmailAddress;
        }

        public final void setDestinationEmailAddress(String destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
        }

        @Override
        public final Builder destinationEmailAddress(String destinationEmailAddress) {
            this.destinationEmailAddress = destinationEmailAddress;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, Reference.Builder> getReferences() {
            Map<String, Reference.Builder> result = ContactReferencesCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setReferences(Map<String, Reference.BuilderImpl> references) {
            this.references = ContactReferencesCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Map<String, Reference> references) {
            this.references = ContactReferencesCopier.copy(references);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InboundEmailContent.Builder getEmailMessage() {
            return emailMessage != null ? emailMessage.toBuilder() : null;
        }

        public final void setEmailMessage(InboundEmailContent.BuilderImpl emailMessage) {
            this.emailMessage = emailMessage != null ? emailMessage.build() : null;
        }

        @Override
        public final Builder emailMessage(InboundEmailContent emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final InboundAdditionalRecipients.Builder getAdditionalRecipients() {
            return additionalRecipients != null ? additionalRecipients.toBuilder() : null;
        }

        public final void setAdditionalRecipients(InboundAdditionalRecipients.BuilderImpl additionalRecipients) {
            this.additionalRecipients = additionalRecipients != null ? additionalRecipients.build() : null;
        }

        @Override
        public final Builder additionalRecipients(InboundAdditionalRecipients additionalRecipients) {
            this.additionalRecipients = additionalRecipients;
            return this;
        }

        public final List<EmailAttachment.Builder> getAttachments() {
            List<EmailAttachment.Builder> result = EmailAttachmentsCopier.copyToBuilder(this.attachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachments(Collection<EmailAttachment.BuilderImpl> attachments) {
            this.attachments = EmailAttachmentsCopier.copyFromBuilder(attachments);
        }

        @Override
        public final Builder attachments(Collection<EmailAttachment> attachments) {
            this.attachments = EmailAttachmentsCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(EmailAttachment... attachments) {
            attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<EmailAttachment.Builder>... attachments) {
            attachments(Stream.of(attachments).map(c -> EmailAttachment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getContactFlowId() {
            return contactFlowId;
        }

        public final void setContactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
        }

        @Override
        public final Builder contactFlowId(String contactFlowId) {
            this.contactFlowId = contactFlowId;
            return this;
        }

        public final String getRelatedContactId() {
            return relatedContactId;
        }

        public final void setRelatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
        }

        @Override
        public final Builder relatedContactId(String relatedContactId) {
            this.relatedContactId = relatedContactId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getSegmentAttributes() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributesCopier.copyToBuilder(this.segmentAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSegmentAttributes(Map<String, SegmentAttributeValue.BuilderImpl> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copyFromBuilder(segmentAttributes);
        }

        @Override
        public final Builder segmentAttributes(Map<String, SegmentAttributeValue> segmentAttributes) {
            this.segmentAttributes = SegmentAttributesCopier.copy(segmentAttributes);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartEmailContactRequest build() {
            return new StartEmailContactRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
