/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service quota has been exceeded.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceQuotaExceededException extends ConnectException implements
        ToCopyableBuilder<ServiceQuotaExceededException.Builder, ServiceQuotaExceededException> {
    private static final SdkField<ServiceQuotaExceededExceptionReason> REASON_FIELD = SdkField
            .<ServiceQuotaExceededExceptionReason> builder(MarshallingType.SDK_POJO).memberName("Reason")
            .getter(getter(ServiceQuotaExceededException::reason)).setter(setter(Builder::reason))
            .constructor(ServiceQuotaExceededExceptionReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceQuotaExceededExceptionReason reason;

    private ServiceQuotaExceededException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Reason property for this object.
     * 
     * @return The value of the Reason property for this object.
     */
    public ServiceQuotaExceededExceptionReason reason() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceQuotaExceededException, T> g) {
        return obj -> g.apply((ServiceQuotaExceededException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceQuotaExceededException>, ConnectException.Builder {
        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(ServiceQuotaExceededExceptionReason reason);

        /**
         * Sets the value of the Reason property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ServiceQuotaExceededExceptionReason.Builder} avoiding the need to create one manually via
         * {@link ServiceQuotaExceededExceptionReason#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceQuotaExceededExceptionReason.Builder#build()} is called
         * immediately and its result is passed to {@link #reason(ServiceQuotaExceededExceptionReason)}.
         * 
         * @param reason
         *        a consumer that will call methods on {@link ServiceQuotaExceededExceptionReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reason(ServiceQuotaExceededExceptionReason)
         */
        default Builder reason(Consumer<ServiceQuotaExceededExceptionReason.Builder> reason) {
            return reason(ServiceQuotaExceededExceptionReason.builder().applyMutation(reason).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends ConnectException.BuilderImpl implements Builder {
        private ServiceQuotaExceededExceptionReason reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceQuotaExceededException model) {
            super(model);
            reason(model.reason);
        }

        public final ServiceQuotaExceededExceptionReason.Builder getReason() {
            return reason != null ? reason.toBuilder() : null;
        }

        public final void setReason(ServiceQuotaExceededExceptionReason.BuilderImpl reason) {
            this.reason = reason != null ? reason.build() : null;
        }

        @Override
        public final Builder reason(ServiceQuotaExceededExceptionReason reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ServiceQuotaExceededException build() {
            return new ServiceQuotaExceededException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
