/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The timestamp condition indicating which timestamp should be used and how it should be filtered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchContactsTimestampCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchContactsTimestampCondition.Builder, SearchContactsTimestampCondition> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(SearchContactsTimestampCondition::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CONDITION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConditionType").getter(getter(SearchContactsTimestampCondition::conditionTypeAsString))
            .setter(setter(Builder::conditionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            CONDITION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String conditionType;

    private SearchContactsTimestampCondition(BuilderImpl builder) {
        this.type = builder.type;
        this.conditionType = builder.conditionType;
    }

    /**
     * <p>
     * Type of the timestamps to use for the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SearchContactsTimeRangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the timestamps to use for the filter.
     * @see SearchContactsTimeRangeType
     */
    public final SearchContactsTimeRangeType type() {
        return SearchContactsTimeRangeType.fromValue(type);
    }

    /**
     * <p>
     * Type of the timestamps to use for the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SearchContactsTimeRangeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Type of the timestamps to use for the filter.
     * @see SearchContactsTimeRangeType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Condition of the timestamp on the contact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conditionType}
     * will return {@link SearchContactsTimeRangeConditionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #conditionTypeAsString}.
     * </p>
     * 
     * @return Condition of the timestamp on the contact.
     * @see SearchContactsTimeRangeConditionType
     */
    public final SearchContactsTimeRangeConditionType conditionType() {
        return SearchContactsTimeRangeConditionType.fromValue(conditionType);
    }

    /**
     * <p>
     * Condition of the timestamp on the contact.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #conditionType}
     * will return {@link SearchContactsTimeRangeConditionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #conditionTypeAsString}.
     * </p>
     * 
     * @return Condition of the timestamp on the contact.
     * @see SearchContactsTimeRangeConditionType
     */
    public final String conditionTypeAsString() {
        return conditionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(conditionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsTimestampCondition)) {
            return false;
        }
        SearchContactsTimestampCondition other = (SearchContactsTimestampCondition) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(conditionTypeAsString(), other.conditionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchContactsTimestampCondition").add("Type", typeAsString())
                .add("ConditionType", conditionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ConditionType":
            return Optional.ofNullable(clazz.cast(conditionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ConditionType", CONDITION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsTimestampCondition, T> g) {
        return obj -> g.apply((SearchContactsTimestampCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchContactsTimestampCondition> {
        /**
         * <p>
         * Type of the timestamps to use for the filter.
         * </p>
         * 
         * @param type
         *        Type of the timestamps to use for the filter.
         * @see SearchContactsTimeRangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchContactsTimeRangeType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the timestamps to use for the filter.
         * </p>
         * 
         * @param type
         *        Type of the timestamps to use for the filter.
         * @see SearchContactsTimeRangeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchContactsTimeRangeType
         */
        Builder type(SearchContactsTimeRangeType type);

        /**
         * <p>
         * Condition of the timestamp on the contact.
         * </p>
         * 
         * @param conditionType
         *        Condition of the timestamp on the contact.
         * @see SearchContactsTimeRangeConditionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchContactsTimeRangeConditionType
         */
        Builder conditionType(String conditionType);

        /**
         * <p>
         * Condition of the timestamp on the contact.
         * </p>
         * 
         * @param conditionType
         *        Condition of the timestamp on the contact.
         * @see SearchContactsTimeRangeConditionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SearchContactsTimeRangeConditionType
         */
        Builder conditionType(SearchContactsTimeRangeConditionType conditionType);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String conditionType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsTimestampCondition model) {
            type(model.type);
            conditionType(model.conditionType);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SearchContactsTimeRangeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getConditionType() {
            return conditionType;
        }

        public final void setConditionType(String conditionType) {
            this.conditionType = conditionType;
        }

        @Override
        public final Builder conditionType(String conditionType) {
            this.conditionType = conditionType;
            return this;
        }

        @Override
        public final Builder conditionType(SearchContactsTimeRangeConditionType conditionType) {
            this.conditionType(conditionType == null ? null : conditionType.toString());
            return this;
        }

        @Override
        public SearchContactsTimestampCondition build() {
            return new SearchContactsTimestampCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
