/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The criteria of the time range to additionally filter on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchContactsAdditionalTimeRangeCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchContactsAdditionalTimeRangeCriteria.Builder, SearchContactsAdditionalTimeRangeCriteria> {
    private static final SdkField<SearchContactsTimeRange> TIME_RANGE_FIELD = SdkField
            .<SearchContactsTimeRange> builder(MarshallingType.SDK_POJO).memberName("TimeRange")
            .getter(getter(SearchContactsAdditionalTimeRangeCriteria::timeRange)).setter(setter(Builder::timeRange))
            .constructor(SearchContactsTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRange").build()).build();

    private static final SdkField<SearchContactsTimestampCondition> TIMESTAMP_CONDITION_FIELD = SdkField
            .<SearchContactsTimestampCondition> builder(MarshallingType.SDK_POJO).memberName("TimestampCondition")
            .getter(getter(SearchContactsAdditionalTimeRangeCriteria::timestampCondition))
            .setter(setter(Builder::timestampCondition)).constructor(SearchContactsTimestampCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampCondition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_RANGE_FIELD,
            TIMESTAMP_CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SearchContactsTimeRange timeRange;

    private final SearchContactsTimestampCondition timestampCondition;

    private SearchContactsAdditionalTimeRangeCriteria(BuilderImpl builder) {
        this.timeRange = builder.timeRange;
        this.timestampCondition = builder.timestampCondition;
    }

    /**
     * Returns the value of the TimeRange property for this object.
     * 
     * @return The value of the TimeRange property for this object.
     */
    public final SearchContactsTimeRange timeRange() {
        return timeRange;
    }

    /**
     * <p>
     * List of the timestamp conditions.
     * </p>
     * 
     * @return List of the timestamp conditions.
     */
    public final SearchContactsTimestampCondition timestampCondition() {
        return timestampCondition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeRange());
        hashCode = 31 * hashCode + Objects.hashCode(timestampCondition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchContactsAdditionalTimeRangeCriteria)) {
            return false;
        }
        SearchContactsAdditionalTimeRangeCriteria other = (SearchContactsAdditionalTimeRangeCriteria) obj;
        return Objects.equals(timeRange(), other.timeRange()) && Objects.equals(timestampCondition(), other.timestampCondition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchContactsAdditionalTimeRangeCriteria").add("TimeRange", timeRange())
                .add("TimestampCondition", timestampCondition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeRange":
            return Optional.ofNullable(clazz.cast(timeRange()));
        case "TimestampCondition":
            return Optional.ofNullable(clazz.cast(timestampCondition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimeRange", TIME_RANGE_FIELD);
        map.put("TimestampCondition", TIMESTAMP_CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchContactsAdditionalTimeRangeCriteria, T> g) {
        return obj -> g.apply((SearchContactsAdditionalTimeRangeCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchContactsAdditionalTimeRangeCriteria> {
        /**
         * Sets the value of the TimeRange property for this object.
         *
         * @param timeRange
         *        The new value for the TimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeRange(SearchContactsTimeRange timeRange);

        /**
         * Sets the value of the TimeRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SearchContactsTimeRange.Builder} avoiding
         * the need to create one manually via {@link SearchContactsTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchContactsTimeRange.Builder#build()} is called immediately
         * and its result is passed to {@link #timeRange(SearchContactsTimeRange)}.
         * 
         * @param timeRange
         *        a consumer that will call methods on {@link SearchContactsTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeRange(SearchContactsTimeRange)
         */
        default Builder timeRange(Consumer<SearchContactsTimeRange.Builder> timeRange) {
            return timeRange(SearchContactsTimeRange.builder().applyMutation(timeRange).build());
        }

        /**
         * <p>
         * List of the timestamp conditions.
         * </p>
         * 
         * @param timestampCondition
         *        List of the timestamp conditions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampCondition(SearchContactsTimestampCondition timestampCondition);

        /**
         * <p>
         * List of the timestamp conditions.
         * </p>
         * This is a convenience method that creates an instance of the {@link SearchContactsTimestampCondition.Builder}
         * avoiding the need to create one manually via {@link SearchContactsTimestampCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchContactsTimestampCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #timestampCondition(SearchContactsTimestampCondition)}.
         * 
         * @param timestampCondition
         *        a consumer that will call methods on {@link SearchContactsTimestampCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampCondition(SearchContactsTimestampCondition)
         */
        default Builder timestampCondition(Consumer<SearchContactsTimestampCondition.Builder> timestampCondition) {
            return timestampCondition(SearchContactsTimestampCondition.builder().applyMutation(timestampCondition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SearchContactsTimeRange timeRange;

        private SearchContactsTimestampCondition timestampCondition;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchContactsAdditionalTimeRangeCriteria model) {
            timeRange(model.timeRange);
            timestampCondition(model.timestampCondition);
        }

        public final SearchContactsTimeRange.Builder getTimeRange() {
            return timeRange != null ? timeRange.toBuilder() : null;
        }

        public final void setTimeRange(SearchContactsTimeRange.BuilderImpl timeRange) {
            this.timeRange = timeRange != null ? timeRange.build() : null;
        }

        @Override
        public final Builder timeRange(SearchContactsTimeRange timeRange) {
            this.timeRange = timeRange;
            return this;
        }

        public final SearchContactsTimestampCondition.Builder getTimestampCondition() {
            return timestampCondition != null ? timestampCondition.toBuilder() : null;
        }

        public final void setTimestampCondition(SearchContactsTimestampCondition.BuilderImpl timestampCondition) {
            this.timestampCondition = timestampCondition != null ? timestampCondition.build() : null;
        }

        @Override
        public final Builder timestampCondition(SearchContactsTimestampCondition timestampCondition) {
            this.timestampCondition = timestampCondition;
            return this;
        }

        @Override
        public SearchContactsAdditionalTimeRangeCriteria build() {
            return new SearchContactsAdditionalTimeRangeCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
