/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Latest routing criteria on the contact.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoutingCriteria implements SdkPojo, Serializable, ToCopyableBuilder<RoutingCriteria.Builder, RoutingCriteria> {
    private static final SdkField<List<Step>> STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("Steps")
            .getter(getter(RoutingCriteria::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> ACTIVATION_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ActivationTimestamp").getter(getter(RoutingCriteria::activationTimestamp))
            .setter(setter(Builder::activationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationTimestamp").build())
            .build();

    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Index")
            .getter(getter(RoutingCriteria::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD,
            ACTIVATION_TIMESTAMP_FIELD, INDEX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Step> steps;

    private final Instant activationTimestamp;

    private final Integer index;

    private RoutingCriteria(BuilderImpl builder) {
        this.steps = builder.steps;
        this.activationTimestamp = builder.activationTimestamp;
        this.index = builder.index;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of routing steps. When Amazon Connect does not find an available agent meeting the requirements in a step
     * for a given step duration, the routing criteria will move on to the next step sequentially until a join is
     * completed with an agent. When all steps are exhausted, the contact will be offered to any agent in the queue.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return List of routing steps. When Amazon Connect does not find an available agent meeting the requirements in a
     *         step for a given step duration, the routing criteria will move on to the next step sequentially until a
     *         join is completed with an agent. When all steps are exhausted, the contact will be offered to any agent
     *         in the queue.
     */
    public final List<Step> steps() {
        return steps;
    }

    /**
     * <p>
     * The timestamp indicating when the routing criteria is set to active. A routing criteria is activated when contact
     * is transferred to a queue. ActivationTimestamp will be set on routing criteria for contacts in agent queue even
     * though Routing criteria is never activated for contacts in agent queue.
     * </p>
     * 
     * @return The timestamp indicating when the routing criteria is set to active. A routing criteria is activated when
     *         contact is transferred to a queue. ActivationTimestamp will be set on routing criteria for contacts in
     *         agent queue even though Routing criteria is never activated for contacts in agent queue.
     */
    public final Instant activationTimestamp() {
        return activationTimestamp;
    }

    /**
     * <p>
     * Information about the index of the routing criteria.
     * </p>
     * 
     * @return Information about the index of the routing criteria.
     */
    public final Integer index() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(activationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoutingCriteria)) {
            return false;
        }
        RoutingCriteria other = (RoutingCriteria) obj;
        return hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps())
                && Objects.equals(activationTimestamp(), other.activationTimestamp()) && Objects.equals(index(), other.index());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoutingCriteria").add("Steps", hasSteps() ? steps() : null)
                .add("ActivationTimestamp", activationTimestamp()).add("Index", index()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "ActivationTimestamp":
            return Optional.ofNullable(clazz.cast(activationTimestamp()));
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Steps", STEPS_FIELD);
        map.put("ActivationTimestamp", ACTIVATION_TIMESTAMP_FIELD);
        map.put("Index", INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoutingCriteria, T> g) {
        return obj -> g.apply((RoutingCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoutingCriteria> {
        /**
         * <p>
         * List of routing steps. When Amazon Connect does not find an available agent meeting the requirements in a
         * step for a given step duration, the routing criteria will move on to the next step sequentially until a join
         * is completed with an agent. When all steps are exhausted, the contact will be offered to any agent in the
         * queue.
         * </p>
         * 
         * @param steps
         *        List of routing steps. When Amazon Connect does not find an available agent meeting the requirements
         *        in a step for a given step duration, the routing criteria will move on to the next step sequentially
         *        until a join is completed with an agent. When all steps are exhausted, the contact will be offered to
         *        any agent in the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<Step> steps);

        /**
         * <p>
         * List of routing steps. When Amazon Connect does not find an available agent meeting the requirements in a
         * step for a given step duration, the routing criteria will move on to the next step sequentially until a join
         * is completed with an agent. When all steps are exhausted, the contact will be offered to any agent in the
         * queue.
         * </p>
         * 
         * @param steps
         *        List of routing steps. When Amazon Connect does not find an available agent meeting the requirements
         *        in a step for a given step duration, the routing criteria will move on to the next step sequentially
         *        until a join is completed with an agent. When all steps are exhausted, the contact will be offered to
         *        any agent in the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Step... steps);

        /**
         * <p>
         * List of routing steps. When Amazon Connect does not find an available agent meeting the requirements in a
         * step for a given step duration, the routing criteria will move on to the next step sequentially until a join
         * is completed with an agent. When all steps are exhausted, the contact will be offered to any agent in the
         * queue.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.connect.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #steps(List<Step>)}.
         * 
         * @param steps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(java.util.Collection<Step>)
         */
        Builder steps(Consumer<Step.Builder>... steps);

        /**
         * <p>
         * The timestamp indicating when the routing criteria is set to active. A routing criteria is activated when
         * contact is transferred to a queue. ActivationTimestamp will be set on routing criteria for contacts in agent
         * queue even though Routing criteria is never activated for contacts in agent queue.
         * </p>
         * 
         * @param activationTimestamp
         *        The timestamp indicating when the routing criteria is set to active. A routing criteria is activated
         *        when contact is transferred to a queue. ActivationTimestamp will be set on routing criteria for
         *        contacts in agent queue even though Routing criteria is never activated for contacts in agent queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationTimestamp(Instant activationTimestamp);

        /**
         * <p>
         * Information about the index of the routing criteria.
         * </p>
         * 
         * @param index
         *        Information about the index of the routing criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);
    }

    static final class BuilderImpl implements Builder {
        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();

        private Instant activationTimestamp;

        private Integer index;

        private BuilderImpl() {
        }

        private BuilderImpl(RoutingCriteria model) {
            steps(model.steps);
            activationTimestamp(model.activationTimestamp);
            index(model.index);
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder>... steps) {
            steps(Stream.of(steps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getActivationTimestamp() {
            return activationTimestamp;
        }

        public final void setActivationTimestamp(Instant activationTimestamp) {
            this.activationTimestamp = activationTimestamp;
        }

        @Override
        public final Builder activationTimestamp(Instant activationTimestamp) {
            this.activationTimestamp = activationTimestamp;
            return this;
        }

        public final Integer getIndex() {
            return index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        @Override
        public RoutingCriteria build() {
            return new RoutingCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
