/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a queue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Queue implements SdkPojo, Serializable, ToCopyableBuilder<Queue.Builder, Queue> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Queue::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> QUEUE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueArn").getter(getter(Queue::queueArn)).setter(setter(Builder::queueArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueArn").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueueId").getter(getter(Queue::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Queue::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<OutboundCallerConfig> OUTBOUND_CALLER_CONFIG_FIELD = SdkField
            .<OutboundCallerConfig> builder(MarshallingType.SDK_POJO).memberName("OutboundCallerConfig")
            .getter(getter(Queue::outboundCallerConfig)).setter(setter(Builder::outboundCallerConfig))
            .constructor(OutboundCallerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundCallerConfig").build())
            .build();

    private static final SdkField<OutboundEmailConfig> OUTBOUND_EMAIL_CONFIG_FIELD = SdkField
            .<OutboundEmailConfig> builder(MarshallingType.SDK_POJO).memberName("OutboundEmailConfig")
            .getter(getter(Queue::outboundEmailConfig)).setter(setter(Builder::outboundEmailConfig))
            .constructor(OutboundEmailConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutboundEmailConfig").build())
            .build();

    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationId").getter(getter(Queue::hoursOfOperationId))
            .setter(setter(Builder::hoursOfOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationId").build())
            .build();

    private static final SdkField<Integer> MAX_CONTACTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxContacts").getter(getter(Queue::maxContacts)).setter(setter(Builder::maxContacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxContacts").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Queue::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Queue::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(Queue::lastModifiedTime)).setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(Queue::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, QUEUE_ARN_FIELD,
            QUEUE_ID_FIELD, DESCRIPTION_FIELD, OUTBOUND_CALLER_CONFIG_FIELD, OUTBOUND_EMAIL_CONFIG_FIELD,
            HOURS_OF_OPERATION_ID_FIELD, MAX_CONTACTS_FIELD, STATUS_FIELD, TAGS_FIELD, LAST_MODIFIED_TIME_FIELD,
            LAST_MODIFIED_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String queueArn;

    private final String queueId;

    private final String description;

    private final OutboundCallerConfig outboundCallerConfig;

    private final OutboundEmailConfig outboundEmailConfig;

    private final String hoursOfOperationId;

    private final Integer maxContacts;

    private final String status;

    private final Map<String, String> tags;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private Queue(BuilderImpl builder) {
        this.name = builder.name;
        this.queueArn = builder.queueArn;
        this.queueId = builder.queueId;
        this.description = builder.description;
        this.outboundCallerConfig = builder.outboundCallerConfig;
        this.outboundEmailConfig = builder.outboundEmailConfig;
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.maxContacts = builder.maxContacts;
        this.status = builder.status;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * The name of the queue.
     * </p>
     * 
     * @return The name of the queue.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the queue.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the queue.
     */
    public final String queueArn() {
        return queueArn;
    }

    /**
     * <p>
     * The identifier for the queue.
     * </p>
     * 
     * @return The identifier for the queue.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The description of the queue.
     * </p>
     * 
     * @return The description of the queue.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The outbound caller ID name, number, and outbound whisper flow.
     * </p>
     * 
     * @return The outbound caller ID name, number, and outbound whisper flow.
     */
    public final OutboundCallerConfig outboundCallerConfig() {
        return outboundCallerConfig;
    }

    /**
     * <p>
     * The outbound email address ID for a specified queue.
     * </p>
     * 
     * @return The outbound email address ID for a specified queue.
     */
    public final OutboundEmailConfig outboundEmailConfig() {
        return outboundEmailConfig;
    }

    /**
     * <p>
     * The identifier for the hours of operation.
     * </p>
     * 
     * @return The identifier for the hours of operation.
     */
    public final String hoursOfOperationId() {
        return hoursOfOperationId;
    }

    /**
     * <p>
     * The maximum number of contacts that can be in the queue before it is considered full.
     * </p>
     * 
     * @return The maximum number of contacts that can be in the queue before it is considered full.
     */
    public final Integer maxContacts() {
        return maxContacts;
    }

    /**
     * <p>
     * The status of the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the queue.
     * @see QueueStatus
     */
    public final QueueStatus status() {
        return QueueStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the queue.
     * @see QueueStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp when this resource was last modified.
     * </p>
     * 
     * @return The timestamp when this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Web Services Region where this resource was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where this resource was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(queueArn());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(outboundCallerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outboundEmailConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(maxContacts());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(queueArn(), other.queueArn())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(description(), other.description())
                && Objects.equals(outboundCallerConfig(), other.outboundCallerConfig())
                && Objects.equals(outboundEmailConfig(), other.outboundEmailConfig())
                && Objects.equals(hoursOfOperationId(), other.hoursOfOperationId())
                && Objects.equals(maxContacts(), other.maxContacts()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Queue").add("Name", name()).add("QueueArn", queueArn()).add("QueueId", queueId())
                .add("Description", description()).add("OutboundCallerConfig", outboundCallerConfig())
                .add("OutboundEmailConfig", outboundEmailConfig()).add("HoursOfOperationId", hoursOfOperationId())
                .add("MaxContacts", maxContacts()).add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null)
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "QueueArn":
            return Optional.ofNullable(clazz.cast(queueArn()));
        case "QueueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "OutboundCallerConfig":
            return Optional.ofNullable(clazz.cast(outboundCallerConfig()));
        case "OutboundEmailConfig":
            return Optional.ofNullable(clazz.cast(outboundEmailConfig()));
        case "HoursOfOperationId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationId()));
        case "MaxContacts":
            return Optional.ofNullable(clazz.cast(maxContacts()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("QueueArn", QUEUE_ARN_FIELD);
        map.put("QueueId", QUEUE_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("OutboundCallerConfig", OUTBOUND_CALLER_CONFIG_FIELD);
        map.put("OutboundEmailConfig", OUTBOUND_EMAIL_CONFIG_FIELD);
        map.put("HoursOfOperationId", HOURS_OF_OPERATION_ID_FIELD);
        map.put("MaxContacts", MAX_CONTACTS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Queue, T> g) {
        return obj -> g.apply((Queue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Queue> {
        /**
         * <p>
         * The name of the queue.
         * </p>
         * 
         * @param name
         *        The name of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the queue.
         * </p>
         * 
         * @param queueArn
         *        The Amazon Resource Name (ARN) for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueArn(String queueArn);

        /**
         * <p>
         * The identifier for the queue.
         * </p>
         * 
         * @param queueId
         *        The identifier for the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The description of the queue.
         * </p>
         * 
         * @param description
         *        The description of the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The outbound caller ID name, number, and outbound whisper flow.
         * </p>
         * 
         * @param outboundCallerConfig
         *        The outbound caller ID name, number, and outbound whisper flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundCallerConfig(OutboundCallerConfig outboundCallerConfig);

        /**
         * <p>
         * The outbound caller ID name, number, and outbound whisper flow.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundCallerConfig.Builder} avoiding
         * the need to create one manually via {@link OutboundCallerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundCallerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outboundCallerConfig(OutboundCallerConfig)}.
         * 
         * @param outboundCallerConfig
         *        a consumer that will call methods on {@link OutboundCallerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundCallerConfig(OutboundCallerConfig)
         */
        default Builder outboundCallerConfig(Consumer<OutboundCallerConfig.Builder> outboundCallerConfig) {
            return outboundCallerConfig(OutboundCallerConfig.builder().applyMutation(outboundCallerConfig).build());
        }

        /**
         * <p>
         * The outbound email address ID for a specified queue.
         * </p>
         * 
         * @param outboundEmailConfig
         *        The outbound email address ID for a specified queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outboundEmailConfig(OutboundEmailConfig outboundEmailConfig);

        /**
         * <p>
         * The outbound email address ID for a specified queue.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutboundEmailConfig.Builder} avoiding the
         * need to create one manually via {@link OutboundEmailConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutboundEmailConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #outboundEmailConfig(OutboundEmailConfig)}.
         * 
         * @param outboundEmailConfig
         *        a consumer that will call methods on {@link OutboundEmailConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outboundEmailConfig(OutboundEmailConfig)
         */
        default Builder outboundEmailConfig(Consumer<OutboundEmailConfig.Builder> outboundEmailConfig) {
            return outboundEmailConfig(OutboundEmailConfig.builder().applyMutation(outboundEmailConfig).build());
        }

        /**
         * <p>
         * The identifier for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationId
         *        The identifier for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationId(String hoursOfOperationId);

        /**
         * <p>
         * The maximum number of contacts that can be in the queue before it is considered full.
         * </p>
         * 
         * @param maxContacts
         *        The maximum number of contacts that can be in the queue before it is considered full.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxContacts(Integer maxContacts);

        /**
         * <p>
         * The status of the queue.
         * </p>
         * 
         * @param status
         *        The status of the queue.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the queue.
         * </p>
         * 
         * @param status
         *        The status of the queue.
         * @see QueueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueStatus
         */
        Builder status(QueueStatus status);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp when this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Web Services Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The Amazon Web Services Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String queueArn;

        private String queueId;

        private String description;

        private OutboundCallerConfig outboundCallerConfig;

        private OutboundEmailConfig outboundEmailConfig;

        private String hoursOfOperationId;

        private Integer maxContacts;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(Queue model) {
            name(model.name);
            queueArn(model.queueArn);
            queueId(model.queueId);
            description(model.description);
            outboundCallerConfig(model.outboundCallerConfig);
            outboundEmailConfig(model.outboundEmailConfig);
            hoursOfOperationId(model.hoursOfOperationId);
            maxContacts(model.maxContacts);
            status(model.status);
            tags(model.tags);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQueueArn() {
            return queueArn;
        }

        public final void setQueueArn(String queueArn) {
            this.queueArn = queueArn;
        }

        @Override
        public final Builder queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final OutboundCallerConfig.Builder getOutboundCallerConfig() {
            return outboundCallerConfig != null ? outboundCallerConfig.toBuilder() : null;
        }

        public final void setOutboundCallerConfig(OutboundCallerConfig.BuilderImpl outboundCallerConfig) {
            this.outboundCallerConfig = outboundCallerConfig != null ? outboundCallerConfig.build() : null;
        }

        @Override
        public final Builder outboundCallerConfig(OutboundCallerConfig outboundCallerConfig) {
            this.outboundCallerConfig = outboundCallerConfig;
            return this;
        }

        public final OutboundEmailConfig.Builder getOutboundEmailConfig() {
            return outboundEmailConfig != null ? outboundEmailConfig.toBuilder() : null;
        }

        public final void setOutboundEmailConfig(OutboundEmailConfig.BuilderImpl outboundEmailConfig) {
            this.outboundEmailConfig = outboundEmailConfig != null ? outboundEmailConfig.build() : null;
        }

        @Override
        public final Builder outboundEmailConfig(OutboundEmailConfig outboundEmailConfig) {
            this.outboundEmailConfig = outboundEmailConfig;
            return this;
        }

        public final String getHoursOfOperationId() {
            return hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final Integer getMaxContacts() {
            return maxContacts;
        }

        public final void setMaxContacts(Integer maxContacts) {
            this.maxContacts = maxContacts;
        }

        @Override
        public final Builder maxContacts(Integer maxContacts) {
            this.maxContacts = maxContacts;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public Queue build() {
            return new Queue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
