/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the hours of operations with the effective override applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperationalHour implements SdkPojo, Serializable, ToCopyableBuilder<OperationalHour.Builder, OperationalHour> {
    private static final SdkField<OverrideTimeSlice> START_FIELD = SdkField.<OverrideTimeSlice> builder(MarshallingType.SDK_POJO)
            .memberName("Start").getter(getter(OperationalHour::start)).setter(setter(Builder::start))
            .constructor(OverrideTimeSlice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<OverrideTimeSlice> END_FIELD = SdkField.<OverrideTimeSlice> builder(MarshallingType.SDK_POJO)
            .memberName("End").getter(getter(OperationalHour::end)).setter(setter(Builder::end))
            .constructor(OverrideTimeSlice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OverrideTimeSlice start;

    private final OverrideTimeSlice end;

    private OperationalHour(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The start time that your contact center opens.
     * </p>
     * 
     * @return The start time that your contact center opens.
     */
    public final OverrideTimeSlice start() {
        return start;
    }

    /**
     * <p>
     * The end time that your contact center closes.
     * </p>
     * 
     * @return The end time that your contact center closes.
     */
    public final OverrideTimeSlice end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationalHour)) {
            return false;
        }
        OperationalHour other = (OperationalHour) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperationalHour").add("Start", start()).add("End", end()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Start", START_FIELD);
        map.put("End", END_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OperationalHour, T> g) {
        return obj -> g.apply((OperationalHour) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperationalHour> {
        /**
         * <p>
         * The start time that your contact center opens.
         * </p>
         * 
         * @param start
         *        The start time that your contact center opens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(OverrideTimeSlice start);

        /**
         * <p>
         * The start time that your contact center opens.
         * </p>
         * This is a convenience method that creates an instance of the {@link OverrideTimeSlice.Builder} avoiding the
         * need to create one manually via {@link OverrideTimeSlice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideTimeSlice.Builder#build()} is called immediately and its
         * result is passed to {@link #start(OverrideTimeSlice)}.
         * 
         * @param start
         *        a consumer that will call methods on {@link OverrideTimeSlice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #start(OverrideTimeSlice)
         */
        default Builder start(Consumer<OverrideTimeSlice.Builder> start) {
            return start(OverrideTimeSlice.builder().applyMutation(start).build());
        }

        /**
         * <p>
         * The end time that your contact center closes.
         * </p>
         * 
         * @param end
         *        The end time that your contact center closes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(OverrideTimeSlice end);

        /**
         * <p>
         * The end time that your contact center closes.
         * </p>
         * This is a convenience method that creates an instance of the {@link OverrideTimeSlice.Builder} avoiding the
         * need to create one manually via {@link OverrideTimeSlice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OverrideTimeSlice.Builder#build()} is called immediately and its
         * result is passed to {@link #end(OverrideTimeSlice)}.
         * 
         * @param end
         *        a consumer that will call methods on {@link OverrideTimeSlice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #end(OverrideTimeSlice)
         */
        default Builder end(Consumer<OverrideTimeSlice.Builder> end) {
            return end(OverrideTimeSlice.builder().applyMutation(end).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OverrideTimeSlice start;

        private OverrideTimeSlice end;

        private BuilderImpl() {
        }

        private BuilderImpl(OperationalHour model) {
            start(model.start);
            end(model.end);
        }

        public final OverrideTimeSlice.Builder getStart() {
            return start != null ? start.toBuilder() : null;
        }

        public final void setStart(OverrideTimeSlice.BuilderImpl start) {
            this.start = start != null ? start.build() : null;
        }

        @Override
        public final Builder start(OverrideTimeSlice start) {
            this.start = start;
            return this;
        }

        public final OverrideTimeSlice.Builder getEnd() {
            return end != null ? end.toBuilder() : null;
        }

        public final void setEnd(OverrideTimeSlice.BuilderImpl end) {
            this.end = end != null ? end.build() : null;
        }

        @Override
        public final Builder end(OverrideTimeSlice end) {
            this.end = end;
            return this;
        }

        @Override
        public OperationalHour build() {
            return new OperationalHour(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
