/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEvaluationFormsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListEvaluationFormsResponse.Builder, ListEvaluationFormsResponse> {
    private static final SdkField<List<EvaluationFormSummary>> EVALUATION_FORM_SUMMARY_LIST_FIELD = SdkField
            .<List<EvaluationFormSummary>> builder(MarshallingType.LIST)
            .memberName("EvaluationFormSummaryList")
            .getter(getter(ListEvaluationFormsResponse::evaluationFormSummaryList))
            .setter(setter(Builder::evaluationFormSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationFormSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEvaluationFormsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EVALUATION_FORM_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EvaluationFormSummary> evaluationFormSummaryList;

    private final String nextToken;

    private ListEvaluationFormsResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationFormSummaryList = builder.evaluationFormSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EvaluationFormSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEvaluationFormSummaryList() {
        return evaluationFormSummaryList != null && !(evaluationFormSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides details about a list of evaluation forms belonging to an instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEvaluationFormSummaryList} method.
     * </p>
     * 
     * @return Provides details about a list of evaluation forms belonging to an instance.
     */
    public final List<EvaluationFormSummary> evaluationFormSummaryList() {
        return evaluationFormSummaryList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvaluationFormSummaryList() ? evaluationFormSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEvaluationFormsResponse)) {
            return false;
        }
        ListEvaluationFormsResponse other = (ListEvaluationFormsResponse) obj;
        return hasEvaluationFormSummaryList() == other.hasEvaluationFormSummaryList()
                && Objects.equals(evaluationFormSummaryList(), other.evaluationFormSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEvaluationFormsResponse")
                .add("EvaluationFormSummaryList", hasEvaluationFormSummaryList() ? evaluationFormSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationFormSummaryList":
            return Optional.ofNullable(clazz.cast(evaluationFormSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationFormSummaryList", EVALUATION_FORM_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEvaluationFormsResponse, T> g) {
        return obj -> g.apply((ListEvaluationFormsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListEvaluationFormsResponse> {
        /**
         * <p>
         * Provides details about a list of evaluation forms belonging to an instance.
         * </p>
         * 
         * @param evaluationFormSummaryList
         *        Provides details about a list of evaluation forms belonging to an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormSummaryList(Collection<EvaluationFormSummary> evaluationFormSummaryList);

        /**
         * <p>
         * Provides details about a list of evaluation forms belonging to an instance.
         * </p>
         * 
         * @param evaluationFormSummaryList
         *        Provides details about a list of evaluation forms belonging to an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationFormSummaryList(EvaluationFormSummary... evaluationFormSummaryList);

        /**
         * <p>
         * Provides details about a list of evaluation forms belonging to an instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.connect.model.EvaluationFormSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #evaluationFormSummaryList(List<EvaluationFormSummary>)}.
         * 
         * @param evaluationFormSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationFormSummaryList(java.util.Collection<EvaluationFormSummary>)
         */
        Builder evaluationFormSummaryList(Consumer<EvaluationFormSummary.Builder>... evaluationFormSummaryList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<EvaluationFormSummary> evaluationFormSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEvaluationFormsResponse model) {
            super(model);
            evaluationFormSummaryList(model.evaluationFormSummaryList);
            nextToken(model.nextToken);
        }

        public final List<EvaluationFormSummary.Builder> getEvaluationFormSummaryList() {
            List<EvaluationFormSummary.Builder> result = EvaluationFormSummaryListCopier
                    .copyToBuilder(this.evaluationFormSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluationFormSummaryList(Collection<EvaluationFormSummary.BuilderImpl> evaluationFormSummaryList) {
            this.evaluationFormSummaryList = EvaluationFormSummaryListCopier.copyFromBuilder(evaluationFormSummaryList);
        }

        @Override
        public final Builder evaluationFormSummaryList(Collection<EvaluationFormSummary> evaluationFormSummaryList) {
            this.evaluationFormSummaryList = EvaluationFormSummaryListCopier.copy(evaluationFormSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationFormSummaryList(EvaluationFormSummary... evaluationFormSummaryList) {
            evaluationFormSummaryList(Arrays.asList(evaluationFormSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluationFormSummaryList(Consumer<EvaluationFormSummary.Builder>... evaluationFormSummaryList) {
            evaluationFormSummaryList(Stream.of(evaluationFormSummaryList)
                    .map(c -> EvaluationFormSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEvaluationFormsResponse build() {
            return new ListEvaluationFormsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
