/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the additional TO and CC recipients of an inbound email contact.
 * </p>
 * <note>
 * <p>
 * You can include up to 50 email addresses in total, distributed across <a href=
 * "https://docs.aws.amazon.com/connect/latest/APIReference/API_StartEmailContact.html#API_StartEmailContact_RequestBody"
 * >DestinationEmailAddress</a>, <code>ToAddresses</code>, and <code>CcAddresses</code>. This total must include one
 * required <code>DestinationEmailAddress</code>. You can then specify up to 49 addresses allocated across
 * <code>ToAddresses</code> and <code>CcAddresses</code> as needed.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InboundAdditionalRecipients implements SdkPojo, Serializable,
        ToCopyableBuilder<InboundAdditionalRecipients.Builder, InboundAdditionalRecipients> {
    private static final SdkField<List<EmailAddressInfo>> TO_ADDRESSES_FIELD = SdkField
            .<List<EmailAddressInfo>> builder(MarshallingType.LIST)
            .memberName("ToAddresses")
            .getter(getter(InboundAdditionalRecipients::toAddresses))
            .setter(setter(Builder::toAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailAddressInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailAddressInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EmailAddressInfo>> CC_ADDRESSES_FIELD = SdkField
            .<List<EmailAddressInfo>> builder(MarshallingType.LIST)
            .memberName("CcAddresses")
            .getter(getter(InboundAdditionalRecipients::ccAddresses))
            .setter(setter(Builder::ccAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CcAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EmailAddressInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(EmailAddressInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TO_ADDRESSES_FIELD,
            CC_ADDRESSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<EmailAddressInfo> toAddresses;

    private final List<EmailAddressInfo> ccAddresses;

    private InboundAdditionalRecipients(BuilderImpl builder) {
        this.toAddresses = builder.toAddresses;
        this.ccAddresses = builder.ccAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ToAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasToAddresses() {
        return toAddresses != null && !(toAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <b>additional</b> recipients information present in to list. You must have 1 required recipient (
     * <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
     * <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasToAddresses} method.
     * </p>
     * 
     * @return The <b>additional</b> recipients information present in to list. You must have 1 required recipient (
     *         <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
     *         <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
     */
    public final List<EmailAddressInfo> toAddresses() {
        return toAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the CcAddresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCcAddresses() {
        return ccAddresses != null && !(ccAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <b>additional</b> recipients information present in cc list. You must have 1 required recipient (
     * <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
     * <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCcAddresses} method.
     * </p>
     * 
     * @return The <b>additional</b> recipients information present in cc list. You must have 1 required recipient (
     *         <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
     *         <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
     */
    public final List<EmailAddressInfo> ccAddresses() {
        return ccAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasToAddresses() ? toAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCcAddresses() ? ccAddresses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InboundAdditionalRecipients)) {
            return false;
        }
        InboundAdditionalRecipients other = (InboundAdditionalRecipients) obj;
        return hasToAddresses() == other.hasToAddresses() && Objects.equals(toAddresses(), other.toAddresses())
                && hasCcAddresses() == other.hasCcAddresses() && Objects.equals(ccAddresses(), other.ccAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InboundAdditionalRecipients").add("ToAddresses", hasToAddresses() ? toAddresses() : null)
                .add("CcAddresses", hasCcAddresses() ? ccAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ToAddresses":
            return Optional.ofNullable(clazz.cast(toAddresses()));
        case "CcAddresses":
            return Optional.ofNullable(clazz.cast(ccAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ToAddresses", TO_ADDRESSES_FIELD);
        map.put("CcAddresses", CC_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InboundAdditionalRecipients, T> g) {
        return obj -> g.apply((InboundAdditionalRecipients) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InboundAdditionalRecipients> {
        /**
         * <p>
         * The <b>additional</b> recipients information present in to list. You must have 1 required recipient (
         * <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         * <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * </p>
         * 
         * @param toAddresses
         *        The <b>additional</b> recipients information present in to list. You must have 1 required recipient (
         *        <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         *        <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toAddresses(Collection<EmailAddressInfo> toAddresses);

        /**
         * <p>
         * The <b>additional</b> recipients information present in to list. You must have 1 required recipient (
         * <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         * <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * </p>
         * 
         * @param toAddresses
         *        The <b>additional</b> recipients information present in to list. You must have 1 required recipient (
         *        <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         *        <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toAddresses(EmailAddressInfo... toAddresses);

        /**
         * <p>
         * The <b>additional</b> recipients information present in to list. You must have 1 required recipient (
         * <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         * <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EmailAddressInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.EmailAddressInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EmailAddressInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #toAddresses(List<EmailAddressInfo>)}.
         * 
         * @param toAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EmailAddressInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toAddresses(java.util.Collection<EmailAddressInfo>)
         */
        Builder toAddresses(Consumer<EmailAddressInfo.Builder>... toAddresses);

        /**
         * <p>
         * The <b>additional</b> recipients information present in cc list. You must have 1 required recipient (
         * <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         * <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * </p>
         * 
         * @param ccAddresses
         *        The <b>additional</b> recipients information present in cc list. You must have 1 required recipient (
         *        <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         *        <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccAddresses(Collection<EmailAddressInfo> ccAddresses);

        /**
         * <p>
         * The <b>additional</b> recipients information present in cc list. You must have 1 required recipient (
         * <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         * <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * </p>
         * 
         * @param ccAddresses
         *        The <b>additional</b> recipients information present in cc list. You must have 1 required recipient (
         *        <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         *        <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccAddresses(EmailAddressInfo... ccAddresses);

        /**
         * <p>
         * The <b>additional</b> recipients information present in cc list. You must have 1 required recipient (
         * <code>DestinationEmailAddress</code>). You can then specify up to 49 additional recipients (across
         * <code>ToAddresses</code> and <code>CcAddresses</code>), for a total of 50 recipients.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EmailAddressInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.EmailAddressInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EmailAddressInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #ccAddresses(List<EmailAddressInfo>)}.
         * 
         * @param ccAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EmailAddressInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ccAddresses(java.util.Collection<EmailAddressInfo>)
         */
        Builder ccAddresses(Consumer<EmailAddressInfo.Builder>... ccAddresses);
    }

    static final class BuilderImpl implements Builder {
        private List<EmailAddressInfo> toAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<EmailAddressInfo> ccAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InboundAdditionalRecipients model) {
            toAddresses(model.toAddresses);
            ccAddresses(model.ccAddresses);
        }

        public final List<EmailAddressInfo.Builder> getToAddresses() {
            List<EmailAddressInfo.Builder> result = EmailAddressRecipientListCopier.copyToBuilder(this.toAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToAddresses(Collection<EmailAddressInfo.BuilderImpl> toAddresses) {
            this.toAddresses = EmailAddressRecipientListCopier.copyFromBuilder(toAddresses);
        }

        @Override
        public final Builder toAddresses(Collection<EmailAddressInfo> toAddresses) {
            this.toAddresses = EmailAddressRecipientListCopier.copy(toAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(EmailAddressInfo... toAddresses) {
            toAddresses(Arrays.asList(toAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toAddresses(Consumer<EmailAddressInfo.Builder>... toAddresses) {
            toAddresses(Stream.of(toAddresses).map(c -> EmailAddressInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EmailAddressInfo.Builder> getCcAddresses() {
            List<EmailAddressInfo.Builder> result = EmailAddressRecipientListCopier.copyToBuilder(this.ccAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCcAddresses(Collection<EmailAddressInfo.BuilderImpl> ccAddresses) {
            this.ccAddresses = EmailAddressRecipientListCopier.copyFromBuilder(ccAddresses);
        }

        @Override
        public final Builder ccAddresses(Collection<EmailAddressInfo> ccAddresses) {
            this.ccAddresses = EmailAddressRecipientListCopier.copy(ccAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(EmailAddressInfo... ccAddresses) {
            ccAddresses(Arrays.asList(ccAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ccAddresses(Consumer<EmailAddressInfo.Builder>... ccAddresses) {
            ccAddresses(Stream.of(ccAddresses).map(c -> EmailAddressInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public InboundAdditionalRecipients build() {
            return new InboundAdditionalRecipients(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
