/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The historical metric names.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum HistoricalMetricName {
    CONTACTS_QUEUED("CONTACTS_QUEUED"),

    CONTACTS_HANDLED("CONTACTS_HANDLED"),

    CONTACTS_ABANDONED("CONTACTS_ABANDONED"),

    CONTACTS_CONSULTED("CONTACTS_CONSULTED"),

    CONTACTS_AGENT_HUNG_UP_FIRST("CONTACTS_AGENT_HUNG_UP_FIRST"),

    CONTACTS_HANDLED_INCOMING("CONTACTS_HANDLED_INCOMING"),

    CONTACTS_HANDLED_OUTBOUND("CONTACTS_HANDLED_OUTBOUND"),

    CONTACTS_HOLD_ABANDONS("CONTACTS_HOLD_ABANDONS"),

    CONTACTS_TRANSFERRED_IN("CONTACTS_TRANSFERRED_IN"),

    CONTACTS_TRANSFERRED_OUT("CONTACTS_TRANSFERRED_OUT"),

    CONTACTS_TRANSFERRED_IN_FROM_QUEUE("CONTACTS_TRANSFERRED_IN_FROM_QUEUE"),

    CONTACTS_TRANSFERRED_OUT_FROM_QUEUE("CONTACTS_TRANSFERRED_OUT_FROM_QUEUE"),

    CONTACTS_MISSED("CONTACTS_MISSED"),

    CALLBACK_CONTACTS_HANDLED("CALLBACK_CONTACTS_HANDLED"),

    API_CONTACTS_HANDLED("API_CONTACTS_HANDLED"),

    OCCUPANCY("OCCUPANCY"),

    HANDLE_TIME("HANDLE_TIME"),

    AFTER_CONTACT_WORK_TIME("AFTER_CONTACT_WORK_TIME"),

    QUEUED_TIME("QUEUED_TIME"),

    ABANDON_TIME("ABANDON_TIME"),

    QUEUE_ANSWER_TIME("QUEUE_ANSWER_TIME"),

    HOLD_TIME("HOLD_TIME"),

    INTERACTION_TIME("INTERACTION_TIME"),

    INTERACTION_AND_HOLD_TIME("INTERACTION_AND_HOLD_TIME"),

    SERVICE_LEVEL("SERVICE_LEVEL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HistoricalMetricName> VALUE_MAP = EnumUtils.uniqueIndex(HistoricalMetricName.class,
            HistoricalMetricName::toString);

    private final String value;

    private HistoricalMetricName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HistoricalMetricName corresponding to the value
     */
    public static HistoricalMetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HistoricalMetricName}s
     */
    public static Set<HistoricalMetricName> knownValues() {
        Set<HistoricalMetricName> knownValues = EnumSet.allOf(HistoricalMetricName.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
