/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a historical metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HistoricalMetric implements SdkPojo, Serializable,
        ToCopyableBuilder<HistoricalMetric.Builder, HistoricalMetric> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(HistoricalMetric::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Threshold> THRESHOLD_FIELD = SdkField.<Threshold> builder(MarshallingType.SDK_POJO)
            .memberName("Threshold").getter(getter(HistoricalMetric::threshold)).setter(setter(Builder::threshold))
            .constructor(Threshold::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Threshold").build()).build();

    private static final SdkField<String> STATISTIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Statistic").getter(getter(HistoricalMetric::statisticAsString)).setter(setter(Builder::statistic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Statistic").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(HistoricalMetric::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, THRESHOLD_FIELD,
            STATISTIC_FIELD, UNIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Threshold threshold;

    private final String statistic;

    private final String unit;

    private HistoricalMetric(BuilderImpl builder) {
        this.name = builder.name;
        this.threshold = builder.threshold;
        this.statistic = builder.statistic;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The name of the metric. Following is a list of each supported metric mapped to the UI name, linked to a detailed
     * description in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <dl>
     * <dt>ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time"
     * >Average queue abandon time</a>
     * </p>
     * </dd>
     * <dt>AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time"
     * >After contact work time</a>
     * </p>
     * </dd>
     * <dt>API_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled">API
     * contacts handled</a>
     * </p>
     * </dd>
     * <dt>AVG_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time"
     * >Average customer hold time</a>
     * </p>
     * </dd>
     * <dt>CALLBACK_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-contacts-handled"
     * >Callback contacts handled</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned">Contacts
     * abandoned</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-agent-hung-up-first"
     * >Contacts agent hung up first</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_CONSULTED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-consulted">Contacts
     * consulted</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled">Contacts
     * handled</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED_INCOMING</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-incoming"
     * >Contacts handled incoming</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-outbound"
     * >Contacts handled outbound</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect"
     * >Contacts hold disconnect</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_MISSED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response"
     * >AGENT_NON_RESPONSE</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued">Contacts
     * queued</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_IN</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-in"
     * >Contacts transferred in</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
     * >Contacts transferred out queue</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out"
     * >Contacts transferred out</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
     * >Contacts transferred out queue</a>
     * </p>
     * </dd>
     * <dt>HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time">Average
     * handle time</a>
     * </p>
     * </dd>
     * <dt>INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time"
     * >Average agent interaction and customer hold time</a>
     * </p>
     * </dd>
     * <dt>INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#aaverage-agent-interaction-time"
     * >Average agent interaction time</a>
     * </p>
     * </dd>
     * <dt>OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: PERCENT
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy">Occupancy</a>
     * </p>
     * </dd>
     * <dt>QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html##average-queue-answer-time"
     * >Average queue answer time</a>
     * </p>
     * </dd>
     * <dt>QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: MAX
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time">Minimum
     * flow time</a>
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: PERCENT
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level">Service level
     * X</a>
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link HistoricalMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the metric. Following is a list of each supported metric mapped to the UI name, linked to a
     *         detailed description in the <i>Amazon Connect Administrator Guide</i>. </p>
     *         <dl>
     *         <dt>ABANDON_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time"
     *         >Average queue abandon time</a>
     *         </p>
     *         </dd>
     *         <dt>AFTER_CONTACT_WORK_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time"
     *         >After contact work time</a>
     *         </p>
     *         </dd>
     *         <dt>API_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled">API
     *         contacts handled</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time"
     *         >Average customer hold time</a>
     *         </p>
     *         </dd>
     *         <dt>CALLBACK_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-contacts-handled"
     *         >Callback contacts handled</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_ABANDONED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned"
     *         >Contacts abandoned</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-agent-hung-up-first"
     *         >Contacts agent hung up first</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_CONSULTED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-consulted"
     *         >Contacts consulted</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled"
     *         >Contacts handled</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED_INCOMING</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-incoming"
     *         >Contacts handled incoming</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED_OUTBOUND</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-outbound"
     *         >Contacts handled outbound</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HOLD_ABANDONS</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect"
     *         >Contacts hold disconnect</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_MISSED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response"
     *         >AGENT_NON_RESPONSE</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_QUEUED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued"
     *         >Contacts queued</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_IN</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-in"
     *         >Contacts transferred in</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
     *         >Contacts transferred out queue</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out"
     *         >Contacts transferred out</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
     *         >Contacts transferred out queue</a>
     *         </p>
     *         </dd>
     *         <dt>HANDLE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time"
     *         >Average handle time</a>
     *         </p>
     *         </dd>
     *         <dt>INTERACTION_AND_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time"
     *         >Average agent interaction and customer hold time</a>
     *         </p>
     *         </dd>
     *         <dt>INTERACTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#aaverage-agent-interaction-time"
     *         >Average agent interaction time</a>
     *         </p>
     *         </dd>
     *         <dt>OCCUPANCY</dt>
     *         <dd>
     *         <p>
     *         Unit: PERCENT
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy"
     *         >Occupancy</a>
     *         </p>
     *         </dd>
     *         <dt>QUEUE_ANSWER_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html##average-queue-answer-time"
     *         >Average queue answer time</a>
     *         </p>
     *         </dd>
     *         <dt>QUEUED_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: MAX
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time"
     *         >Minimum flow time</a>
     *         </p>
     *         </dd>
     *         <dt>SERVICE_LEVEL</dt>
     *         <dd>
     *         <p>
     *         You can include up to 20 SERVICE_LEVEL metrics in a request.
     *         </p>
     *         <p>
     *         Unit: PERCENT
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level"
     *         >Service level X</a>
     *         </p>
     *         </dd>
     * @see HistoricalMetricName
     */
    public final HistoricalMetricName name() {
        return HistoricalMetricName.fromValue(name);
    }

    /**
     * <p>
     * The name of the metric. Following is a list of each supported metric mapped to the UI name, linked to a detailed
     * description in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <dl>
     * <dt>ABANDON_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time"
     * >Average queue abandon time</a>
     * </p>
     * </dd>
     * <dt>AFTER_CONTACT_WORK_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time"
     * >After contact work time</a>
     * </p>
     * </dd>
     * <dt>API_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled">API
     * contacts handled</a>
     * </p>
     * </dd>
     * <dt>AVG_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time"
     * >Average customer hold time</a>
     * </p>
     * </dd>
     * <dt>CALLBACK_CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-contacts-handled"
     * >Callback contacts handled</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_ABANDONED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned">Contacts
     * abandoned</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-agent-hung-up-first"
     * >Contacts agent hung up first</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_CONSULTED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-consulted">Contacts
     * consulted</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled">Contacts
     * handled</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED_INCOMING</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-incoming"
     * >Contacts handled incoming</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-outbound"
     * >Contacts handled outbound</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_HOLD_ABANDONS</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect"
     * >Contacts hold disconnect</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_MISSED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response"
     * >AGENT_NON_RESPONSE</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_QUEUED</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued">Contacts
     * queued</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_IN</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-in"
     * >Contacts transferred in</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
     * >Contacts transferred out queue</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out"
     * >Contacts transferred out</a>
     * </p>
     * </dd>
     * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     * <dd>
     * <p>
     * Unit: COUNT
     * </p>
     * <p>
     * Statistic: SUM
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
     * >Contacts transferred out queue</a>
     * </p>
     * </dd>
     * <dt>HANDLE_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time">Average
     * handle time</a>
     * </p>
     * </dd>
     * <dt>INTERACTION_AND_HOLD_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time"
     * >Average agent interaction and customer hold time</a>
     * </p>
     * </dd>
     * <dt>INTERACTION_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#aaverage-agent-interaction-time"
     * >Average agent interaction time</a>
     * </p>
     * </dd>
     * <dt>OCCUPANCY</dt>
     * <dd>
     * <p>
     * Unit: PERCENT
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy">Occupancy</a>
     * </p>
     * </dd>
     * <dt>QUEUE_ANSWER_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * UI name: <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html##average-queue-answer-time"
     * >Average queue answer time</a>
     * </p>
     * </dd>
     * <dt>QUEUED_TIME</dt>
     * <dd>
     * <p>
     * Unit: SECONDS
     * </p>
     * <p>
     * Statistic: MAX
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time">Minimum
     * flow time</a>
     * </p>
     * </dd>
     * <dt>SERVICE_LEVEL</dt>
     * <dd>
     * <p>
     * You can include up to 20 SERVICE_LEVEL metrics in a request.
     * </p>
     * <p>
     * Unit: PERCENT
     * </p>
     * <p>
     * Statistic: AVG
     * </p>
     * <p>
     * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For
     * <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     * </p>
     * <p>
     * UI name: <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level">Service level
     * X</a>
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link HistoricalMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the metric. Following is a list of each supported metric mapped to the UI name, linked to a
     *         detailed description in the <i>Amazon Connect Administrator Guide</i>. </p>
     *         <dl>
     *         <dt>ABANDON_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time"
     *         >Average queue abandon time</a>
     *         </p>
     *         </dd>
     *         <dt>AFTER_CONTACT_WORK_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time"
     *         >After contact work time</a>
     *         </p>
     *         </dd>
     *         <dt>API_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled">API
     *         contacts handled</a>
     *         </p>
     *         </dd>
     *         <dt>AVG_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time"
     *         >Average customer hold time</a>
     *         </p>
     *         </dd>
     *         <dt>CALLBACK_CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-contacts-handled"
     *         >Callback contacts handled</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_ABANDONED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned"
     *         >Contacts abandoned</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-agent-hung-up-first"
     *         >Contacts agent hung up first</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_CONSULTED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-consulted"
     *         >Contacts consulted</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled"
     *         >Contacts handled</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED_INCOMING</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-incoming"
     *         >Contacts handled incoming</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HANDLED_OUTBOUND</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-outbound"
     *         >Contacts handled outbound</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_HOLD_ABANDONS</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect"
     *         >Contacts hold disconnect</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_MISSED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response"
     *         >AGENT_NON_RESPONSE</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_QUEUED</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued"
     *         >Contacts queued</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_IN</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-in"
     *         >Contacts transferred in</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
     *         >Contacts transferred out queue</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out"
     *         >Contacts transferred out</a>
     *         </p>
     *         </dd>
     *         <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
     *         <dd>
     *         <p>
     *         Unit: COUNT
     *         </p>
     *         <p>
     *         Statistic: SUM
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
     *         >Contacts transferred out queue</a>
     *         </p>
     *         </dd>
     *         <dt>HANDLE_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time"
     *         >Average handle time</a>
     *         </p>
     *         </dd>
     *         <dt>INTERACTION_AND_HOLD_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time"
     *         >Average agent interaction and customer hold time</a>
     *         </p>
     *         </dd>
     *         <dt>INTERACTION_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#aaverage-agent-interaction-time"
     *         >Average agent interaction time</a>
     *         </p>
     *         </dd>
     *         <dt>OCCUPANCY</dt>
     *         <dd>
     *         <p>
     *         Unit: PERCENT
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy"
     *         >Occupancy</a>
     *         </p>
     *         </dd>
     *         <dt>QUEUE_ANSWER_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         UI name: <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html##average-queue-answer-time"
     *         >Average queue answer time</a>
     *         </p>
     *         </dd>
     *         <dt>QUEUED_TIME</dt>
     *         <dd>
     *         <p>
     *         Unit: SECONDS
     *         </p>
     *         <p>
     *         Statistic: MAX
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time"
     *         >Minimum flow time</a>
     *         </p>
     *         </dd>
     *         <dt>SERVICE_LEVEL</dt>
     *         <dd>
     *         <p>
     *         You can include up to 20 SERVICE_LEVEL metrics in a request.
     *         </p>
     *         <p>
     *         Unit: PERCENT
     *         </p>
     *         <p>
     *         Statistic: AVG
     *         </p>
     *         <p>
     *         Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
     *         seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
     *         </p>
     *         <p>
     *         UI name: <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level"
     *         >Service level X</a>
     *         </p>
     *         </dd>
     * @see HistoricalMetricName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The threshold for the metric, used with service level metrics.
     * </p>
     * 
     * @return The threshold for the metric, used with service level metrics.
     */
    public final Threshold threshold() {
        return threshold;
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic for the metric.
     * @see Statistic
     */
    public final Statistic statistic() {
        return Statistic.fromValue(statistic);
    }

    /**
     * <p>
     * The statistic for the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statistic} will
     * return {@link Statistic#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statisticAsString}.
     * </p>
     * 
     * @return The statistic for the metric.
     * @see Statistic
     */
    public final String statisticAsString() {
        return statistic;
    }

    /**
     * <p>
     * The unit for the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for the metric.
     * @see Unit
     */
    public final Unit unit() {
        return Unit.fromValue(unit);
    }

    /**
     * <p>
     * The unit for the metric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link Unit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return The unit for the metric.
     * @see Unit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        hashCode = 31 * hashCode + Objects.hashCode(statisticAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistoricalMetric)) {
            return false;
        }
        HistoricalMetric other = (HistoricalMetric) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(threshold(), other.threshold())
                && Objects.equals(statisticAsString(), other.statisticAsString())
                && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HistoricalMetric").add("Name", nameAsString()).add("Threshold", threshold())
                .add("Statistic", statisticAsString()).add("Unit", unitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        case "Statistic":
            return Optional.ofNullable(clazz.cast(statisticAsString()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Threshold", THRESHOLD_FIELD);
        map.put("Statistic", STATISTIC_FIELD);
        map.put("Unit", UNIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HistoricalMetric, T> g) {
        return obj -> g.apply((HistoricalMetric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HistoricalMetric> {
        /**
         * <p>
         * The name of the metric. Following is a list of each supported metric mapped to the UI name, linked to a
         * detailed description in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time"
         * >Average queue abandon time</a>
         * </p>
         * </dd>
         * <dt>AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time"
         * >After contact work time</a>
         * </p>
         * </dd>
         * <dt>API_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled"
         * >API contacts handled</a>
         * </p>
         * </dd>
         * <dt>AVG_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time"
         * >Average customer hold time</a>
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-contacts-handled"
         * >Callback contacts handled</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned"
         * >Contacts abandoned</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-agent-hung-up-first"
         * >Contacts agent hung up first</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_CONSULTED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-consulted"
         * >Contacts consulted</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled"
         * >Contacts handled</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_INCOMING</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-incoming"
         * >Contacts handled incoming</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-outbound"
         * >Contacts handled outbound</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect"
         * >Contacts hold disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_MISSED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response"
         * >AGENT_NON_RESPONSE</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued"
         * >Contacts queued</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-in"
         * >Contacts transferred in</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
         * >Contacts transferred out queue</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out"
         * >Contacts transferred out</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
         * >Contacts transferred out queue</a>
         * </p>
         * </dd>
         * <dt>HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time"
         * >Average handle time</a>
         * </p>
         * </dd>
         * <dt>INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time"
         * >Average agent interaction and customer hold time</a>
         * </p>
         * </dd>
         * <dt>INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#aaverage-agent-interaction-time"
         * >Average agent interaction time</a>
         * </p>
         * </dd>
         * <dt>OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy">Occupancy</a>
         * </p>
         * </dd>
         * <dt>QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html##average-queue-answer-time"
         * >Average queue answer time</a>
         * </p>
         * </dd>
         * <dt>QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: MAX
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time"
         * >Minimum flow time</a>
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         * </p>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level">Service
         * level X</a>
         * </p>
         * </dd>
         * </dl>
         * 
         * @param name
         *        The name of the metric. Following is a list of each supported metric mapped to the UI name, linked to
         *        a detailed description in the <i>Amazon Connect Administrator Guide</i>. </p>
         *        <dl>
         *        <dt>ABANDON_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time"
         *        >Average queue abandon time</a>
         *        </p>
         *        </dd>
         *        <dt>AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time"
         *        >After contact work time</a>
         *        </p>
         *        </dd>
         *        <dt>API_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled"
         *        >API contacts handled</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time"
         *        >Average customer hold time</a>
         *        </p>
         *        </dd>
         *        <dt>CALLBACK_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-contacts-handled"
         *        >Callback contacts handled</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ABANDONED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned"
         *        >Contacts abandoned</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-agent-hung-up-first"
         *        >Contacts agent hung up first</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_CONSULTED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-consulted"
         *        >Contacts consulted</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled"
         *        >Contacts handled</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_INCOMING</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-incoming"
         *        >Contacts handled incoming</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-outbound"
         *        >Contacts handled outbound</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HOLD_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect"
         *        >Contacts hold disconnect</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_MISSED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response"
         *        >AGENT_NON_RESPONSE</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued"
         *        >Contacts queued</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-in"
         *        >Contacts transferred in</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
         *        >Contacts transferred out queue</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out"
         *        >Contacts transferred out</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
         *        >Contacts transferred out queue</a>
         *        </p>
         *        </dd>
         *        <dt>HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time"
         *        >Average handle time</a>
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time"
         *        >Average agent interaction and customer hold time</a>
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#aaverage-agent-interaction-time"
         *        >Average agent interaction time</a>
         *        </p>
         *        </dd>
         *        <dt>OCCUPANCY</dt>
         *        <dd>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy"
         *        >Occupancy</a>
         *        </p>
         *        </dd>
         *        <dt>QUEUE_ANSWER_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html##average-queue-answer-time"
         *        >Average queue answer time</a>
         *        </p>
         *        </dd>
         *        <dt>QUEUED_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: MAX
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time"
         *        >Minimum flow time</a>
         *        </p>
         *        </dd>
         *        <dt>SERVICE_LEVEL</dt>
         *        <dd>
         *        <p>
         *        You can include up to 20 SERVICE_LEVEL metrics in a request.
         *        </p>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         *        </p>
         *        <p>
         *        UI name: <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level"
         *        >Service level X</a>
         *        </p>
         *        </dd>
         * @see HistoricalMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoricalMetricName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the metric. Following is a list of each supported metric mapped to the UI name, linked to a
         * detailed description in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * <dl>
         * <dt>ABANDON_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time"
         * >Average queue abandon time</a>
         * </p>
         * </dd>
         * <dt>AFTER_CONTACT_WORK_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time"
         * >After contact work time</a>
         * </p>
         * </dd>
         * <dt>API_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled"
         * >API contacts handled</a>
         * </p>
         * </dd>
         * <dt>AVG_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time"
         * >Average customer hold time</a>
         * </p>
         * </dd>
         * <dt>CALLBACK_CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-contacts-handled"
         * >Callback contacts handled</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_ABANDONED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned"
         * >Contacts abandoned</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-agent-hung-up-first"
         * >Contacts agent hung up first</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_CONSULTED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-consulted"
         * >Contacts consulted</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled"
         * >Contacts handled</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_INCOMING</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-incoming"
         * >Contacts handled incoming</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-outbound"
         * >Contacts handled outbound</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_HOLD_ABANDONS</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect"
         * >Contacts hold disconnect</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_MISSED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response"
         * >AGENT_NON_RESPONSE</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_QUEUED</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued"
         * >Contacts queued</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-in"
         * >Contacts transferred in</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
         * >Contacts transferred out queue</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out"
         * >Contacts transferred out</a>
         * </p>
         * </dd>
         * <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         * <dd>
         * <p>
         * Unit: COUNT
         * </p>
         * <p>
         * Statistic: SUM
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
         * >Contacts transferred out queue</a>
         * </p>
         * </dd>
         * <dt>HANDLE_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time"
         * >Average handle time</a>
         * </p>
         * </dd>
         * <dt>INTERACTION_AND_HOLD_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time"
         * >Average agent interaction and customer hold time</a>
         * </p>
         * </dd>
         * <dt>INTERACTION_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#aaverage-agent-interaction-time"
         * >Average agent interaction time</a>
         * </p>
         * </dd>
         * <dt>OCCUPANCY</dt>
         * <dd>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy">Occupancy</a>
         * </p>
         * </dd>
         * <dt>QUEUE_ANSWER_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * UI name: <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html##average-queue-answer-time"
         * >Average queue answer time</a>
         * </p>
         * </dd>
         * <dt>QUEUED_TIME</dt>
         * <dd>
         * <p>
         * Unit: SECONDS
         * </p>
         * <p>
         * Statistic: MAX
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time"
         * >Minimum flow time</a>
         * </p>
         * </dd>
         * <dt>SERVICE_LEVEL</dt>
         * <dd>
         * <p>
         * You can include up to 20 SERVICE_LEVEL metrics in a request.
         * </p>
         * <p>
         * Unit: PERCENT
         * </p>
         * <p>
         * Statistic: AVG
         * </p>
         * <p>
         * Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds.
         * For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         * </p>
         * <p>
         * UI name: <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level">Service
         * level X</a>
         * </p>
         * </dd>
         * </dl>
         * 
         * @param name
         *        The name of the metric. Following is a list of each supported metric mapped to the UI name, linked to
         *        a detailed description in the <i>Amazon Connect Administrator Guide</i>. </p>
         *        <dl>
         *        <dt>ABANDON_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-queue-abandon-time"
         *        >Average queue abandon time</a>
         *        </p>
         *        </dd>
         *        <dt>AFTER_CONTACT_WORK_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#after-contact-work-time"
         *        >After contact work time</a>
         *        </p>
         *        </dd>
         *        <dt>API_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#api-contacts-handled"
         *        >API contacts handled</a>
         *        </p>
         *        </dd>
         *        <dt>AVG_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-customer-hold-time"
         *        >Average customer hold time</a>
         *        </p>
         *        </dd>
         *        <dt>CALLBACK_CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#callback-contacts-handled"
         *        >Callback contacts handled</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_ABANDONED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-abandoned"
         *        >Contacts abandoned</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-agent-hung-up-first"
         *        >Contacts agent hung up first</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_CONSULTED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-consulted"
         *        >Contacts consulted</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled"
         *        >Contacts handled</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_INCOMING</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-incoming"
         *        >Contacts handled incoming</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HANDLED_OUTBOUND</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-handled-outbound"
         *        >Contacts handled outbound</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_HOLD_ABANDONS</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-hold-disconnect"
         *        >Contacts hold disconnect</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_MISSED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#agent-non-response"
         *        >AGENT_NON_RESPONSE</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_QUEUED</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-queued"
         *        >Contacts queued</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-in"
         *        >Contacts transferred in</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
         *        >Contacts transferred out queue</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out"
         *        >Contacts transferred out</a>
         *        </p>
         *        </dd>
         *        <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt>
         *        <dd>
         *        <p>
         *        Unit: COUNT
         *        </p>
         *        <p>
         *        Statistic: SUM
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#contacts-transferred-out-queue"
         *        >Contacts transferred out queue</a>
         *        </p>
         *        </dd>
         *        <dt>HANDLE_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-handle-time"
         *        >Average handle time</a>
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_AND_HOLD_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#average-agent-interaction-and-customer-hold-time"
         *        >Average agent interaction and customer hold time</a>
         *        </p>
         *        </dd>
         *        <dt>INTERACTION_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#aaverage-agent-interaction-time"
         *        >Average agent interaction time</a>
         *        </p>
         *        </dd>
         *        <dt>OCCUPANCY</dt>
         *        <dd>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#occupancy"
         *        >Occupancy</a>
         *        </p>
         *        </dd>
         *        <dt>QUEUE_ANSWER_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html##average-queue-answer-time"
         *        >Average queue answer time</a>
         *        </p>
         *        </dd>
         *        <dt>QUEUED_TIME</dt>
         *        <dd>
         *        <p>
         *        Unit: SECONDS
         *        </p>
         *        <p>
         *        Statistic: MAX
         *        </p>
         *        <p>
         *        UI name: <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#minimum-flow-time"
         *        >Minimum flow time</a>
         *        </p>
         *        </dd>
         *        <dt>SERVICE_LEVEL</dt>
         *        <dd>
         *        <p>
         *        You can include up to 20 SERVICE_LEVEL metrics in a request.
         *        </p>
         *        <p>
         *        Unit: PERCENT
         *        </p>
         *        <p>
         *        Statistic: AVG
         *        </p>
         *        <p>
         *        Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in
         *        seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").
         *        </p>
         *        <p>
         *        UI name: <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-definitions.html#service-level"
         *        >Service level X</a>
         *        </p>
         *        </dd>
         * @see HistoricalMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HistoricalMetricName
         */
        Builder name(HistoricalMetricName name);

        /**
         * <p>
         * The threshold for the metric, used with service level metrics.
         * </p>
         * 
         * @param threshold
         *        The threshold for the metric, used with service level metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Threshold threshold);

        /**
         * <p>
         * The threshold for the metric, used with service level metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link Threshold.Builder} avoiding the need to
         * create one manually via {@link Threshold#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Threshold.Builder#build()} is called immediately and its result
         * is passed to {@link #threshold(Threshold)}.
         * 
         * @param threshold
         *        a consumer that will call methods on {@link Threshold.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threshold(Threshold)
         */
        default Builder threshold(Consumer<Threshold.Builder> threshold) {
            return threshold(Threshold.builder().applyMutation(threshold).build());
        }

        /**
         * <p>
         * The statistic for the metric.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(String statistic);

        /**
         * <p>
         * The statistic for the metric.
         * </p>
         * 
         * @param statistic
         *        The statistic for the metric.
         * @see Statistic
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Statistic
         */
        Builder statistic(Statistic statistic);

        /**
         * <p>
         * The unit for the metric.
         * </p>
         * 
         * @param unit
         *        The unit for the metric.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(String unit);

        /**
         * <p>
         * The unit for the metric.
         * </p>
         * 
         * @param unit
         *        The unit for the metric.
         * @see Unit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Unit
         */
        Builder unit(Unit unit);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Threshold threshold;

        private String statistic;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(HistoricalMetric model) {
            name(model.name);
            threshold(model.threshold);
            statistic(model.statistic);
            unit(model.unit);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(HistoricalMetricName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Threshold.Builder getThreshold() {
            return threshold != null ? threshold.toBuilder() : null;
        }

        public final void setThreshold(Threshold.BuilderImpl threshold) {
            this.threshold = threshold != null ? threshold.build() : null;
        }

        @Override
        public final Builder threshold(Threshold threshold) {
            this.threshold = threshold;
            return this;
        }

        public final String getStatistic() {
            return statistic;
        }

        public final void setStatistic(String statistic) {
            this.statistic = statistic;
        }

        @Override
        public final Builder statistic(String statistic) {
            this.statistic = statistic;
            return this;
        }

        @Override
        public final Builder statistic(Statistic statistic) {
            this.statistic(statistic == null ? null : statistic.toString());
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(Unit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public HistoricalMetric build() {
            return new HistoricalMetric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
