/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMetricDataV2Response extends ConnectResponse implements
        ToCopyableBuilder<GetMetricDataV2Response.Builder, GetMetricDataV2Response> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetMetricDataV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<MetricResultV2>> METRIC_RESULTS_FIELD = SdkField
            .<List<MetricResultV2>> builder(MarshallingType.LIST)
            .memberName("MetricResults")
            .getter(getter(GetMetricDataV2Response::metricResults))
            .setter(setter(Builder::metricResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricResultV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricResultV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            METRIC_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<MetricResultV2> metricResults;

    private GetMetricDataV2Response(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.metricResults = builder.metricResults;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricResults() {
        return metricResults != null && !(metricResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the metrics requested in the API request If no grouping is specified, a summary of metric data
     * is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricResults} method.
     * </p>
     * 
     * @return Information about the metrics requested in the API request If no grouping is specified, a summary of
     *         metric data is returned.
     */
    public final List<MetricResultV2> metricResults() {
        return metricResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricResults() ? metricResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataV2Response)) {
            return false;
        }
        GetMetricDataV2Response other = (GetMetricDataV2Response) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasMetricResults() == other.hasMetricResults()
                && Objects.equals(metricResults(), other.metricResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMetricDataV2Response").add("NextToken", nextToken())
                .add("MetricResults", hasMetricResults() ? metricResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MetricResults":
            return Optional.ofNullable(clazz.cast(metricResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MetricResults", METRIC_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataV2Response, T> g) {
        return obj -> g.apply((GetMetricDataV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMetricDataV2Response> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the metrics requested in the API request If no grouping is specified, a summary of metric
         * data is returned.
         * </p>
         * 
         * @param metricResults
         *        Information about the metrics requested in the API request If no grouping is specified, a summary of
         *        metric data is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricResults(Collection<MetricResultV2> metricResults);

        /**
         * <p>
         * Information about the metrics requested in the API request If no grouping is specified, a summary of metric
         * data is returned.
         * </p>
         * 
         * @param metricResults
         *        Information about the metrics requested in the API request If no grouping is specified, a summary of
         *        metric data is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricResults(MetricResultV2... metricResults);

        /**
         * <p>
         * Information about the metrics requested in the API request If no grouping is specified, a summary of metric
         * data is returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.MetricResultV2.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.MetricResultV2#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.MetricResultV2.Builder#build()} is called immediately
         * and its result is passed to {@link #metricResults(List<MetricResultV2>)}.
         * 
         * @param metricResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.MetricResultV2.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricResults(java.util.Collection<MetricResultV2>)
         */
        Builder metricResults(Consumer<MetricResultV2.Builder>... metricResults);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<MetricResultV2> metricResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataV2Response model) {
            super(model);
            nextToken(model.nextToken);
            metricResults(model.metricResults);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MetricResultV2.Builder> getMetricResults() {
            List<MetricResultV2.Builder> result = MetricResultsV2Copier.copyToBuilder(this.metricResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricResults(Collection<MetricResultV2.BuilderImpl> metricResults) {
            this.metricResults = MetricResultsV2Copier.copyFromBuilder(metricResults);
        }

        @Override
        public final Builder metricResults(Collection<MetricResultV2> metricResults) {
            this.metricResults = MetricResultsV2Copier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(MetricResultV2... metricResults) {
            metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<MetricResultV2.Builder>... metricResults) {
            metricResults(Stream.of(metricResults).map(c -> MetricResultV2.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMetricDataV2Response build() {
            return new GetMetricDataV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
