/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContactMetricsResponse extends ConnectResponse implements
        ToCopyableBuilder<GetContactMetricsResponse.Builder, GetContactMetricsResponse> {
    private static final SdkField<List<ContactMetricResult>> METRIC_RESULTS_FIELD = SdkField
            .<List<ContactMetricResult>> builder(MarshallingType.LIST)
            .memberName("MetricResults")
            .getter(getter(GetContactMetricsResponse::metricResults))
            .setter(setter(Builder::metricResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContactMetricResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContactMetricResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetContactMetricsResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetContactMetricsResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_RESULTS_FIELD,
            ID_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ContactMetricResult> metricResults;

    private final String id;

    private final String arn;

    private GetContactMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.metricResults = builder.metricResults;
        this.id = builder.id;
        this.arn = builder.arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricResults() {
        return metricResults != null && !(metricResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metric results containing the calculated values for each requested metric. Each result includes the
     * metric name and its corresponding calculated value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricResults} method.
     * </p>
     * 
     * @return A list of metric results containing the calculated values for each requested metric. Each result includes
     *         the metric name and its corresponding calculated value.
     */
    public final List<ContactMetricResult> metricResults() {
        return metricResults;
    }

    /**
     * <p>
     * The unique identifier of the contact for which metrics were retrieved.
     * </p>
     * 
     * @return The unique identifier of the contact for which metrics were retrieved.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the contact for which metrics were retrieved.
     * </p>
     * 
     * @return The ARN of the contact for which metrics were retrieved.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricResults() ? metricResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContactMetricsResponse)) {
            return false;
        }
        GetContactMetricsResponse other = (GetContactMetricsResponse) obj;
        return hasMetricResults() == other.hasMetricResults() && Objects.equals(metricResults(), other.metricResults())
                && Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContactMetricsResponse").add("MetricResults", hasMetricResults() ? metricResults() : null)
                .add("Id", id()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricResults":
            return Optional.ofNullable(clazz.cast(metricResults()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricResults", METRIC_RESULTS_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContactMetricsResponse, T> g) {
        return obj -> g.apply((GetContactMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContactMetricsResponse> {
        /**
         * <p>
         * A list of metric results containing the calculated values for each requested metric. Each result includes the
         * metric name and its corresponding calculated value.
         * </p>
         * 
         * @param metricResults
         *        A list of metric results containing the calculated values for each requested metric. Each result
         *        includes the metric name and its corresponding calculated value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricResults(Collection<ContactMetricResult> metricResults);

        /**
         * <p>
         * A list of metric results containing the calculated values for each requested metric. Each result includes the
         * metric name and its corresponding calculated value.
         * </p>
         * 
         * @param metricResults
         *        A list of metric results containing the calculated values for each requested metric. Each result
         *        includes the metric name and its corresponding calculated value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricResults(ContactMetricResult... metricResults);

        /**
         * <p>
         * A list of metric results containing the calculated values for each requested metric. Each result includes the
         * metric name and its corresponding calculated value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.ContactMetricResult.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.connect.model.ContactMetricResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.ContactMetricResult.Builder#build()} is called
         * immediately and its result is passed to {@link #metricResults(List<ContactMetricResult>)}.
         * 
         * @param metricResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.ContactMetricResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricResults(java.util.Collection<ContactMetricResult>)
         */
        Builder metricResults(Consumer<ContactMetricResult.Builder>... metricResults);

        /**
         * <p>
         * The unique identifier of the contact for which metrics were retrieved.
         * </p>
         * 
         * @param id
         *        The unique identifier of the contact for which metrics were retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the contact for which metrics were retrieved.
         * </p>
         * 
         * @param arn
         *        The ARN of the contact for which metrics were retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<ContactMetricResult> metricResults = DefaultSdkAutoConstructList.getInstance();

        private String id;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContactMetricsResponse model) {
            super(model);
            metricResults(model.metricResults);
            id(model.id);
            arn(model.arn);
        }

        public final List<ContactMetricResult.Builder> getMetricResults() {
            List<ContactMetricResult.Builder> result = ContactMetricResultsCopier.copyToBuilder(this.metricResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricResults(Collection<ContactMetricResult.BuilderImpl> metricResults) {
            this.metricResults = ContactMetricResultsCopier.copyFromBuilder(metricResults);
        }

        @Override
        public final Builder metricResults(Collection<ContactMetricResult> metricResults) {
            this.metricResults = ContactMetricResultsCopier.copy(metricResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(ContactMetricResult... metricResults) {
            metricResults(Arrays.asList(metricResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricResults(Consumer<ContactMetricResult.Builder>... metricResults) {
            metricResults(Stream.of(metricResults).map(c -> ContactMetricResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public GetContactMetricsResponse build() {
            return new GetContactMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
