/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the option range used for scoring in numeric questions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormNumericQuestionOption implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormNumericQuestionOption.Builder, EvaluationFormNumericQuestionOption> {
    private static final SdkField<Integer> MIN_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinValue").getter(getter(EvaluationFormNumericQuestionOption::minValue))
            .setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinValue").build()).build();

    private static final SdkField<Integer> MAX_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxValue").getter(getter(EvaluationFormNumericQuestionOption::maxValue))
            .setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxValue").build()).build();

    private static final SdkField<Integer> SCORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Score")
            .getter(getter(EvaluationFormNumericQuestionOption::score)).setter(setter(Builder::score))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Score").build()).build();

    private static final SdkField<Boolean> AUTOMATIC_FAIL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticFail").getter(getter(EvaluationFormNumericQuestionOption::automaticFail))
            .setter(setter(Builder::automaticFail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_VALUE_FIELD,
            MAX_VALUE_FIELD, SCORE_FIELD, AUTOMATIC_FAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minValue;

    private final Integer maxValue;

    private final Integer score;

    private final Boolean automaticFail;

    private EvaluationFormNumericQuestionOption(BuilderImpl builder) {
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.score = builder.score;
        this.automaticFail = builder.automaticFail;
    }

    /**
     * <p>
     * The minimum answer value of the range option.
     * </p>
     * 
     * @return The minimum answer value of the range option.
     */
    public final Integer minValue() {
        return minValue;
    }

    /**
     * <p>
     * The maximum answer value of the range option.
     * </p>
     * 
     * @return The maximum answer value of the range option.
     */
    public final Integer maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * The score assigned to answer values within the range option.
     * </p>
     * 
     * @return The score assigned to answer values within the range option.
     */
    public final Integer score() {
        return score;
    }

    /**
     * <p>
     * The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall evaluation
     * gets a score of 0.
     * </p>
     * 
     * @return The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall
     *         evaluation gets a score of 0.
     */
    public final Boolean automaticFail() {
        return automaticFail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(score());
        hashCode = 31 * hashCode + Objects.hashCode(automaticFail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormNumericQuestionOption)) {
            return false;
        }
        EvaluationFormNumericQuestionOption other = (EvaluationFormNumericQuestionOption) obj;
        return Objects.equals(minValue(), other.minValue()) && Objects.equals(maxValue(), other.maxValue())
                && Objects.equals(score(), other.score()) && Objects.equals(automaticFail(), other.automaticFail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormNumericQuestionOption").add("MinValue", minValue()).add("MaxValue", maxValue())
                .add("Score", score()).add("AutomaticFail", automaticFail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "Score":
            return Optional.ofNullable(clazz.cast(score()));
        case "AutomaticFail":
            return Optional.ofNullable(clazz.cast(automaticFail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinValue", MIN_VALUE_FIELD);
        map.put("MaxValue", MAX_VALUE_FIELD);
        map.put("Score", SCORE_FIELD);
        map.put("AutomaticFail", AUTOMATIC_FAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormNumericQuestionOption, T> g) {
        return obj -> g.apply((EvaluationFormNumericQuestionOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormNumericQuestionOption> {
        /**
         * <p>
         * The minimum answer value of the range option.
         * </p>
         * 
         * @param minValue
         *        The minimum answer value of the range option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Integer minValue);

        /**
         * <p>
         * The maximum answer value of the range option.
         * </p>
         * 
         * @param maxValue
         *        The maximum answer value of the range option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Integer maxValue);

        /**
         * <p>
         * The score assigned to answer values within the range option.
         * </p>
         * 
         * @param score
         *        The score assigned to answer values within the range option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder score(Integer score);

        /**
         * <p>
         * The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall
         * evaluation gets a score of 0.
         * </p>
         * 
         * @param automaticFail
         *        The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall
         *        evaluation gets a score of 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticFail(Boolean automaticFail);
    }

    static final class BuilderImpl implements Builder {
        private Integer minValue;

        private Integer maxValue;

        private Integer score;

        private Boolean automaticFail;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormNumericQuestionOption model) {
            minValue(model.minValue);
            maxValue(model.maxValue);
            score(model.score);
            automaticFail(model.automaticFail);
        }

        public final Integer getMinValue() {
            return minValue;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Integer getMaxValue() {
            return maxValue;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final Integer getScore() {
            return score;
        }

        public final void setScore(Integer score) {
            this.score = score;
        }

        @Override
        public final Builder score(Integer score) {
            this.score = score;
            return this;
        }

        public final Boolean getAutomaticFail() {
            return automaticFail;
        }

        public final void setAutomaticFail(Boolean automaticFail) {
            this.automaticFail = automaticFail;
        }

        @Override
        public final Builder automaticFail(Boolean automaticFail) {
            this.automaticFail = automaticFail;
            return this;
        }

        @Override
        public EvaluationFormNumericQuestionOption build() {
            return new EvaluationFormNumericQuestionOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
