/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a contact evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Evaluation implements SdkPojo, Serializable, ToCopyableBuilder<Evaluation.Builder, Evaluation> {
    private static final SdkField<String> EVALUATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationId").getter(getter(Evaluation::evaluationId)).setter(setter(Builder::evaluationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationId").build()).build();

    private static final SdkField<String> EVALUATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EvaluationArn").getter(getter(Evaluation::evaluationArn)).setter(setter(Builder::evaluationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationArn").build()).build();

    private static final SdkField<EvaluationMetadata> METADATA_FIELD = SdkField
            .<EvaluationMetadata> builder(MarshallingType.SDK_POJO).memberName("Metadata").getter(getter(Evaluation::metadata))
            .setter(setter(Builder::metadata)).constructor(EvaluationMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<Map<String, EvaluationAnswerOutput>> ANSWERS_FIELD = SdkField
            .<Map<String, EvaluationAnswerOutput>> builder(MarshallingType.MAP)
            .memberName("Answers")
            .getter(getter(Evaluation::answers))
            .setter(setter(Builder::answers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Answers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EvaluationAnswerOutput> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationAnswerOutput::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, EvaluationNote>> NOTES_FIELD = SdkField
            .<Map<String, EvaluationNote>> builder(MarshallingType.MAP)
            .memberName("Notes")
            .getter(getter(Evaluation::notes))
            .setter(setter(Builder::notes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EvaluationNote> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationNote::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Evaluation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, EvaluationScore>> SCORES_FIELD = SdkField
            .<Map<String, EvaluationScore>> builder(MarshallingType.MAP)
            .memberName("Scores")
            .getter(getter(Evaluation::scores))
            .setter(setter(Builder::scores))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scores").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<EvaluationScore> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationScore::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Evaluation::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(Evaluation::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(Evaluation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_ID_FIELD,
            EVALUATION_ARN_FIELD, METADATA_FIELD, ANSWERS_FIELD, NOTES_FIELD, STATUS_FIELD, SCORES_FIELD, CREATED_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String evaluationId;

    private final String evaluationArn;

    private final EvaluationMetadata metadata;

    private final Map<String, EvaluationAnswerOutput> answers;

    private final Map<String, EvaluationNote> notes;

    private final String status;

    private final Map<String, EvaluationScore> scores;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final Map<String, String> tags;

    private Evaluation(BuilderImpl builder) {
        this.evaluationId = builder.evaluationId;
        this.evaluationArn = builder.evaluationArn;
        this.metadata = builder.metadata;
        this.answers = builder.answers;
        this.notes = builder.notes;
        this.status = builder.status;
        this.scores = builder.scores;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique identifier for the contact evaluation.
     * </p>
     * 
     * @return A unique identifier for the contact evaluation.
     */
    public final String evaluationId() {
        return evaluationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the contact evaluation resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the contact evaluation resource.
     */
    public final String evaluationArn() {
        return evaluationArn;
    }

    /**
     * <p>
     * Metadata about the contact evaluation.
     * </p>
     * 
     * @return Metadata about the contact evaluation.
     */
    public final EvaluationMetadata metadata() {
        return metadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the Answers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAnswers() {
        return answers != null && !(answers instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of question identifiers to answer value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnswers} method.
     * </p>
     * 
     * @return A map of question identifiers to answer value.
     */
    public final Map<String, EvaluationAnswerOutput> answers() {
        return answers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notes property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNotes() {
        return notes != null && !(notes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of question identifiers to note value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotes} method.
     * </p>
     * 
     * @return A map of question identifiers to note value.
     */
    public final Map<String, EvaluationNote> notes() {
        return notes;
    }

    /**
     * <p>
     * The status of the contact evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the contact evaluation.
     * @see EvaluationStatus
     */
    public final EvaluationStatus status() {
        return EvaluationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the contact evaluation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link EvaluationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the contact evaluation.
     * @see EvaluationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Scores property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasScores() {
        return scores != null && !(scores instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of item (section or question) identifiers to score value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScores} method.
     * </p>
     * 
     * @return A map of item (section or question) identifiers to score value.
     */
    public final Map<String, EvaluationScore> scores() {
        return scores;
    }

    /**
     * <p>
     * The timestamp for when the evaluation was created.
     * </p>
     * 
     * @return The timestamp for when the evaluation was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The timestamp for when the evaluation was last updated.
     * </p>
     * 
     * @return The timestamp for when the evaluation was last updated.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "Tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(evaluationId());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationArn());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasAnswers() ? answers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotes() ? notes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasScores() ? scores() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Evaluation)) {
            return false;
        }
        Evaluation other = (Evaluation) obj;
        return Objects.equals(evaluationId(), other.evaluationId()) && Objects.equals(evaluationArn(), other.evaluationArn())
                && Objects.equals(metadata(), other.metadata()) && hasAnswers() == other.hasAnswers()
                && Objects.equals(answers(), other.answers()) && hasNotes() == other.hasNotes()
                && Objects.equals(notes(), other.notes()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasScores() == other.hasScores() && Objects.equals(scores(), other.scores())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Evaluation").add("EvaluationId", evaluationId()).add("EvaluationArn", evaluationArn())
                .add("Metadata", metadata()).add("Answers", hasAnswers() ? answers() : null)
                .add("Notes", hasNotes() ? notes() : null).add("Status", statusAsString())
                .add("Scores", hasScores() ? scores() : null).add("CreatedTime", createdTime())
                .add("LastModifiedTime", lastModifiedTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EvaluationId":
            return Optional.ofNullable(clazz.cast(evaluationId()));
        case "EvaluationArn":
            return Optional.ofNullable(clazz.cast(evaluationArn()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "Answers":
            return Optional.ofNullable(clazz.cast(answers()));
        case "Notes":
            return Optional.ofNullable(clazz.cast(notes()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Scores":
            return Optional.ofNullable(clazz.cast(scores()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EvaluationId", EVALUATION_ID_FIELD);
        map.put("EvaluationArn", EVALUATION_ARN_FIELD);
        map.put("Metadata", METADATA_FIELD);
        map.put("Answers", ANSWERS_FIELD);
        map.put("Notes", NOTES_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Scores", SCORES_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Evaluation, T> g) {
        return obj -> g.apply((Evaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Evaluation> {
        /**
         * <p>
         * A unique identifier for the contact evaluation.
         * </p>
         * 
         * @param evaluationId
         *        A unique identifier for the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationId(String evaluationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the contact evaluation resource.
         * </p>
         * 
         * @param evaluationArn
         *        The Amazon Resource Name (ARN) for the contact evaluation resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationArn(String evaluationArn);

        /**
         * <p>
         * Metadata about the contact evaluation.
         * </p>
         * 
         * @param metadata
         *        Metadata about the contact evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(EvaluationMetadata metadata);

        /**
         * <p>
         * Metadata about the contact evaluation.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationMetadata.Builder} avoiding the
         * need to create one manually via {@link EvaluationMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(EvaluationMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link EvaluationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(EvaluationMetadata)
         */
        default Builder metadata(Consumer<EvaluationMetadata.Builder> metadata) {
            return metadata(EvaluationMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * A map of question identifiers to answer value.
         * </p>
         * 
         * @param answers
         *        A map of question identifiers to answer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder answers(Map<String, EvaluationAnswerOutput> answers);

        /**
         * <p>
         * A map of question identifiers to note value.
         * </p>
         * 
         * @param notes
         *        A map of question identifiers to note value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notes(Map<String, EvaluationNote> notes);

        /**
         * <p>
         * The status of the contact evaluation.
         * </p>
         * 
         * @param status
         *        The status of the contact evaluation.
         * @see EvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the contact evaluation.
         * </p>
         * 
         * @param status
         *        The status of the contact evaluation.
         * @see EvaluationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationStatus
         */
        Builder status(EvaluationStatus status);

        /**
         * <p>
         * A map of item (section or question) identifiers to score value.
         * </p>
         * 
         * @param scores
         *        A map of item (section or question) identifiers to score value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scores(Map<String, EvaluationScore> scores);

        /**
         * <p>
         * The timestamp for when the evaluation was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp for when the evaluation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The timestamp for when the evaluation was last updated.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp for when the evaluation was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "Tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "Tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String evaluationId;

        private String evaluationArn;

        private EvaluationMetadata metadata;

        private Map<String, EvaluationAnswerOutput> answers = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, EvaluationNote> notes = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private Map<String, EvaluationScore> scores = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdTime;

        private Instant lastModifiedTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Evaluation model) {
            evaluationId(model.evaluationId);
            evaluationArn(model.evaluationArn);
            metadata(model.metadata);
            answers(model.answers);
            notes(model.notes);
            status(model.status);
            scores(model.scores);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            tags(model.tags);
        }

        public final String getEvaluationId() {
            return evaluationId;
        }

        public final void setEvaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
        }

        @Override
        public final Builder evaluationId(String evaluationId) {
            this.evaluationId = evaluationId;
            return this;
        }

        public final String getEvaluationArn() {
            return evaluationArn;
        }

        public final void setEvaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
        }

        @Override
        public final Builder evaluationArn(String evaluationArn) {
            this.evaluationArn = evaluationArn;
            return this;
        }

        public final EvaluationMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(EvaluationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EvaluationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Map<String, EvaluationAnswerOutput.Builder> getAnswers() {
            Map<String, EvaluationAnswerOutput.Builder> result = EvaluationAnswersOutputMapCopier.copyToBuilder(this.answers);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAnswers(Map<String, EvaluationAnswerOutput.BuilderImpl> answers) {
            this.answers = EvaluationAnswersOutputMapCopier.copyFromBuilder(answers);
        }

        @Override
        public final Builder answers(Map<String, EvaluationAnswerOutput> answers) {
            this.answers = EvaluationAnswersOutputMapCopier.copy(answers);
            return this;
        }

        public final Map<String, EvaluationNote.Builder> getNotes() {
            Map<String, EvaluationNote.Builder> result = EvaluationNotesMapCopier.copyToBuilder(this.notes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setNotes(Map<String, EvaluationNote.BuilderImpl> notes) {
            this.notes = EvaluationNotesMapCopier.copyFromBuilder(notes);
        }

        @Override
        public final Builder notes(Map<String, EvaluationNote> notes) {
            this.notes = EvaluationNotesMapCopier.copy(notes);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EvaluationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, EvaluationScore.Builder> getScores() {
            Map<String, EvaluationScore.Builder> result = EvaluationScoresMapCopier.copyToBuilder(this.scores);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setScores(Map<String, EvaluationScore.BuilderImpl> scores) {
            this.scores = EvaluationScoresMapCopier.copyFromBuilder(scores);
        }

        @Override
        public final Builder scores(Map<String, EvaluationScore> scores) {
            this.scores = EvaluationScoresMapCopier.copy(scores);
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Evaluation build() {
            return new Evaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
