/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the call disconnect experience.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisconnectDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DisconnectDetails.Builder, DisconnectDetails> {
    private static final SdkField<String> POTENTIAL_DISCONNECT_ISSUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PotentialDisconnectIssue").getter(getter(DisconnectDetails::potentialDisconnectIssue))
            .setter(setter(Builder::potentialDisconnectIssue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PotentialDisconnectIssue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(POTENTIAL_DISCONNECT_ISSUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String potentialDisconnectIssue;

    private DisconnectDetails(BuilderImpl builder) {
        this.potentialDisconnectIssue = builder.potentialDisconnectIssue;
    }

    /**
     * <p>
     * Indicates the potential disconnection issues for a call. This field is not populated if the service does not
     * detect potential issues.
     * </p>
     * 
     * @return Indicates the potential disconnection issues for a call. This field is not populated if the service does
     *         not detect potential issues.
     */
    public final String potentialDisconnectIssue() {
        return potentialDisconnectIssue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(potentialDisconnectIssue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisconnectDetails)) {
            return false;
        }
        DisconnectDetails other = (DisconnectDetails) obj;
        return Objects.equals(potentialDisconnectIssue(), other.potentialDisconnectIssue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisconnectDetails").add("PotentialDisconnectIssue", potentialDisconnectIssue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PotentialDisconnectIssue":
            return Optional.ofNullable(clazz.cast(potentialDisconnectIssue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PotentialDisconnectIssue", POTENTIAL_DISCONNECT_ISSUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisconnectDetails, T> g) {
        return obj -> g.apply((DisconnectDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DisconnectDetails> {
        /**
         * <p>
         * Indicates the potential disconnection issues for a call. This field is not populated if the service does not
         * detect potential issues.
         * </p>
         * 
         * @param potentialDisconnectIssue
         *        Indicates the potential disconnection issues for a call. This field is not populated if the service
         *        does not detect potential issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder potentialDisconnectIssue(String potentialDisconnectIssue);
    }

    static final class BuilderImpl implements Builder {
        private String potentialDisconnectIssue;

        private BuilderImpl() {
        }

        private BuilderImpl(DisconnectDetails model) {
            potentialDisconnectIssue(model.potentialDisconnectIssue);
        }

        public final String getPotentialDisconnectIssue() {
            return potentialDisconnectIssue;
        }

        public final void setPotentialDisconnectIssue(String potentialDisconnectIssue) {
            this.potentialDisconnectIssue = potentialDisconnectIssue;
        }

        @Override
        public final Builder potentialDisconnectIssue(String potentialDisconnectIssue) {
            this.potentialDisconnectIssue = potentialDisconnectIssue;
            return this;
        }

        @Override
        public DisconnectDetails build() {
            return new DisconnectDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
