/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeContactEvaluationResponse extends ConnectResponse implements
        ToCopyableBuilder<DescribeContactEvaluationResponse.Builder, DescribeContactEvaluationResponse> {
    private static final SdkField<Evaluation> EVALUATION_FIELD = SdkField.<Evaluation> builder(MarshallingType.SDK_POJO)
            .memberName("Evaluation").getter(getter(DescribeContactEvaluationResponse::evaluation))
            .setter(setter(Builder::evaluation)).constructor(Evaluation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Evaluation").build()).build();

    private static final SdkField<EvaluationFormContent> EVALUATION_FORM_FIELD = SdkField
            .<EvaluationFormContent> builder(MarshallingType.SDK_POJO).memberName("EvaluationForm")
            .getter(getter(DescribeContactEvaluationResponse::evaluationForm)).setter(setter(Builder::evaluationForm))
            .constructor(EvaluationFormContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationForm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_FIELD,
            EVALUATION_FORM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Evaluation evaluation;

    private final EvaluationFormContent evaluationForm;

    private DescribeContactEvaluationResponse(BuilderImpl builder) {
        super(builder);
        this.evaluation = builder.evaluation;
        this.evaluationForm = builder.evaluationForm;
    }

    /**
     * <p>
     * Information about the evaluation form completed for a specific contact.
     * </p>
     * 
     * @return Information about the evaluation form completed for a specific contact.
     */
    public final Evaluation evaluation() {
        return evaluation;
    }

    /**
     * <p>
     * Information about the evaluation form.
     * </p>
     * 
     * @return Information about the evaluation form.
     */
    public final EvaluationFormContent evaluationForm() {
        return evaluationForm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evaluation());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationForm());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeContactEvaluationResponse)) {
            return false;
        }
        DescribeContactEvaluationResponse other = (DescribeContactEvaluationResponse) obj;
        return Objects.equals(evaluation(), other.evaluation()) && Objects.equals(evaluationForm(), other.evaluationForm());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeContactEvaluationResponse").add("Evaluation", evaluation())
                .add("EvaluationForm", evaluationForm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Evaluation":
            return Optional.ofNullable(clazz.cast(evaluation()));
        case "EvaluationForm":
            return Optional.ofNullable(clazz.cast(evaluationForm()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Evaluation", EVALUATION_FIELD);
        map.put("EvaluationForm", EVALUATION_FORM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeContactEvaluationResponse, T> g) {
        return obj -> g.apply((DescribeContactEvaluationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeContactEvaluationResponse> {
        /**
         * <p>
         * Information about the evaluation form completed for a specific contact.
         * </p>
         * 
         * @param evaluation
         *        Information about the evaluation form completed for a specific contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluation(Evaluation evaluation);

        /**
         * <p>
         * Information about the evaluation form completed for a specific contact.
         * </p>
         * This is a convenience method that creates an instance of the {@link Evaluation.Builder} avoiding the need to
         * create one manually via {@link Evaluation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Evaluation.Builder#build()} is called immediately and its result
         * is passed to {@link #evaluation(Evaluation)}.
         * 
         * @param evaluation
         *        a consumer that will call methods on {@link Evaluation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluation(Evaluation)
         */
        default Builder evaluation(Consumer<Evaluation.Builder> evaluation) {
            return evaluation(Evaluation.builder().applyMutation(evaluation).build());
        }

        /**
         * <p>
         * Information about the evaluation form.
         * </p>
         * 
         * @param evaluationForm
         *        Information about the evaluation form.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationForm(EvaluationFormContent evaluationForm);

        /**
         * <p>
         * Information about the evaluation form.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationFormContent.Builder} avoiding
         * the need to create one manually via {@link EvaluationFormContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationFormContent.Builder#build()} is called immediately and
         * its result is passed to {@link #evaluationForm(EvaluationFormContent)}.
         * 
         * @param evaluationForm
         *        a consumer that will call methods on {@link EvaluationFormContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #evaluationForm(EvaluationFormContent)
         */
        default Builder evaluationForm(Consumer<EvaluationFormContent.Builder> evaluationForm) {
            return evaluationForm(EvaluationFormContent.builder().applyMutation(evaluationForm).build());
        }
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private Evaluation evaluation;

        private EvaluationFormContent evaluationForm;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeContactEvaluationResponse model) {
            super(model);
            evaluation(model.evaluation);
            evaluationForm(model.evaluationForm);
        }

        public final Evaluation.Builder getEvaluation() {
            return evaluation != null ? evaluation.toBuilder() : null;
        }

        public final void setEvaluation(Evaluation.BuilderImpl evaluation) {
            this.evaluation = evaluation != null ? evaluation.build() : null;
        }

        @Override
        public final Builder evaluation(Evaluation evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        public final EvaluationFormContent.Builder getEvaluationForm() {
            return evaluationForm != null ? evaluationForm.toBuilder() : null;
        }

        public final void setEvaluationForm(EvaluationFormContent.BuilderImpl evaluationForm) {
            this.evaluationForm = evaluationForm != null ? evaluationForm.build() : null;
        }

        @Override
        public final Builder evaluationForm(EvaluationFormContent evaluationForm) {
            this.evaluationForm = evaluationForm;
            return this;
        }

        @Override
        public DescribeContactEvaluationResponse build() {
            return new DescribeContactEvaluationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
