/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object to specify the hours of operation override date condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateCondition implements SdkPojo, Serializable, ToCopyableBuilder<DateCondition.Builder, DateCondition> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(DateCondition::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(DateCondition::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> COMPARISON_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonType").getter(getter(DateCondition::comparisonTypeAsString))
            .setter(setter(Builder::comparisonType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, VALUE_FIELD,
            COMPARISON_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String value;

    private final String comparisonType;

    private DateCondition(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.value = builder.value;
        this.comparisonType = builder.comparisonType;
    }

    /**
     * <p>
     * An object to specify the hours of operation override date field.
     * </p>
     * 
     * @return An object to specify the hours of operation override date field.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * An object to specify the hours of operation override date value.
     * </p>
     * 
     * @return An object to specify the hours of operation override date value.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * An object to specify the hours of operation override date condition <code>comparisonType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link DateComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return An object to specify the hours of operation override date condition <code>comparisonType</code>.
     * @see DateComparisonType
     */
    public final DateComparisonType comparisonType() {
        return DateComparisonType.fromValue(comparisonType);
    }

    /**
     * <p>
     * An object to specify the hours of operation override date condition <code>comparisonType</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonType}
     * will return {@link DateComparisonType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #comparisonTypeAsString}.
     * </p>
     * 
     * @return An object to specify the hours of operation override date condition <code>comparisonType</code>.
     * @see DateComparisonType
     */
    public final String comparisonTypeAsString() {
        return comparisonType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateCondition)) {
            return false;
        }
        DateCondition other = (DateCondition) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(value(), other.value())
                && Objects.equals(comparisonTypeAsString(), other.comparisonTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateCondition").add("FieldName", fieldName()).add("Value", value())
                .add("ComparisonType", comparisonTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "ComparisonType":
            return Optional.ofNullable(clazz.cast(comparisonTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("Value", VALUE_FIELD);
        map.put("ComparisonType", COMPARISON_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DateCondition, T> g) {
        return obj -> g.apply((DateCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateCondition> {
        /**
         * <p>
         * An object to specify the hours of operation override date field.
         * </p>
         * 
         * @param fieldName
         *        An object to specify the hours of operation override date field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * An object to specify the hours of operation override date value.
         * </p>
         * 
         * @param value
         *        An object to specify the hours of operation override date value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * An object to specify the hours of operation override date condition <code>comparisonType</code>.
         * </p>
         * 
         * @param comparisonType
         *        An object to specify the hours of operation override date condition <code>comparisonType</code>.
         * @see DateComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DateComparisonType
         */
        Builder comparisonType(String comparisonType);

        /**
         * <p>
         * An object to specify the hours of operation override date condition <code>comparisonType</code>.
         * </p>
         * 
         * @param comparisonType
         *        An object to specify the hours of operation override date condition <code>comparisonType</code>.
         * @see DateComparisonType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DateComparisonType
         */
        Builder comparisonType(DateComparisonType comparisonType);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String value;

        private String comparisonType;

        private BuilderImpl() {
        }

        private BuilderImpl(DateCondition model) {
            fieldName(model.fieldName);
            value(model.value);
            comparisonType(model.comparisonType);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getComparisonType() {
            return comparisonType;
        }

        public final void setComparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
        }

        @Override
        public final Builder comparisonType(String comparisonType) {
            this.comparisonType = comparisonType;
            return this;
        }

        @Override
        public final Builder comparisonType(DateComparisonType comparisonType) {
            this.comparisonType(comparisonType == null ? null : comparisonType.toString());
            return this;
        }

        @Override
        public DateCondition build() {
            return new DateCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
