/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The way to sort the resulting response based on metrics. By default resources are sorted based on
 * <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric collection is sorted based on the input metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrentMetricSortCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<CurrentMetricSortCriteria.Builder, CurrentMetricSortCriteria> {
    private static final SdkField<String> SORT_BY_METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortByMetric").getter(getter(CurrentMetricSortCriteria::sortByMetricAsString))
            .setter(setter(Builder::sortByMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortByMetric").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(CurrentMetricSortCriteria::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_METRIC_FIELD,
            SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sortByMetric;

    private final String sortOrder;

    private CurrentMetricSortCriteria(BuilderImpl builder) {
        this.sortByMetric = builder.sortByMetric;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * Returns the value of the SortByMetric property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortByMetric} will
     * return {@link CurrentMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByMetricAsString}.
     * </p>
     * 
     * @return The value of the SortByMetric property for this object.
     * @see CurrentMetricName
     */
    public final CurrentMetricName sortByMetric() {
        return CurrentMetricName.fromValue(sortByMetric);
    }

    /**
     * Returns the value of the SortByMetric property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortByMetric} will
     * return {@link CurrentMetricName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByMetricAsString}.
     * </p>
     * 
     * @return The value of the SortByMetric property for this object.
     * @see CurrentMetricName
     */
    public final String sortByMetricAsString() {
        return sortByMetric;
    }

    /**
     * <p>
     * The way to sort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The way to sort.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The way to sort.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The way to sort.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sortByMetricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentMetricSortCriteria)) {
            return false;
        }
        CurrentMetricSortCriteria other = (CurrentMetricSortCriteria) obj;
        return Objects.equals(sortByMetricAsString(), other.sortByMetricAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CurrentMetricSortCriteria").add("SortByMetric", sortByMetricAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SortByMetric":
            return Optional.ofNullable(clazz.cast(sortByMetricAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SortByMetric", SORT_BY_METRIC_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CurrentMetricSortCriteria, T> g) {
        return obj -> g.apply((CurrentMetricSortCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrentMetricSortCriteria> {
        /**
         * Sets the value of the SortByMetric property for this object.
         *
         * @param sortByMetric
         *        The new value for the SortByMetric property for this object.
         * @see CurrentMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrentMetricName
         */
        Builder sortByMetric(String sortByMetric);

        /**
         * Sets the value of the SortByMetric property for this object.
         *
         * @param sortByMetric
         *        The new value for the SortByMetric property for this object.
         * @see CurrentMetricName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CurrentMetricName
         */
        Builder sortByMetric(CurrentMetricName sortByMetric);

        /**
         * <p>
         * The way to sort.
         * </p>
         * 
         * @param sortOrder
         *        The way to sort.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The way to sort.
         * </p>
         * 
         * @param sortOrder
         *        The way to sort.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String sortByMetric;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentMetricSortCriteria model) {
            sortByMetric(model.sortByMetric);
            sortOrder(model.sortOrder);
        }

        public final String getSortByMetric() {
            return sortByMetric;
        }

        public final void setSortByMetric(String sortByMetric) {
            this.sortByMetric = sortByMetric;
        }

        @Override
        public final Builder sortByMetric(String sortByMetric) {
            this.sortByMetric = sortByMetric;
            return this;
        }

        @Override
        public final Builder sortByMetric(CurrentMetricName sortByMetric) {
            this.sortByMetric(sortByMetric == null ? null : sortByMetric.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public CurrentMetricSortCriteria build() {
            return new CurrentMetricSortCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
