/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserHierarchyGroupResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateUserHierarchyGroupResponse.Builder, CreateUserHierarchyGroupResponse> {
    private static final SdkField<String> HIERARCHY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HierarchyGroupId").getter(getter(CreateUserHierarchyGroupResponse::hierarchyGroupId))
            .setter(setter(Builder::hierarchyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupId").build()).build();

    private static final SdkField<String> HIERARCHY_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HierarchyGroupArn").getter(getter(CreateUserHierarchyGroupResponse::hierarchyGroupArn))
            .setter(setter(Builder::hierarchyGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HierarchyGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIERARCHY_GROUP_ID_FIELD,
            HIERARCHY_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hierarchyGroupId;

    private final String hierarchyGroupArn;

    private CreateUserHierarchyGroupResponse(BuilderImpl builder) {
        super(builder);
        this.hierarchyGroupId = builder.hierarchyGroupId;
        this.hierarchyGroupArn = builder.hierarchyGroupArn;
    }

    /**
     * <p>
     * The identifier of the hierarchy group.
     * </p>
     * 
     * @return The identifier of the hierarchy group.
     */
    public final String hierarchyGroupId() {
        return hierarchyGroupId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hierarchy group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hierarchy group.
     */
    public final String hierarchyGroupArn() {
        return hierarchyGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(hierarchyGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserHierarchyGroupResponse)) {
            return false;
        }
        CreateUserHierarchyGroupResponse other = (CreateUserHierarchyGroupResponse) obj;
        return Objects.equals(hierarchyGroupId(), other.hierarchyGroupId())
                && Objects.equals(hierarchyGroupArn(), other.hierarchyGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserHierarchyGroupResponse").add("HierarchyGroupId", hierarchyGroupId())
                .add("HierarchyGroupArn", hierarchyGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HierarchyGroupId":
            return Optional.ofNullable(clazz.cast(hierarchyGroupId()));
        case "HierarchyGroupArn":
            return Optional.ofNullable(clazz.cast(hierarchyGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HierarchyGroupId", HIERARCHY_GROUP_ID_FIELD);
        map.put("HierarchyGroupArn", HIERARCHY_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserHierarchyGroupResponse, T> g) {
        return obj -> g.apply((CreateUserHierarchyGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserHierarchyGroupResponse> {
        /**
         * <p>
         * The identifier of the hierarchy group.
         * </p>
         * 
         * @param hierarchyGroupId
         *        The identifier of the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroupId(String hierarchyGroupId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hierarchy group.
         * </p>
         * 
         * @param hierarchyGroupArn
         *        The Amazon Resource Name (ARN) of the hierarchy group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hierarchyGroupArn(String hierarchyGroupArn);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String hierarchyGroupId;

        private String hierarchyGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserHierarchyGroupResponse model) {
            super(model);
            hierarchyGroupId(model.hierarchyGroupId);
            hierarchyGroupArn(model.hierarchyGroupArn);
        }

        public final String getHierarchyGroupId() {
            return hierarchyGroupId;
        }

        public final void setHierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
        }

        @Override
        public final Builder hierarchyGroupId(String hierarchyGroupId) {
            this.hierarchyGroupId = hierarchyGroupId;
            return this;
        }

        public final String getHierarchyGroupArn() {
            return hierarchyGroupArn;
        }

        public final void setHierarchyGroupArn(String hierarchyGroupArn) {
            this.hierarchyGroupArn = hierarchyGroupArn;
        }

        @Override
        public final Builder hierarchyGroupArn(String hierarchyGroupArn) {
            this.hierarchyGroupArn = hierarchyGroupArn;
            return this;
        }

        @Override
        public CreateUserHierarchyGroupResponse build() {
            return new CreateUserHierarchyGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
