/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntegrationAssociationResponse extends ConnectResponse implements
        ToCopyableBuilder<CreateIntegrationAssociationResponse.Builder, CreateIntegrationAssociationResponse> {
    private static final SdkField<String> INTEGRATION_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationAssociationId")
            .getter(getter(CreateIntegrationAssociationResponse::integrationAssociationId))
            .setter(setter(Builder::integrationAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationId").build())
            .build();

    private static final SdkField<String> INTEGRATION_ASSOCIATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationAssociationArn")
            .getter(getter(CreateIntegrationAssociationResponse::integrationAssociationArn))
            .setter(setter(Builder::integrationAssociationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegrationAssociationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTEGRATION_ASSOCIATION_ID_FIELD, INTEGRATION_ASSOCIATION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String integrationAssociationId;

    private final String integrationAssociationArn;

    private CreateIntegrationAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.integrationAssociationId = builder.integrationAssociationId;
        this.integrationAssociationArn = builder.integrationAssociationArn;
    }

    /**
     * <p>
     * The identifier for the integration association.
     * </p>
     * 
     * @return The identifier for the integration association.
     */
    public final String integrationAssociationId() {
        return integrationAssociationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the association.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the association.
     */
    public final String integrationAssociationArn() {
        return integrationAssociationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(integrationAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationAssociationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntegrationAssociationResponse)) {
            return false;
        }
        CreateIntegrationAssociationResponse other = (CreateIntegrationAssociationResponse) obj;
        return Objects.equals(integrationAssociationId(), other.integrationAssociationId())
                && Objects.equals(integrationAssociationArn(), other.integrationAssociationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIntegrationAssociationResponse")
                .add("IntegrationAssociationId", integrationAssociationId())
                .add("IntegrationAssociationArn", integrationAssociationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IntegrationAssociationId":
            return Optional.ofNullable(clazz.cast(integrationAssociationId()));
        case "IntegrationAssociationArn":
            return Optional.ofNullable(clazz.cast(integrationAssociationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IntegrationAssociationId", INTEGRATION_ASSOCIATION_ID_FIELD);
        map.put("IntegrationAssociationArn", INTEGRATION_ASSOCIATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntegrationAssociationResponse, T> g) {
        return obj -> g.apply((CreateIntegrationAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIntegrationAssociationResponse> {
        /**
         * <p>
         * The identifier for the integration association.
         * </p>
         * 
         * @param integrationAssociationId
         *        The identifier for the integration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationId(String integrationAssociationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the association.
         * </p>
         * 
         * @param integrationAssociationArn
         *        The Amazon Resource Name (ARN) for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationArn(String integrationAssociationArn);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private String integrationAssociationId;

        private String integrationAssociationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntegrationAssociationResponse model) {
            super(model);
            integrationAssociationId(model.integrationAssociationId);
            integrationAssociationArn(model.integrationAssociationArn);
        }

        public final String getIntegrationAssociationId() {
            return integrationAssociationId;
        }

        public final void setIntegrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
        }

        @Override
        public final Builder integrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
            return this;
        }

        public final String getIntegrationAssociationArn() {
            return integrationAssociationArn;
        }

        public final void setIntegrationAssociationArn(String integrationAssociationArn) {
            this.integrationAssociationArn = integrationAssociationArn;
        }

        @Override
        public final Builder integrationAssociationArn(String integrationAssociationArn) {
            this.integrationAssociationArn = integrationAssociationArn;
            return this;
        }

        @Override
        public CreateIntegrationAssociationResponse build() {
            return new CreateIntegrationAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
