/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of a segment attribute. This is structured as a map with a single key-value pair. The key 'valueString'
 * indicates that the attribute type is a string, and its corresponding value is the actual string value of the segment
 * attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactSearchSummarySegmentAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactSearchSummarySegmentAttributeValue.Builder, ContactSearchSummarySegmentAttributeValue> {
    private static final SdkField<String> VALUE_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ValueString").getter(getter(ContactSearchSummarySegmentAttributeValue::valueString))
            .setter(setter(Builder::valueString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueString").build()).build();

    private static final SdkField<Map<String, SegmentAttributeValue>> VALUE_MAP_FIELD = SdkField
            .<Map<String, SegmentAttributeValue>> builder(MarshallingType.MAP)
            .memberName("ValueMap")
            .getter(getter(ContactSearchSummarySegmentAttributeValue::valueMap))
            .setter(setter(Builder::valueMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<SegmentAttributeValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentAttributeValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_STRING_FIELD,
            VALUE_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String valueString;

    private final Map<String, SegmentAttributeValue> valueMap;

    private ContactSearchSummarySegmentAttributeValue(BuilderImpl builder) {
        this.valueString = builder.valueString;
        this.valueMap = builder.valueMap;
    }

    /**
     * <p>
     * The value of a segment attribute represented as a string.
     * </p>
     * 
     * @return The value of a segment attribute represented as a string.
     */
    public final String valueString() {
        return valueString;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValueMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValueMap() {
        return valueMap != null && !(valueMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key and value of a segment attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValueMap} method.
     * </p>
     * 
     * @return The key and value of a segment attribute.
     */
    public final Map<String, SegmentAttributeValue> valueMap() {
        return valueMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValueMap() ? valueMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactSearchSummarySegmentAttributeValue)) {
            return false;
        }
        ContactSearchSummarySegmentAttributeValue other = (ContactSearchSummarySegmentAttributeValue) obj;
        return Objects.equals(valueString(), other.valueString()) && hasValueMap() == other.hasValueMap()
                && Objects.equals(valueMap(), other.valueMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactSearchSummarySegmentAttributeValue").add("ValueString", valueString())
                .add("ValueMap", hasValueMap() ? valueMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ValueString":
            return Optional.ofNullable(clazz.cast(valueString()));
        case "ValueMap":
            return Optional.ofNullable(clazz.cast(valueMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ValueString", VALUE_STRING_FIELD);
        map.put("ValueMap", VALUE_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactSearchSummarySegmentAttributeValue, T> g) {
        return obj -> g.apply((ContactSearchSummarySegmentAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactSearchSummarySegmentAttributeValue> {
        /**
         * <p>
         * The value of a segment attribute represented as a string.
         * </p>
         * 
         * @param valueString
         *        The value of a segment attribute represented as a string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueString(String valueString);

        /**
         * <p>
         * The key and value of a segment attribute.
         * </p>
         * 
         * @param valueMap
         *        The key and value of a segment attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueMap(Map<String, SegmentAttributeValue> valueMap);
    }

    static final class BuilderImpl implements Builder {
        private String valueString;

        private Map<String, SegmentAttributeValue> valueMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContactSearchSummarySegmentAttributeValue model) {
            valueString(model.valueString);
            valueMap(model.valueMap);
        }

        public final String getValueString() {
            return valueString;
        }

        public final void setValueString(String valueString) {
            this.valueString = valueString;
        }

        @Override
        public final Builder valueString(String valueString) {
            this.valueString = valueString;
            return this;
        }

        public final Map<String, SegmentAttributeValue.Builder> getValueMap() {
            Map<String, SegmentAttributeValue.Builder> result = SegmentAttributeValueMapCopier.copyToBuilder(this.valueMap);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setValueMap(Map<String, SegmentAttributeValue.BuilderImpl> valueMap) {
            this.valueMap = SegmentAttributeValueMapCopier.copyFromBuilder(valueMap);
        }

        @Override
        public final Builder valueMap(Map<String, SegmentAttributeValue> valueMap) {
            this.valueMap = SegmentAttributeValueMapCopier.copy(valueMap);
            return this;
        }

        @Override
        public ContactSearchSummarySegmentAttributeValue build() {
            return new ContactSearchSummarySegmentAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
