/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ContactEvaluationsCopier {
    static Map<String, ContactEvaluation> copy(Map<String, ? extends ContactEvaluation> contactEvaluationsParam) {
        Map<String, ContactEvaluation> map;
        if (contactEvaluationsParam == null || contactEvaluationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ContactEvaluation> modifiableMap = new LinkedHashMap<>(contactEvaluationsParam.size());
            contactEvaluationsParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ContactEvaluation> copyFromBuilder(Map<String, ? extends ContactEvaluation.Builder> contactEvaluationsParam) {
        Map<String, ContactEvaluation> map;
        if (contactEvaluationsParam == null || contactEvaluationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ContactEvaluation> modifiableMap = new LinkedHashMap<>(contactEvaluationsParam.size());
            contactEvaluationsParam.forEach((key, value) -> {
                ContactEvaluation member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ContactEvaluation.Builder> copyToBuilder(Map<String, ? extends ContactEvaluation> contactEvaluationsParam) {
        Map<String, ContactEvaluation.Builder> map;
        if (contactEvaluationsParam == null || contactEvaluationsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ContactEvaluation.Builder> modifiableMap = new LinkedHashMap<>(contactEvaluationsParam.size());
            contactEvaluationsParam.forEach((key, value) -> {
                ContactEvaluation.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
