/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contact configuration for push notification registration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactConfiguration.Builder, ContactConfiguration> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(ContactConfiguration::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<String> PARTICIPANT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantRole").getter(getter(ContactConfiguration::participantRoleAsString))
            .setter(setter(Builder::participantRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantRole").build()).build();

    private static final SdkField<Boolean> INCLUDE_RAW_MESSAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeRawMessage").getter(getter(ContactConfiguration::includeRawMessage))
            .setter(setter(Builder::includeRawMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeRawMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            PARTICIPANT_ROLE_FIELD, INCLUDE_RAW_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String contactId;

    private final String participantRole;

    private final Boolean includeRawMessage;

    private ContactConfiguration(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.participantRole = builder.participantRole;
        this.includeRawMessage = builder.includeRawMessage;
    }

    /**
     * <p>
     * The identifier of the contact within the Amazon Connect instance.
     * </p>
     * 
     * @return The identifier of the contact within the Amazon Connect instance.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The role of the participant in the chat conversation.
     * </p>
     * <note>
     * <p>
     * Only <code>CUSTOMER</code> is currently supported. Any other values other than <code>CUSTOMER</code> will result
     * in an exception (4xx error).
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant in the chat conversation.</p> <note>
     *         <p>
     *         Only <code>CUSTOMER</code> is currently supported. Any other values other than <code>CUSTOMER</code> will
     *         result in an exception (4xx error).
     *         </p>
     * @see ParticipantRole
     */
    public final ParticipantRole participantRole() {
        return ParticipantRole.fromValue(participantRole);
    }

    /**
     * <p>
     * The role of the participant in the chat conversation.
     * </p>
     * <note>
     * <p>
     * Only <code>CUSTOMER</code> is currently supported. Any other values other than <code>CUSTOMER</code> will result
     * in an exception (4xx error).
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantRole}
     * will return {@link ParticipantRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantRoleAsString}.
     * </p>
     * 
     * @return The role of the participant in the chat conversation.</p> <note>
     *         <p>
     *         Only <code>CUSTOMER</code> is currently supported. Any other values other than <code>CUSTOMER</code> will
     *         result in an exception (4xx error).
     *         </p>
     * @see ParticipantRole
     */
    public final String participantRoleAsString() {
        return participantRole;
    }

    /**
     * <p>
     * Whether to include raw connect message in the push notification payload. Default is <code>False</code>.
     * </p>
     * 
     * @return Whether to include raw connect message in the push notification payload. Default is <code>False</code>.
     */
    public final Boolean includeRawMessage() {
        return includeRawMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(participantRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(includeRawMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactConfiguration)) {
            return false;
        }
        ContactConfiguration other = (ContactConfiguration) obj;
        return Objects.equals(contactId(), other.contactId())
                && Objects.equals(participantRoleAsString(), other.participantRoleAsString())
                && Objects.equals(includeRawMessage(), other.includeRawMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactConfiguration").add("ContactId", contactId())
                .add("ParticipantRole", participantRoleAsString()).add("IncludeRawMessage", includeRawMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "ParticipantRole":
            return Optional.ofNullable(clazz.cast(participantRoleAsString()));
        case "IncludeRawMessage":
            return Optional.ofNullable(clazz.cast(includeRawMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContactId", CONTACT_ID_FIELD);
        map.put("ParticipantRole", PARTICIPANT_ROLE_FIELD);
        map.put("IncludeRawMessage", INCLUDE_RAW_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContactConfiguration, T> g) {
        return obj -> g.apply((ContactConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactConfiguration> {
        /**
         * <p>
         * The identifier of the contact within the Amazon Connect instance.
         * </p>
         * 
         * @param contactId
         *        The identifier of the contact within the Amazon Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The role of the participant in the chat conversation.
         * </p>
         * <note>
         * <p>
         * Only <code>CUSTOMER</code> is currently supported. Any other values other than <code>CUSTOMER</code> will
         * result in an exception (4xx error).
         * </p>
         * </note>
         * 
         * @param participantRole
         *        The role of the participant in the chat conversation.</p> <note>
         *        <p>
         *        Only <code>CUSTOMER</code> is currently supported. Any other values other than <code>CUSTOMER</code>
         *        will result in an exception (4xx error).
         *        </p>
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(String participantRole);

        /**
         * <p>
         * The role of the participant in the chat conversation.
         * </p>
         * <note>
         * <p>
         * Only <code>CUSTOMER</code> is currently supported. Any other values other than <code>CUSTOMER</code> will
         * result in an exception (4xx error).
         * </p>
         * </note>
         * 
         * @param participantRole
         *        The role of the participant in the chat conversation.</p> <note>
         *        <p>
         *        Only <code>CUSTOMER</code> is currently supported. Any other values other than <code>CUSTOMER</code>
         *        will result in an exception (4xx error).
         *        </p>
         * @see ParticipantRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantRole
         */
        Builder participantRole(ParticipantRole participantRole);

        /**
         * <p>
         * Whether to include raw connect message in the push notification payload. Default is <code>False</code>.
         * </p>
         * 
         * @param includeRawMessage
         *        Whether to include raw connect message in the push notification payload. Default is <code>False</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeRawMessage(Boolean includeRawMessage);
    }

    static final class BuilderImpl implements Builder {
        private String contactId;

        private String participantRole;

        private Boolean includeRawMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactConfiguration model) {
            contactId(model.contactId);
            participantRole(model.participantRole);
            includeRawMessage(model.includeRawMessage);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getParticipantRole() {
            return participantRole;
        }

        public final void setParticipantRole(String participantRole) {
            this.participantRole = participantRole;
        }

        @Override
        public final Builder participantRole(String participantRole) {
            this.participantRole = participantRole;
            return this;
        }

        @Override
        public final Builder participantRole(ParticipantRole participantRole) {
            this.participantRole(participantRole == null ? null : participantRole.toString());
            return this;
        }

        public final Boolean getIncludeRawMessage() {
            return includeRawMessage;
        }

        public final void setIncludeRawMessage(Boolean includeRawMessage) {
            this.includeRawMessage = includeRawMessage;
        }

        @Override
        public final Builder includeRawMessage(Boolean includeRawMessage) {
            this.includeRawMessage = includeRawMessage;
            return this;
        }

        @Override
        public ContactConfiguration build() {
            return new ContactConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
