/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the overall participant interactions at the contact level.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChatContactMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<ChatContactMetrics.Builder, ChatContactMetrics> {
    private static final SdkField<Boolean> MULTI_PARTY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiParty").getter(getter(ChatContactMetrics::multiParty)).setter(setter(Builder::multiParty))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiParty").build()).build();

    private static final SdkField<Integer> TOTAL_MESSAGES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalMessages").getter(getter(ChatContactMetrics::totalMessages)).setter(setter(Builder::totalMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalMessages").build()).build();

    private static final SdkField<Integer> TOTAL_BOT_MESSAGES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalBotMessages").getter(getter(ChatContactMetrics::totalBotMessages))
            .setter(setter(Builder::totalBotMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBotMessages").build()).build();

    private static final SdkField<Integer> TOTAL_BOT_MESSAGE_LENGTH_IN_CHARS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalBotMessageLengthInChars")
            .getter(getter(ChatContactMetrics::totalBotMessageLengthInChars))
            .setter(setter(Builder::totalBotMessageLengthInChars))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalBotMessageLengthInChars")
                    .build()).build();

    private static final SdkField<Long> CONVERSATION_CLOSE_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ConversationCloseTimeInMillis")
            .getter(getter(ChatContactMetrics::conversationCloseTimeInMillis))
            .setter(setter(Builder::conversationCloseTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversationCloseTimeInMillis")
                    .build()).build();

    private static final SdkField<Integer> CONVERSATION_TURN_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ConversationTurnCount").getter(getter(ChatContactMetrics::conversationTurnCount))
            .setter(setter(Builder::conversationTurnCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversationTurnCount").build())
            .build();

    private static final SdkField<Instant> AGENT_FIRST_RESPONSE_TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AgentFirstResponseTimestamp")
            .getter(getter(ChatContactMetrics::agentFirstResponseTimestamp))
            .setter(setter(Builder::agentFirstResponseTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentFirstResponseTimestamp")
                    .build()).build();

    private static final SdkField<Long> AGENT_FIRST_RESPONSE_TIME_IN_MILLIS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("AgentFirstResponseTimeInMillis")
            .getter(getter(ChatContactMetrics::agentFirstResponseTimeInMillis))
            .setter(setter(Builder::agentFirstResponseTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentFirstResponseTimeInMillis")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_PARTY_FIELD,
            TOTAL_MESSAGES_FIELD, TOTAL_BOT_MESSAGES_FIELD, TOTAL_BOT_MESSAGE_LENGTH_IN_CHARS_FIELD,
            CONVERSATION_CLOSE_TIME_IN_MILLIS_FIELD, CONVERSATION_TURN_COUNT_FIELD, AGENT_FIRST_RESPONSE_TIMESTAMP_FIELD,
            AGENT_FIRST_RESPONSE_TIME_IN_MILLIS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean multiParty;

    private final Integer totalMessages;

    private final Integer totalBotMessages;

    private final Integer totalBotMessageLengthInChars;

    private final Long conversationCloseTimeInMillis;

    private final Integer conversationTurnCount;

    private final Instant agentFirstResponseTimestamp;

    private final Long agentFirstResponseTimeInMillis;

    private ChatContactMetrics(BuilderImpl builder) {
        this.multiParty = builder.multiParty;
        this.totalMessages = builder.totalMessages;
        this.totalBotMessages = builder.totalBotMessages;
        this.totalBotMessageLengthInChars = builder.totalBotMessageLengthInChars;
        this.conversationCloseTimeInMillis = builder.conversationCloseTimeInMillis;
        this.conversationTurnCount = builder.conversationTurnCount;
        this.agentFirstResponseTimestamp = builder.agentFirstResponseTimestamp;
        this.agentFirstResponseTimeInMillis = builder.agentFirstResponseTimeInMillis;
    }

    /**
     * <p>
     * A boolean flag indicating whether multiparty chat or supervisor barge were enabled on this contact.
     * </p>
     * 
     * @return A boolean flag indicating whether multiparty chat or supervisor barge were enabled on this contact.
     */
    public final Boolean multiParty() {
        return multiParty;
    }

    /**
     * <p>
     * The number of chat messages on the contact.
     * </p>
     * 
     * @return The number of chat messages on the contact.
     */
    public final Integer totalMessages() {
        return totalMessages;
    }

    /**
     * <p>
     * The total number of bot and automated messages on a chat contact.
     * </p>
     * 
     * @return The total number of bot and automated messages on a chat contact.
     */
    public final Integer totalBotMessages() {
        return totalBotMessages;
    }

    /**
     * <p>
     * The total number of characters from bot and automated messages on a chat contact.
     * </p>
     * 
     * @return The total number of characters from bot and automated messages on a chat contact.
     */
    public final Integer totalBotMessageLengthInChars() {
        return totalBotMessageLengthInChars;
    }

    /**
     * <p>
     * The time it took for a contact to end after the last customer message.
     * </p>
     * 
     * @return The time it took for a contact to end after the last customer message.
     */
    public final Long conversationCloseTimeInMillis() {
        return conversationCloseTimeInMillis;
    }

    /**
     * <p>
     * The number of conversation turns in a chat contact, which represents the back-and-forth exchanges between
     * customer and other participants.
     * </p>
     * 
     * @return The number of conversation turns in a chat contact, which represents the back-and-forth exchanges between
     *         customer and other participants.
     */
    public final Integer conversationTurnCount() {
        return conversationTurnCount;
    }

    /**
     * <p>
     * The agent first response timestamp for a chat contact.
     * </p>
     * 
     * @return The agent first response timestamp for a chat contact.
     */
    public final Instant agentFirstResponseTimestamp() {
        return agentFirstResponseTimestamp;
    }

    /**
     * <p>
     * The time for an agent to respond after obtaining a chat contact.
     * </p>
     * 
     * @return The time for an agent to respond after obtaining a chat contact.
     */
    public final Long agentFirstResponseTimeInMillis() {
        return agentFirstResponseTimeInMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multiParty());
        hashCode = 31 * hashCode + Objects.hashCode(totalMessages());
        hashCode = 31 * hashCode + Objects.hashCode(totalBotMessages());
        hashCode = 31 * hashCode + Objects.hashCode(totalBotMessageLengthInChars());
        hashCode = 31 * hashCode + Objects.hashCode(conversationCloseTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(conversationTurnCount());
        hashCode = 31 * hashCode + Objects.hashCode(agentFirstResponseTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(agentFirstResponseTimeInMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChatContactMetrics)) {
            return false;
        }
        ChatContactMetrics other = (ChatContactMetrics) obj;
        return Objects.equals(multiParty(), other.multiParty()) && Objects.equals(totalMessages(), other.totalMessages())
                && Objects.equals(totalBotMessages(), other.totalBotMessages())
                && Objects.equals(totalBotMessageLengthInChars(), other.totalBotMessageLengthInChars())
                && Objects.equals(conversationCloseTimeInMillis(), other.conversationCloseTimeInMillis())
                && Objects.equals(conversationTurnCount(), other.conversationTurnCount())
                && Objects.equals(agentFirstResponseTimestamp(), other.agentFirstResponseTimestamp())
                && Objects.equals(agentFirstResponseTimeInMillis(), other.agentFirstResponseTimeInMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChatContactMetrics").add("MultiParty", multiParty()).add("TotalMessages", totalMessages())
                .add("TotalBotMessages", totalBotMessages()).add("TotalBotMessageLengthInChars", totalBotMessageLengthInChars())
                .add("ConversationCloseTimeInMillis", conversationCloseTimeInMillis())
                .add("ConversationTurnCount", conversationTurnCount())
                .add("AgentFirstResponseTimestamp", agentFirstResponseTimestamp())
                .add("AgentFirstResponseTimeInMillis", agentFirstResponseTimeInMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MultiParty":
            return Optional.ofNullable(clazz.cast(multiParty()));
        case "TotalMessages":
            return Optional.ofNullable(clazz.cast(totalMessages()));
        case "TotalBotMessages":
            return Optional.ofNullable(clazz.cast(totalBotMessages()));
        case "TotalBotMessageLengthInChars":
            return Optional.ofNullable(clazz.cast(totalBotMessageLengthInChars()));
        case "ConversationCloseTimeInMillis":
            return Optional.ofNullable(clazz.cast(conversationCloseTimeInMillis()));
        case "ConversationTurnCount":
            return Optional.ofNullable(clazz.cast(conversationTurnCount()));
        case "AgentFirstResponseTimestamp":
            return Optional.ofNullable(clazz.cast(agentFirstResponseTimestamp()));
        case "AgentFirstResponseTimeInMillis":
            return Optional.ofNullable(clazz.cast(agentFirstResponseTimeInMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MultiParty", MULTI_PARTY_FIELD);
        map.put("TotalMessages", TOTAL_MESSAGES_FIELD);
        map.put("TotalBotMessages", TOTAL_BOT_MESSAGES_FIELD);
        map.put("TotalBotMessageLengthInChars", TOTAL_BOT_MESSAGE_LENGTH_IN_CHARS_FIELD);
        map.put("ConversationCloseTimeInMillis", CONVERSATION_CLOSE_TIME_IN_MILLIS_FIELD);
        map.put("ConversationTurnCount", CONVERSATION_TURN_COUNT_FIELD);
        map.put("AgentFirstResponseTimestamp", AGENT_FIRST_RESPONSE_TIMESTAMP_FIELD);
        map.put("AgentFirstResponseTimeInMillis", AGENT_FIRST_RESPONSE_TIME_IN_MILLIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChatContactMetrics, T> g) {
        return obj -> g.apply((ChatContactMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChatContactMetrics> {
        /**
         * <p>
         * A boolean flag indicating whether multiparty chat or supervisor barge were enabled on this contact.
         * </p>
         * 
         * @param multiParty
         *        A boolean flag indicating whether multiparty chat or supervisor barge were enabled on this contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiParty(Boolean multiParty);

        /**
         * <p>
         * The number of chat messages on the contact.
         * </p>
         * 
         * @param totalMessages
         *        The number of chat messages on the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalMessages(Integer totalMessages);

        /**
         * <p>
         * The total number of bot and automated messages on a chat contact.
         * </p>
         * 
         * @param totalBotMessages
         *        The total number of bot and automated messages on a chat contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBotMessages(Integer totalBotMessages);

        /**
         * <p>
         * The total number of characters from bot and automated messages on a chat contact.
         * </p>
         * 
         * @param totalBotMessageLengthInChars
         *        The total number of characters from bot and automated messages on a chat contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBotMessageLengthInChars(Integer totalBotMessageLengthInChars);

        /**
         * <p>
         * The time it took for a contact to end after the last customer message.
         * </p>
         * 
         * @param conversationCloseTimeInMillis
         *        The time it took for a contact to end after the last customer message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationCloseTimeInMillis(Long conversationCloseTimeInMillis);

        /**
         * <p>
         * The number of conversation turns in a chat contact, which represents the back-and-forth exchanges between
         * customer and other participants.
         * </p>
         * 
         * @param conversationTurnCount
         *        The number of conversation turns in a chat contact, which represents the back-and-forth exchanges
         *        between customer and other participants.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationTurnCount(Integer conversationTurnCount);

        /**
         * <p>
         * The agent first response timestamp for a chat contact.
         * </p>
         * 
         * @param agentFirstResponseTimestamp
         *        The agent first response timestamp for a chat contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentFirstResponseTimestamp(Instant agentFirstResponseTimestamp);

        /**
         * <p>
         * The time for an agent to respond after obtaining a chat contact.
         * </p>
         * 
         * @param agentFirstResponseTimeInMillis
         *        The time for an agent to respond after obtaining a chat contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentFirstResponseTimeInMillis(Long agentFirstResponseTimeInMillis);
    }

    static final class BuilderImpl implements Builder {
        private Boolean multiParty;

        private Integer totalMessages;

        private Integer totalBotMessages;

        private Integer totalBotMessageLengthInChars;

        private Long conversationCloseTimeInMillis;

        private Integer conversationTurnCount;

        private Instant agentFirstResponseTimestamp;

        private Long agentFirstResponseTimeInMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(ChatContactMetrics model) {
            multiParty(model.multiParty);
            totalMessages(model.totalMessages);
            totalBotMessages(model.totalBotMessages);
            totalBotMessageLengthInChars(model.totalBotMessageLengthInChars);
            conversationCloseTimeInMillis(model.conversationCloseTimeInMillis);
            conversationTurnCount(model.conversationTurnCount);
            agentFirstResponseTimestamp(model.agentFirstResponseTimestamp);
            agentFirstResponseTimeInMillis(model.agentFirstResponseTimeInMillis);
        }

        public final Boolean getMultiParty() {
            return multiParty;
        }

        public final void setMultiParty(Boolean multiParty) {
            this.multiParty = multiParty;
        }

        @Override
        public final Builder multiParty(Boolean multiParty) {
            this.multiParty = multiParty;
            return this;
        }

        public final Integer getTotalMessages() {
            return totalMessages;
        }

        public final void setTotalMessages(Integer totalMessages) {
            this.totalMessages = totalMessages;
        }

        @Override
        public final Builder totalMessages(Integer totalMessages) {
            this.totalMessages = totalMessages;
            return this;
        }

        public final Integer getTotalBotMessages() {
            return totalBotMessages;
        }

        public final void setTotalBotMessages(Integer totalBotMessages) {
            this.totalBotMessages = totalBotMessages;
        }

        @Override
        public final Builder totalBotMessages(Integer totalBotMessages) {
            this.totalBotMessages = totalBotMessages;
            return this;
        }

        public final Integer getTotalBotMessageLengthInChars() {
            return totalBotMessageLengthInChars;
        }

        public final void setTotalBotMessageLengthInChars(Integer totalBotMessageLengthInChars) {
            this.totalBotMessageLengthInChars = totalBotMessageLengthInChars;
        }

        @Override
        public final Builder totalBotMessageLengthInChars(Integer totalBotMessageLengthInChars) {
            this.totalBotMessageLengthInChars = totalBotMessageLengthInChars;
            return this;
        }

        public final Long getConversationCloseTimeInMillis() {
            return conversationCloseTimeInMillis;
        }

        public final void setConversationCloseTimeInMillis(Long conversationCloseTimeInMillis) {
            this.conversationCloseTimeInMillis = conversationCloseTimeInMillis;
        }

        @Override
        public final Builder conversationCloseTimeInMillis(Long conversationCloseTimeInMillis) {
            this.conversationCloseTimeInMillis = conversationCloseTimeInMillis;
            return this;
        }

        public final Integer getConversationTurnCount() {
            return conversationTurnCount;
        }

        public final void setConversationTurnCount(Integer conversationTurnCount) {
            this.conversationTurnCount = conversationTurnCount;
        }

        @Override
        public final Builder conversationTurnCount(Integer conversationTurnCount) {
            this.conversationTurnCount = conversationTurnCount;
            return this;
        }

        public final Instant getAgentFirstResponseTimestamp() {
            return agentFirstResponseTimestamp;
        }

        public final void setAgentFirstResponseTimestamp(Instant agentFirstResponseTimestamp) {
            this.agentFirstResponseTimestamp = agentFirstResponseTimestamp;
        }

        @Override
        public final Builder agentFirstResponseTimestamp(Instant agentFirstResponseTimestamp) {
            this.agentFirstResponseTimestamp = agentFirstResponseTimestamp;
            return this;
        }

        public final Long getAgentFirstResponseTimeInMillis() {
            return agentFirstResponseTimeInMillis;
        }

        public final void setAgentFirstResponseTimeInMillis(Long agentFirstResponseTimeInMillis) {
            this.agentFirstResponseTimeInMillis = agentFirstResponseTimeInMillis;
        }

        @Override
        public final Builder agentFirstResponseTimeInMillis(Long agentFirstResponseTimeInMillis) {
            this.agentFirstResponseTimeInMillis = agentFirstResponseTimeInMillis;
            return this;
        }

        @Override
        public ChatContactMetrics build() {
            return new ChatContactMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
