/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SLA configuration for Case SlaAssignmentType.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseSlaConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CaseSlaConfiguration.Builder, CaseSlaConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CaseSlaConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CaseSlaConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> FIELD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldId").getter(getter(CaseSlaConfiguration::fieldId)).setter(setter(Builder::fieldId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()).build();

    private static final SdkField<List<FieldValueUnion>> TARGET_FIELD_VALUES_FIELD = SdkField
            .<List<FieldValueUnion>> builder(MarshallingType.LIST)
            .memberName("TargetFieldValues")
            .getter(getter(CaseSlaConfiguration::targetFieldValues))
            .setter(setter(Builder::targetFieldValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetFieldValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldValueUnion> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldValueUnion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TARGET_SLA_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TargetSlaMinutes").getter(getter(CaseSlaConfiguration::targetSlaMinutes))
            .setter(setter(Builder::targetSlaMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSlaMinutes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            FIELD_ID_FIELD, TARGET_FIELD_VALUES_FIELD, TARGET_SLA_MINUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String type;

    private final String fieldId;

    private final List<FieldValueUnion> targetFieldValues;

    private final Long targetSlaMinutes;

    private CaseSlaConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.fieldId = builder.fieldId;
        this.targetFieldValues = builder.targetFieldValues;
        this.targetSlaMinutes = builder.targetSlaMinutes;
    }

    /**
     * <p>
     * Name of an SLA.
     * </p>
     * 
     * @return Name of an SLA.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Type of SLA for Case SlaAssignmentType.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SlaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of SLA for Case SlaAssignmentType.
     * @see SlaType
     */
    public final SlaType type() {
        return SlaType.fromValue(type);
    }

    /**
     * <p>
     * Type of SLA for Case SlaAssignmentType.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SlaType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type of SLA for Case SlaAssignmentType.
     * @see SlaType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Unique identifier of a Case field.
     * </p>
     * 
     * @return Unique identifier of a Case field.
     */
    public final String fieldId() {
        return fieldId;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetFieldValues property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetFieldValues() {
        return targetFieldValues != null && !(targetFieldValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents a list of target field values for the fieldId specified in CaseSlaConfiguration. The SLA is considered
     * met if any one of these target field values matches the actual field value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetFieldValues} method.
     * </p>
     * 
     * @return Represents a list of target field values for the fieldId specified in CaseSlaConfiguration. The SLA is
     *         considered met if any one of these target field values matches the actual field value.
     */
    public final List<FieldValueUnion> targetFieldValues() {
        return targetFieldValues;
    }

    /**
     * <p>
     * Target duration in minutes within which an SLA should be completed.
     * </p>
     * 
     * @return Target duration in minutes within which an SLA should be completed.
     */
    public final Long targetSlaMinutes() {
        return targetSlaMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetFieldValues() ? targetFieldValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(targetSlaMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseSlaConfiguration)) {
            return false;
        }
        CaseSlaConfiguration other = (CaseSlaConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(fieldId(), other.fieldId()) && hasTargetFieldValues() == other.hasTargetFieldValues()
                && Objects.equals(targetFieldValues(), other.targetFieldValues())
                && Objects.equals(targetSlaMinutes(), other.targetSlaMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaseSlaConfiguration").add("Name", name()).add("Type", typeAsString()).add("FieldId", fieldId())
                .add("TargetFieldValues", hasTargetFieldValues() ? targetFieldValues() : null)
                .add("TargetSlaMinutes", targetSlaMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "FieldId":
            return Optional.ofNullable(clazz.cast(fieldId()));
        case "TargetFieldValues":
            return Optional.ofNullable(clazz.cast(targetFieldValues()));
        case "TargetSlaMinutes":
            return Optional.ofNullable(clazz.cast(targetSlaMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("FieldId", FIELD_ID_FIELD);
        map.put("TargetFieldValues", TARGET_FIELD_VALUES_FIELD);
        map.put("TargetSlaMinutes", TARGET_SLA_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseSlaConfiguration, T> g) {
        return obj -> g.apply((CaseSlaConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseSlaConfiguration> {
        /**
         * <p>
         * Name of an SLA.
         * </p>
         * 
         * @param name
         *        Name of an SLA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Type of SLA for Case SlaAssignmentType.
         * </p>
         * 
         * @param type
         *        Type of SLA for Case SlaAssignmentType.
         * @see SlaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlaType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of SLA for Case SlaAssignmentType.
         * </p>
         * 
         * @param type
         *        Type of SLA for Case SlaAssignmentType.
         * @see SlaType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlaType
         */
        Builder type(SlaType type);

        /**
         * <p>
         * Unique identifier of a Case field.
         * </p>
         * 
         * @param fieldId
         *        Unique identifier of a Case field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldId(String fieldId);

        /**
         * <p>
         * Represents a list of target field values for the fieldId specified in CaseSlaConfiguration. The SLA is
         * considered met if any one of these target field values matches the actual field value.
         * </p>
         * 
         * @param targetFieldValues
         *        Represents a list of target field values for the fieldId specified in CaseSlaConfiguration. The SLA is
         *        considered met if any one of these target field values matches the actual field value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFieldValues(Collection<FieldValueUnion> targetFieldValues);

        /**
         * <p>
         * Represents a list of target field values for the fieldId specified in CaseSlaConfiguration. The SLA is
         * considered met if any one of these target field values matches the actual field value.
         * </p>
         * 
         * @param targetFieldValues
         *        Represents a list of target field values for the fieldId specified in CaseSlaConfiguration. The SLA is
         *        considered met if any one of these target field values matches the actual field value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFieldValues(FieldValueUnion... targetFieldValues);

        /**
         * <p>
         * Represents a list of target field values for the fieldId specified in CaseSlaConfiguration. The SLA is
         * considered met if any one of these target field values matches the actual field value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.FieldValueUnion.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connect.model.FieldValueUnion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.FieldValueUnion.Builder#build()} is called immediately
         * and its result is passed to {@link #targetFieldValues(List<FieldValueUnion>)}.
         * 
         * @param targetFieldValues
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.FieldValueUnion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetFieldValues(java.util.Collection<FieldValueUnion>)
         */
        Builder targetFieldValues(Consumer<FieldValueUnion.Builder>... targetFieldValues);

        /**
         * <p>
         * Target duration in minutes within which an SLA should be completed.
         * </p>
         * 
         * @param targetSlaMinutes
         *        Target duration in minutes within which an SLA should be completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSlaMinutes(Long targetSlaMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String type;

        private String fieldId;

        private List<FieldValueUnion> targetFieldValues = DefaultSdkAutoConstructList.getInstance();

        private Long targetSlaMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseSlaConfiguration model) {
            name(model.name);
            type(model.type);
            fieldId(model.fieldId);
            targetFieldValues(model.targetFieldValues);
            targetSlaMinutes(model.targetSlaMinutes);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SlaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFieldId() {
            return fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final List<FieldValueUnion.Builder> getTargetFieldValues() {
            List<FieldValueUnion.Builder> result = SlaFieldValueUnionListCopier.copyToBuilder(this.targetFieldValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetFieldValues(Collection<FieldValueUnion.BuilderImpl> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copyFromBuilder(targetFieldValues);
        }

        @Override
        public final Builder targetFieldValues(Collection<FieldValueUnion> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copy(targetFieldValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(FieldValueUnion... targetFieldValues) {
            targetFieldValues(Arrays.asList(targetFieldValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(Consumer<FieldValueUnion.Builder>... targetFieldValues) {
            targetFieldValues(Stream.of(targetFieldValues).map(c -> FieldValueUnion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getTargetSlaMinutes() {
            return targetSlaMinutes;
        }

        public final void setTargetSlaMinutes(Long targetSlaMinutes) {
            this.targetSlaMinutes = targetSlaMinutes;
        }

        @Override
        public final Builder targetSlaMinutes(Long targetSlaMinutes) {
            this.targetSlaMinutes = targetSlaMinutes;
            return this;
        }

        @Override
        public CaseSlaConfiguration build() {
            return new CaseSlaConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
