/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAttachedFileMetadataRequest extends ConnectRequest implements
        ToCopyableBuilder<BatchGetAttachedFileMetadataRequest.Builder, BatchGetAttachedFileMetadataRequest> {
    private static final SdkField<List<String>> FILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FileIds")
            .getter(getter(BatchGetAttachedFileMetadataRequest::fileIds))
            .setter(setter(Builder::fileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(BatchGetAttachedFileMetadataRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> ASSOCIATED_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociatedResourceArn").getter(getter(BatchGetAttachedFileMetadataRequest::associatedResourceArn))
            .setter(setter(Builder::associatedResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("associatedResourceArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_IDS_FIELD,
            INSTANCE_ID_FIELD, ASSOCIATED_RESOURCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> fileIds;

    private final String instanceId;

    private final String associatedResourceArn;

    private BatchGetAttachedFileMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.fileIds = builder.fileIds;
        this.instanceId = builder.instanceId;
        this.associatedResourceArn = builder.associatedResourceArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFileIds() {
        return fileIds != null && !(fileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The unique identifiers of the attached file resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileIds} method.
     * </p>
     * 
     * @return The unique identifiers of the attached file resource.
     */
    public final List<String> fileIds() {
        return fileIds;
    }

    /**
     * <p>
     * The unique identifier of the Connect instance.
     * </p>
     * 
     * @return The unique identifier of the Connect instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The resource to which the attached file is (being) uploaded to. The supported resources are <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Cases</a> and <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html">Email</a>.
     * </p>
     * <note>
     * <p>
     * This value must be a valid ARN.
     * </p>
     * </note>
     * 
     * @return The resource to which the attached file is (being) uploaded to. The supported resources are <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Cases</a> and <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html">Email</a>.</p>
     *         <note>
     *         <p>
     *         This value must be a valid ARN.
     *         </p>
     */
    public final String associatedResourceArn() {
        return associatedResourceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFileIds() ? fileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(associatedResourceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAttachedFileMetadataRequest)) {
            return false;
        }
        BatchGetAttachedFileMetadataRequest other = (BatchGetAttachedFileMetadataRequest) obj;
        return hasFileIds() == other.hasFileIds() && Objects.equals(fileIds(), other.fileIds())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(associatedResourceArn(), other.associatedResourceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAttachedFileMetadataRequest").add("FileIds", hasFileIds() ? fileIds() : null)
                .add("InstanceId", instanceId()).add("AssociatedResourceArn", associatedResourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileIds":
            return Optional.ofNullable(clazz.cast(fileIds()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AssociatedResourceArn":
            return Optional.ofNullable(clazz.cast(associatedResourceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileIds", FILE_IDS_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("associatedResourceArn", ASSOCIATED_RESOURCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAttachedFileMetadataRequest, T> g) {
        return obj -> g.apply((BatchGetAttachedFileMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAttachedFileMetadataRequest> {
        /**
         * <p>
         * The unique identifiers of the attached file resource.
         * </p>
         * 
         * @param fileIds
         *        The unique identifiers of the attached file resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileIds(Collection<String> fileIds);

        /**
         * <p>
         * The unique identifiers of the attached file resource.
         * </p>
         * 
         * @param fileIds
         *        The unique identifiers of the attached file resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileIds(String... fileIds);

        /**
         * <p>
         * The unique identifier of the Connect instance.
         * </p>
         * 
         * @param instanceId
         *        The unique identifier of the Connect instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The resource to which the attached file is (being) uploaded to. The supported resources are <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Cases</a> and <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html">Email</a>.
         * </p>
         * <note>
         * <p>
         * This value must be a valid ARN.
         * </p>
         * </note>
         * 
         * @param associatedResourceArn
         *        The resource to which the attached file is (being) uploaded to. The supported resources are <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Cases</a> and <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-email-channel.html">Email</a>.</p>
         *        <note>
         *        <p>
         *        This value must be a valid ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArn(String associatedResourceArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private List<String> fileIds = DefaultSdkAutoConstructList.getInstance();

        private String instanceId;

        private String associatedResourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAttachedFileMetadataRequest model) {
            super(model);
            fileIds(model.fileIds);
            instanceId(model.instanceId);
            associatedResourceArn(model.associatedResourceArn);
        }

        public final Collection<String> getFileIds() {
            if (fileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return fileIds;
        }

        public final void setFileIds(Collection<String> fileIds) {
            this.fileIds = FileIdListCopier.copy(fileIds);
        }

        @Override
        public final Builder fileIds(Collection<String> fileIds) {
            this.fileIds = FileIdListCopier.copy(fileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileIds(String... fileIds) {
            fileIds(Arrays.asList(fileIds));
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAssociatedResourceArn() {
            return associatedResourceArn;
        }

        public final void setAssociatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
        }

        @Override
        public final Builder associatedResourceArn(String associatedResourceArn) {
            this.associatedResourceArn = associatedResourceArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAttachedFileMetadataRequest build() {
            return new BatchGetAttachedFileMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
