/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This API is in preview release for Amazon Connect and is subject to change. To request access to this API, contact
 * Amazon Web Services Support.
 * </p>
 * <p>
 * Information about an authentication profile. An authentication profile is a resource that stores the authentication
 * settings for users in your contact center. You use authentication profiles to set up IP address range restrictions
 * and session timeouts. For more information, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html">Set IP address restrictions
 * or session timeouts</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthenticationProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthenticationProfile.Builder, AuthenticationProfile> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AuthenticationProfile::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AuthenticationProfile::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AuthenticationProfile::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AuthenticationProfile::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<String>> ALLOWED_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedIps")
            .getter(getter(AuthenticationProfile::allowedIps))
            .setter(setter(Builder::allowedIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> BLOCKED_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("BlockedIps")
            .getter(getter(AuthenticationProfile::blockedIps))
            .setter(setter(Builder::blockedIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockedIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefault").getter(getter(AuthenticationProfile::isDefault)).setter(setter(Builder::isDefault))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefault").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(AuthenticationProfile::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(AuthenticationProfile::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(AuthenticationProfile::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final SdkField<Integer> PERIODIC_SESSION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PeriodicSessionDuration").getter(getter(AuthenticationProfile::periodicSessionDuration))
            .setter(setter(Builder::periodicSessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodicSessionDuration").build())
            .build();

    private static final SdkField<Integer> MAX_SESSION_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSessionDuration").getter(getter(AuthenticationProfile::maxSessionDuration))
            .setter(setter(Builder::maxSessionDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionDuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, ALLOWED_IPS_FIELD, BLOCKED_IPS_FIELD, IS_DEFAULT_FIELD, CREATED_TIME_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD, PERIODIC_SESSION_DURATION_FIELD, MAX_SESSION_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final List<String> allowedIps;

    private final List<String> blockedIps;

    private final Boolean isDefault;

    private final Instant createdTime;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private final Integer periodicSessionDuration;

    private final Integer maxSessionDuration;

    private AuthenticationProfile(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.allowedIps = builder.allowedIps;
        this.blockedIps = builder.blockedIps;
        this.isDefault = builder.isDefault;
        this.createdTime = builder.createdTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
        this.periodicSessionDuration = builder.periodicSessionDuration;
        this.maxSessionDuration = builder.maxSessionDuration;
    }

    /**
     * <p>
     * A unique identifier for the authentication profile.
     * </p>
     * 
     * @return A unique identifier for the authentication profile.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the authentication profile.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the authentication profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name for the authentication profile.
     * </p>
     * 
     * @return The name for the authentication profile.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the authentication profile.
     * </p>
     * 
     * @return The description for the authentication profile.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAllowedIps() {
        return allowedIps != null && !(allowedIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IP address range strings that are allowed to access the Amazon Connect instance. For more information
     * about how to configure IP addresses, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
     * >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedIps} method.
     * </p>
     * 
     * @return A list of IP address range strings that are allowed to access the Amazon Connect instance. For more
     *         information about how to configure IP addresses, see <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
     *         >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final List<String> allowedIps() {
        return allowedIps;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockedIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBlockedIps() {
        return blockedIps != null && !(blockedIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For more
     * information about how to configure IP addresses, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
     * >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockedIps} method.
     * </p>
     * 
     * @return A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For more
     *         information about how to configure IP addresses, see <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
     *         >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final List<String> blockedIps() {
        return blockedIps;
    }

    /**
     * <p>
     * Shows whether the authentication profile is the default authentication profile for the Amazon Connect instance.
     * The default authentication profile applies to all agents in an Amazon Connect instance, unless overridden by
     * another authentication profile.
     * </p>
     * 
     * @return Shows whether the authentication profile is the default authentication profile for the Amazon Connect
     *         instance. The default authentication profile applies to all agents in an Amazon Connect instance, unless
     *         overridden by another authentication profile.
     */
    public final Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The timestamp when the authentication profile was created.
     * </p>
     * 
     * @return The timestamp when the authentication profile was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The timestamp when the authentication profile was last modified.
     * </p>
     * 
     * @return The timestamp when the authentication profile was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the authentication profile was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where the authentication profile was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    /**
     * <p>
     * The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This value
     * determines the maximum possible time before an agent is authenticated. For more information, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
     * >Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This
     *         value determines the maximum possible time before an agent is authenticated. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
     *         >Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final Integer periodicSessionDuration() {
        return periodicSessionDuration;
    }

    /**
     * <p>
     * The long lived session duration for users logged in to Amazon Connect, in minutes. After this time period, users
     * must log in again. For more information, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
     * >Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.
     * </p>
     * 
     * @return The long lived session duration for users logged in to Amazon Connect, in minutes. After this time
     *         period, users must log in again. For more information, see <a href=
     *         "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
     *         >Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.
     */
    public final Integer maxSessionDuration() {
        return maxSessionDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedIps() ? allowedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockedIps() ? blockedIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(isDefault());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        hashCode = 31 * hashCode + Objects.hashCode(periodicSessionDuration());
        hashCode = 31 * hashCode + Objects.hashCode(maxSessionDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationProfile)) {
            return false;
        }
        AuthenticationProfile other = (AuthenticationProfile) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && hasAllowedIps() == other.hasAllowedIps()
                && Objects.equals(allowedIps(), other.allowedIps()) && hasBlockedIps() == other.hasBlockedIps()
                && Objects.equals(blockedIps(), other.blockedIps()) && Objects.equals(isDefault(), other.isDefault())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion())
                && Objects.equals(periodicSessionDuration(), other.periodicSessionDuration())
                && Objects.equals(maxSessionDuration(), other.maxSessionDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthenticationProfile").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("AllowedIps", hasAllowedIps() ? allowedIps() : null)
                .add("BlockedIps", hasBlockedIps() ? blockedIps() : null).add("IsDefault", isDefault())
                .add("CreatedTime", createdTime()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedRegion", lastModifiedRegion()).add("PeriodicSessionDuration", periodicSessionDuration())
                .add("MaxSessionDuration", maxSessionDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AllowedIps":
            return Optional.ofNullable(clazz.cast(allowedIps()));
        case "BlockedIps":
            return Optional.ofNullable(clazz.cast(blockedIps()));
        case "IsDefault":
            return Optional.ofNullable(clazz.cast(isDefault()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        case "PeriodicSessionDuration":
            return Optional.ofNullable(clazz.cast(periodicSessionDuration()));
        case "MaxSessionDuration":
            return Optional.ofNullable(clazz.cast(maxSessionDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AllowedIps", ALLOWED_IPS_FIELD);
        map.put("BlockedIps", BLOCKED_IPS_FIELD);
        map.put("IsDefault", IS_DEFAULT_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedRegion", LAST_MODIFIED_REGION_FIELD);
        map.put("PeriodicSessionDuration", PERIODIC_SESSION_DURATION_FIELD);
        map.put("MaxSessionDuration", MAX_SESSION_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationProfile, T> g) {
        return obj -> g.apply((AuthenticationProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthenticationProfile> {
        /**
         * <p>
         * A unique identifier for the authentication profile.
         * </p>
         * 
         * @param id
         *        A unique identifier for the authentication profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the authentication profile.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the authentication profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name for the authentication profile.
         * </p>
         * 
         * @param name
         *        The name for the authentication profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the authentication profile.
         * </p>
         * 
         * @param description
         *        The description for the authentication profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of IP address range strings that are allowed to access the Amazon Connect instance. For more
         * information about how to configure IP addresses, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         * >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param allowedIps
         *        A list of IP address range strings that are allowed to access the Amazon Connect instance. For more
         *        information about how to configure IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         *        >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedIps(Collection<String> allowedIps);

        /**
         * <p>
         * A list of IP address range strings that are allowed to access the Amazon Connect instance. For more
         * information about how to configure IP addresses, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         * >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param allowedIps
         *        A list of IP address range strings that are allowed to access the Amazon Connect instance. For more
         *        information about how to configure IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         *        >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedIps(String... allowedIps);

        /**
         * <p>
         * A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For more
         * information about how to configure IP addresses, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         * >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param blockedIps
         *        A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For
         *        more information about how to configure IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         *        >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedIps(Collection<String> blockedIps);

        /**
         * <p>
         * A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For more
         * information about how to configure IP addresses, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         * >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param blockedIps
         *        A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For
         *        more information about how to configure IP addresses, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac"
         *        >Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockedIps(String... blockedIps);

        /**
         * <p>
         * Shows whether the authentication profile is the default authentication profile for the Amazon Connect
         * instance. The default authentication profile applies to all agents in an Amazon Connect instance, unless
         * overridden by another authentication profile.
         * </p>
         * 
         * @param isDefault
         *        Shows whether the authentication profile is the default authentication profile for the Amazon Connect
         *        instance. The default authentication profile applies to all agents in an Amazon Connect instance,
         *        unless overridden by another authentication profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The timestamp when the authentication profile was created.
         * </p>
         * 
         * @param createdTime
         *        The timestamp when the authentication profile was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The timestamp when the authentication profile was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when the authentication profile was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Web Services Region where the authentication profile was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The Amazon Web Services Region where the authentication profile was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);

        /**
         * <p>
         * The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This value
         * determines the maximum possible time before an agent is authenticated. For more information, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         * >Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param periodicSessionDuration
         *        The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This
         *        value determines the maximum possible time before an agent is authenticated. For more information, see
         *        <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         *        >Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder periodicSessionDuration(Integer periodicSessionDuration);

        /**
         * <p>
         * The long lived session duration for users logged in to Amazon Connect, in minutes. After this time period,
         * users must log in again. For more information, see <a href=
         * "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         * >Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * </p>
         * 
         * @param maxSessionDuration
         *        The long lived session duration for users logged in to Amazon Connect, in minutes. After this time
         *        period, users must log in again. For more information, see <a href=
         *        "https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts"
         *        >Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSessionDuration(Integer maxSessionDuration);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private List<String> allowedIps = DefaultSdkAutoConstructList.getInstance();

        private List<String> blockedIps = DefaultSdkAutoConstructList.getInstance();

        private Boolean isDefault;

        private Instant createdTime;

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private Integer periodicSessionDuration;

        private Integer maxSessionDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationProfile model) {
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            allowedIps(model.allowedIps);
            blockedIps(model.blockedIps);
            isDefault(model.isDefault);
            createdTime(model.createdTime);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
            periodicSessionDuration(model.periodicSessionDuration);
            maxSessionDuration(model.maxSessionDuration);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getAllowedIps() {
            if (allowedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedIps;
        }

        public final void setAllowedIps(Collection<String> allowedIps) {
            this.allowedIps = IpCidrListCopier.copy(allowedIps);
        }

        @Override
        public final Builder allowedIps(Collection<String> allowedIps) {
            this.allowedIps = IpCidrListCopier.copy(allowedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedIps(String... allowedIps) {
            allowedIps(Arrays.asList(allowedIps));
            return this;
        }

        public final Collection<String> getBlockedIps() {
            if (blockedIps instanceof SdkAutoConstructList) {
                return null;
            }
            return blockedIps;
        }

        public final void setBlockedIps(Collection<String> blockedIps) {
            this.blockedIps = IpCidrListCopier.copy(blockedIps);
        }

        @Override
        public final Builder blockedIps(Collection<String> blockedIps) {
            this.blockedIps = IpCidrListCopier.copy(blockedIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedIps(String... blockedIps) {
            blockedIps(Arrays.asList(blockedIps));
            return this;
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        public final Integer getPeriodicSessionDuration() {
            return periodicSessionDuration;
        }

        public final void setPeriodicSessionDuration(Integer periodicSessionDuration) {
            this.periodicSessionDuration = periodicSessionDuration;
        }

        @Override
        public final Builder periodicSessionDuration(Integer periodicSessionDuration) {
            this.periodicSessionDuration = periodicSessionDuration;
            return this;
        }

        public final Integer getMaxSessionDuration() {
            return maxSessionDuration;
        }

        public final void setMaxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
        }

        @Override
        public final Builder maxSessionDuration(Integer maxSessionDuration) {
            this.maxSessionDuration = maxSessionDuration;
            return this;
        }

        @Override
        public AuthenticationProfile build() {
            return new AuthenticationProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
