/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about datasets that are available to associate with: <code>DataSetId</code>, <code>DataSetName</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsDataSetsResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsDataSetsResult.Builder, AnalyticsDataSetsResult> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(AnalyticsDataSetsResult::dataSetId)).setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<String> DATA_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetName").getter(getter(AnalyticsDataSetsResult::dataSetName)).setter(setter(Builder::dataSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD,
            DATA_SET_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSetId;

    private final String dataSetName;

    private AnalyticsDataSetsResult(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
        this.dataSetName = builder.dataSetName;
    }

    /**
     * <p>
     * The identifier of the dataset.
     * </p>
     * 
     * @return The identifier of the dataset.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String dataSetName() {
        return dataSetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsDataSetsResult)) {
            return false;
        }
        AnalyticsDataSetsResult other = (AnalyticsDataSetsResult) obj;
        return Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(dataSetName(), other.dataSetName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsDataSetsResult").add("DataSetId", dataSetId()).add("DataSetName", dataSetName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "DataSetName":
            return Optional.ofNullable(clazz.cast(dataSetName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSetId", DATA_SET_ID_FIELD);
        map.put("DataSetName", DATA_SET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsDataSetsResult, T> g) {
        return obj -> g.apply((AnalyticsDataSetsResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsDataSetsResult> {
        /**
         * <p>
         * The identifier of the dataset.
         * </p>
         * 
         * @param dataSetId
         *        The identifier of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param dataSetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetName(String dataSetName);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetId;

        private String dataSetName;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsDataSetsResult model) {
            dataSetId(model.dataSetId);
            dataSetName(model.dataSetName);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getDataSetName() {
            return dataSetName;
        }

        public final void setDataSetName(String dataSetName) {
            this.dataSetName = dataSetName;
        }

        @Override
        public final Builder dataSetName(String dataSetName) {
            this.dataSetName = dataSetName;
            return this;
        }

        @Override
        public AnalyticsDataSetsResult build() {
            return new AnalyticsDataSetsResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
