/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>StartConfigurationRecorder</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartConfigurationRecorderRequest extends ConfigRequest implements
        ToCopyableBuilder<StartConfigurationRecorderRequest.Builder, StartConfigurationRecorderRequest> {
    private static final SdkField<String> CONFIGURATION_RECORDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationRecorderName").getter(getter(StartConfigurationRecorderRequest::configurationRecorderName))
            .setter(setter(Builder::configurationRecorderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorderName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONFIGURATION_RECORDER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationRecorderName;

    private StartConfigurationRecorderRequest(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderName = builder.configurationRecorderName;
    }

    /**
     * <p>
     * The name of the customer managed configuration recorder that you want to start.
     * </p>
     * 
     * @return The name of the customer managed configuration recorder that you want to start.
     */
    public final String configurationRecorderName() {
        return configurationRecorderName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationRecorderName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartConfigurationRecorderRequest)) {
            return false;
        }
        StartConfigurationRecorderRequest other = (StartConfigurationRecorderRequest) obj;
        return Objects.equals(configurationRecorderName(), other.configurationRecorderName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartConfigurationRecorderRequest")
                .add("ConfigurationRecorderName", configurationRecorderName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorderName":
            return Optional.ofNullable(clazz.cast(configurationRecorderName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationRecorderName", CONFIGURATION_RECORDER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartConfigurationRecorderRequest, T> g) {
        return obj -> g.apply((StartConfigurationRecorderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartConfigurationRecorderRequest> {
        /**
         * <p>
         * The name of the customer managed configuration recorder that you want to start.
         * </p>
         * 
         * @param configurationRecorderName
         *        The name of the customer managed configuration recorder that you want to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderName(String configurationRecorderName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationRecorderName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartConfigurationRecorderRequest model) {
            super(model);
            configurationRecorderName(model.configurationRecorderName);
        }

        public final String getConfigurationRecorderName() {
            return configurationRecorderName;
        }

        public final void setConfigurationRecorderName(String configurationRecorderName) {
            this.configurationRecorderName = configurationRecorderName;
        }

        @Override
        public final Builder configurationRecorderName(String configurationRecorderName) {
            this.configurationRecorderName = configurationRecorderName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartConfigurationRecorderRequest build() {
            return new StartConfigurationRecorderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
