/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceEvaluationsResponse extends ConfigResponse implements
        ToCopyableBuilder<ListResourceEvaluationsResponse.Builder, ListResourceEvaluationsResponse> {
    private static final SdkField<List<ResourceEvaluation>> RESOURCE_EVALUATIONS_FIELD = SdkField
            .<List<ResourceEvaluation>> builder(MarshallingType.LIST)
            .memberName("ResourceEvaluations")
            .getter(getter(ListResourceEvaluationsResponse::resourceEvaluations))
            .setter(setter(Builder::resourceEvaluations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEvaluations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceEvaluation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceEvaluation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceEvaluationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_EVALUATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ResourceEvaluation> resourceEvaluations;

    private final String nextToken;

    private ListResourceEvaluationsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceEvaluations = builder.resourceEvaluations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceEvaluations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceEvaluations() {
        return resourceEvaluations != null && !(resourceEvaluations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a <code>ResourceEvaluations</code> object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceEvaluations} method.
     * </p>
     * 
     * @return Returns a <code>ResourceEvaluations</code> object.
     */
    public final List<ResourceEvaluation> resourceEvaluations() {
        return resourceEvaluations;
    }

    /**
     * <p>
     * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>nextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceEvaluations() ? resourceEvaluations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceEvaluationsResponse)) {
            return false;
        }
        ListResourceEvaluationsResponse other = (ListResourceEvaluationsResponse) obj;
        return hasResourceEvaluations() == other.hasResourceEvaluations()
                && Objects.equals(resourceEvaluations(), other.resourceEvaluations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceEvaluationsResponse")
                .add("ResourceEvaluations", hasResourceEvaluations() ? resourceEvaluations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceEvaluations":
            return Optional.ofNullable(clazz.cast(resourceEvaluations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceEvaluations", RESOURCE_EVALUATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceEvaluationsResponse, T> g) {
        return obj -> g.apply((ListResourceEvaluationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListResourceEvaluationsResponse> {
        /**
         * <p>
         * Returns a <code>ResourceEvaluations</code> object.
         * </p>
         * 
         * @param resourceEvaluations
         *        Returns a <code>ResourceEvaluations</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEvaluations(Collection<ResourceEvaluation> resourceEvaluations);

        /**
         * <p>
         * Returns a <code>ResourceEvaluations</code> object.
         * </p>
         * 
         * @param resourceEvaluations
         *        Returns a <code>ResourceEvaluations</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEvaluations(ResourceEvaluation... resourceEvaluations);

        /**
         * <p>
         * Returns a <code>ResourceEvaluations</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.ResourceEvaluation.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.config.model.ResourceEvaluation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.ResourceEvaluation.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceEvaluations(List<ResourceEvaluation>)}.
         * 
         * @param resourceEvaluations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.ResourceEvaluation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceEvaluations(java.util.Collection<ResourceEvaluation>)
         */
        Builder resourceEvaluations(Consumer<ResourceEvaluation.Builder>... resourceEvaluations);

        /**
         * <p>
         * The <code>nextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ResourceEvaluation> resourceEvaluations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceEvaluationsResponse model) {
            super(model);
            resourceEvaluations(model.resourceEvaluations);
            nextToken(model.nextToken);
        }

        public final List<ResourceEvaluation.Builder> getResourceEvaluations() {
            List<ResourceEvaluation.Builder> result = ResourceEvaluationsCopier.copyToBuilder(this.resourceEvaluations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceEvaluations(Collection<ResourceEvaluation.BuilderImpl> resourceEvaluations) {
            this.resourceEvaluations = ResourceEvaluationsCopier.copyFromBuilder(resourceEvaluations);
        }

        @Override
        public final Builder resourceEvaluations(Collection<ResourceEvaluation> resourceEvaluations) {
            this.resourceEvaluations = ResourceEvaluationsCopier.copy(resourceEvaluations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceEvaluations(ResourceEvaluation... resourceEvaluations) {
            resourceEvaluations(Arrays.asList(resourceEvaluations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceEvaluations(Consumer<ResourceEvaluation.Builder>... resourceEvaluations) {
            resourceEvaluations(Stream.of(resourceEvaluations).map(c -> ResourceEvaluation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceEvaluationsResponse build() {
            return new ListResourceEvaluationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
