/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConfigurationRecordersResponse extends ConfigResponse implements
        ToCopyableBuilder<ListConfigurationRecordersResponse.Builder, ListConfigurationRecordersResponse> {
    private static final SdkField<List<ConfigurationRecorderSummary>> CONFIGURATION_RECORDER_SUMMARIES_FIELD = SdkField
            .<List<ConfigurationRecorderSummary>> builder(MarshallingType.LIST)
            .memberName("ConfigurationRecorderSummaries")
            .getter(getter(ListConfigurationRecordersResponse::configurationRecorderSummaries))
            .setter(setter(Builder::configurationRecorderSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorderSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationRecorderSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationRecorderSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConfigurationRecordersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_RECORDER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfigurationRecorderSummary> configurationRecorderSummaries;

    private final String nextToken;

    private ListConfigurationRecordersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderSummaries = builder.configurationRecorderSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationRecorderSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationRecorderSummaries() {
        return configurationRecorderSummaries != null && !(configurationRecorderSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ConfigurationRecorderSummary</code> objects that includes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationRecorderSummaries} method.
     * </p>
     * 
     * @return A list of <code>ConfigurationRecorderSummary</code> objects that includes.
     */
    public final List<ConfigurationRecorderSummary> configurationRecorderSummaries() {
        return configurationRecorderSummaries;
    }

    /**
     * <p>
     * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in a
     * paginated response.
     * </p>
     * 
     * @return The <code>NextToken</code> string returned on a previous page that you use to get the next page of
     *         results in a paginated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasConfigurationRecorderSummaries() ? configurationRecorderSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationRecordersResponse)) {
            return false;
        }
        ListConfigurationRecordersResponse other = (ListConfigurationRecordersResponse) obj;
        return hasConfigurationRecorderSummaries() == other.hasConfigurationRecorderSummaries()
                && Objects.equals(configurationRecorderSummaries(), other.configurationRecorderSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListConfigurationRecordersResponse")
                .add("ConfigurationRecorderSummaries",
                        hasConfigurationRecorderSummaries() ? configurationRecorderSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorderSummaries":
            return Optional.ofNullable(clazz.cast(configurationRecorderSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationRecorderSummaries", CONFIGURATION_RECORDER_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationRecordersResponse, T> g) {
        return obj -> g.apply((ListConfigurationRecordersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListConfigurationRecordersResponse> {
        /**
         * <p>
         * A list of <code>ConfigurationRecorderSummary</code> objects that includes.
         * </p>
         * 
         * @param configurationRecorderSummaries
         *        A list of <code>ConfigurationRecorderSummary</code> objects that includes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderSummaries(Collection<ConfigurationRecorderSummary> configurationRecorderSummaries);

        /**
         * <p>
         * A list of <code>ConfigurationRecorderSummary</code> objects that includes.
         * </p>
         * 
         * @param configurationRecorderSummaries
         *        A list of <code>ConfigurationRecorderSummary</code> objects that includes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderSummaries(ConfigurationRecorderSummary... configurationRecorderSummaries);

        /**
         * <p>
         * A list of <code>ConfigurationRecorderSummary</code> objects that includes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.ConfigurationRecorderSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.config.model.ConfigurationRecorderSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.ConfigurationRecorderSummary.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #configurationRecorderSummaries(List<ConfigurationRecorderSummary>)}.
         * 
         * @param configurationRecorderSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.ConfigurationRecorderSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationRecorderSummaries(java.util.Collection<ConfigurationRecorderSummary>)
         */
        Builder configurationRecorderSummaries(Consumer<ConfigurationRecorderSummary.Builder>... configurationRecorderSummaries);

        /**
         * <p>
         * The <code>NextToken</code> string returned on a previous page that you use to get the next page of results in
         * a paginated response.
         * </p>
         * 
         * @param nextToken
         *        The <code>NextToken</code> string returned on a previous page that you use to get the next page of
         *        results in a paginated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConfigResponse.BuilderImpl implements Builder {
        private List<ConfigurationRecorderSummary> configurationRecorderSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationRecordersResponse model) {
            super(model);
            configurationRecorderSummaries(model.configurationRecorderSummaries);
            nextToken(model.nextToken);
        }

        public final List<ConfigurationRecorderSummary.Builder> getConfigurationRecorderSummaries() {
            List<ConfigurationRecorderSummary.Builder> result = ConfigurationRecorderSummariesCopier
                    .copyToBuilder(this.configurationRecorderSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationRecorderSummaries(
                Collection<ConfigurationRecorderSummary.BuilderImpl> configurationRecorderSummaries) {
            this.configurationRecorderSummaries = ConfigurationRecorderSummariesCopier
                    .copyFromBuilder(configurationRecorderSummaries);
        }

        @Override
        public final Builder configurationRecorderSummaries(
                Collection<ConfigurationRecorderSummary> configurationRecorderSummaries) {
            this.configurationRecorderSummaries = ConfigurationRecorderSummariesCopier.copy(configurationRecorderSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderSummaries(ConfigurationRecorderSummary... configurationRecorderSummaries) {
            configurationRecorderSummaries(Arrays.asList(configurationRecorderSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderSummaries(
                Consumer<ConfigurationRecorderSummary.Builder>... configurationRecorderSummaries) {
            configurationRecorderSummaries(Stream.of(configurationRecorderSummaries)
                    .map(c -> ConfigurationRecorderSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationRecordersResponse build() {
            return new ListConfigurationRecordersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
