/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the <a>DescribeConfigurationRecorders</a> action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConfigurationRecordersRequest extends ConfigRequest implements
        ToCopyableBuilder<DescribeConfigurationRecordersRequest.Builder, DescribeConfigurationRecordersRequest> {
    private static final SdkField<List<String>> CONFIGURATION_RECORDER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ConfigurationRecorderNames")
            .getter(getter(DescribeConfigurationRecordersRequest::configurationRecorderNames))
            .setter(setter(Builder::configurationRecorderNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationRecorderNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServicePrincipal").getter(getter(DescribeConfigurationRecordersRequest::servicePrincipal))
            .setter(setter(Builder::servicePrincipal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePrincipal").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeConfigurationRecordersRequest::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_RECORDER_NAMES_FIELD, SERVICE_PRINCIPAL_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> configurationRecorderNames;

    private final String servicePrincipal;

    private final String arn;

    private DescribeConfigurationRecordersRequest(BuilderImpl builder) {
        super(builder);
        this.configurationRecorderNames = builder.configurationRecorderNames;
        this.servicePrincipal = builder.servicePrincipal;
        this.arn = builder.arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationRecorderNames property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationRecorderNames() {
        return configurationRecorderNames != null && !(configurationRecorderNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of names of the configuration recorders that you want to specify.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationRecorderNames} method.
     * </p>
     * 
     * @return A list of names of the configuration recorders that you want to specify.</p> <note>
     *         <p>
     *         When making a request to this operation, you can only specify one configuration recorder.
     *         </p>
     */
    public final List<String> configurationRecorderNames() {
        return configurationRecorderNames;
    }

    /**
     * <p>
     * For service-linked configuration recorders, you can use the service principal of the linked Amazon Web Services
     * service to specify the configuration recorder.
     * </p>
     * 
     * @return For service-linked configuration recorders, you can use the service principal of the linked Amazon Web
     *         Services service to specify the configuration recorder.
     */
    public final String servicePrincipal() {
        return servicePrincipal;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the configuration recorder that you want to specify.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the configuration recorder that you want to specify.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationRecorderNames() ? configurationRecorderNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(servicePrincipal());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationRecordersRequest)) {
            return false;
        }
        DescribeConfigurationRecordersRequest other = (DescribeConfigurationRecordersRequest) obj;
        return hasConfigurationRecorderNames() == other.hasConfigurationRecorderNames()
                && Objects.equals(configurationRecorderNames(), other.configurationRecorderNames())
                && Objects.equals(servicePrincipal(), other.servicePrincipal()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConfigurationRecordersRequest")
                .add("ConfigurationRecorderNames", hasConfigurationRecorderNames() ? configurationRecorderNames() : null)
                .add("ServicePrincipal", servicePrincipal()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationRecorderNames":
            return Optional.ofNullable(clazz.cast(configurationRecorderNames()));
        case "ServicePrincipal":
            return Optional.ofNullable(clazz.cast(servicePrincipal()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationRecorderNames", CONFIGURATION_RECORDER_NAMES_FIELD);
        map.put("ServicePrincipal", SERVICE_PRINCIPAL_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationRecordersRequest, T> g) {
        return obj -> g.apply((DescribeConfigurationRecordersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeConfigurationRecordersRequest> {
        /**
         * <p>
         * A list of names of the configuration recorders that you want to specify.
         * </p>
         * <note>
         * <p>
         * When making a request to this operation, you can only specify one configuration recorder.
         * </p>
         * </note>
         * 
         * @param configurationRecorderNames
         *        A list of names of the configuration recorders that you want to specify.</p> <note>
         *        <p>
         *        When making a request to this operation, you can only specify one configuration recorder.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderNames(Collection<String> configurationRecorderNames);

        /**
         * <p>
         * A list of names of the configuration recorders that you want to specify.
         * </p>
         * <note>
         * <p>
         * When making a request to this operation, you can only specify one configuration recorder.
         * </p>
         * </note>
         * 
         * @param configurationRecorderNames
         *        A list of names of the configuration recorders that you want to specify.</p> <note>
         *        <p>
         *        When making a request to this operation, you can only specify one configuration recorder.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationRecorderNames(String... configurationRecorderNames);

        /**
         * <p>
         * For service-linked configuration recorders, you can use the service principal of the linked Amazon Web
         * Services service to specify the configuration recorder.
         * </p>
         * 
         * @param servicePrincipal
         *        For service-linked configuration recorders, you can use the service principal of the linked Amazon Web
         *        Services service to specify the configuration recorder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servicePrincipal(String servicePrincipal);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the configuration recorder that you want to specify.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the configuration recorder that you want to specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private List<String> configurationRecorderNames = DefaultSdkAutoConstructList.getInstance();

        private String servicePrincipal;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationRecordersRequest model) {
            super(model);
            configurationRecorderNames(model.configurationRecorderNames);
            servicePrincipal(model.servicePrincipal);
            arn(model.arn);
        }

        public final Collection<String> getConfigurationRecorderNames() {
            if (configurationRecorderNames instanceof SdkAutoConstructList) {
                return null;
            }
            return configurationRecorderNames;
        }

        public final void setConfigurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
        }

        @Override
        public final Builder configurationRecorderNames(Collection<String> configurationRecorderNames) {
            this.configurationRecorderNames = ConfigurationRecorderNameListCopier.copy(configurationRecorderNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationRecorderNames(String... configurationRecorderNames) {
            configurationRecorderNames(Arrays.asList(configurationRecorderNames));
            return this;
        }

        public final String getServicePrincipal() {
            return servicePrincipal;
        }

        public final void setServicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
        }

        @Override
        public final Builder servicePrincipal(String servicePrincipal) {
            this.servicePrincipal = servicePrincipal;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConfigurationRecordersRequest build() {
            return new DescribeConfigurationRecordersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
