/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the runtime system, policy definition, and whether debug logging enabled. You can specify the following
 * CustomPolicyDetails parameter values only for Config Custom Policy rules.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomPolicyDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomPolicyDetails.Builder, CustomPolicyDetails> {
    private static final SdkField<String> POLICY_RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyRuntime").getter(getter(CustomPolicyDetails::policyRuntime))
            .setter(setter(Builder::policyRuntime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRuntime").build()).build();

    private static final SdkField<String> POLICY_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyText").getter(getter(CustomPolicyDetails::policyText)).setter(setter(Builder::policyText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyText").build()).build();

    private static final SdkField<Boolean> ENABLE_DEBUG_LOG_DELIVERY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableDebugLogDelivery").getter(getter(CustomPolicyDetails::enableDebugLogDelivery))
            .setter(setter(Builder::enableDebugLogDelivery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDebugLogDelivery").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_RUNTIME_FIELD,
            POLICY_TEXT_FIELD, ENABLE_DEBUG_LOG_DELIVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String policyRuntime;

    private final String policyText;

    private final Boolean enableDebugLogDelivery;

    private CustomPolicyDetails(BuilderImpl builder) {
        this.policyRuntime = builder.policyRuntime;
        this.policyText = builder.policyText;
        this.enableDebugLogDelivery = builder.enableDebugLogDelivery;
    }

    /**
     * <p>
     * The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to
     * write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a
     * href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.
     * </p>
     * 
     * @return The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you
     *         to write policies that are enforced by Config Custom Policy rules. For more information about Guard, see
     *         the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.
     */
    public final String policyRuntime() {
        return policyRuntime;
    }

    /**
     * <p>
     * The policy definition containing the logic for your Config Custom Policy rule.
     * </p>
     * 
     * @return The policy definition containing the logic for your Config Custom Policy rule.
     */
    public final String policyText() {
        return policyText;
    }

    /**
     * <p>
     * The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is
     * <code>false</code>.
     * </p>
     * 
     * @return The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value
     *         is <code>false</code>.
     */
    public final Boolean enableDebugLogDelivery() {
        return enableDebugLogDelivery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyRuntime());
        hashCode = 31 * hashCode + Objects.hashCode(policyText());
        hashCode = 31 * hashCode + Objects.hashCode(enableDebugLogDelivery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomPolicyDetails)) {
            return false;
        }
        CustomPolicyDetails other = (CustomPolicyDetails) obj;
        return Objects.equals(policyRuntime(), other.policyRuntime()) && Objects.equals(policyText(), other.policyText())
                && Objects.equals(enableDebugLogDelivery(), other.enableDebugLogDelivery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomPolicyDetails").add("PolicyRuntime", policyRuntime()).add("PolicyText", policyText())
                .add("EnableDebugLogDelivery", enableDebugLogDelivery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyRuntime":
            return Optional.ofNullable(clazz.cast(policyRuntime()));
        case "PolicyText":
            return Optional.ofNullable(clazz.cast(policyText()));
        case "EnableDebugLogDelivery":
            return Optional.ofNullable(clazz.cast(enableDebugLogDelivery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyRuntime", POLICY_RUNTIME_FIELD);
        map.put("PolicyText", POLICY_TEXT_FIELD);
        map.put("EnableDebugLogDelivery", ENABLE_DEBUG_LOG_DELIVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomPolicyDetails, T> g) {
        return obj -> g.apply((CustomPolicyDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomPolicyDetails> {
        /**
         * <p>
         * The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows you to
         * write policies that are enforced by Config Custom Policy rules. For more information about Guard, see the <a
         * href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub Repository</a>.
         * </p>
         * 
         * @param policyRuntime
         *        The runtime system for your Config Custom Policy rule. Guard is a policy-as-code language that allows
         *        you to write policies that are enforced by Config Custom Policy rules. For more information about
         *        Guard, see the <a href="https://github.com/aws-cloudformation/cloudformation-guard">Guard GitHub
         *        Repository</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRuntime(String policyRuntime);

        /**
         * <p>
         * The policy definition containing the logic for your Config Custom Policy rule.
         * </p>
         * 
         * @param policyText
         *        The policy definition containing the logic for your Config Custom Policy rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyText(String policyText);

        /**
         * <p>
         * The boolean expression for enabling debug logging for your Config Custom Policy rule. The default value is
         * <code>false</code>.
         * </p>
         * 
         * @param enableDebugLogDelivery
         *        The boolean expression for enabling debug logging for your Config Custom Policy rule. The default
         *        value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDebugLogDelivery(Boolean enableDebugLogDelivery);
    }

    static final class BuilderImpl implements Builder {
        private String policyRuntime;

        private String policyText;

        private Boolean enableDebugLogDelivery;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomPolicyDetails model) {
            policyRuntime(model.policyRuntime);
            policyText(model.policyText);
            enableDebugLogDelivery(model.enableDebugLogDelivery);
        }

        public final String getPolicyRuntime() {
            return policyRuntime;
        }

        public final void setPolicyRuntime(String policyRuntime) {
            this.policyRuntime = policyRuntime;
        }

        @Override
        public final Builder policyRuntime(String policyRuntime) {
            this.policyRuntime = policyRuntime;
            return this;
        }

        public final String getPolicyText() {
            return policyText;
        }

        public final void setPolicyText(String policyText) {
            this.policyText = policyText;
        }

        @Override
        public final Builder policyText(String policyText) {
            this.policyText = policyText;
            return this;
        }

        public final Boolean getEnableDebugLogDelivery() {
            return enableDebugLogDelivery;
        }

        public final void setEnableDebugLogDelivery(Boolean enableDebugLogDelivery) {
            this.enableDebugLogDelivery = enableDebugLogDelivery;
        }

        @Override
        public final Builder enableDebugLogDelivery(Boolean enableDebugLogDelivery) {
            this.enableDebugLogDelivery = enableDebugLogDelivery;
            return this;
        }

        @Override
        public CustomPolicyDetails build() {
            return new CustomPolicyDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
