/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details about the configuration aggregator, including information about source accounts, regions, and metadata of
 * the aggregator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigurationAggregator implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfigurationAggregator.Builder, ConfigurationAggregator> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationAggregatorName")
            .getter(getter(ConfigurationAggregator::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final SdkField<String> CONFIGURATION_AGGREGATOR_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationAggregatorArn")
            .getter(getter(ConfigurationAggregator::configurationAggregatorArn))
            .setter(setter(Builder::configurationAggregatorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorArn").build())
            .build();

    private static final SdkField<List<AccountAggregationSource>> ACCOUNT_AGGREGATION_SOURCES_FIELD = SdkField
            .<List<AccountAggregationSource>> builder(MarshallingType.LIST)
            .memberName("AccountAggregationSources")
            .getter(getter(ConfigurationAggregator::accountAggregationSources))
            .setter(setter(Builder::accountAggregationSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAggregationSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AccountAggregationSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccountAggregationSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OrganizationAggregationSource> ORGANIZATION_AGGREGATION_SOURCE_FIELD = SdkField
            .<OrganizationAggregationSource> builder(MarshallingType.SDK_POJO)
            .memberName("OrganizationAggregationSource")
            .getter(getter(ConfigurationAggregator::organizationAggregationSource))
            .setter(setter(Builder::organizationAggregationSource))
            .constructor(OrganizationAggregationSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationAggregationSource")
                    .build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ConfigurationAggregator::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(ConfigurationAggregator::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(ConfigurationAggregator::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<AggregatorFilters> AGGREGATOR_FILTERS_FIELD = SdkField
            .<AggregatorFilters> builder(MarshallingType.SDK_POJO).memberName("AggregatorFilters")
            .getter(getter(ConfigurationAggregator::aggregatorFilters)).setter(setter(Builder::aggregatorFilters))
            .constructor(AggregatorFilters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorFilters").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAME_FIELD, CONFIGURATION_AGGREGATOR_ARN_FIELD, ACCOUNT_AGGREGATION_SOURCES_FIELD,
            ORGANIZATION_AGGREGATION_SOURCE_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_BY_FIELD,
            AGGREGATOR_FILTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationAggregatorName;

    private final String configurationAggregatorArn;

    private final List<AccountAggregationSource> accountAggregationSources;

    private final OrganizationAggregationSource organizationAggregationSource;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private final String createdBy;

    private final AggregatorFilters aggregatorFilters;

    private ConfigurationAggregator(BuilderImpl builder) {
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.configurationAggregatorArn = builder.configurationAggregatorArn;
        this.accountAggregationSources = builder.accountAggregationSources;
        this.organizationAggregationSource = builder.organizationAggregationSource;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdBy = builder.createdBy;
        this.aggregatorFilters = builder.aggregatorFilters;
    }

    /**
     * <p>
     * The name of the aggregator.
     * </p>
     * 
     * @return The name of the aggregator.
     */
    public final String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the aggregator.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the aggregator.
     */
    public final String configurationAggregatorArn() {
        return configurationAggregatorArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountAggregationSources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccountAggregationSources() {
        return accountAggregationSources != null && !(accountAggregationSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of source accounts and regions to be aggregated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountAggregationSources} method.
     * </p>
     * 
     * @return Provides a list of source accounts and regions to be aggregated.
     */
    public final List<AccountAggregationSource> accountAggregationSources() {
        return accountAggregationSources;
    }

    /**
     * <p>
     * Provides an organization and list of regions to be aggregated.
     * </p>
     * 
     * @return Provides an organization and list of regions to be aggregated.
     */
    public final OrganizationAggregationSource organizationAggregationSource() {
        return organizationAggregationSource;
    }

    /**
     * <p>
     * The time stamp when the configuration aggregator was created.
     * </p>
     * 
     * @return The time stamp when the configuration aggregator was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time of the last update.
     * </p>
     * 
     * @return The time of the last update.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Amazon Web Services service that created the configuration aggregator.
     * </p>
     * 
     * @return Amazon Web Services service that created the configuration aggregator.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * An object to filter the data you specify for an aggregator.
     * </p>
     * 
     * @return An object to filter the data you specify for an aggregator.
     */
    public final AggregatorFilters aggregatorFilters() {
        return aggregatorFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountAggregationSources() ? accountAggregationSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(organizationAggregationSource());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(aggregatorFilters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationAggregator)) {
            return false;
        }
        ConfigurationAggregator other = (ConfigurationAggregator) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && Objects.equals(configurationAggregatorArn(), other.configurationAggregatorArn())
                && hasAccountAggregationSources() == other.hasAccountAggregationSources()
                && Objects.equals(accountAggregationSources(), other.accountAggregationSources())
                && Objects.equals(organizationAggregationSource(), other.organizationAggregationSource())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(aggregatorFilters(), other.aggregatorFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigurationAggregator").add("ConfigurationAggregatorName", configurationAggregatorName())
                .add("ConfigurationAggregatorArn", configurationAggregatorArn())
                .add("AccountAggregationSources", hasAccountAggregationSources() ? accountAggregationSources() : null)
                .add("OrganizationAggregationSource", organizationAggregationSource()).add("CreationTime", creationTime())
                .add("LastUpdatedTime", lastUpdatedTime()).add("CreatedBy", createdBy())
                .add("AggregatorFilters", aggregatorFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "ConfigurationAggregatorArn":
            return Optional.ofNullable(clazz.cast(configurationAggregatorArn()));
        case "AccountAggregationSources":
            return Optional.ofNullable(clazz.cast(accountAggregationSources()));
        case "OrganizationAggregationSource":
            return Optional.ofNullable(clazz.cast(organizationAggregationSource()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "AggregatorFilters":
            return Optional.ofNullable(clazz.cast(aggregatorFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationAggregatorName", CONFIGURATION_AGGREGATOR_NAME_FIELD);
        map.put("ConfigurationAggregatorArn", CONFIGURATION_AGGREGATOR_ARN_FIELD);
        map.put("AccountAggregationSources", ACCOUNT_AGGREGATION_SOURCES_FIELD);
        map.put("OrganizationAggregationSource", ORGANIZATION_AGGREGATION_SOURCE_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("AggregatorFilters", AGGREGATOR_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationAggregator, T> g) {
        return obj -> g.apply((ConfigurationAggregator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigurationAggregator> {
        /**
         * <p>
         * The name of the aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the aggregator.
         * </p>
         * 
         * @param configurationAggregatorArn
         *        The Amazon Resource Name (ARN) of the aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorArn(String configurationAggregatorArn);

        /**
         * <p>
         * Provides a list of source accounts and regions to be aggregated.
         * </p>
         * 
         * @param accountAggregationSources
         *        Provides a list of source accounts and regions to be aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAggregationSources(Collection<AccountAggregationSource> accountAggregationSources);

        /**
         * <p>
         * Provides a list of source accounts and regions to be aggregated.
         * </p>
         * 
         * @param accountAggregationSources
         *        Provides a list of source accounts and regions to be aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountAggregationSources(AccountAggregationSource... accountAggregationSources);

        /**
         * <p>
         * Provides a list of source accounts and regions to be aggregated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.AccountAggregationSource.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.config.model.AccountAggregationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.AccountAggregationSource.Builder#build()} is called
         * immediately and its result is passed to {@link #accountAggregationSources(List<AccountAggregationSource>)}.
         * 
         * @param accountAggregationSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.AccountAggregationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountAggregationSources(java.util.Collection<AccountAggregationSource>)
         */
        Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder>... accountAggregationSources);

        /**
         * <p>
         * Provides an organization and list of regions to be aggregated.
         * </p>
         * 
         * @param organizationAggregationSource
         *        Provides an organization and list of regions to be aggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationAggregationSource(OrganizationAggregationSource organizationAggregationSource);

        /**
         * <p>
         * Provides an organization and list of regions to be aggregated.
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationAggregationSource.Builder}
         * avoiding the need to create one manually via {@link OrganizationAggregationSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationAggregationSource.Builder#build()} is called
         * immediately and its result is passed to {@link #organizationAggregationSource(OrganizationAggregationSource)}.
         * 
         * @param organizationAggregationSource
         *        a consumer that will call methods on {@link OrganizationAggregationSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationAggregationSource(OrganizationAggregationSource)
         */
        default Builder organizationAggregationSource(
                Consumer<OrganizationAggregationSource.Builder> organizationAggregationSource) {
            return organizationAggregationSource(OrganizationAggregationSource.builder()
                    .applyMutation(organizationAggregationSource).build());
        }

        /**
         * <p>
         * The time stamp when the configuration aggregator was created.
         * </p>
         * 
         * @param creationTime
         *        The time stamp when the configuration aggregator was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time of the last update.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The time of the last update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Amazon Web Services service that created the configuration aggregator.
         * </p>
         * 
         * @param createdBy
         *        Amazon Web Services service that created the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * An object to filter the data you specify for an aggregator.
         * </p>
         * 
         * @param aggregatorFilters
         *        An object to filter the data you specify for an aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregatorFilters(AggregatorFilters aggregatorFilters);

        /**
         * <p>
         * An object to filter the data you specify for an aggregator.
         * </p>
         * This is a convenience method that creates an instance of the {@link AggregatorFilters.Builder} avoiding the
         * need to create one manually via {@link AggregatorFilters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AggregatorFilters.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregatorFilters(AggregatorFilters)}.
         * 
         * @param aggregatorFilters
         *        a consumer that will call methods on {@link AggregatorFilters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregatorFilters(AggregatorFilters)
         */
        default Builder aggregatorFilters(Consumer<AggregatorFilters.Builder> aggregatorFilters) {
            return aggregatorFilters(AggregatorFilters.builder().applyMutation(aggregatorFilters).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private String configurationAggregatorArn;

        private List<AccountAggregationSource> accountAggregationSources = DefaultSdkAutoConstructList.getInstance();

        private OrganizationAggregationSource organizationAggregationSource;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private String createdBy;

        private AggregatorFilters aggregatorFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationAggregator model) {
            configurationAggregatorName(model.configurationAggregatorName);
            configurationAggregatorArn(model.configurationAggregatorArn);
            accountAggregationSources(model.accountAggregationSources);
            organizationAggregationSource(model.organizationAggregationSource);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
            createdBy(model.createdBy);
            aggregatorFilters(model.aggregatorFilters);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final String getConfigurationAggregatorArn() {
            return configurationAggregatorArn;
        }

        public final void setConfigurationAggregatorArn(String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
        }

        @Override
        public final Builder configurationAggregatorArn(String configurationAggregatorArn) {
            this.configurationAggregatorArn = configurationAggregatorArn;
            return this;
        }

        public final List<AccountAggregationSource.Builder> getAccountAggregationSources() {
            List<AccountAggregationSource.Builder> result = AccountAggregationSourceListCopier
                    .copyToBuilder(this.accountAggregationSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccountAggregationSources(Collection<AccountAggregationSource.BuilderImpl> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copyFromBuilder(accountAggregationSources);
        }

        @Override
        public final Builder accountAggregationSources(Collection<AccountAggregationSource> accountAggregationSources) {
            this.accountAggregationSources = AccountAggregationSourceListCopier.copy(accountAggregationSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(AccountAggregationSource... accountAggregationSources) {
            accountAggregationSources(Arrays.asList(accountAggregationSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountAggregationSources(Consumer<AccountAggregationSource.Builder>... accountAggregationSources) {
            accountAggregationSources(Stream.of(accountAggregationSources)
                    .map(c -> AccountAggregationSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final OrganizationAggregationSource.Builder getOrganizationAggregationSource() {
            return organizationAggregationSource != null ? organizationAggregationSource.toBuilder() : null;
        }

        public final void setOrganizationAggregationSource(OrganizationAggregationSource.BuilderImpl organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource != null ? organizationAggregationSource.build()
                    : null;
        }

        @Override
        public final Builder organizationAggregationSource(OrganizationAggregationSource organizationAggregationSource) {
            this.organizationAggregationSource = organizationAggregationSource;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final AggregatorFilters.Builder getAggregatorFilters() {
            return aggregatorFilters != null ? aggregatorFilters.toBuilder() : null;
        }

        public final void setAggregatorFilters(AggregatorFilters.BuilderImpl aggregatorFilters) {
            this.aggregatorFilters = aggregatorFilters != null ? aggregatorFilters.build() : null;
        }

        @Override
        public final Builder aggregatorFilters(AggregatorFilters aggregatorFilters) {
            this.aggregatorFilters = aggregatorFilters;
            return this;
        }

        @Override
        public ConfigurationAggregator build() {
            return new ConfigurationAggregator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
