/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAggregateResourceConfigRequest extends ConfigRequest implements
        ToCopyableBuilder<BatchGetAggregateResourceConfigRequest.Builder, BatchGetAggregateResourceConfigRequest> {
    private static final SdkField<String> CONFIGURATION_AGGREGATOR_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationAggregatorName")
            .getter(getter(BatchGetAggregateResourceConfigRequest::configurationAggregatorName))
            .setter(setter(Builder::configurationAggregatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAggregatorName")
                    .build()).build();

    private static final SdkField<List<AggregateResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<AggregateResourceIdentifier>> builder(MarshallingType.LIST)
            .memberName("ResourceIdentifiers")
            .getter(getter(BatchGetAggregateResourceConfigRequest::resourceIdentifiers))
            .setter(setter(Builder::resourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AggregateResourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(AggregateResourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_AGGREGATOR_NAME_FIELD, RESOURCE_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String configurationAggregatorName;

    private final List<AggregateResourceIdentifier> resourceIdentifiers;

    private BatchGetAggregateResourceConfigRequest(BuilderImpl builder) {
        super(builder);
        this.configurationAggregatorName = builder.configurationAggregatorName;
        this.resourceIdentifiers = builder.resourceIdentifiers;
    }

    /**
     * <p>
     * The name of the configuration aggregator.
     * </p>
     * 
     * @return The name of the configuration aggregator.
     */
    public final String configurationAggregatorName() {
        return configurationAggregatorName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIdentifiers() {
        return resourceIdentifiers != null && !(resourceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of aggregate ResourceIdentifiers objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIdentifiers} method.
     * </p>
     * 
     * @return A list of aggregate ResourceIdentifiers objects.
     */
    public final List<AggregateResourceIdentifier> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configurationAggregatorName());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIdentifiers() ? resourceIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAggregateResourceConfigRequest)) {
            return false;
        }
        BatchGetAggregateResourceConfigRequest other = (BatchGetAggregateResourceConfigRequest) obj;
        return Objects.equals(configurationAggregatorName(), other.configurationAggregatorName())
                && hasResourceIdentifiers() == other.hasResourceIdentifiers()
                && Objects.equals(resourceIdentifiers(), other.resourceIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAggregateResourceConfigRequest")
                .add("ConfigurationAggregatorName", configurationAggregatorName())
                .add("ResourceIdentifiers", hasResourceIdentifiers() ? resourceIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationAggregatorName":
            return Optional.ofNullable(clazz.cast(configurationAggregatorName()));
        case "ResourceIdentifiers":
            return Optional.ofNullable(clazz.cast(resourceIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationAggregatorName", CONFIGURATION_AGGREGATOR_NAME_FIELD);
        map.put("ResourceIdentifiers", RESOURCE_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAggregateResourceConfigRequest, T> g) {
        return obj -> g.apply((BatchGetAggregateResourceConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConfigRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAggregateResourceConfigRequest> {
        /**
         * <p>
         * The name of the configuration aggregator.
         * </p>
         * 
         * @param configurationAggregatorName
         *        The name of the configuration aggregator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAggregatorName(String configurationAggregatorName);

        /**
         * <p>
         * A list of aggregate ResourceIdentifiers objects.
         * </p>
         * 
         * @param resourceIdentifiers
         *        A list of aggregate ResourceIdentifiers objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers);

        /**
         * <p>
         * A list of aggregate ResourceIdentifiers objects.
         * </p>
         * 
         * @param resourceIdentifiers
         *        A list of aggregate ResourceIdentifiers objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(AggregateResourceIdentifier... resourceIdentifiers);

        /**
         * <p>
         * A list of aggregate ResourceIdentifiers objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.config.model.AggregateResourceIdentifier.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.config.model.AggregateResourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.config.model.AggregateResourceIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceIdentifiers(List<AggregateResourceIdentifier>)}.
         * 
         * @param resourceIdentifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.config.model.AggregateResourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifiers(java.util.Collection<AggregateResourceIdentifier>)
         */
        Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder>... resourceIdentifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConfigRequest.BuilderImpl implements Builder {
        private String configurationAggregatorName;

        private List<AggregateResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAggregateResourceConfigRequest model) {
            super(model);
            configurationAggregatorName(model.configurationAggregatorName);
            resourceIdentifiers(model.resourceIdentifiers);
        }

        public final String getConfigurationAggregatorName() {
            return configurationAggregatorName;
        }

        public final void setConfigurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
        }

        @Override
        public final Builder configurationAggregatorName(String configurationAggregatorName) {
            this.configurationAggregatorName = configurationAggregatorName;
            return this;
        }

        public final List<AggregateResourceIdentifier.Builder> getResourceIdentifiers() {
            List<AggregateResourceIdentifier.Builder> result = ResourceIdentifiersListCopier
                    .copyToBuilder(this.resourceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIdentifiers(Collection<AggregateResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersListCopier.copyFromBuilder(resourceIdentifiers);
        }

        @Override
        public final Builder resourceIdentifiers(Collection<AggregateResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifiersListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(AggregateResourceIdentifier... resourceIdentifiers) {
            resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<AggregateResourceIdentifier.Builder>... resourceIdentifiers) {
            resourceIdentifiers(Stream.of(resourceIdentifiers)
                    .map(c -> AggregateResourceIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAggregateResourceConfigRequest build() {
            return new BatchGetAggregateResourceConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
