/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.config;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.config.internal.ConfigServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.config.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.config.model.AssociateResourceTypesRequest;
import software.amazon.awssdk.services.config.model.AssociateResourceTypesResponse;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigRequest;
import software.amazon.awssdk.services.config.model.BatchGetResourceConfigResponse;
import software.amazon.awssdk.services.config.model.ConfigException;
import software.amazon.awssdk.services.config.model.ConflictException;
import software.amazon.awssdk.services.config.model.ConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.DeleteAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.DeleteDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsRequest;
import software.amazon.awssdk.services.config.model.DeleteEvaluationResultsResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.DeleteOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestRequest;
import software.amazon.awssdk.services.config.model.DeletePendingAggregationRequestResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DeleteRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigRequest;
import software.amazon.awssdk.services.config.model.DeleteResourceConfigResponse;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.DeleteRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.DeleteServiceLinkedConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryRequest;
import software.amazon.awssdk.services.config.model.DeleteStoredQueryResponse;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotRequest;
import software.amazon.awssdk.services.config.model.DeliverConfigSnapshotResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRuleEvaluationStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorSourcesStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationAggregatorsResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecorderStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.DescribeConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePackStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsRequest;
import software.amazon.awssdk.services.config.model.DescribeDeliveryChannelsResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRulesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesResponse;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsRequest;
import software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusRequest;
import software.amazon.awssdk.services.config.model.DescribeRemediationExecutionStatusResponse;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest;
import software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse;
import software.amazon.awssdk.services.config.model.DisassociateResourceTypesRequest;
import software.amazon.awssdk.services.config.model.DisassociateResourceTypesResponse;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetAggregateComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetAggregateDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.GetAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceRequest;
import software.amazon.awssdk.services.config.model.GetComplianceDetailsByResourceResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByConfigRuleResponse;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeRequest;
import software.amazon.awssdk.services.config.model.GetComplianceSummaryByResourceTypeResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceDetailsResponse;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryRequest;
import software.amazon.awssdk.services.config.model.GetConformancePackComplianceSummaryResponse;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsRequest;
import software.amazon.awssdk.services.config.model.GetDiscoveredResourceCountsResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyRequest;
import software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryRequest;
import software.amazon.awssdk.services.config.model.GetResourceConfigHistoryResponse;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryRequest;
import software.amazon.awssdk.services.config.model.GetResourceEvaluationSummaryResponse;
import software.amazon.awssdk.services.config.model.GetStoredQueryRequest;
import software.amazon.awssdk.services.config.model.GetStoredQueryResponse;
import software.amazon.awssdk.services.config.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.config.model.InsufficientDeliveryPolicyException;
import software.amazon.awssdk.services.config.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.config.model.InvalidConfigurationRecorderNameException;
import software.amazon.awssdk.services.config.model.InvalidDeliveryChannelNameException;
import software.amazon.awssdk.services.config.model.InvalidExpressionException;
import software.amazon.awssdk.services.config.model.InvalidLimitException;
import software.amazon.awssdk.services.config.model.InvalidNextTokenException;
import software.amazon.awssdk.services.config.model.InvalidParameterValueException;
import software.amazon.awssdk.services.config.model.InvalidRecordingGroupException;
import software.amazon.awssdk.services.config.model.InvalidResultTokenException;
import software.amazon.awssdk.services.config.model.InvalidRoleException;
import software.amazon.awssdk.services.config.model.InvalidS3KeyPrefixException;
import software.amazon.awssdk.services.config.model.InvalidS3KmsKeyArnException;
import software.amazon.awssdk.services.config.model.InvalidSnsTopicArnException;
import software.amazon.awssdk.services.config.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.config.model.LastDeliveryChannelDeleteFailedException;
import software.amazon.awssdk.services.config.model.LimitExceededException;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListAggregateDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersRequest;
import software.amazon.awssdk.services.config.model.ListConfigurationRecordersResponse;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresRequest;
import software.amazon.awssdk.services.config.model.ListConformancePackComplianceScoresResponse;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesRequest;
import software.amazon.awssdk.services.config.model.ListDiscoveredResourcesResponse;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsRequest;
import software.amazon.awssdk.services.config.model.ListResourceEvaluationsResponse;
import software.amazon.awssdk.services.config.model.ListStoredQueriesRequest;
import software.amazon.awssdk.services.config.model.ListStoredQueriesResponse;
import software.amazon.awssdk.services.config.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.config.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.config.model.MaxActiveResourcesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConfigurationRecordersExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfDeliveryChannelsExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConfigRulesExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfOrganizationConformancePacksExceededException;
import software.amazon.awssdk.services.config.model.MaxNumberOfRetentionConfigurationsExceededException;
import software.amazon.awssdk.services.config.model.NoAvailableConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoAvailableDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.config.model.NoRunningConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchBucketException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchConfigRuleInConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationAggregatorException;
import software.amazon.awssdk.services.config.model.NoSuchConfigurationRecorderException;
import software.amazon.awssdk.services.config.model.NoSuchConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchDeliveryChannelException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConfigRuleException;
import software.amazon.awssdk.services.config.model.NoSuchOrganizationConformancePackException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationConfigurationException;
import software.amazon.awssdk.services.config.model.NoSuchRemediationExceptionException;
import software.amazon.awssdk.services.config.model.NoSuchRetentionConfigurationException;
import software.amazon.awssdk.services.config.model.OrganizationAccessDeniedException;
import software.amazon.awssdk.services.config.model.OrganizationAllFeaturesNotEnabledException;
import software.amazon.awssdk.services.config.model.OrganizationConformancePackTemplateValidationException;
import software.amazon.awssdk.services.config.model.OversizedConfigurationItemException;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationRequest;
import software.amazon.awssdk.services.config.model.PutAggregationAuthorizationResponse;
import software.amazon.awssdk.services.config.model.PutConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationAggregatorResponse;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelRequest;
import software.amazon.awssdk.services.config.model.PutDeliveryChannelResponse;
import software.amazon.awssdk.services.config.model.PutEvaluationsRequest;
import software.amazon.awssdk.services.config.model.PutEvaluationsResponse;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationRequest;
import software.amazon.awssdk.services.config.model.PutExternalEvaluationResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleResponse;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest;
import software.amazon.awssdk.services.config.model.PutOrganizationConformancePackResponse;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationConfigurationsResponse;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsRequest;
import software.amazon.awssdk.services.config.model.PutRemediationExceptionsResponse;
import software.amazon.awssdk.services.config.model.PutResourceConfigRequest;
import software.amazon.awssdk.services.config.model.PutResourceConfigResponse;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationRequest;
import software.amazon.awssdk.services.config.model.PutRetentionConfigurationResponse;
import software.amazon.awssdk.services.config.model.PutServiceLinkedConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.PutServiceLinkedConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.PutStoredQueryRequest;
import software.amazon.awssdk.services.config.model.PutStoredQueryResponse;
import software.amazon.awssdk.services.config.model.RemediationInProgressException;
import software.amazon.awssdk.services.config.model.ResourceConcurrentModificationException;
import software.amazon.awssdk.services.config.model.ResourceInUseException;
import software.amazon.awssdk.services.config.model.ResourceNotDiscoveredException;
import software.amazon.awssdk.services.config.model.ResourceNotFoundException;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectAggregateResourceConfigResponse;
import software.amazon.awssdk.services.config.model.SelectResourceConfigRequest;
import software.amazon.awssdk.services.config.model.SelectResourceConfigResponse;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartConfigRulesEvaluationResponse;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StartConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionRequest;
import software.amazon.awssdk.services.config.model.StartRemediationExecutionResponse;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationRequest;
import software.amazon.awssdk.services.config.model.StartResourceEvaluationResponse;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderRequest;
import software.amazon.awssdk.services.config.model.StopConfigurationRecorderResponse;
import software.amazon.awssdk.services.config.model.TagResourceRequest;
import software.amazon.awssdk.services.config.model.TagResourceResponse;
import software.amazon.awssdk.services.config.model.TooManyTagsException;
import software.amazon.awssdk.services.config.model.UnmodifiableEntityException;
import software.amazon.awssdk.services.config.model.UntagResourceRequest;
import software.amazon.awssdk.services.config.model.UntagResourceResponse;
import software.amazon.awssdk.services.config.model.ValidationException;
import software.amazon.awssdk.services.config.transform.AssociateResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.BatchGetResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteEvaluationResultsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeletePendingAggregationRequestRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteServiceLinkedConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeleteStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DeliverConfigSnapshotRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregateComplianceByConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeAggregationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeComplianceByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRuleEvaluationStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorSourcesStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationAggregatorsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecorderStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackComplianceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePackStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeDeliveryChannelsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRuleStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConfigRulesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePackStatusesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeOrganizationConformancePacksRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribePendingAggregationRequestsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRemediationExecutionStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DescribeRetentionConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.DisassociateResourceTypesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConfigRuleComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceDetailsByResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetComplianceSummaryByResourceTypeRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceDetailsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetConformancePackComplianceSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetCustomRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetDiscoveredResourceCountsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConfigRuleDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationConformancePackDetailedStatusRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetOrganizationCustomRulePolicyRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceConfigHistoryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetResourceEvaluationSummaryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.GetStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListAggregateDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListConfigurationRecordersRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListConformancePackComplianceScoresRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListDiscoveredResourcesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListResourceEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListStoredQueriesRequestMarshaller;
import software.amazon.awssdk.services.config.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutAggregationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationAggregatorRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutDeliveryChannelRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutEvaluationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutExternalEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConfigRuleRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutOrganizationConformancePackRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRemediationExceptionsRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutRetentionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutServiceLinkedConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.PutStoredQueryRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectAggregateResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.SelectResourceConfigRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigRulesEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartRemediationExecutionRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StartResourceEvaluationRequestMarshaller;
import software.amazon.awssdk.services.config.transform.StopConfigurationRecorderRequestMarshaller;
import software.amazon.awssdk.services.config.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.config.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link ConfigAsyncClient}.
 *
 * @see ConfigAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultConfigAsyncClient implements ConfigAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultConfigAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultConfigAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Config_Service" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Adds all resource types specified in the <code>ResourceTypes</code> list to the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingGroup.html">RecordingGroup</a> of
     * specified configuration recorder and includes those resource types when recording.
     * </p>
     * <p>
     * For this operation, the specified configuration recorder must use a <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_RecordingStrategy.html">RecordingStrategy</a>
     * that is either <code>INCLUSION_BY_RESOURCE_TYPES</code> or <code>EXCLUSION_BY_RESOURCE_TYPES</code>.
     * </p>
     *
     * @param associateResourceTypesRequest
     * @return A Java Future containing the result of the AssociateResourceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ConflictException For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a
     *         service-linked recorder already exists for the specified service.</p>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it
     *         is currently in use by the linked Amazon Web Services service.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">
     *         DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed
     *         configuration recorder is running. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder is not in use by the service. No
     *         association or dissociation of resource types is permitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, your requested change to the configuration recorder has been
     *         denied by its linked Amazon Web Services service.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.AssociateResourceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AssociateResourceTypes" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateResourceTypesResponse> associateResourceTypes(
            AssociateResourceTypesRequest associateResourceTypesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateResourceTypesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateResourceTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateResourceTypes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateResourceTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateResourceTypesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<AssociateResourceTypesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateResourceTypesRequest, AssociateResourceTypesResponse>()
                            .withOperationName("AssociateResourceTypes").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AssociateResourceTypesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateResourceTypesRequest));
            CompletableFuture<AssociateResourceTypesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current configuration items for resources that are present in your Config aggregator. The operation
     * also returns a list of resources that are not processed in the current request. If there are no unprocessed
     * resources, the operation returns an empty <code>unprocessedResourceIdentifiers</code> list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return tags and relationships.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetAggregateResourceConfigRequest
     * @return A Java Future containing the result of the BatchGetAggregateResourceConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetAggregateResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetAggregateResourceConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetAggregateResourceConfigResponse> batchGetAggregateResourceConfig(
            BatchGetAggregateResourceConfigRequest batchGetAggregateResourceConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetAggregateResourceConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                batchGetAggregateResourceConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetAggregateResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetAggregateResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetAggregateResourceConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetAggregateResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetAggregateResourceConfigRequest, BatchGetAggregateResourceConfigResponse>()
                            .withOperationName("BatchGetAggregateResourceConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetAggregateResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetAggregateResourceConfigRequest));
            CompletableFuture<BatchGetAggregateResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the <code>BaseConfigurationItem</code> for one or more requested resources. The operation also returns a
     * list of resources that are not processed in the current request. If there are no unprocessed resources, the
     * operation returns an empty unprocessedResourceKeys list.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The API does not return results for deleted resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * The API does not return any tags for the requested resources. This information is filtered out of the
     * supplementaryConfiguration section of the API response.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param batchGetResourceConfigRequest
     * @return A Java Future containing the result of the BatchGetResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoAvailableConfigurationRecorderException There are no customer managed configuration recorders
     *         available to record your resources. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html"
     *         >PutConfigurationRecorder</a> operation to create the customer managed configuration recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.BatchGetResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BatchGetResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetResourceConfigResponse> batchGetResourceConfig(
            BatchGetResourceConfigRequest batchGetResourceConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetResourceConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetResourceConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<BatchGetResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetResourceConfigRequest, BatchGetResourceConfigResponse>()
                            .withOperationName("BatchGetResourceConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetResourceConfigRequest));
            CompletableFuture<BatchGetResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the authorization granted to the specified configuration aggregator account in a specified region.
     * </p>
     *
     * @param deleteAggregationAuthorizationRequest
     * @return A Java Future containing the result of the DeleteAggregationAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteAggregationAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteAggregationAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAggregationAuthorizationResponse> deleteAggregationAuthorization(
            DeleteAggregationAuthorizationRequest deleteAggregationAuthorizationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAggregationAuthorizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAggregationAuthorizationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAggregationAuthorization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAggregationAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAggregationAuthorizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteAggregationAuthorizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAggregationAuthorizationRequest, DeleteAggregationAuthorizationResponse>()
                            .withOperationName("DeleteAggregationAuthorization").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAggregationAuthorizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteAggregationAuthorizationRequest));
            CompletableFuture<DeleteAggregationAuthorizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified Config rule and all of its evaluation results.
     * </p>
     * <p>
     * Config sets the state of a rule to <code>DELETING</code> until the deletion is complete. You cannot update a rule
     * while it is in this state. If you make a <code>PutConfigRule</code> or <code>DeleteConfigRule</code> request for
     * the rule, you will receive a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * You can check the state of a rule by using the <code>DescribeConfigRules</code> request.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note>
     *
     * @param deleteConfigRuleRequest
     * @return A Java Future containing the result of the DeleteConfigRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigRule" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigRuleResponse> deleteConfigRule(DeleteConfigRuleRequest deleteConfigRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfigRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfigRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigRuleRequest, DeleteConfigRuleResponse>()
                            .withOperationName("DeleteConfigRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfigRuleRequest));
            CompletableFuture<DeleteConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified configuration aggregator and the aggregated data associated with the aggregator.
     * </p>
     *
     * @param deleteConfigurationAggregatorRequest
     * @return A Java Future containing the result of the DeleteConfigurationAggregator operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigurationAggregatorResponse> deleteConfigurationAggregator(
            DeleteConfigurationAggregatorRequest deleteConfigurationAggregatorRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfigurationAggregatorRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteConfigurationAggregatorRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationAggregator");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigurationAggregatorResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfigurationAggregatorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteConfigurationAggregatorResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationAggregatorRequest, DeleteConfigurationAggregatorResponse>()
                            .withOperationName("DeleteConfigurationAggregator").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfigurationAggregatorRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfigurationAggregatorRequest));
            CompletableFuture<DeleteConfigurationAggregatorResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the customer managed configuration recorder.
     * </p>
     * <p>
     * This operation does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html"
     * >GetResourceConfigHistory</a> operation, but you will not be able to access this information in the Config
     * console until you have created a new customer managed configuration recorder.
     * </p>
     *
     * @param deleteConfigurationRecorderRequest
     *        The request object for the <code>DeleteConfigurationRecorder</code> operation.
     * @return A Java Future containing the result of the DeleteConfigurationRecorder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>UnmodifiableEntityException The requested operation is not valid.</p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html">
     *         PutConfigurationRecorder</a>, you will see this exception because you cannot use this operation to create
     *         a service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a> operation to create a service-linked configuration recorder.
     *         </p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteConfigurationRecorder.html">
     *         DeleteConfigurationRecorder</a>, you will see this exception because you cannot use this operation to
     *         delete a service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a> operation to delete a service-linked configuration
     *         recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_StartConfigurationRecorder.html">
     *         StartConfigurationRecorder</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a>, you will see this exception because these operations do not affect
     *         service-linked configuration recorders. Service-linked configuration recorders are always recording. To
     *         stop recording, you must delete the service-linked configuration recorder. Use the <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a> operation to delete a service-linked configuration
     *         recorder.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConfigurationRecorderResponse> deleteConfigurationRecorder(
            DeleteConfigurationRecorderRequest deleteConfigurationRecorderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConfigurationRecorderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConfigurationRecorderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConfigurationRecorder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConfigurationRecorderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConfigurationRecorderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteConfigurationRecorderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConfigurationRecorderRequest, DeleteConfigurationRecorderResponse>()
                            .withOperationName("DeleteConfigurationRecorder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConfigurationRecorderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConfigurationRecorderRequest));
            CompletableFuture<DeleteConfigurationRecorderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified conformance pack and all the Config rules, remediation actions, and all evaluation results
     * within that conformance pack.
     * </p>
     * <p>
     * Config sets the conformance pack to <code>DELETE_IN_PROGRESS</code> until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note>
     *
     * @param deleteConformancePackRequest
     * @return A Java Future containing the result of the DeleteConformancePack operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteConformancePack" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConformancePackResponse> deleteConformancePack(
            DeleteConformancePackRequest deleteConformancePackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConformancePackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConformancePackRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConformancePack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConformancePackResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConformancePackResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteConformancePackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConformancePackRequest, DeleteConformancePackResponse>()
                            .withOperationName("DeleteConformancePack").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteConformancePackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteConformancePackRequest));
            CompletableFuture<DeleteConformancePackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the delivery channel.
     * </p>
     * <p>
     * Before you can delete the delivery channel, you must stop the customer managed configuration recorder. You can
     * use the <a>StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     * </p>
     *
     * @param deleteDeliveryChannelRequest
     *        The input for the <a>DeleteDeliveryChannel</a> action. The action accepts the following data, in JSON
     *        format.
     * @return A Java Future containing the result of the DeleteDeliveryChannel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>LastDeliveryChannelDeleteFailedException You cannot delete the delivery channel you specified because
     *         the customer managed configuration recorder is running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteDeliveryChannel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteDeliveryChannel" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeliveryChannelResponse> deleteDeliveryChannel(
            DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDeliveryChannelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeliveryChannelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeliveryChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeliveryChannelResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeliveryChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteDeliveryChannelResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeliveryChannelRequest, DeleteDeliveryChannelResponse>()
                            .withOperationName("DeleteDeliveryChannel").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteDeliveryChannelRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDeliveryChannelRequest));
            CompletableFuture<DeleteDeliveryChannelResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the evaluation results for the specified Config rule. You can specify one Config rule per request. After
     * you delete the evaluation results, you can call the <a>StartConfigRulesEvaluation</a> API to start evaluating
     * your Amazon Web Services resources against the rule.
     * </p>
     *
     * @param deleteEvaluationResultsRequest
     * @return A Java Future containing the result of the DeleteEvaluationResults operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteEvaluationResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteEvaluationResults"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteEvaluationResultsResponse> deleteEvaluationResults(
            DeleteEvaluationResultsRequest deleteEvaluationResultsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteEvaluationResultsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEvaluationResultsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEvaluationResults");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteEvaluationResultsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteEvaluationResultsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteEvaluationResultsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteEvaluationResultsRequest, DeleteEvaluationResultsResponse>()
                            .withOperationName("DeleteEvaluationResults").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteEvaluationResultsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteEvaluationResultsRequest));
            CompletableFuture<DeleteEvaluationResultsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified organization Config rule and all of its evaluation results from all member accounts in that
     * organization.
     * </p>
     * <p>
     * Only a management account and a delegated administrator account can delete an organization Config rule. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a rule to DELETE_IN_PROGRESS until the deletion is complete. You cannot update a rule
     * while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note>
     *
     * @param deleteOrganizationConfigRuleRequest
     * @return A Java Future containing the result of the DeleteOrganizationConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOrganizationConfigRuleResponse> deleteOrganizationConfigRule(
            DeleteOrganizationConfigRuleRequest deleteOrganizationConfigRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOrganizationConfigRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOrganizationConfigRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOrganizationConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOrganizationConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteOrganizationConfigRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteOrganizationConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOrganizationConfigRuleRequest, DeleteOrganizationConfigRuleResponse>()
                            .withOperationName("DeleteOrganizationConfigRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOrganizationConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOrganizationConfigRuleRequest));
            CompletableFuture<DeleteOrganizationConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified organization conformance pack and all of the Config rules and remediation actions from all
     * member accounts in that organization.
     * </p>
     * <p>
     * Only a management account or a delegated administrator account can delete an organization conformance pack. When
     * calling this API with a delegated administrator, you must ensure Organizations
     * <code>ListDelegatedAdministrator</code> permissions are added.
     * </p>
     * <p>
     * Config sets the state of a conformance pack to DELETE_IN_PROGRESS until the deletion is complete. You cannot
     * update a conformance pack while it is in this state.
     * </p>
     * <note>
     * <p>
     * <b>Recommendation: Consider excluding the <code>AWS::Config::ResourceCompliance</code> resource type from
     * recording before deleting rules</b>
     * </p>
     * <p>
     * Deleting rules creates configuration items (CIs) for <code>AWS::Config::ResourceCompliance</code> that can affect
     * your costs for the configuration recorder. If you are deleting rules which evaluate a large number of resource
     * types, this can lead to a spike in the number of CIs recorded.
     * </p>
     * <p>
     * To avoid the associated costs, you can opt to disable recording for the
     * <code>AWS::Config::ResourceCompliance</code> resource type before deleting rules, and re-enable recording after
     * the rules have been deleted.
     * </p>
     * <p>
     * However, since deleting rules is an asynchronous process, it might take an hour or more to complete. During the
     * time when recording is disabled for <code>AWS::Config::ResourceCompliance</code>, rule evaluations will not be
     * recorded in the associated resource’s history.
     * </p>
     * </note>
     *
     * @param deleteOrganizationConformancePackRequest
     * @return A Java Future containing the result of the DeleteOrganizationConformancePack operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>ResourceInUseException You see this exception in the following cases: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, Config is deleting this rule. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, the rule is deleting your evaluation results. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConfigRule, a remediation action is associated with the rule and Config cannot delete this
     *         rule. Delete the remediation action associated with the rule before deleting the rule and try your
     *         request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConfigOrganizationRule, organization Config rule deletion is in progress. Try your request again
     *         later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteOrganizationConfigRule, organization Config rule creation is in progress. Try your request
     *         again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For PutConformancePack and PutOrganizationConformancePack, a conformance pack creation, update, and
     *         deletion is in progress. Try your request again later.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For DeleteConformancePack, a conformance pack creation, update, and deletion is in progress. Try your
     *         request again later.
     *         </p>
     *         </li></li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteOrganizationConformancePack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteOrganizationConformancePack"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOrganizationConformancePackResponse> deleteOrganizationConformancePack(
            DeleteOrganizationConformancePackRequest deleteOrganizationConformancePackRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOrganizationConformancePackRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteOrganizationConformancePackRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOrganizationConformancePack");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteOrganizationConformancePackResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteOrganizationConformancePackResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteOrganizationConformancePackResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOrganizationConformancePackRequest, DeleteOrganizationConformancePackResponse>()
                            .withOperationName("DeleteOrganizationConformancePack").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteOrganizationConformancePackRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOrganizationConformancePackRequest));
            CompletableFuture<DeleteOrganizationConformancePackResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes pending authorization requests for a specified aggregator account in a specified region.
     * </p>
     *
     * @param deletePendingAggregationRequestRequest
     * @return A Java Future containing the result of the DeletePendingAggregationRequest operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeletePendingAggregationRequest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeletePendingAggregationRequest"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePendingAggregationRequestResponse> deletePendingAggregationRequest(
            DeletePendingAggregationRequestRequest deletePendingAggregationRequestRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePendingAggregationRequestRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deletePendingAggregationRequestRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePendingAggregationRequest");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePendingAggregationRequestResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeletePendingAggregationRequestResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeletePendingAggregationRequestResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePendingAggregationRequestRequest, DeletePendingAggregationRequestResponse>()
                            .withOperationName("DeletePendingAggregationRequest").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeletePendingAggregationRequestRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePendingAggregationRequestRequest));
            CompletableFuture<DeletePendingAggregationRequestResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the remediation configuration.
     * </p>
     *
     * @param deleteRemediationConfigurationRequest
     * @return A Java Future containing the result of the DeleteRemediationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationConfigurationException You specified an Config rule without a remediation
     *         configuration.</li>
     *         <li>RemediationInProgressException Remediation action is in progress. You can either cancel execution in
     *         Amazon Web Services Systems Manager or wait and try again later.</li>
     *         <li>InsufficientPermissionsException Indicates one of the following errors:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>,
     *         the rule cannot be created because the IAM role assigned to Config lacks permissions to perform the
     *         config:Put* action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigRule.html">PutConfigRule</a>,
     *         the Lambda function cannot be invoked. Check the function ARN, and check the function's permissions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConfigRule.html">
     *         PutOrganizationConfigRule</a>, organization Config rule cannot be created because you do not have
     *         permissions to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConformancePack.html">
     *         PutConformancePack</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutOrganizationConformancePack.html"
     *         >PutOrganizationConformancePack</a>, a conformance pack cannot be created because you do not have the
     *         following permissions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You do not have permission to call IAM <code>GetRole</code> action or create a service-linked role.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You do not have permission to read Amazon S3 bucket or call SSM:GetDocument.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, a service-linked configuration recorder cannot be created
     *         because you do not have the following permissions: IAM <code>CreateServiceLinkedRole</code>.
     *         </p>
     *         </li></li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRemediationConfigurationResponse> deleteRemediationConfiguration(
            DeleteRemediationConfigurationRequest deleteRemediationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRemediationConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRemediationConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRemediationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRemediationConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRemediationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRemediationConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRemediationConfigurationRequest, DeleteRemediationConfigurationResponse>()
                            .withOperationName("DeleteRemediationConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRemediationConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRemediationConfigurationRequest));
            CompletableFuture<DeleteRemediationConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more remediation exceptions mentioned in the resource keys.
     * </p>
     * <note>
     * <p>
     * Config generates a remediation exception when a problem occurs executing a remediation action to a specific
     * resource. Remediation exceptions blocks auto-remediation until the exception is cleared.
     * </p>
     * </note>
     *
     * @param deleteRemediationExceptionsRequest
     * @return A Java Future containing the result of the DeleteRemediationExceptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchRemediationExceptionException You tried to delete a remediation exception that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRemediationExceptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRemediationExceptions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRemediationExceptionsResponse> deleteRemediationExceptions(
            DeleteRemediationExceptionsRequest deleteRemediationExceptionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRemediationExceptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRemediationExceptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRemediationExceptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRemediationExceptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRemediationExceptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRemediationExceptionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRemediationExceptionsRequest, DeleteRemediationExceptionsResponse>()
                            .withOperationName("DeleteRemediationExceptions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRemediationExceptionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRemediationExceptionsRequest));
            CompletableFuture<DeleteRemediationExceptionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Records the configuration state for a custom resource that has been deleted. This API records a new
     * ConfigurationItem with a ResourceDeleted status. You can retrieve the ConfigurationItems recorded for this
     * resource in your Config History.
     * </p>
     *
     * @param deleteResourceConfigRequest
     * @return A Java Future containing the result of the DeleteResourceConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteResourceConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteResourceConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceConfigResponse> deleteResourceConfig(
            DeleteResourceConfigRequest deleteResourceConfigRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourceConfigRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceConfig");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceConfigResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceConfigResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteResourceConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceConfigRequest, DeleteResourceConfigResponse>()
                            .withOperationName("DeleteResourceConfig").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteResourceConfigRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResourceConfigRequest));
            CompletableFuture<DeleteResourceConfigResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the retention configuration.
     * </p>
     *
     * @param deleteRetentionConfigurationRequest
     * @return A Java Future containing the result of the DeleteRetentionConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchRetentionConfigurationException You have specified a retention configuration that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteRetentionConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteRetentionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRetentionConfigurationResponse> deleteRetentionConfiguration(
            DeleteRetentionConfigurationRequest deleteRetentionConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRetentionConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRetentionConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRetentionConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRetentionConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRetentionConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteRetentionConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRetentionConfigurationRequest, DeleteRetentionConfigurationResponse>()
                            .withOperationName("DeleteRetentionConfiguration").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRetentionConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRetentionConfigurationRequest));
            CompletableFuture<DeleteRetentionConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing service-linked configuration recorder.
     * </p>
     * <p>
     * This operation does not delete the configuration information that was previously recorded. You will be able to
     * access the previously recorded information by using the <a
     * href="https://docs.aws.amazon.com/config/latest/APIReference/API_GetResourceConfigHistory.html"
     * >GetResourceConfigHistory</a> operation, but you will not be able to access this information in the Config
     * console until you have created a new service-linked configuration recorder for the same service.
     * </p>
     * <note>
     * <p>
     * <b>The recording scope determines if you receive configuration items</b>
     * </p>
     * <p>
     * The recording scope is set by the service that is linked to the configuration recorder and determines whether you
     * receive configuration items (CIs) in the delivery channel. If the recording scope is internal, you will not
     * receive CIs in the delivery channel.
     * </p>
     * </note>
     *
     * @param deleteServiceLinkedConfigurationRecorderRequest
     * @return A Java Future containing the result of the DeleteServiceLinkedConfigurationRecorder operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ConflictException For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutServiceLinkedConfigurationRecorder.html"
     *         >PutServiceLinkedConfigurationRecorder</a>, you cannot create a service-linked recorder because a
     *         service-linked recorder already exists for the specified service.</p>
     *         <p>
     *         For <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteServiceLinkedConfigurationRecorder.html"
     *         >DeleteServiceLinkedConfigurationRecorder</a>, you cannot delete the service-linked recorder because it
     *         is currently in use by the linked Amazon Web Services service.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_DeleteDeliveryChannel.html">
     *         DeleteDeliveryChannel</a>, you cannot delete the specified delivery channel because the customer managed
     *         configuration recorder is running. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_StopConfigurationRecorder.html"
     *         >StopConfigurationRecorder</a> operation to stop the customer managed configuration recorder.
     *         </p>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder is not in use by the service. No
     *         association or dissociation of resource types is permitted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, your requested change to the configuration recorder has been
     *         denied by its linked Amazon Web Services service.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteServiceLinkedConfigurationRecorder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteServiceLinkedConfigurationRecorder"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteServiceLinkedConfigurationRecorderResponse> deleteServiceLinkedConfigurationRecorder(
            DeleteServiceLinkedConfigurationRecorderRequest deleteServiceLinkedConfigurationRecorderRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                deleteServiceLinkedConfigurationRecorderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteServiceLinkedConfigurationRecorderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceLinkedConfigurationRecorder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteServiceLinkedConfigurationRecorderResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DeleteServiceLinkedConfigurationRecorderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteServiceLinkedConfigurationRecorderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteServiceLinkedConfigurationRecorderRequest, DeleteServiceLinkedConfigurationRecorderResponse>()
                            .withOperationName("DeleteServiceLinkedConfigurationRecorder").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteServiceLinkedConfigurationRecorderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteServiceLinkedConfigurationRecorderRequest));
            CompletableFuture<DeleteServiceLinkedConfigurationRecorderResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the stored query for a single Amazon Web Services account and a single Amazon Web Services Region.
     * </p>
     *
     * @param deleteStoredQueryRequest
     * @return A Java Future containing the result of the DeleteStoredQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>ResourceNotFoundException You have specified a resource that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeleteStoredQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeleteStoredQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStoredQueryResponse> deleteStoredQuery(DeleteStoredQueryRequest deleteStoredQueryRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStoredQueryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStoredQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStoredQuery");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteStoredQueryResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteStoredQueryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeleteStoredQueryResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStoredQueryRequest, DeleteStoredQueryResponse>()
                            .withOperationName("DeleteStoredQuery").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteStoredQueryRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteStoredQueryRequest));
            CompletableFuture<DeleteStoredQueryResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Schedules delivery of a configuration snapshot to the Amazon S3 bucket in the specified delivery channel. After
     * the delivery has started, Config sends the following notifications using an Amazon SNS topic that you have
     * specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Notification of the start of the delivery.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of the completion of the delivery, if the delivery was successfully completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Notification of delivery failure, if the delivery failed.
     * </p>
     * </li>
     * </ul>
     *
     * @param deliverConfigSnapshotRequest
     *        The input for the <a>DeliverConfigSnapshot</a> action.
     * @return A Java Future containing the result of the DeliverConfigSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>NoAvailableConfigurationRecorderException There are no customer managed configuration recorders
     *         available to record your resources. Use the <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutConfigurationRecorder.html"
     *         >PutConfigurationRecorder</a> operation to create the customer managed configuration recorder.</li>
     *         <li>NoRunningConfigurationRecorderException There is no configuration recorder running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DeliverConfigSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliverConfigSnapshot" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeliverConfigSnapshotResponse> deliverConfigSnapshot(
            DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deliverConfigSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deliverConfigSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeliverConfigSnapshot");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeliverConfigSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeliverConfigSnapshotResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DeliverConfigSnapshotResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeliverConfigSnapshotRequest, DeliverConfigSnapshotResponse>()
                            .withOperationName("DeliverConfigSnapshot").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeliverConfigSnapshotRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(deliverConfigSnapshotRequest));
            CompletableFuture<DeliverConfigSnapshotResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of compliant and noncompliant rules with the number of resources for compliant and noncompliant
     * rules. Does not display rules that do not have compliance results.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConfigRulesRequest
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConfigRules operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> describeAggregateComplianceByConfigRules(
            DescribeAggregateComplianceByConfigRulesRequest describeAggregateComplianceByConfigRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeAggregateComplianceByConfigRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregateComplianceByConfigRulesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregateComplianceByConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAggregateComplianceByConfigRulesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAggregateComplianceByConfigRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregateComplianceByConfigRulesRequest, DescribeAggregateComplianceByConfigRulesResponse>()
                            .withOperationName("DescribeAggregateComplianceByConfigRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAggregateComplianceByConfigRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAggregateComplianceByConfigRulesRequest));
            CompletableFuture<DescribeAggregateComplianceByConfigRulesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of the existing and deleted conformance packs and their associated compliance status with the
     * count of compliant and noncompliant Config rules within each conformance pack. Also returns the total rule count
     * which includes compliant rules, noncompliant rules, and rules that cannot be evaluated due to insufficient data.
     * </p>
     * <note>
     * <p>
     * The results can return an empty result page, but if you have a <code>nextToken</code>, the results are displayed
     * on the next page.
     * </p>
     * </note>
     *
     * @param describeAggregateComplianceByConformancePacksRequest
     * @return A Java Future containing the result of the DescribeAggregateComplianceByConformancePacks operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregateComplianceByConformancePacks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregateComplianceByConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> describeAggregateComplianceByConformancePacks(
            DescribeAggregateComplianceByConformancePacksRequest describeAggregateComplianceByConformancePacksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeAggregateComplianceByConformancePacksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregateComplianceByConformancePacksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregateComplianceByConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAggregateComplianceByConformancePacksResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAggregateComplianceByConformancePacksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregateComplianceByConformancePacksRequest, DescribeAggregateComplianceByConformancePacksResponse>()
                            .withOperationName("DescribeAggregateComplianceByConformancePacks")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAggregateComplianceByConformancePacksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAggregateComplianceByConformancePacksRequest));
            CompletableFuture<DescribeAggregateComplianceByConformancePacksResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of authorizations granted to various aggregator accounts and regions.
     * </p>
     *
     * @param describeAggregationAuthorizationsRequest
     * @return A Java Future containing the result of the DescribeAggregationAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeAggregationAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeAggregationAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAggregationAuthorizationsResponse> describeAggregationAuthorizations(
            DescribeAggregationAuthorizationsRequest describeAggregationAuthorizationsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAggregationAuthorizationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAggregationAuthorizationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAggregationAuthorizations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAggregationAuthorizationsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeAggregationAuthorizationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeAggregationAuthorizationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAggregationAuthorizationsRequest, DescribeAggregationAuthorizationsResponse>()
                            .withOperationName("DescribeAggregationAuthorizations").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeAggregationAuthorizationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeAggregationAuthorizationsRequest));
            CompletableFuture<DescribeAggregationAuthorizationsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Indicates whether the specified Config rules are compliant. If a rule is noncompliant, this operation returns the
     * number of Amazon Web Services resources that do not comply with the rule.
     * </p>
     * <p>
     * A rule is compliant if all of the evaluated resources comply with it. It is noncompliant if any of these
     * resources do not comply.
     * </p>
     * <p>
     * If Config has no current evaluation results for the rule, it returns <code>INSUFFICIENT_DATA</code>. This result
     * might indicate one of the following conditions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role you assigned to
     * your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule is a custom
     * rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code> permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByConfigRuleRequest
     * @return A Java Future containing the result of the DescribeComplianceByConfigRule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByConfigRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByConfigRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeComplianceByConfigRuleResponse> describeComplianceByConfigRule(
            DescribeComplianceByConfigRuleRequest describeComplianceByConfigRuleRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeComplianceByConfigRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeComplianceByConfigRuleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeComplianceByConfigRule");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeComplianceByConfigRuleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeComplianceByConfigRuleResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeComplianceByConfigRuleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeComplianceByConfigRuleRequest, DescribeComplianceByConfigRuleResponse>()
                            .withOperationName("DescribeComplianceByConfigRule").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeComplianceByConfigRuleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeComplianceByConfigRuleRequest));
            CompletableFuture<DescribeComplianceByConfigRuleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Indicates whether the specified Amazon Web Services resources are compliant. If a resource is noncompliant, this
     * operation returns the number of Config rules that the resource does not comply with.
     * </p>
     * <p>
     * A resource is compliant if it complies with all the Config rules that evaluate it. It is noncompliant if it does
     * not comply with one or more of these rules.
     * </p>
     * <p>
     * If Config has no current evaluation results for the resource, it returns <code>INSUFFICIENT_DATA</code>. This
     * result might indicate one of the following conditions about the rules that evaluate the resource:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Config has never invoked an evaluation for the rule. To check whether it has, use the
     * <code>DescribeConfigRuleEvaluationStatus</code> action to get the <code>LastSuccessfulInvocationTime</code> and
     * <code>LastFailedInvocationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function is failing to send evaluation results to Config. Verify that the role that you
     * assigned to your configuration recorder includes the <code>config:PutEvaluations</code> permission. If the rule
     * is a custom rule, verify that the Lambda execution role includes the <code>config:PutEvaluations</code>
     * permission.
     * </p>
     * </li>
     * <li>
     * <p>
     * The rule's Lambda function has returned <code>NOT_APPLICABLE</code> for all evaluation results. This can occur if
     * the resources were deleted or removed from the rule's scope.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComplianceByResourceRequest
     * @return A Java Future containing the result of the DescribeComplianceByResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeComplianceByResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeComplianceByResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeComplianceByResourceResponse> describeComplianceByResource(
            DescribeComplianceByResourceRequest describeComplianceByResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeComplianceByResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeComplianceByResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeComplianceByResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeComplianceByResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeComplianceByResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeComplianceByResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeComplianceByResourceRequest, DescribeComplianceByResourceResponse>()
                            .withOperationName("DescribeComplianceByResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeComplianceByResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeComplianceByResourceRequest));
            CompletableFuture<DescribeComplianceByResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns status information for each of your Config managed rules. The status includes information such as the
     * last time Config invoked the rule, the last time Config failed to invoke the rule, and the related error for the
     * last failure.
     * </p>
     *
     * @param describeConfigRuleEvaluationStatusRequest
     * @return A Java Future containing the result of the DescribeConfigRuleEvaluationStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRuleEvaluationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRuleEvaluationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> describeConfigRuleEvaluationStatus(
            DescribeConfigRuleEvaluationStatusRequest describeConfigRuleEvaluationStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConfigRuleEvaluationStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigRuleEvaluationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigRuleEvaluationStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigRuleEvaluationStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConfigRuleEvaluationStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigRuleEvaluationStatusRequest, DescribeConfigRuleEvaluationStatusResponse>()
                            .withOperationName("DescribeConfigRuleEvaluationStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConfigRuleEvaluationStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConfigRuleEvaluationStatusRequest));
            CompletableFuture<DescribeConfigRuleEvaluationStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about your Config rules.
     * </p>
     *
     * @param describeConfigRulesRequest
     * @return A Java Future containing the result of the DescribeConfigRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigRuleException The Config rule in the request is not valid. Verify that the rule is an
     *         Config Process Check rule, that the rule name is correct, and that valid Amazon Resouce Names (ARNs) are
     *         used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigRules" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigRulesResponse> describeConfigRules(
            DescribeConfigRulesRequest describeConfigRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConfigRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConfigRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConfigRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConfigRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigRulesRequest, DescribeConfigRulesResponse>()
                            .withOperationName("DescribeConfigRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConfigRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConfigRulesRequest));
            CompletableFuture<DescribeConfigRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns status information for sources within an aggregator. The status includes information about the last time
     * Config verified authorization between the source account and an aggregator account. In case of a failure, the
     * status contains the related error code or message.
     * </p>
     *
     * @param describeConfigurationAggregatorSourcesStatusRequest
     * @return A Java Future containing the result of the DescribeConfigurationAggregatorSourcesStatus operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregatorSourcesStatus
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregatorSourcesStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> describeConfigurationAggregatorSourcesStatus(
            DescribeConfigurationAggregatorSourcesStatusRequest describeConfigurationAggregatorSourcesStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeConfigurationAggregatorSourcesStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationAggregatorSourcesStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationAggregatorSourcesStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationAggregatorSourcesStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConfigurationAggregatorSourcesStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationAggregatorSourcesStatusRequest, DescribeConfigurationAggregatorSourcesStatusResponse>()
                            .withOperationName("DescribeConfigurationAggregatorSourcesStatus")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConfigurationAggregatorSourcesStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConfigurationAggregatorSourcesStatusRequest));
            CompletableFuture<DescribeConfigurationAggregatorSourcesStatusResponse> whenCompleted = executeFuture.whenComplete((
                    r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the details of one or more configuration aggregators. If the configuration aggregator is not specified,
     * this operation returns the details for all the configuration aggregators associated with the account.
     * </p>
     *
     * @param describeConfigurationAggregatorsRequest
     * @return A Java Future containing the result of the DescribeConfigurationAggregators operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigurationAggregatorException You have specified a configuration aggregator that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationAggregatorsResponse> describeConfigurationAggregators(
            DescribeConfigurationAggregatorsRequest describeConfigurationAggregatorsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConfigurationAggregatorsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationAggregatorsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationAggregators");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationAggregatorsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConfigurationAggregatorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConfigurationAggregatorsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationAggregatorsRequest, DescribeConfigurationAggregatorsResponse>()
                            .withOperationName("DescribeConfigurationAggregators").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConfigurationAggregatorsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConfigurationAggregatorsRequest));
            CompletableFuture<DescribeConfigurationAggregatorsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current status of the configuration recorder you specify as well as the status of the last recording
     * event for the configuration recorders.
     * </p>
     * <p>
     * For a detailed status of recording events over time, add your Config events to Amazon CloudWatch metrics and use
     * CloudWatch metrics.
     * </p>
     * <p>
     * If a configuration recorder is not specified, this operation returns the status for the customer managed
     * configuration recorder configured for the account, if applicable.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecorderStatusRequest
     *        The input for the <a>DescribeConfigurationRecorderStatus</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorderStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorderStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorderStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationRecorderStatusResponse> describeConfigurationRecorderStatus(
            DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConfigurationRecorderStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationRecorderStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationRecorderStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationRecorderStatusResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConfigurationRecorderStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConfigurationRecorderStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResponse>()
                            .withOperationName("DescribeConfigurationRecorderStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConfigurationRecorderStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConfigurationRecorderStatusRequest));
            CompletableFuture<DescribeConfigurationRecorderStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details for the configuration recorder you specify.
     * </p>
     * <p>
     * If a configuration recorder is not specified, this operation returns details for the customer managed
     * configuration recorder configured for the account, if applicable.
     * </p>
     * <note>
     * <p>
     * When making a request to this operation, you can only specify one configuration recorder.
     * </p>
     * </note>
     *
     * @param describeConfigurationRecordersRequest
     *        The input for the <a>DescribeConfigurationRecorders</a> action.
     * @return A Java Future containing the result of the DescribeConfigurationRecorders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConfigurationRecorderException You have specified a configuration recorder that does not exist.
     *         </li>
     *         <li>ValidationException The requested operation is not valid. You will see this exception if there are
     *         missing required fields or if the input value fails the validation.</p>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_PutStoredQuery.html">PutStoredQuery</a>,
     *         one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         There are missing required fields.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The input value fails the validation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are trying to create more than 300 queries.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorders.html"
     *         >DescribeConfigurationRecorders</a> and <a href=
     *         "https://docs.aws.amazon.com/config/latest/APIReference/API_DescribeConfigurationRecorderStatus.html"
     *         >DescribeConfigurationRecorderStatus</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         You have specified more than one configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You have provided a service principal for service-linked configuration recorder that is not valid.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For <a href="https://docs.aws.amazon.com/config/latest/APIReference/API_AssociateResourceTypes.html">
     *         AssociateResourceTypes</a> and <a
     *         href="https://docs.aws.amazon.com/config/latest/APIReference/API_DisassociateResourceTypes.html"
     *         >DisassociateResourceTypes</a>, one of the following errors:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Your configuraiton recorder has a recording strategy that does not allow the association or
     *         disassociation of resource types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         One or more of the specified resource types are already associated or disassociated with the
     *         configuration recorder.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For service-linked configuration recorders, the configuration recorder does not record one or more of the
     *         specified resource types.
     *         </p>
     *         </li></li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConfigurationRecorders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConfigurationRecorders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConfigurationRecordersResponse> describeConfigurationRecorders(
            DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConfigurationRecordersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConfigurationRecordersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConfigurationRecorders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConfigurationRecordersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConfigurationRecordersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConfigurationRecordersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResponse>()
                            .withOperationName("DescribeConfigurationRecorders").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConfigurationRecordersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConfigurationRecordersRequest));
            CompletableFuture<DescribeConfigurationRecordersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns compliance details for each rule in that conformance pack.
     * </p>
     * <note>
     * <p>
     * You must provide exact rule names.
     * </p>
     * </note>
     *
     * @param describeConformancePackComplianceRequest
     * @return A Java Future containing the result of the DescribeConformancePackCompliance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>NoSuchConfigRuleInConformancePackException Config rule that you passed in the filter does not exist.</li>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackCompliance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackCompliance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConformancePackComplianceResponse> describeConformancePackCompliance(
            DescribeConformancePackComplianceRequest describeConformancePackComplianceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConformancePackComplianceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConformancePackComplianceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePackCompliance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConformancePackComplianceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeConformancePackComplianceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConformancePackComplianceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePackComplianceRequest, DescribeConformancePackComplianceResponse>()
                            .withOperationName("DescribeConformancePackCompliance").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConformancePackComplianceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConformancePackComplianceRequest));
            CompletableFuture<DescribeConformancePackComplianceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides one or more conformance packs deployment status.
     * </p>
     * <note>
     * <p>
     * If there are no conformance packs then you will see an empty result.
     * </p>
     * </note>
     *
     * @param describeConformancePackStatusRequest
     * @return A Java Future containing the result of the DescribeConformancePackStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePackStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePackStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConformancePackStatusResponse> describeConformancePackStatus(
            DescribeConformancePackStatusRequest describeConformancePackStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConformancePackStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConformancePackStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePackStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConformancePackStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConformancePackStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConformancePackStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePackStatusRequest, DescribeConformancePackStatusResponse>()
                            .withOperationName("DescribeConformancePackStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConformancePackStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConformancePackStatusRequest));
            CompletableFuture<DescribeConformancePackStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of one or more conformance packs.
     * </p>
     *
     * @param describeConformancePacksRequest
     * @return A Java Future containing the result of the DescribeConformancePacks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchConformancePackException You specified one or more conformance packs that do not exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidParameterValueException One or more of the specified parameters are not valid. Verify that
     *         your parameters are valid and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeConformancePacksResponse> describeConformancePacks(
            DescribeConformancePacksRequest describeConformancePacksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConformancePacksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConformancePacksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeConformancePacksResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeConformancePacksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeConformancePacksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeConformancePacksRequest, DescribeConformancePacksResponse>()
                            .withOperationName("DescribeConformancePacks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeConformancePacksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeConformancePacksRequest));
            CompletableFuture<DescribeConformancePacksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the current status of the specified delivery channel. If a delivery channel is not specified, this
     * operation returns the current status of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelStatusRequest
     *        The input for the <a>DeliveryChannelStatus</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannelStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannelStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannelStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeliveryChannelStatusResponse> describeDeliveryChannelStatus(
            DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDeliveryChannelStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDeliveryChannelStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliveryChannelStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeliveryChannelStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeliveryChannelStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDeliveryChannelStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResponse>()
                            .withOperationName("DescribeDeliveryChannelStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDeliveryChannelStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDeliveryChannelStatusRequest));
            CompletableFuture<DescribeDeliveryChannelStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns details about the specified delivery channel. If a delivery channel is not specified, this operation
     * returns the details of all delivery channels associated with the account.
     * </p>
     * <note>
     * <p>
     * Currently, you can specify only one delivery channel per region in your account.
     * </p>
     * </note>
     *
     * @param describeDeliveryChannelsRequest
     *        The input for the <a>DescribeDeliveryChannels</a> action.
     * @return A Java Future containing the result of the DescribeDeliveryChannels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchDeliveryChannelException You have specified a delivery channel that does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeDeliveryChannels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeDeliveryChannels"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDeliveryChannelsResponse> describeDeliveryChannels(
            DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDeliveryChannelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDeliveryChannelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDeliveryChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDeliveryChannelsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDeliveryChannelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeDeliveryChannelsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResponse>()
                            .withOperationName("DescribeDeliveryChannels").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeDeliveryChannelsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeDeliveryChannelsRequest));
            CompletableFuture<DescribeDeliveryChannelsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides organization Config rule deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization Config rule is successfully deployed in all the member
     * accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization Config rule names. It is only applicable, when you request all the
     * organization Config rules.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRuleStatusesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfigRuleStatuses operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRuleStatuses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRuleStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> describeOrganizationConfigRuleStatuses(
            DescribeOrganizationConfigRuleStatusesRequest describeOrganizationConfigRuleStatusesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrganizationConfigRuleStatusesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigRuleStatusesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfigRuleStatuses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConfigRuleStatusesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConfigRuleStatusesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigRuleStatusesRequest, DescribeOrganizationConfigRuleStatusesResponse>()
                            .withOperationName("DescribeOrganizationConfigRuleStatuses").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOrganizationConfigRuleStatusesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrganizationConfigRuleStatusesRequest));
            CompletableFuture<DescribeOrganizationConfigRuleStatusesResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of organization Config rules.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization Config rule names. It is only applicable,
     * when you request all the organization Config rules.
     * </p>
     * <p>
     * <i>For accounts within an organization</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConfigRulesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConfigRules operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConfigRuleException The Config rule in the request is not valid. Verify that the
     *         rule is an organization Config Process Check rule, that the rule name is correct, and that valid Amazon
     *         Resouce Names (ARNs) are used before trying again.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConfigRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConfigRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConfigRulesResponse> describeOrganizationConfigRules(
            DescribeOrganizationConfigRulesRequest describeOrganizationConfigRulesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrganizationConfigRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConfigRulesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConfigRules");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConfigRulesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOrganizationConfigRulesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeOrganizationConfigRulesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConfigRulesRequest, DescribeOrganizationConfigRulesResponse>()
                            .withOperationName("DescribeOrganizationConfigRules").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOrganizationConfigRulesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrganizationConfigRulesRequest));
            CompletableFuture<DescribeOrganizationConfigRulesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides organization conformance pack deployment status for an organization.
     * </p>
     * <note>
     * <p>
     * The status is not considered successful until organization conformance pack is successfully deployed in all the
     * member accounts with an exception of excluded accounts.
     * </p>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response. Limit and next token are not
     * applicable if you specify organization conformance pack names. They are only applicable, when you request all the
     * organization conformance packs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePackStatusesRequest
     * @return A Java Future containing the result of the DescribeOrganizationConformancePackStatuses operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePackStatuses
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePackStatuses"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> describeOrganizationConformancePackStatuses(
            DescribeOrganizationConformancePackStatusesRequest describeOrganizationConformancePackStatusesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                describeOrganizationConformancePackStatusesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConformancePackStatusesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConformancePackStatuses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConformancePackStatusesResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConformancePackStatusesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableConfigurationRecorderException::builder)
                            .build());
                case "InvalidNextTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                case "LimitExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(LimitExceededException::builder).build());
                case "OrganizationAllFeaturesNotEnabledException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAllFeaturesNotEnabledException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAllFeaturesNotEnabledException::builder)
                            .build());
                case "InvalidLimitException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLimitException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidLimitException::builder).build());
                case "NoSuchOrganizationConfigRuleException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConfigRuleException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConfigRuleException::builder)
                                    .build());
                case "MaxNumberOfDeliveryChannelsExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfDeliveryChannelsExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfDeliveryChannelsExceededException::builder)
                            .build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "MaxNumberOfConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConfigRulesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConfigRulesExceededException::builder)
                            .build());
                case "InvalidExpressionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidExpressionException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidExpressionException::builder).build());
                case "NoSuchOrganizationConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchOrganizationConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchOrganizationConformancePackException::builder)
                            .build());
                case "MaxNumberOfConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxNumberOfConformancePacksExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxNumberOfConformancePacksExceededException::builder)
                            .build());
                case "MaxNumberOfOrganizationConfigRulesExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConfigRulesExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConfigRulesExceededException::builder).build());
                case "ResourceInUseException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceInUseException::builder).build());
                case "InvalidRecordingGroupException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRecordingGroupException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidRecordingGroupException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                case "TooManyTagsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(400)
                            .exceptionBuilderSupplier(TooManyTagsException::builder).build());
                case "MaxNumberOfRetentionConfigurationsExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfRetentionConfigurationsExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfRetentionConfigurationsExceededException::builder).build());
                case "InvalidDeliveryChannelNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeliveryChannelNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidDeliveryChannelNameException::builder).build());
                case "ConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConformancePackTemplateValidationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ConformancePackTemplateValidationException::builder)
                            .build());
                case "MaxNumberOfOrganizationConformancePacksExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfOrganizationConformancePacksExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfOrganizationConformancePacksExceededException::builder).build());
                case "InvalidS3KeyPrefixException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KeyPrefixException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KeyPrefixException::builder).build());
                case "ResourceNotDiscoveredException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotDiscoveredException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceNotDiscoveredException::builder).build());
                case "NoSuchRemediationConfigurationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationConfigurationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationConfigurationException::builder)
                            .build());
                case "NoAvailableDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableDeliveryChannelException::builder).build());
                case "NoSuchRemediationExceptionException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchRemediationExceptionException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRemediationExceptionException::builder).build());
                case "InvalidResultTokenException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResultTokenException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidResultTokenException::builder).build());
                case "OversizedConfigurationItemException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OversizedConfigurationItemException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OversizedConfigurationItemException::builder).build());
                case "InsufficientDeliveryPolicyException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDeliveryPolicyException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientDeliveryPolicyException::builder).build());
                case "OrganizationAccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationAccessDeniedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(OrganizationAccessDeniedException::builder).build());
                case "NoAvailableOrganizationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableOrganizationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoAvailableOrganizationException::builder).build());
                case "NoSuchDeliveryChannelException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchDeliveryChannelException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchDeliveryChannelException::builder).build());
                case "LastDeliveryChannelDeleteFailedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("LastDeliveryChannelDeleteFailedException")
                            .httpStatusCode(400).exceptionBuilderSupplier(LastDeliveryChannelDeleteFailedException::builder)
                            .build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "IdempotentParameterMismatch":
                    return Optional.of(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch").httpStatusCode(400)
                            .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build());
                case "NoSuchConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationRecorderException::builder).build());
                case "InsufficientPermissionsException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
                case "InvalidSNSTopicARNException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSNSTopicARNException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidSnsTopicArnException::builder).build());
                case "MaxActiveResourcesExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxActiveResourcesExceededException")
                            .httpStatusCode(400).exceptionBuilderSupplier(MaxActiveResourcesExceededException::builder).build());
                case "InvalidParameterValueException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterValueException::builder).build());
                case "NoSuchConfigRuleInConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleInConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigRuleInConformancePackException::builder)
                            .build());
                case "MaxNumberOfConfigurationRecordersExceededException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("MaxNumberOfConfigurationRecordersExceededException").httpStatusCode(400)
                            .exceptionBuilderSupplier(MaxNumberOfConfigurationRecordersExceededException::builder).build());
                case "NoSuchConformancePackException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConformancePackException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConformancePackException::builder).build());
                case "InvalidS3KmsKeyArnException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3KmsKeyArnException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidS3KmsKeyArnException::builder).build());
                case "NoSuchBucketException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchBucketException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchBucketException::builder).build());
                case "InvalidConfigurationRecorderNameException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidConfigurationRecorderNameException")
                            .httpStatusCode(400).exceptionBuilderSupplier(InvalidConfigurationRecorderNameException::builder)
                            .build());
                case "InvalidTimeRangeException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                case "NoSuchConfigRuleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigRuleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(NoSuchConfigRuleException::builder).build());
                case "InvalidRoleException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRoleException").httpStatusCode(400)
                            .exceptionBuilderSupplier(InvalidRoleException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);

            CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationConformancePackStatusesRequest, DescribeOrganizationConformancePackStatusesResponse>()
                            .withOperationName("DescribeOrganizationConformancePackStatuses")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DescribeOrganizationConformancePackStatusesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeOrganizationConformancePackStatusesRequest));
            CompletableFuture<DescribeOrganizationConformancePackStatusesResponse> whenCompleted = executeFuture.whenComplete((r,
                    e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of organization conformance packs.
     * </p>
     * <note>
     * <p>
     * When you specify the limit and the next token, you receive a paginated response.
     * </p>
     * <p>
     * Limit and next token are not applicable if you specify organization conformance packs names. They are only
     * applicable, when you request all the organization conformance packs.
     * </p>
     * <p>
     * <i>For accounts within an organization</i>
     * </p>
     * <p>
     * If you deploy an organizational rule or conformance pack in an organization administrator account, and then
     * establish a delegated administrator and deploy an organizational rule or conformance pack in the delegated
     * administrator account, you won't be able to see the organizational rule or conformance pack in the organization
     * administrator account from the delegated administrator account or see the organizational rule or conformance pack
     * in the delegated administrator account from organization administrator account. The
     * <code>DescribeOrganizationConfigRules</code> and <code>DescribeOrganizationConformancePacks</code> APIs can only
     * see and interact with the organization-related resource that were deployed from within the account calling those
     * APIs.
     * </p>
     * </note>
     *
     * @param describeOrganizationConformancePacksRequest
     * @return A Java Future containing the result of the DescribeOrganizationConformancePacks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NoSuchOrganizationConformancePackException Config organization conformance pack that you passed in
     *         the filter does not exist.</p>
     *         <p>
     *         For DeleteOrganizationConformancePack, you tried to delete an organization conformance pack that does not
     *         exist.</li>
     *         <li>InvalidNextTokenException The specified next token is not valid. Specify the <code>nextToken</code>
     *         string that was returned in the previous response to get the next page of results.</li>
     *         <li>InvalidLimitException The specified limit is outside the allowable range.</li>
     *         <li>OrganizationAccessDeniedException For <code>PutConfigurationAggregator</code> API, you can see this
     *         exception for the following reasons:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         No permission to call <code>EnableAWSServiceAccess</code> API
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator cannot be updated because your Amazon Web Services Organization management
     *         account or the delegated administrator role changed. Delete this aggregator and create a new one with the
     *         current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The configuration aggregator is associated with a previous Amazon Web Services Organization and Config
     *         cannot aggregate data with current Amazon Web Services Organization. Delete this aggregator and create a
     *         new one with the current Amazon Web Services Organization.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You are not a registered delegated administrator for Config with permissions to call
     *         <code>ListDelegatedAdministrators</code> API. Ensure that the management account registers delagated
     *         administrator for Config service principal name before the delegated administrator creates an aggregator.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For all <code>OrganizationConfigRule</code> and <code>OrganizationConformancePack</code> APIs, Config
     *         throws an exception if APIs are called from member accounts. All APIs must be called from organization
     *         management account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConfigException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConfigAsyncClient.DescribeOrganizationConformancePacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DescribeOrganizationConformancePacks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationConformancePacksResponse> describeOrganizationConformancePacks(
            DescribeOrganizationConformancePacksRequest describeOrganizationConformancePacksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeOrganizationConformancePacksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeOrganizationConformancePacksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Config Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOrganizationConformancePacks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationConformancePacksResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeOrganizationConformancePacksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "NoRunningConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoRunningConfigurationRecorderException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoRunningConfigurationRecorderException::builder)
                            .build());
                case "OrganizationConformancePackTemplateValidationException":
                    return Optional.of(ExceptionMetadata.builder()
                            .errorCode("OrganizationConformancePackTemplateValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(OrganizationConformancePackTemplateValidationException::builder).build());
                case "UnmodifiableEntityException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnmodifiableEntityException").httpStatusCode(400)
                            .exceptionBuilderSupplier(UnmodifiableEntityException::builder).build());
                case "NoSuchRetentionConfigurationException":
                    return Optional
                            .of(ExceptionMetadata.builder().errorCode("NoSuchRetentionConfigurationException")
                                    .httpStatusCode(400).exceptionBuilderSupplier(NoSuchRetentionConfigurationException::builder)
                                    .build());
                case "ResourceConcurrentModificationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceConcurrentModificationException")
                            .httpStatusCode(400).exceptionBuilderSupplier(ResourceConcurrentModificationException::builder)
                            .build());
                case "NoSuchConfigurationAggregatorException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoSuchConfigurationAggregatorException")
                            .httpStatusCode(400).exceptionBuilderSupplier(NoSuchConfigurationAggregatorException::builder)
                            .build());
                case "RemediationInProgressException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RemediationInProgressException")
                            .httpStatusCode(400).exceptionBuilderSupplier(RemediationInProgressException::builder).build());
                case "NoAvailableConfigurationRecorderException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableConfigurationRecorderException")